{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetSize: TVector3;
    procedure SetSize(const Value: TVector3);
    function GetCcw: boolean;
    procedure SetCcw(const Value: boolean);
    function GetDivisions: Integer;
    procedure SetDivisions(const Value: Integer);
  public
    property Size: TVector3 read GetSize write SetSize;
    property Ccw: boolean read GetCcw write SetCcw;
    property Divisions: Integer read GetDivisions write SetDivisions;

{$endif read_interface}

{$ifdef read_implementation}

{ TBoxNode ----------------------------------------------- }

function TBoxNode.GetSize: TVector3;
begin
  Result := FdSize.Value;
end;

procedure TBoxNode.SetSize(const Value: TVector3);
begin
  FdSize.Send(Value);
end;

function TBoxNode.GetCcw: boolean;
begin
  Result := FdCcw.Value;
end;

procedure TBoxNode.SetCcw(const Value: boolean);
begin
  FdCcw.Send(Value);
end;

function TBoxNode.GetDivisions: Integer;
begin
  Result := FdDivisions.Value;
end;

procedure TBoxNode.SetDivisions(const Value: Integer);
begin
  FdDivisions.Send(Value);
end;

{$endif read_implementation}
