{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAlpha: Single;
    procedure SetAlpha(const Value: Single);
    function GetColor: TCastleColorRGB;
    procedure SetColor(const Value: TCastleColorRGB);
  public
    property Alpha: Single read GetAlpha write SetAlpha;
    property Color: TCastleColorRGB read GetColor write SetColor;
    procedure SetFunction(const Value: array of string);
    procedure SetFunction(const Value: TCastleStringList);
    procedure SetMode(const Value: array of string);
    procedure SetMode(const Value: TCastleStringList);
    procedure SetSource(const Value: array of string);
    procedure SetSource(const Value: TCastleStringList);
    procedure SetTexture(const Value: array of TAbstractTextureNode);

{$endif read_interface}

{$ifdef read_implementation}

{ TMultiTextureNode ----------------------------------------------- }

function TMultiTextureNode.GetAlpha: Single;
begin
  Result := FdAlpha.Value;
end;

procedure TMultiTextureNode.SetAlpha(const Value: Single);
begin
  FdAlpha.Send(Value);
end;

function TMultiTextureNode.GetColor: TCastleColorRGB;
begin
  Result := FdColor.Value;
end;

procedure TMultiTextureNode.SetColor(const Value: TCastleColorRGB);
begin
  FdColor.Send(Value);
end;

procedure TMultiTextureNode.SetFunction(const Value: array of string);
begin
  FdFunction.Send(Value);
end;

procedure TMultiTextureNode.SetFunction(const Value: TCastleStringList);
begin
  FdFunction.Send(Value);
end;

procedure TMultiTextureNode.SetMode(const Value: array of string);
begin
  FdMode.Send(Value);
end;

procedure TMultiTextureNode.SetMode(const Value: TCastleStringList);
begin
  FdMode.Send(Value);
end;

procedure TMultiTextureNode.SetSource(const Value: array of string);
begin
  FdSource.Send(Value);
end;

procedure TMultiTextureNode.SetSource(const Value: TCastleStringList);
begin
  FdSource.Send(Value);
end;

procedure TMultiTextureNode.SetTexture(const Value: array of TAbstractTextureNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractTextureNode));
  FdTexture.Send(A);
end;

{$endif read_implementation}
