{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAddress: String;
    procedure SetAddress(const Value: String);
    function GetApplicationID: Integer;
    procedure SetApplicationID(const Value: Integer);
    function GetPort: Integer;
    procedure SetPort(const Value: Integer);
    function GetSiteID: Integer;
    procedure SetSiteID(const Value: Integer);
  public
    { X3D field "address". } { }
    property Address: String read GetAddress write SetAddress;
    { X3D field "applicationID". } { }
    property ApplicationID: Integer read GetApplicationID write SetApplicationID;
    { Set X3D field "mapping". } { }
    procedure SetMapping(const Value: array of TDISEntityTypeMappingNode);
    { X3D field "port". } { }
    property Port: Integer read GetPort write SetPort;
    { X3D field "siteID". } { }
    property SiteID: Integer read GetSiteID write SetSiteID;

{$endif read_interface}

{$ifdef read_implementation}

{ TDISEntityManagerNode ----------------------------------------------- }

function TDISEntityManagerNode.GetAddress: String;
begin
  Result := FdAddress.Value;
end;

procedure TDISEntityManagerNode.SetAddress(const Value: String);
begin
  FdAddress.Send(Value);
end;

function TDISEntityManagerNode.GetApplicationID: Integer;
begin
  Result := FdApplicationID.Value;
end;

procedure TDISEntityManagerNode.SetApplicationID(const Value: Integer);
begin
  FdApplicationID.Send(Value);
end;

procedure TDISEntityManagerNode.SetMapping(const Value: array of TDISEntityTypeMappingNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TDISEntityTypeMappingNode));
  FdMapping.Send(A);
end;

function TDISEntityManagerNode.GetPort: Integer;
begin
  Result := FdPort.Value;
end;

procedure TDISEntityManagerNode.SetPort(const Value: Integer);
begin
  FdPort.Send(Value);
end;

function TDISEntityManagerNode.GetSiteID: Integer;
begin
  Result := FdSiteID.Value;
end;

procedure TDISEntityManagerNode.SetSiteID(const Value: Integer);
begin
  FdSiteID.Send(Value);
end;

{$endif read_implementation}
