{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetGeoCenter: TVector3Double;
    procedure SetGeoCenter(const Value: TVector3Double);
    function GetRotation: TVector4;
    procedure SetRotation(const Value: TVector4);
    function GetScale: TVector3;
    procedure SetScale(const Value: TVector3);
    function GetScaleOrientation: TVector4;
    procedure SetScaleOrientation(const Value: TVector4);
    function GetTranslation: TVector3;
    procedure SetTranslation(const Value: TVector3);
    function GetGeoOrigin: TGeoOriginNode;
    procedure SetGeoOrigin(const Value: TGeoOriginNode);
  public
    { X3D field "geoCenter". } { }
    property GeoCenter: TVector3Double read GetGeoCenter write SetGeoCenter;
    { X3D field "rotation". } { }
    property Rotation: TVector4 read GetRotation write SetRotation;
    { X3D field "scale". } { }
    property Scale: TVector3 read GetScale write SetScale;
    { X3D field "scaleOrientation". } { }
    property ScaleOrientation: TVector4 read GetScaleOrientation write SetScaleOrientation;
    { X3D field "translation". } { }
    property Translation: TVector3 read GetTranslation write SetTranslation;
    { X3D field "geoOrigin". } { }
    property GeoOrigin: TGeoOriginNode read GetGeoOrigin write SetGeoOrigin;
    { Set X3D field "geoSystem". } { }
    procedure SetGeoSystem(const Value: array of string);
    { Set X3D field "geoSystem". } { }
    procedure SetGeoSystem(const Value: TCastleStringList);

{$endif read_interface}

{$ifdef read_implementation}

{ TGeoTransformNode ----------------------------------------------- }

function TGeoTransformNode.GetGeoCenter: TVector3Double;
begin
  Result := FdGeoCenter.Value;
end;

procedure TGeoTransformNode.SetGeoCenter(const Value: TVector3Double);
begin
  FdGeoCenter.Send(Value);
end;

function TGeoTransformNode.GetRotation: TVector4;
begin
  Result := FdRotation.Value;
end;

procedure TGeoTransformNode.SetRotation(const Value: TVector4);
begin
  FdRotation.Send(Value);
end;

function TGeoTransformNode.GetScale: TVector3;
begin
  Result := FdScale.Value;
end;

procedure TGeoTransformNode.SetScale(const Value: TVector3);
begin
  FdScale.Send(Value);
end;

function TGeoTransformNode.GetScaleOrientation: TVector4;
begin
  Result := FdScaleOrientation.Value;
end;

procedure TGeoTransformNode.SetScaleOrientation(const Value: TVector4);
begin
  FdScaleOrientation.Send(Value);
end;

function TGeoTransformNode.GetTranslation: TVector3;
begin
  Result := FdTranslation.Value;
end;

procedure TGeoTransformNode.SetTranslation(const Value: TVector3);
begin
  FdTranslation.Send(Value);
end;

function TGeoTransformNode.GetGeoOrigin: TGeoOriginNode;
begin
  if FdGeoOrigin.Value is TGeoOriginNode then
    Result := TGeoOriginNode(FdGeoOrigin.Value)
  else
    Result := nil;
end;

procedure TGeoTransformNode.SetGeoOrigin(const Value: TGeoOriginNode);
begin
  FdGeoOrigin.Send(Value);
end;

procedure TGeoTransformNode.SetGeoSystem(const Value: array of string);
begin
  FdGeoSystem.Send(Value);
end;

procedure TGeoTransformNode.SetGeoSystem(const Value: TCastleStringList);
begin
  FdGeoSystem.Send(Value);
end;

{$endif read_implementation}
