{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetCreateParticles: Boolean;
    procedure SetCreateParticles(const Value: Boolean);
    function GetEnabled: Boolean;
    procedure SetEnabled(const Value: Boolean);
    function GetLifetimeVariation: Single;
    procedure SetLifetimeVariation(const Value: Single);
    function GetMaxParticles: Integer;
    procedure SetMaxParticles(const Value: Integer);
    function GetParticleLifetime: Single;
    procedure SetParticleLifetime(const Value: Single);
    function GetParticleSize: TVector2;
    procedure SetParticleSize(const Value: TVector2);
    function GetColorRamp: TAbstractColorNode;
    procedure SetColorRamp(const Value: TAbstractColorNode);
    function GetEmitter: TAbstractParticleEmitterNode;
    procedure SetEmitter(const Value: TAbstractParticleEmitterNode);
    function GetTexCoordRamp: TTextureCoordinateNode;
    procedure SetTexCoordRamp(const Value: TTextureCoordinateNode);
  public
    { X3D field "createParticles". } { }
    property CreateParticles: Boolean read GetCreateParticles write SetCreateParticles;
    { X3D field "enabled". } { }
    property Enabled: Boolean read GetEnabled write SetEnabled;
    { X3D field "lifetimeVariation". } { }
    property LifetimeVariation: Single read GetLifetimeVariation write SetLifetimeVariation;
    { X3D field "maxParticles". } { }
    property MaxParticles: Integer read GetMaxParticles write SetMaxParticles;
    { X3D field "particleLifetime". } { }
    property ParticleLifetime: Single read GetParticleLifetime write SetParticleLifetime;
    { X3D field "particleSize". } { }
    property ParticleSize: TVector2 read GetParticleSize write SetParticleSize;
    { X3D field "colorRamp". } { }
    property ColorRamp: TAbstractColorNode read GetColorRamp write SetColorRamp;
    { Set X3D field "colorKey". } { }
    procedure SetColorKey(const Value: array of Single);
    { Set X3D field "colorKey". } { }
    procedure SetColorKey(const Value: TSingleList);
    { X3D field "emitter". } { }
    property Emitter: TAbstractParticleEmitterNode read GetEmitter write SetEmitter;
    { Set X3D field "physics". } { }
    procedure SetPhysics(const Value: array of TAbstractParticlePhysicsModelNode);
    { X3D field "texCoordRamp". } { }
    property TexCoordRamp: TTextureCoordinateNode read GetTexCoordRamp write SetTexCoordRamp;
    { Set X3D field "texCoordKey". } { }
    procedure SetTexCoordKey(const Value: array of Single);
    { Set X3D field "texCoordKey". } { }
    procedure SetTexCoordKey(const Value: TSingleList);

{$endif read_interface}

{$ifdef read_implementation}

{ TParticleSystemNode ----------------------------------------------- }

function TParticleSystemNode.GetCreateParticles: Boolean;
begin
  Result := FdCreateParticles.Value;
end;

procedure TParticleSystemNode.SetCreateParticles(const Value: Boolean);
begin
  FdCreateParticles.Send(Value);
end;

function TParticleSystemNode.GetEnabled: Boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TParticleSystemNode.SetEnabled(const Value: Boolean);
begin
  FdEnabled.Send(Value);
end;

function TParticleSystemNode.GetLifetimeVariation: Single;
begin
  Result := FdLifetimeVariation.Value;
end;

procedure TParticleSystemNode.SetLifetimeVariation(const Value: Single);
begin
  FdLifetimeVariation.Send(Value);
end;

function TParticleSystemNode.GetMaxParticles: Integer;
begin
  Result := FdMaxParticles.Value;
end;

procedure TParticleSystemNode.SetMaxParticles(const Value: Integer);
begin
  FdMaxParticles.Send(Value);
end;

function TParticleSystemNode.GetParticleLifetime: Single;
begin
  Result := FdParticleLifetime.Value;
end;

procedure TParticleSystemNode.SetParticleLifetime(const Value: Single);
begin
  FdParticleLifetime.Send(Value);
end;

function TParticleSystemNode.GetParticleSize: TVector2;
begin
  Result := FdParticleSize.Value;
end;

procedure TParticleSystemNode.SetParticleSize(const Value: TVector2);
begin
  FdParticleSize.Send(Value);
end;

function TParticleSystemNode.GetColorRamp: TAbstractColorNode;
begin
  if FdColorRamp.Value is TAbstractColorNode then
    Result := TAbstractColorNode(FdColorRamp.Value)
  else
    Result := nil;
end;

procedure TParticleSystemNode.SetColorRamp(const Value: TAbstractColorNode);
begin
  FdColorRamp.Send(Value);
end;

procedure TParticleSystemNode.SetColorKey(const Value: array of Single);
begin
  FdColorKey.Send(Value);
end;

procedure TParticleSystemNode.SetColorKey(const Value: TSingleList);
begin
  FdColorKey.Send(Value);
end;

function TParticleSystemNode.GetEmitter: TAbstractParticleEmitterNode;
begin
  if FdEmitter.Value is TAbstractParticleEmitterNode then
    Result := TAbstractParticleEmitterNode(FdEmitter.Value)
  else
    Result := nil;
end;

procedure TParticleSystemNode.SetEmitter(const Value: TAbstractParticleEmitterNode);
begin
  FdEmitter.Send(Value);
end;

procedure TParticleSystemNode.SetPhysics(const Value: array of TAbstractParticlePhysicsModelNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractParticlePhysicsModelNode));
  FdPhysics.Send(A);
end;

function TParticleSystemNode.GetTexCoordRamp: TTextureCoordinateNode;
begin
  if FdTexCoordRamp.Value is TTextureCoordinateNode then
    Result := TTextureCoordinateNode(FdTexCoordRamp.Value)
  else
    Result := nil;
end;

procedure TParticleSystemNode.SetTexCoordRamp(const Value: TTextureCoordinateNode);
begin
  FdTexCoordRamp.Send(Value);
end;

procedure TParticleSystemNode.SetTexCoordKey(const Value: array of Single);
begin
  FdTexCoordKey.Send(Value);
end;

procedure TParticleSystemNode.SetTexCoordKey(const Value: TSingleList);
begin
  FdTexCoordKey.Send(Value);
end;

{$endif read_implementation}
