{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAddress: String;
    procedure SetAddress(const Value: String);
    function GetApplicationID: Integer;
    procedure SetApplicationID(const Value: Integer);
    function GetEntityID: Integer;
    procedure SetEntityID(const Value: Integer);
    function GetMulticastRelayHost: String;
    procedure SetMulticastRelayHost(const Value: String);
    function GetMulticastRelayPort: Integer;
    procedure SetMulticastRelayPort(const Value: Integer);
    function GetPort: Integer;
    procedure SetPort(const Value: Integer);
    function GetRadioID: Integer;
    procedure SetRadioID(const Value: Integer);
    function GetReadInterval: Single;
    procedure SetReadInterval(const Value: Single);
    function GetReceivedPower: Single;
    procedure SetReceivedPower(const Value: Single);
    function GetReceiverState: Integer;
    procedure SetReceiverState(const Value: Integer);
    function GetRtpHeaderExpected: Boolean;
    procedure SetRtpHeaderExpected(const Value: Boolean);
    function GetSiteID: Integer;
    procedure SetSiteID(const Value: Integer);
    function GetTransmitterApplicationID: Integer;
    procedure SetTransmitterApplicationID(const Value: Integer);
    function GetTransmitterEntityID: Integer;
    procedure SetTransmitterEntityID(const Value: Integer);
    function GetTransmitterRadioID: Integer;
    procedure SetTransmitterRadioID(const Value: Integer);
    function GetTransmitterSiteID: Integer;
    procedure SetTransmitterSiteID(const Value: Integer);
    function GetWhichGeometry: Integer;
    procedure SetWhichGeometry(const Value: Integer);
    function GetWriteInterval: Single;
    procedure SetWriteInterval(const Value: Single);
    function GetBBox: TBox3D;
    procedure SetBBox(const Value: TBox3D);
  public
    { X3D field "address". } { }
    property Address: String read GetAddress write SetAddress;
    { X3D field "applicationID". } { }
    property ApplicationID: Integer read GetApplicationID write SetApplicationID;
    { X3D field "entityID". } { }
    property EntityID: Integer read GetEntityID write SetEntityID;
    { X3D field "multicastRelayHost". } { }
    property MulticastRelayHost: String read GetMulticastRelayHost write SetMulticastRelayHost;
    { X3D field "multicastRelayPort". } { }
    property MulticastRelayPort: Integer read GetMulticastRelayPort write SetMulticastRelayPort;
    { X3D field "port". } { }
    property Port: Integer read GetPort write SetPort;
    { X3D field "radioID". } { }
    property RadioID: Integer read GetRadioID write SetRadioID;
    { X3D field "readInterval". } { }
    property ReadInterval: Single read GetReadInterval write SetReadInterval;
    { X3D field "receivedPower". } { }
    property ReceivedPower: Single read GetReceivedPower write SetReceivedPower;
    { X3D field "receiverState". } { }
    property ReceiverState: Integer read GetReceiverState write SetReceiverState;
    { X3D field "rtpHeaderExpected". } { }
    property RtpHeaderExpected: Boolean read GetRtpHeaderExpected write SetRtpHeaderExpected;
    { X3D field "siteID". } { }
    property SiteID: Integer read GetSiteID write SetSiteID;
    { X3D field "transmitterApplicationID". } { }
    property TransmitterApplicationID: Integer read GetTransmitterApplicationID write SetTransmitterApplicationID;
    { X3D field "transmitterEntityID". } { }
    property TransmitterEntityID: Integer read GetTransmitterEntityID write SetTransmitterEntityID;
    { X3D field "transmitterRadioID". } { }
    property TransmitterRadioID: Integer read GetTransmitterRadioID write SetTransmitterRadioID;
    { X3D field "transmitterSiteID". } { }
    property TransmitterSiteID: Integer read GetTransmitterSiteID write SetTransmitterSiteID;
    { X3D field "whichGeometry". } { }
    property WhichGeometry: Integer read GetWhichGeometry write SetWhichGeometry;
    { X3D field "writeInterval". } { }
    property WriteInterval: Single read GetWriteInterval write SetWriteInterval;
    { X3D fields "bboxCenter" and "bboxSize" are get/set as TBox3D. } { }
    property BBox: TBox3D read GetBBox write SetBBox;

{$endif read_interface}

{$ifdef read_implementation}

{ TReceiverPduNode ----------------------------------------------- }

function TReceiverPduNode.GetAddress: String;
begin
  Result := FdAddress.Value;
end;

procedure TReceiverPduNode.SetAddress(const Value: String);
begin
  FdAddress.Send(Value);
end;

function TReceiverPduNode.GetApplicationID: Integer;
begin
  Result := FdApplicationID.Value;
end;

procedure TReceiverPduNode.SetApplicationID(const Value: Integer);
begin
  FdApplicationID.Send(Value);
end;

function TReceiverPduNode.GetEntityID: Integer;
begin
  Result := FdEntityID.Value;
end;

procedure TReceiverPduNode.SetEntityID(const Value: Integer);
begin
  FdEntityID.Send(Value);
end;

function TReceiverPduNode.GetMulticastRelayHost: String;
begin
  Result := FdMulticastRelayHost.Value;
end;

procedure TReceiverPduNode.SetMulticastRelayHost(const Value: String);
begin
  FdMulticastRelayHost.Send(Value);
end;

function TReceiverPduNode.GetMulticastRelayPort: Integer;
begin
  Result := FdMulticastRelayPort.Value;
end;

procedure TReceiverPduNode.SetMulticastRelayPort(const Value: Integer);
begin
  FdMulticastRelayPort.Send(Value);
end;

function TReceiverPduNode.GetPort: Integer;
begin
  Result := FdPort.Value;
end;

procedure TReceiverPduNode.SetPort(const Value: Integer);
begin
  FdPort.Send(Value);
end;

function TReceiverPduNode.GetRadioID: Integer;
begin
  Result := FdRadioID.Value;
end;

procedure TReceiverPduNode.SetRadioID(const Value: Integer);
begin
  FdRadioID.Send(Value);
end;

function TReceiverPduNode.GetReadInterval: Single;
begin
  Result := FdReadInterval.Value;
end;

procedure TReceiverPduNode.SetReadInterval(const Value: Single);
begin
  FdReadInterval.Send(Value);
end;

function TReceiverPduNode.GetReceivedPower: Single;
begin
  Result := FdReceivedPower.Value;
end;

procedure TReceiverPduNode.SetReceivedPower(const Value: Single);
begin
  FdReceivedPower.Send(Value);
end;

function TReceiverPduNode.GetReceiverState: Integer;
begin
  Result := FdReceiverState.Value;
end;

procedure TReceiverPduNode.SetReceiverState(const Value: Integer);
begin
  FdReceiverState.Send(Value);
end;

function TReceiverPduNode.GetRtpHeaderExpected: Boolean;
begin
  Result := FdRtpHeaderExpected.Value;
end;

procedure TReceiverPduNode.SetRtpHeaderExpected(const Value: Boolean);
begin
  FdRtpHeaderExpected.Send(Value);
end;

function TReceiverPduNode.GetSiteID: Integer;
begin
  Result := FdSiteID.Value;
end;

procedure TReceiverPduNode.SetSiteID(const Value: Integer);
begin
  FdSiteID.Send(Value);
end;

function TReceiverPduNode.GetTransmitterApplicationID: Integer;
begin
  Result := FdTransmitterApplicationID.Value;
end;

procedure TReceiverPduNode.SetTransmitterApplicationID(const Value: Integer);
begin
  FdTransmitterApplicationID.Send(Value);
end;

function TReceiverPduNode.GetTransmitterEntityID: Integer;
begin
  Result := FdTransmitterEntityID.Value;
end;

procedure TReceiverPduNode.SetTransmitterEntityID(const Value: Integer);
begin
  FdTransmitterEntityID.Send(Value);
end;

function TReceiverPduNode.GetTransmitterRadioID: Integer;
begin
  Result := FdTransmitterRadioID.Value;
end;

procedure TReceiverPduNode.SetTransmitterRadioID(const Value: Integer);
begin
  FdTransmitterRadioID.Send(Value);
end;

function TReceiverPduNode.GetTransmitterSiteID: Integer;
begin
  Result := FdTransmitterSiteID.Value;
end;

procedure TReceiverPduNode.SetTransmitterSiteID(const Value: Integer);
begin
  FdTransmitterSiteID.Send(Value);
end;

function TReceiverPduNode.GetWhichGeometry: Integer;
begin
  Result := FdWhichGeometry.Value;
end;

procedure TReceiverPduNode.SetWhichGeometry(const Value: Integer);
begin
  FdWhichGeometry.Send(Value);
end;

function TReceiverPduNode.GetWriteInterval: Single;
begin
  Result := FdWriteInterval.Value;
end;

procedure TReceiverPduNode.SetWriteInterval(const Value: Single);
begin
  FdWriteInterval.Send(Value);
end;

function TReceiverPduNode.GetBBox: TBox3D;
begin
  Result := TBox3D.FromCenterSize(FdBBoxCenter.Value, FdBBoxSize.Value);
end;

procedure TReceiverPduNode.SetBBox(const Value: TBox3D);
var
  ValueCenter, ValueSize: TVector3;
begin
  Value.ToCenterSize(ValueCenter, ValueSize);
  FdBBoxCenter.Send(ValueCenter);
  FdBBoxSize.Send(ValueSize);
end;

{$endif read_implementation}
