{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAddress: String;
    procedure SetAddress(const Value: String);
    function GetApplicationID: Integer;
    procedure SetApplicationID(const Value: Integer);
    function GetDataLength: Integer;
    procedure SetDataLength(const Value: Integer);
    function GetEncodingScheme: Integer;
    procedure SetEncodingScheme(const Value: Integer);
    function GetEntityID: Integer;
    procedure SetEntityID(const Value: Integer);
    function GetMulticastRelayHost: String;
    procedure SetMulticastRelayHost(const Value: String);
    function GetMulticastRelayPort: Integer;
    procedure SetMulticastRelayPort(const Value: Integer);
    function GetPort: Integer;
    procedure SetPort(const Value: Integer);
    function GetRadioID: Integer;
    procedure SetRadioID(const Value: Integer);
    function GetReadInterval: Single;
    procedure SetReadInterval(const Value: Single);
    function GetRtpHeaderExpected: Boolean;
    procedure SetRtpHeaderExpected(const Value: Boolean);
    function GetSampleRate: Integer;
    procedure SetSampleRate(const Value: Integer);
    function GetSamples: Integer;
    procedure SetSamples(const Value: Integer);
    function GetSiteID: Integer;
    procedure SetSiteID(const Value: Integer);
    function GetTdlType: Integer;
    procedure SetTdlType(const Value: Integer);
    function GetWhichGeometry: Integer;
    procedure SetWhichGeometry(const Value: Integer);
    function GetWriteInterval: Single;
    procedure SetWriteInterval(const Value: Single);
    function GetBBox: TBox3D;
    procedure SetBBox(const Value: TBox3D);
  public
    { X3D field "address". } { }
    property Address: String read GetAddress write SetAddress;
    { X3D field "applicationID". } { }
    property ApplicationID: Integer read GetApplicationID write SetApplicationID;
    { Set X3D field "data". } { }
    procedure SetData(const Value: array of LongInt);
    { Set X3D field "data". } { }
    procedure SetData(const Value: TLongIntList);
    { X3D field "dataLength". } { }
    property DataLength: Integer read GetDataLength write SetDataLength;
    { X3D field "encodingScheme". } { }
    property EncodingScheme: Integer read GetEncodingScheme write SetEncodingScheme;
    { X3D field "entityID". } { }
    property EntityID: Integer read GetEntityID write SetEntityID;
    { X3D field "multicastRelayHost". } { }
    property MulticastRelayHost: String read GetMulticastRelayHost write SetMulticastRelayHost;
    { X3D field "multicastRelayPort". } { }
    property MulticastRelayPort: Integer read GetMulticastRelayPort write SetMulticastRelayPort;
    { X3D field "port". } { }
    property Port: Integer read GetPort write SetPort;
    { X3D field "radioID". } { }
    property RadioID: Integer read GetRadioID write SetRadioID;
    { X3D field "readInterval". } { }
    property ReadInterval: Single read GetReadInterval write SetReadInterval;
    { X3D field "rtpHeaderExpected". } { }
    property RtpHeaderExpected: Boolean read GetRtpHeaderExpected write SetRtpHeaderExpected;
    { X3D field "sampleRate". } { }
    property SampleRate: Integer read GetSampleRate write SetSampleRate;
    { X3D field "samples". } { }
    property Samples: Integer read GetSamples write SetSamples;
    { X3D field "siteID". } { }
    property SiteID: Integer read GetSiteID write SetSiteID;
    { X3D field "tdlType". } { }
    property TdlType: Integer read GetTdlType write SetTdlType;
    { X3D field "whichGeometry". } { }
    property WhichGeometry: Integer read GetWhichGeometry write SetWhichGeometry;
    { X3D field "writeInterval". } { }
    property WriteInterval: Single read GetWriteInterval write SetWriteInterval;
    { X3D fields "bboxCenter" and "bboxSize" are get/set as TBox3D. } { }
    property BBox: TBox3D read GetBBox write SetBBox;

{$endif read_interface}

{$ifdef read_implementation}

{ TSignalPduNode ----------------------------------------------- }

function TSignalPduNode.GetAddress: String;
begin
  Result := FdAddress.Value;
end;

procedure TSignalPduNode.SetAddress(const Value: String);
begin
  FdAddress.Send(Value);
end;

function TSignalPduNode.GetApplicationID: Integer;
begin
  Result := FdApplicationID.Value;
end;

procedure TSignalPduNode.SetApplicationID(const Value: Integer);
begin
  FdApplicationID.Send(Value);
end;

procedure TSignalPduNode.SetData(const Value: array of LongInt);
begin
  FdData.Send(Value);
end;

procedure TSignalPduNode.SetData(const Value: TLongIntList);
begin
  FdData.Send(Value);
end;

function TSignalPduNode.GetDataLength: Integer;
begin
  Result := FdDataLength.Value;
end;

procedure TSignalPduNode.SetDataLength(const Value: Integer);
begin
  FdDataLength.Send(Value);
end;

function TSignalPduNode.GetEncodingScheme: Integer;
begin
  Result := FdEncodingScheme.Value;
end;

procedure TSignalPduNode.SetEncodingScheme(const Value: Integer);
begin
  FdEncodingScheme.Send(Value);
end;

function TSignalPduNode.GetEntityID: Integer;
begin
  Result := FdEntityID.Value;
end;

procedure TSignalPduNode.SetEntityID(const Value: Integer);
begin
  FdEntityID.Send(Value);
end;

function TSignalPduNode.GetMulticastRelayHost: String;
begin
  Result := FdMulticastRelayHost.Value;
end;

procedure TSignalPduNode.SetMulticastRelayHost(const Value: String);
begin
  FdMulticastRelayHost.Send(Value);
end;

function TSignalPduNode.GetMulticastRelayPort: Integer;
begin
  Result := FdMulticastRelayPort.Value;
end;

procedure TSignalPduNode.SetMulticastRelayPort(const Value: Integer);
begin
  FdMulticastRelayPort.Send(Value);
end;

function TSignalPduNode.GetPort: Integer;
begin
  Result := FdPort.Value;
end;

procedure TSignalPduNode.SetPort(const Value: Integer);
begin
  FdPort.Send(Value);
end;

function TSignalPduNode.GetRadioID: Integer;
begin
  Result := FdRadioID.Value;
end;

procedure TSignalPduNode.SetRadioID(const Value: Integer);
begin
  FdRadioID.Send(Value);
end;

function TSignalPduNode.GetReadInterval: Single;
begin
  Result := FdReadInterval.Value;
end;

procedure TSignalPduNode.SetReadInterval(const Value: Single);
begin
  FdReadInterval.Send(Value);
end;

function TSignalPduNode.GetRtpHeaderExpected: Boolean;
begin
  Result := FdRtpHeaderExpected.Value;
end;

procedure TSignalPduNode.SetRtpHeaderExpected(const Value: Boolean);
begin
  FdRtpHeaderExpected.Send(Value);
end;

function TSignalPduNode.GetSampleRate: Integer;
begin
  Result := FdSampleRate.Value;
end;

procedure TSignalPduNode.SetSampleRate(const Value: Integer);
begin
  FdSampleRate.Send(Value);
end;

function TSignalPduNode.GetSamples: Integer;
begin
  Result := FdSamples.Value;
end;

procedure TSignalPduNode.SetSamples(const Value: Integer);
begin
  FdSamples.Send(Value);
end;

function TSignalPduNode.GetSiteID: Integer;
begin
  Result := FdSiteID.Value;
end;

procedure TSignalPduNode.SetSiteID(const Value: Integer);
begin
  FdSiteID.Send(Value);
end;

function TSignalPduNode.GetTdlType: Integer;
begin
  Result := FdTdlType.Value;
end;

procedure TSignalPduNode.SetTdlType(const Value: Integer);
begin
  FdTdlType.Send(Value);
end;

function TSignalPduNode.GetWhichGeometry: Integer;
begin
  Result := FdWhichGeometry.Value;
end;

procedure TSignalPduNode.SetWhichGeometry(const Value: Integer);
begin
  FdWhichGeometry.Send(Value);
end;

function TSignalPduNode.GetWriteInterval: Single;
begin
  Result := FdWriteInterval.Value;
end;

procedure TSignalPduNode.SetWriteInterval(const Value: Single);
begin
  FdWriteInterval.Send(Value);
end;

function TSignalPduNode.GetBBox: TBox3D;
begin
  Result := TBox3D.FromCenterSize(FdBBoxCenter.Value, FdBBoxSize.Value);
end;

procedure TSignalPduNode.SetBBox(const Value: TBox3D);
var
  ValueCenter, ValueSize: TVector3;
begin
  Value.ToCenterSize(ValueCenter, ValueSize);
  FdBBoxCenter.Send(ValueCenter);
  FdBBoxSize.Send(ValueSize);
end;

{$endif read_implementation}
