{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetCenterOfMass: TVector3;
    procedure SetCenterOfMass(const Value: TVector3);
    function GetCoord: TAbstractCoordinateNode;
    procedure SetCoord(const Value: TAbstractCoordinateNode);
    function GetMass: Single;
    procedure SetMass(const Value: Single);
    function GetNameField: String;
    procedure SetNameField(const Value: String);
    function GetRotation: TVector4;
    procedure SetRotation(const Value: TVector4);
    function GetScale: TVector3;
    procedure SetScale(const Value: TVector3);
    function GetTranslation: TVector3;
    procedure SetTranslation(const Value: TVector3);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdCenterOfMass: TSFVec3f;
    { Internal wrapper for property @link(CenterOfMass). This wrapper API may change, we advise to access simpler @link(CenterOfMass) instead. }
    public property FdCenterOfMass: TSFVec3f read FFdCenterOfMass;
    {  }
    property CenterOfMass: TVector3 read GetCenterOfMass write SetCenterOfMass;

    strict private FFdCoord: TSFNode;
    { Internal wrapper for property @link(Coord). This wrapper API may change, we advise to access simpler @link(Coord) instead. }
    public property FdCoord: TSFNode read FFdCoord;
    {  }
    property Coord: TAbstractCoordinateNode read GetCoord write SetCoord;

    strict private FFdDisplacers: TMFNode;
    { Internal wrapper for property @link(Displacers). This wrapper API may change, we advise to access simpler @link(Displacers) instead. }
    public property FdDisplacers: TMFNode read FFdDisplacers;
    {  }
    procedure SetDisplacers(const Value: array of THAnimDisplacerNode);

    strict private FFdMass: TSFFloat;
    { Internal wrapper for property @link(Mass). This wrapper API may change, we advise to access simpler @link(Mass) instead. }
    public property FdMass: TSFFloat read FFdMass;
    {  }
    property Mass: Single read GetMass write SetMass;

    strict private FFdMomentsOfInertia: TMFFloat;
    { Internal wrapper for property @link(MomentsOfInertia). This wrapper API may change, we advise to access simpler @link(MomentsOfInertia) instead. }
    public property FdMomentsOfInertia: TMFFloat read FFdMomentsOfInertia;
    {  }
    procedure SetMomentsOfInertia(const Value: array of Single); overload;
    {  }
    procedure SetMomentsOfInertia(const Value: TSingleList); overload;

    strict private FFdName: TSFString;
    { Internal wrapper for property @link(NameField). This wrapper API may change, we advise to access simpler @link(NameField) instead. }
    public property FdName: TSFString read FFdName;
    {  }
    property NameField: String read GetNameField write SetNameField;

    strict private FFdRotation: TSFRotation;
    { Internal wrapper for property @link(Rotation). This wrapper API may change, we advise to access simpler @link(Rotation) instead. }
    public property FdRotation: TSFRotation read FFdRotation;
    {  }
    property Rotation: TVector4 read GetRotation write SetRotation;

    strict private FFdScale: TSFVec3f;
    { Internal wrapper for property @link(Scale). This wrapper API may change, we advise to access simpler @link(Scale) instead. }
    public property FdScale: TSFVec3f read FFdScale;
    {  }
    property Scale: TVector3 read GetScale write SetScale;

    strict private FFdTranslation: TSFVec3f;
    { Internal wrapper for property @link(Translation). This wrapper API may change, we advise to access simpler @link(Translation) instead. }
    public property FdTranslation: TSFVec3f read FFdTranslation;
    {  }
    property Translation: TVector3 read GetTranslation write SetTranslation;

{$endif read_interface}

{$ifdef read_implementation}

{ THAnimSegmentNode ----------------------------------------------- }

function THAnimSegmentNode.GetCenterOfMass: TVector3;
begin
  Result := FdCenterOfMass.Value;
end;

procedure THAnimSegmentNode.SetCenterOfMass(const Value: TVector3);
begin
  FdCenterOfMass.Send(Value);
end;

function THAnimSegmentNode.GetCoord: TAbstractCoordinateNode;
begin
  if FdCoord.Value is TAbstractCoordinateNode then
    Result := TAbstractCoordinateNode(FdCoord.Value)
  else
    Result := nil;
end;

procedure THAnimSegmentNode.SetCoord(const Value: TAbstractCoordinateNode);
begin
  FdCoord.Send(Value);
end;

procedure THAnimSegmentNode.SetDisplacers(const Value: array of THAnimDisplacerNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimDisplacerNode));
  FdDisplacers.Send(A);
end;

function THAnimSegmentNode.GetMass: Single;
begin
  Result := FdMass.Value;
end;

procedure THAnimSegmentNode.SetMass(const Value: Single);
begin
  FdMass.Send(Value);
end;

procedure THAnimSegmentNode.SetMomentsOfInertia(const Value: array of Single);
begin
  FdMomentsOfInertia.Send(Value);
end;

procedure THAnimSegmentNode.SetMomentsOfInertia(const Value: TSingleList);
begin
  FdMomentsOfInertia.Send(Value);
end;

function THAnimSegmentNode.GetNameField: String;
begin
  Result := FdName.Value;
end;

procedure THAnimSegmentNode.SetNameField(const Value: String);
begin
  FdName.Send(Value);
end;

function THAnimSegmentNode.GetRotation: TVector4;
begin
  Result := FdRotation.Value;
end;

procedure THAnimSegmentNode.SetRotation(const Value: TVector4);
begin
  FdRotation.Send(Value);
end;

function THAnimSegmentNode.GetScale: TVector3;
begin
  Result := FdScale.Value;
end;

procedure THAnimSegmentNode.SetScale(const Value: TVector3);
begin
  FdScale.Send(Value);
end;

function THAnimSegmentNode.GetTranslation: TVector3;
begin
  Result := FdTranslation.Value;
end;

procedure THAnimSegmentNode.SetTranslation(const Value: TVector3);
begin
  FdTranslation.Send(Value);
end;

class function THAnimSegmentNode.ClassX3DType: String;
begin
  Result := 'HAnimSegment';
end;

procedure THAnimSegmentNode.CreateNode;
begin
  inherited;

  FFdCenterOfMass := TSFVec3f.Create(Self, True, 'centerOfMass', Vector3(0, 0, 0));
   FdCenterOfMass.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCenterOfMass);

  FFdCoord := TSFNode.Create(Self, True, 'coord', [TAbstractCoordinateNode]);
   FdCoord.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCoord);

  FFdDisplacers := TMFNode.Create(Self, True, 'displacers', [THAnimDisplacerNode]);
   FdDisplacers.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDisplacers);

  FFdMass := TSFFloat.Create(Self, True, 'mass', 0);
   FdMass.ChangeAlways := chVisibleNonGeometry;
   FdMass.MustBeNonnegative := true;
  AddField(FFdMass);

  FFdMomentsOfInertia := TMFFloat.Create(Self, True, 'momentsOfInertia', [0, 0, 0, 0, 0, 0, 0, 0, 0]);
   FdMomentsOfInertia.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMomentsOfInertia);

  FFdName := TSFString.Create(Self, True, 'name', '');
   FdName.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdName);

  FFdRotation := TSFRotation.Create(Self, True, 'rotation', Vector3(0, 0, 1), 0);
   FdRotation.ChangeAlways := chTransform;
  AddField(FFdRotation);

  FFdScale := TSFVec3f.Create(Self, True, 'scale', Vector3(1, 1, 1));
   FdScale.ChangeAlways := chTransform;
  AddField(FFdScale);

  FFdTranslation := TSFVec3f.Create(Self, True, 'translation', Vector3(0, 0, 0));
   FdTranslation.ChangeAlways := chTransform;
  AddField(FFdTranslation);
end;

{$endif read_implementation}
