{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdTexCoord: TMFNode;
    { Internal wrapper for property @link(TexCoord). This wrapper API may change, we advise to access simpler @link(TexCoord) instead. }
    public property FdTexCoord: TMFNode read FFdTexCoord;
    {  }
    procedure SetTexCoord(const Value: array of TAbstractSingleTextureCoordinateNode);

{$endif read_interface}

{$ifdef read_implementation}

{ TMultiTextureCoordinateNode ----------------------------------------------- }

procedure TMultiTextureCoordinateNode.SetTexCoord(const Value: array of TAbstractSingleTextureCoordinateNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractSingleTextureCoordinateNode));
  FdTexCoord.Send(A);
end;

class function TMultiTextureCoordinateNode.ClassX3DType: String;
begin
  Result := 'MultiTextureCoordinate';
end;

procedure TMultiTextureCoordinateNode.CreateNode;
begin
  inherited;

  FFdTexCoord := TMFNode.Create(Self, True, 'texCoord', [TAbstractSingleTextureCoordinateNode]);
   FdTexCoord.ChangeAlways := chTextureCoordinate;
  AddField(FFdTexCoord);
end;

{$endif read_implementation}
