{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetProfileCurve: TAbstractNurbsControlCurveNode;
    procedure SetProfileCurve(const Value: TAbstractNurbsControlCurveNode);
    function GetTrajectoryCurve: TAbstractNurbsControlCurveNode;
    procedure SetTrajectoryCurve(const Value: TAbstractNurbsControlCurveNode);
    function GetCcw: Boolean;
    procedure SetCcw(const Value: Boolean);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdProfileCurve: TSFNode;
    { Internal wrapper for property @link(ProfileCurve). This wrapper API may change, we advise to access simpler @link(ProfileCurve) instead. }
    public property FdProfileCurve: TSFNode read FFdProfileCurve;
    {  }
    property ProfileCurve: TAbstractNurbsControlCurveNode read GetProfileCurve write SetProfileCurve;

    strict private FFdTrajectoryCurve: TSFNode;
    { Internal wrapper for property @link(TrajectoryCurve). This wrapper API may change, we advise to access simpler @link(TrajectoryCurve) instead. }
    public property FdTrajectoryCurve: TSFNode read FFdTrajectoryCurve;
    {  }
    property TrajectoryCurve: TAbstractNurbsControlCurveNode read GetTrajectoryCurve write SetTrajectoryCurve;

    strict private FFdCcw: TSFBool;
    { Internal wrapper for property @link(Ccw). This wrapper API may change, we advise to access simpler @link(Ccw) instead. }
    public property FdCcw: TSFBool read FFdCcw;
    {  }
    property Ccw: Boolean read GetCcw write SetCcw;

    strict private FFdSolid: TSFBool;
    { Internal wrapper for property @link(Solid). This wrapper API may change, we advise to access simpler @link(Solid) instead. }
    public property FdSolid: TSFBool read FFdSolid;

{$endif read_interface}

{$ifdef read_implementation}

{ TNurbsSwungSurfaceNode ----------------------------------------------- }

function TNurbsSwungSurfaceNode.GetProfileCurve: TAbstractNurbsControlCurveNode;
begin
  if FdProfileCurve.Value is TAbstractNurbsControlCurveNode then
    Result := TAbstractNurbsControlCurveNode(FdProfileCurve.Value)
  else
    Result := nil;
end;

procedure TNurbsSwungSurfaceNode.SetProfileCurve(const Value: TAbstractNurbsControlCurveNode);
begin
  FdProfileCurve.Send(Value);
end;

function TNurbsSwungSurfaceNode.GetTrajectoryCurve: TAbstractNurbsControlCurveNode;
begin
  if FdTrajectoryCurve.Value is TAbstractNurbsControlCurveNode then
    Result := TAbstractNurbsControlCurveNode(FdTrajectoryCurve.Value)
  else
    Result := nil;
end;

procedure TNurbsSwungSurfaceNode.SetTrajectoryCurve(const Value: TAbstractNurbsControlCurveNode);
begin
  FdTrajectoryCurve.Send(Value);
end;

function TNurbsSwungSurfaceNode.GetCcw: Boolean;
begin
  Result := FdCcw.Value;
end;

procedure TNurbsSwungSurfaceNode.SetCcw(const Value: Boolean);
begin
  FdCcw.Send(Value);
end;

class function TNurbsSwungSurfaceNode.ClassX3DType: String;
begin
  Result := 'NurbsSwungSurface';
end;

procedure TNurbsSwungSurfaceNode.CreateNode;
begin
  inherited;

  FFdProfileCurve := TSFNode.Create(Self, True, 'profileCurve', [TAbstractNurbsControlCurveNode]);
   FdProfileCurve.ChangeAlways := chGeometry;
  AddField(FFdProfileCurve);

  FFdTrajectoryCurve := TSFNode.Create(Self, True, 'trajectoryCurve', [TAbstractNurbsControlCurveNode]);
   FdTrajectoryCurve.ChangeAlways := chGeometry;
  AddField(FFdTrajectoryCurve);

  FFdCcw := TSFBool.Create(Self, False, 'ccw', true);
   FdCcw.ChangeAlways := chGeometry;
  AddField(FFdCcw);

  FFdSolid := TSFBool.Create(Self, False, 'solid', true);
   FdSolid.ChangeAlways := chGeometry;
  AddField(FFdSolid);
end;

{$endif read_implementation}
