{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetBackground: TAbstractBackgroundNode;
    procedure SetBackground(const Value: TAbstractBackgroundNode);
    function GetFog: TFogNode;
    procedure SetFog(const Value: TFogNode);
    function GetScene: TAbstractNode;
    procedure SetScene(const Value: TAbstractNode);
    function GetUpdate: TTextureUpdate;
    procedure SetUpdate(const Value: TTextureUpdate);
    function GetTextureProperties: TTexturePropertiesNode;
    procedure SetTextureProperties(const Value: TTexturePropertiesNode);
    function GetRepeatS: Boolean;
    procedure SetRepeatS(const Value: Boolean);
    function GetRepeatT: Boolean;
    procedure SetRepeatT(const Value: Boolean);
    function GetRepeatR: Boolean;
    procedure SetRepeatR(const Value: Boolean);
    function GetDescription: String;
    procedure SetDescription(const Value: String);
    function GetFrameBufferMode: String;
    procedure SetFrameBufferMode(const Value: String);
    function GetTriggerName: String;
    procedure SetTriggerName(const Value: String);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdBackground: TSFNode;
    { Internal wrapper for property @link(Background). This wrapper API may change, we advise to access simpler @link(Background) instead. }
    public property FdBackground: TSFNode read FFdBackground;
    {  }
    property Background: TAbstractBackgroundNode read GetBackground write SetBackground;

    strict private FFdFog: TSFNode;
    { Internal wrapper for property @link(Fog). This wrapper API may change, we advise to access simpler @link(Fog) instead. }
    public property FdFog: TSFNode read FFdFog;
    {  }
    property Fog: TFogNode read GetFog write SetFog;

    strict private FFdEnvironment: TSFNode;
    { Internal wrapper for property @link(Environment). This wrapper API may change, we advise to access simpler @link(Environment) instead. }
    public property FdEnvironment: TSFNode read FFdEnvironment;

    strict private FFdScene: TSFNode;
    { Internal wrapper for property @link(Scene). This wrapper API may change, we advise to access simpler @link(Scene) instead. }
    public property FdScene: TSFNode read FFdScene;
    {  }
    property Scene: TAbstractNode read GetScene write SetScene;

    strict private FFdForeground: TSFNode;
    { Internal wrapper for property @link(Foreground). This wrapper API may change, we advise to access simpler @link(Foreground) instead. }
    public property FdForeground: TSFNode read FFdForeground;

    strict private FFdDimensions: TMFInt32;
    { Internal wrapper for property @link(Dimensions). This wrapper API may change, we advise to access simpler @link(Dimensions) instead. }
    public property FdDimensions: TMFInt32 read FFdDimensions;
    {  }
    procedure SetDimensions(const Value: array of LongInt); overload;
    {  }
    procedure SetDimensions(const Value: TLongIntList); overload;

    strict private FFdUpdate: TSFStringEnum;
    { Internal wrapper for property @link(Update). This wrapper API may change, we advise to access simpler @link(Update) instead. }
    public property FdUpdate: TSFStringEnum read FFdUpdate;
    { When to update the texture contents. }
    property Update: TTextureUpdate read GetUpdate write SetUpdate;

    strict private FFdViewpoint: TSFNode;
    { Internal wrapper for property @link(Viewpoint). This wrapper API may change, we advise to access simpler @link(Viewpoint) instead. }
    public property FdViewpoint: TSFNode read FFdViewpoint;

    strict private FFdTextureProperties: TSFNode;
    { Internal wrapper for property @link(TextureProperties). This wrapper API may change, we advise to access simpler @link(TextureProperties) instead. }
    public property FdTextureProperties: TSFNode read FFdTextureProperties;
    {  }
    property TextureProperties: TTexturePropertiesNode read GetTextureProperties write SetTextureProperties;

    strict private FFdRepeatS: TSFBool;
    { Internal wrapper for property @link(RepeatS). This wrapper API may change, we advise to access simpler @link(RepeatS) instead. }
    public property FdRepeatS: TSFBool read FFdRepeatS;
    {  }
    property RepeatS: Boolean read GetRepeatS write SetRepeatS;

    strict private FFdRepeatT: TSFBool;
    { Internal wrapper for property @link(RepeatT). This wrapper API may change, we advise to access simpler @link(RepeatT) instead. }
    public property FdRepeatT: TSFBool read FFdRepeatT;
    {  }
    property RepeatT: Boolean read GetRepeatT write SetRepeatT;

    strict private FFdRepeatR: TSFBool;
    { Internal wrapper for property @link(RepeatR). This wrapper API may change, we advise to access simpler @link(RepeatR) instead. }
    public property FdRepeatR: TSFBool read FFdRepeatR;
    {  }
    property RepeatR: Boolean read GetRepeatR write SetRepeatR;

    strict private FFdDepthMap: TMFBool;
    { Internal wrapper for property @link(DepthMap). This wrapper API may change, we advise to access simpler @link(DepthMap) instead. }
    public property FdDepthMap: TMFBool read FFdDepthMap;
    {  }
    procedure SetDepthMap(const Value: array of boolean); overload;
    {  }
    procedure SetDepthMap(const Value: TBooleanList); overload;

    strict private FFdZOffset: TMFInt32;
    { Internal wrapper for property @link(ZOffset). This wrapper API may change, we advise to access simpler @link(ZOffset) instead. }
    public property FdZOffset: TMFInt32 read FFdZOffset;
    {  }
    procedure SetZOffset(const Value: array of LongInt); overload;
    {  }
    procedure SetZOffset(const Value: TLongIntList); overload;

    strict private FFdTargets: TMFNode;
    { Internal wrapper for property @link(Targets). This wrapper API may change, we advise to access simpler @link(Targets) instead. }
    public property FdTargets: TMFNode read FFdTargets;
    {  }
    procedure SetTargets(const Value: array of TAbstractTextureNode);

    strict private FFdDescription: TSFString;
    { Internal wrapper for property @link(Description). This wrapper API may change, we advise to access simpler @link(Description) instead. }
    public property FdDescription: TSFString read FFdDescription;
    {  }
    property Description: String read GetDescription write SetDescription;

    strict private FEventViewing: TSFMatrix4fEvent;
    {  }
    public property EventViewing: TSFMatrix4fEvent read FEventViewing;

    strict private FEventProjection: TSFMatrix4fEvent;
    {  }
    public property EventProjection: TSFMatrix4fEvent read FEventProjection;

    strict private FFdFrameBufferMode: TSFString;
    { Internal wrapper for property @link(FrameBufferMode). This wrapper API may change, we advise to access simpler @link(FrameBufferMode) instead. }
    public property FdFrameBufferMode: TSFString read FFdFrameBufferMode;
    {  }
    property FrameBufferMode: String read GetFrameBufferMode write SetFrameBufferMode;

    strict private FFdExcludeNodes: TMFNode;
    { Internal wrapper for property @link(ExcludeNodes). This wrapper API may change, we advise to access simpler @link(ExcludeNodes) instead. }
    public property FdExcludeNodes: TMFNode read FFdExcludeNodes;

    strict private FFdTriggerName: TSFString;
    { Internal wrapper for property @link(TriggerName). This wrapper API may change, we advise to access simpler @link(TriggerName) instead. }
    public property FdTriggerName: TSFString read FFdTriggerName;
    {  }
    property TriggerName: String read GetTriggerName write SetTriggerName;

    strict private FEventImage_changed: TSFImageEvent;
    {  }
    public property EventImage_changed: TSFImageEvent read FEventImage_changed;

    strict private FEventRendering: TSFBoolEvent;
    {  }
    public property EventRendering: TSFBoolEvent read FEventRendering;

{$endif read_interface}

{$ifdef read_implementation}

{ TRenderedTextureNode ----------------------------------------------- }

function TRenderedTextureNode.GetBackground: TAbstractBackgroundNode;
begin
  if FdBackground.Value is TAbstractBackgroundNode then
    Result := TAbstractBackgroundNode(FdBackground.Value)
  else
    Result := nil;
end;

procedure TRenderedTextureNode.SetBackground(const Value: TAbstractBackgroundNode);
begin
  FdBackground.Send(Value);
end;

function TRenderedTextureNode.GetFog: TFogNode;
begin
  if FdFog.Value is TFogNode then
    Result := TFogNode(FdFog.Value)
  else
    Result := nil;
end;

procedure TRenderedTextureNode.SetFog(const Value: TFogNode);
begin
  FdFog.Send(Value);
end;

function TRenderedTextureNode.GetScene: TAbstractNode;
begin
  if FdScene.Value is TAbstractNode then
    Result := TAbstractNode(FdScene.Value)
  else
    Result := nil;
end;

procedure TRenderedTextureNode.SetScene(const Value: TAbstractNode);
begin
  FdScene.Send(Value);
end;

procedure TRenderedTextureNode.SetDimensions(const Value: array of LongInt);
begin
  FdDimensions.Send(Value);
end;

procedure TRenderedTextureNode.SetDimensions(const Value: TLongIntList);
begin
  FdDimensions.Send(Value);
end;

function TRenderedTextureNode.GetUpdate: TTextureUpdate;
begin
  Result := TTextureUpdate(FdUpdate.EnumValue);
end;

procedure TRenderedTextureNode.SetUpdate(const Value: TTextureUpdate);
begin
  FdUpdate.SendEnumValue(Ord(Value));
end;

function TRenderedTextureNode.GetTextureProperties: TTexturePropertiesNode;
begin
  if FdTextureProperties.Value is TTexturePropertiesNode then
    Result := TTexturePropertiesNode(FdTextureProperties.Value)
  else
    Result := nil;
end;

procedure TRenderedTextureNode.SetTextureProperties(const Value: TTexturePropertiesNode);
begin
  FdTextureProperties.Send(Value);
end;

function TRenderedTextureNode.GetRepeatS: Boolean;
begin
  Result := FdRepeatS.Value;
end;

procedure TRenderedTextureNode.SetRepeatS(const Value: Boolean);
begin
  FdRepeatS.Send(Value);
end;

function TRenderedTextureNode.GetRepeatT: Boolean;
begin
  Result := FdRepeatT.Value;
end;

procedure TRenderedTextureNode.SetRepeatT(const Value: Boolean);
begin
  FdRepeatT.Send(Value);
end;

function TRenderedTextureNode.GetRepeatR: Boolean;
begin
  Result := FdRepeatR.Value;
end;

procedure TRenderedTextureNode.SetRepeatR(const Value: Boolean);
begin
  FdRepeatR.Send(Value);
end;

procedure TRenderedTextureNode.SetDepthMap(const Value: array of boolean);
begin
  FdDepthMap.Send(Value);
end;

procedure TRenderedTextureNode.SetDepthMap(const Value: TBooleanList);
begin
  FdDepthMap.Send(Value);
end;

procedure TRenderedTextureNode.SetZOffset(const Value: array of LongInt);
begin
  FdZOffset.Send(Value);
end;

procedure TRenderedTextureNode.SetZOffset(const Value: TLongIntList);
begin
  FdZOffset.Send(Value);
end;

procedure TRenderedTextureNode.SetTargets(const Value: array of TAbstractTextureNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractTextureNode));
  FdTargets.Send(A);
end;

function TRenderedTextureNode.GetDescription: String;
begin
  Result := FdDescription.Value;
end;

procedure TRenderedTextureNode.SetDescription(const Value: String);
begin
  FdDescription.Send(Value);
end;

function TRenderedTextureNode.GetFrameBufferMode: String;
begin
  Result := FdFrameBufferMode.Value;
end;

procedure TRenderedTextureNode.SetFrameBufferMode(const Value: String);
begin
  FdFrameBufferMode.Send(Value);
end;

function TRenderedTextureNode.GetTriggerName: String;
begin
  Result := FdTriggerName.Value;
end;

procedure TRenderedTextureNode.SetTriggerName(const Value: String);
begin
  FdTriggerName.Send(Value);
end;

class function TRenderedTextureNode.ClassX3DType: String;
begin
  Result := 'RenderedTexture';
end;

procedure TRenderedTextureNode.CreateNode;
begin
  inherited;

  FFdBackground := TSFNode.Create(Self, True, 'background', [TAbstractBackgroundNode]);
   FdBackground.ChangeAlways := chGeneratedTextureUpdateNeeded;
  AddField(FFdBackground);

  FFdFog := TSFNode.Create(Self, True, 'fog', [TFogNode]);
   FdFog.ChangeAlways := chGeneratedTextureUpdateNeeded;
  AddField(FFdFog);

  FFdEnvironment := TSFNode.Create(Self, True, 'environment', []);
   FdEnvironment.ChangeAlways := chGeneratedTextureUpdateNeeded;
  AddField(FFdEnvironment);

  FFdScene := TSFNode.Create(Self, True, 'scene', [TAbstractNode]);
   FdScene.ChangeAlways := chGeneratedTextureUpdateNeeded;
  AddField(FFdScene);

  FFdForeground := TSFNode.Create(Self, True, 'foreground', []);
   FdForeground.ChangeAlways := chGeneratedTextureUpdateNeeded;
  AddField(FFdForeground);

  FFdDimensions := TMFInt32.Create(Self, True, 'dimensions', [DefaultRenderedTextureWidth, DefaultRenderedTextureHeight, 4, 1, 1]);
   FdDimensions.ChangeAlways := chTextureRendererProperties;
  AddField(FFdDimensions);

  FFdUpdate := TSFStringEnum.Create(Self, True, 'update', @TextureUpdateNames, Ord(High(TextureUpdateNames)) + 1, Ord(upNone));
   FdUpdate.ChangeAlways := chRedisplay;
  AddField(FFdUpdate);

  FFdViewpoint := TSFNode.Create(Self, True, 'viewpoint', [TAbstractViewpointNode, TViewpointMirrorNode]);
   FdViewpoint.ChangeAlways := chGeneratedTextureUpdateNeeded;
  AddField(FFdViewpoint);

  FFdTextureProperties := TSFNode.Create(Self, False, 'textureProperties', [TTexturePropertiesNode]);
   FdTextureProperties.ChangeAlways := chTextureRendererProperties;
  AddField(FFdTextureProperties);

  FFdRepeatS := TSFBool.Create(Self, False, 'repeatS', true);
   FdRepeatS.ChangeAlways := chTextureRendererProperties;
  AddField(FFdRepeatS);

  FFdRepeatT := TSFBool.Create(Self, False, 'repeatT', true);
   FdRepeatT.ChangeAlways := chTextureRendererProperties;
  AddField(FFdRepeatT);

  FFdRepeatR := TSFBool.Create(Self, False, 'repeatR', true);
   FdRepeatR.ChangeAlways := chTextureRendererProperties;
  AddField(FFdRepeatR);

  FFdDepthMap := TMFBool.Create(Self, True, 'depthMap', []);
   FdDepthMap.ChangeAlways := chTextureRendererProperties;
  AddField(FFdDepthMap);

  FFdZOffset := TMFInt32.Create(Self, True, 'zOffset', []);
   FdZOffset.ChangeAlways := chTextureRendererProperties;
  AddField(FFdZOffset);

  FFdTargets := TMFNode.Create(Self, True, 'targets', [TAbstractTextureNode]);
   FdTargets.ChangeAlways := chTextureRendererProperties;
  AddField(FFdTargets);

  FFdDescription := TSFString.Create(Self, True, 'description', '');
   FdDescription.ChangeAlways := chNone;
  AddField(FFdDescription);

  FEventViewing := TSFMatrix4fEvent.Create(Self, 'viewing', false);
  AddEvent(FEventViewing);

  FEventProjection := TSFMatrix4fEvent.Create(Self, 'projection', false);
  AddEvent(FEventProjection);

  FFdFrameBufferMode := TSFString.Create(Self, True, 'frameBufferMode', 'AUTO');
   FdFrameBufferMode.ChangeAlways := chTextureRendererProperties;
  AddField(FFdFrameBufferMode);

  FFdExcludeNodes := TMFNode.Create(Self, False, 'excludeNodes', []);
   FdExcludeNodes.ChangeAlways := chGeneratedTextureUpdateNeeded;
  AddField(FFdExcludeNodes);

  FFdTriggerName := TSFString.Create(Self, False, 'triggerName', 'Render');
   FdTriggerName.ChangeAlways := chNone;
  AddField(FFdTriggerName);

  FEventImage_changed := TSFImageEvent.Create(Self, 'image_changed', false);
  AddEvent(FEventImage_changed);

  FEventRendering := TSFBoolEvent.Create(Self, 'rendering', false);
  AddEvent(FEventRendering);
end;

{$endif read_implementation}
