{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector3;
    procedure SetCenter(const Value: TVector3);
    function GetRotation: TVector4;
    procedure SetRotation(const Value: TVector4);
    function GetScale: TVector3;
    procedure SetScale(const Value: TVector3);
    function GetScaleOrientation: TVector4;
    procedure SetScaleOrientation(const Value: TVector4);
    function GetTranslation: TVector3;
    procedure SetTranslation(const Value: TVector3);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdCenter: TSFVec3f;
    { Internal wrapper for property @link(Center). This wrapper API may change, we advise to access simpler @link(Center) instead. }
    public property FdCenter: TSFVec3f read FFdCenter;
    { Center point around which the @link(Rotation) and @link(Scale) is performed. }
    property Center: TVector3 read GetCenter write SetCenter;

    strict private FFdRotation: TSFRotation;
    { Internal wrapper for property @link(Rotation). This wrapper API may change, we advise to access simpler @link(Rotation) instead. }
    public property FdRotation: TSFRotation read FFdRotation;
    { Rotate children in 3D, around a specified axis. Rotation is expressed as a 4D vector, in which the first 3 components specify the rotation axis (does not need to be normalized, but must be non-zero) and the last component is the rotation angle @italic(in radians). Rotation is done around @link(Center). }
    property Rotation: TVector4 read GetRotation write SetRotation;

    strict private FFdScale: TSFVec3f;
    { Internal wrapper for property @link(Scale). This wrapper API may change, we advise to access simpler @link(Scale) instead. }
    public property FdScale: TSFVec3f read FFdScale;
    { Scale in 3D. Scaling is done around @link(Center) and with orientation given by @link(ScaleOrientation). Note about negative scale: We do the best we can to work with @italic(any) scale value, even negative or zero. But usually, it's best to keep the scale positive. See the @link(TCastleTransform.Scale) documentation for some good guidelines about the scale. }
    property Scale: TVector3 read GetScale write SetScale;

    strict private FFdScaleOrientation: TSFRotation;
    { Internal wrapper for property @link(ScaleOrientation). This wrapper API may change, we advise to access simpler @link(ScaleOrientation) instead. }
    public property FdScaleOrientation: TSFRotation read FFdScaleOrientation;
    { Orientation in which 3D @link(Scale) is performed. }
    property ScaleOrientation: TVector4 read GetScaleOrientation write SetScaleOrientation;

    strict private FFdTranslation: TSFVec3f;
    { Internal wrapper for property @link(Translation). This wrapper API may change, we advise to access simpler @link(Translation) instead. }
    public property FdTranslation: TSFVec3f read FFdTranslation;
    { Translation (move) the children nodes. }
    property Translation: TVector3 read GetTranslation write SetTranslation;

{$endif read_interface}

{$ifdef read_implementation}

{ TTransformNode ----------------------------------------------- }

function TTransformNode.GetCenter: TVector3;
begin
  Result := FdCenter.Value;
end;

procedure TTransformNode.SetCenter(const Value: TVector3);
begin
  FdCenter.Send(Value);
end;

function TTransformNode.GetRotation: TVector4;
begin
  Result := FdRotation.Value;
end;

procedure TTransformNode.SetRotation(const Value: TVector4);
begin
  FdRotation.Send(Value);
end;

function TTransformNode.GetScale: TVector3;
begin
  Result := FdScale.Value;
end;

procedure TTransformNode.SetScale(const Value: TVector3);
begin
  FdScale.Send(Value);
end;

function TTransformNode.GetScaleOrientation: TVector4;
begin
  Result := FdScaleOrientation.Value;
end;

procedure TTransformNode.SetScaleOrientation(const Value: TVector4);
begin
  FdScaleOrientation.Send(Value);
end;

function TTransformNode.GetTranslation: TVector3;
begin
  Result := FdTranslation.Value;
end;

procedure TTransformNode.SetTranslation(const Value: TVector3);
begin
  FdTranslation.Send(Value);
end;

class function TTransformNode.ClassX3DType: String;
begin
  Result := 'Transform';
end;

procedure TTransformNode.CreateNode;
begin
  inherited;

  FFdCenter := TSFVec3f.Create(Self, True, 'center', Vector3(0, 0, 0));
   FdCenter.ChangeAlways := chTransform;
  AddField(FFdCenter);

  FFdRotation := TSFRotation.Create(Self, True, 'rotation', Vector3(0, 0, 1), 0);
   FdRotation.ChangeAlways := chTransform;
  AddField(FFdRotation);

  FFdScale := TSFVec3f.Create(Self, True, 'scale', Vector3(1, 1, 1));
   FdScale.ChangeAlways := chTransform;
  AddField(FFdScale);

  FFdScaleOrientation := TSFRotation.Create(Self, True, 'scaleOrientation', Vector3(0, 0, 1), 0);
   FdScaleOrientation.ChangeAlways := chTransform;
  AddField(FFdScaleOrientation);

  FFdTranslation := TSFVec3f.Create(Self, True, 'translation', Vector3(0, 0, 0));
   FdTranslation.ChangeAlways := chTransform;
  AddField(FFdTranslation);
end;

{$endif read_implementation}
