{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetDirection: TVector3;
    procedure SetDirection(const Value: TVector3);
    function GetGustiness: Single;
    procedure SetGustiness(const Value: Single);
    function GetSpeed: Single;
    procedure SetSpeed(const Value: Single);
    function GetTurbulence: Single;
    procedure SetTurbulence(const Value: Single);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdDirection: TSFVec3f;
    { Internal wrapper for property @link(Direction). This wrapper API may change, we advise to access simpler @link(Direction) instead. }
    public property FdDirection: TSFVec3f read FFdDirection;
    {  }
    property Direction: TVector3 read GetDirection write SetDirection;

    strict private FFdGustiness: TSFFloat;
    { Internal wrapper for property @link(Gustiness). This wrapper API may change, we advise to access simpler @link(Gustiness) instead. }
    public property FdGustiness: TSFFloat read FFdGustiness;
    {  }
    property Gustiness: Single read GetGustiness write SetGustiness;

    strict private FFdSpeed: TSFFloat;
    { Internal wrapper for property @link(Speed). This wrapper API may change, we advise to access simpler @link(Speed) instead. }
    public property FdSpeed: TSFFloat read FFdSpeed;
    {  }
    property Speed: Single read GetSpeed write SetSpeed;

    strict private FFdTurbulence: TSFFloat;
    { Internal wrapper for property @link(Turbulence). This wrapper API may change, we advise to access simpler @link(Turbulence) instead. }
    public property FdTurbulence: TSFFloat read FFdTurbulence;
    {  }
    property Turbulence: Single read GetTurbulence write SetTurbulence;

{$endif read_interface}

{$ifdef read_implementation}

{ TWindPhysicsModelNode ----------------------------------------------- }

function TWindPhysicsModelNode.GetDirection: TVector3;
begin
  Result := FdDirection.Value;
end;

procedure TWindPhysicsModelNode.SetDirection(const Value: TVector3);
begin
  FdDirection.Send(Value);
end;

function TWindPhysicsModelNode.GetGustiness: Single;
begin
  Result := FdGustiness.Value;
end;

procedure TWindPhysicsModelNode.SetGustiness(const Value: Single);
begin
  FdGustiness.Send(Value);
end;

function TWindPhysicsModelNode.GetSpeed: Single;
begin
  Result := FdSpeed.Value;
end;

procedure TWindPhysicsModelNode.SetSpeed(const Value: Single);
begin
  FdSpeed.Send(Value);
end;

function TWindPhysicsModelNode.GetTurbulence: Single;
begin
  Result := FdTurbulence.Value;
end;

procedure TWindPhysicsModelNode.SetTurbulence(const Value: Single);
begin
  FdTurbulence.Send(Value);
end;

class function TWindPhysicsModelNode.ClassX3DType: String;
begin
  Result := 'WindPhysicsModel';
end;

procedure TWindPhysicsModelNode.CreateNode;
begin
  inherited;

  FFdDirection := TSFVec3f.Create(Self, True, 'direction', Vector3(0, 0, 0));
   FdDirection.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDirection);

  FFdGustiness := TSFFloat.Create(Self, True, 'gustiness', 0.1);
   FdGustiness.ChangeAlways := chVisibleNonGeometry;
   FdGustiness.MustBeNonnegative := true;
  AddField(FFdGustiness);

  FFdSpeed := TSFFloat.Create(Self, True, 'speed', 0.1);
   FdSpeed.ChangeAlways := chVisibleNonGeometry;
   FdSpeed.MustBeNonnegative := true;
  AddField(FFdSpeed);

  FFdTurbulence := TSFFloat.Create(Self, True, 'turbulence', 0);
   FdTurbulence.ChangeAlways := chVisibleNonGeometry;
   FdTurbulence.MustBeNonnegative := true;
  AddField(FFdTurbulence);
end;

{$endif read_implementation}
