{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetNameField: String;
    procedure SetNameField(const Value: String);
    function GetDescription: String;
    procedure SetDescription(const Value: String);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdName: TSFString;
    { Internal wrapper for property @link(NameField). This wrapper API may change, we advise to access simpler @link(NameField) instead. }
    public property FdName: TSFString read FFdName;
    {  }
    property NameField: String read GetNameField write SetNameField;

    strict private FFdDescription: TSFString;
    { Internal wrapper for property @link(Description). This wrapper API may change, we advise to access simpler @link(Description) instead. }
    public property FdDescription: TSFString read FFdDescription;
    {  }
    property Description: String read GetDescription write SetDescription;

    strict private FFdMap: TSFEnum;
    { Internal wrapper for property @link(Map). This wrapper API may change, we advise to access simpler @link(Map) instead. }
    public property FdMap: TSFEnum read FFdMap;

{$endif read_interface}

{$ifdef read_implementation}

{ TWWWAnchorNode_1 ----------------------------------------------- }

function TWWWAnchorNode_1.GetNameField: String;
begin
  Result := FdName.Value;
end;

procedure TWWWAnchorNode_1.SetNameField(const Value: String);
begin
  FdName.Send(Value);
end;

function TWWWAnchorNode_1.GetDescription: String;
begin
  Result := FdDescription.Value;
end;

procedure TWWWAnchorNode_1.SetDescription(const Value: String);
begin
  FdDescription.Send(Value);
end;

class function TWWWAnchorNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TWWWAnchorNode_1.ClassX3DType: String;
begin
  Result := 'WWWAnchor';
end;

procedure TWWWAnchorNode_1.CreateNode;
begin
  inherited;

  FFdName := TSFString.Create(Self, True, 'name', '');
   FdName.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdName);

  FFdDescription := TSFString.Create(Self, True, 'description', '');
   FdDescription.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDescription);

  FFdMap := TSFEnum.Create(Self, True, 'map', @MapNames1, Ord(High(MapNames1)) + 1, 0);
   FdMap.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMap);
end;

{$endif read_implementation}
