{ -*- buffer-read-only: t -*-

  Copyright 2018-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FColorPersistent: TCastleColorPersistent;
  function GetColorForPersistent: TCastleColor;
  procedure SetColorForPersistent(const AValue: TCastleColor);
published
  { @link(Color) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(Color) directly.

    @seealso Color }
  property ColorPersistent: TCastleColorPersistent read FColorPersistent ;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleImagePersistent.GetColorForPersistent: TCastleColor;
begin
  Result := Color;
end;

procedure TCastleImagePersistent.SetColorForPersistent(const AValue: TCastleColor);
begin
  Color := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FColorPersistent := TCastleColorPersistent.Create(nil);
  { Note that some classes (like TCastleVector3Persistent) call SetSubComponent(true)
    on themselves, for backward compatibility. But we should not depend on it,
    some classes (like TFloatRectanglePersisten) may not call it.
    The responsibility of calling "SetSubComponent(true)" should be on the owner
    in general (this is more functional, and more standard too). }
  FColorPersistent.SetSubComponent(true);
  FColorPersistent.InternalGetValue := {$ifdef FPC}@{$endif}GetColorForPersistent;
  FColorPersistent.InternalSetValue := {$ifdef FPC}@{$endif}SetColorForPersistent;
  FColorPersistent.InternalDefaultValue := Color; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FColorPersistent);
{$endif read_implementation_destructor}

{ -*- buffer-read-only: t -*-

  Copyright 2018-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FClipLinePersistent: TCastleVector3Persistent;
  function GetClipLineForPersistent: TVector3;
  procedure SetClipLineForPersistent(const AValue: TVector3);
published
  { @link(ClipLine) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(ClipLine) directly.

    @seealso ClipLine }
  property ClipLinePersistent: TCastleVector3Persistent read FClipLinePersistent ;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleImagePersistent.GetClipLineForPersistent: TVector3;
begin
  Result := ClipLine;
end;

procedure TCastleImagePersistent.SetClipLineForPersistent(const AValue: TVector3);
begin
  ClipLine := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FClipLinePersistent := TCastleVector3Persistent.Create(nil);
  { Note that some classes (like TCastleVector3Persistent) call SetSubComponent(true)
    on themselves, for backward compatibility. But we should not depend on it,
    some classes (like TFloatRectanglePersisten) may not call it.
    The responsibility of calling "SetSubComponent(true)" should be on the owner
    in general (this is more functional, and more standard too). }
  FClipLinePersistent.SetSubComponent(true);
  FClipLinePersistent.InternalGetValue := {$ifdef FPC}@{$endif}GetClipLineForPersistent;
  FClipLinePersistent.InternalSetValue := {$ifdef FPC}@{$endif}SetClipLineForPersistent;
  FClipLinePersistent.InternalDefaultValue := ClipLine; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FClipLinePersistent);
{$endif read_implementation_destructor}

{ -*- buffer-read-only: t -*-

  Copyright 2018-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FRotationCenterPersistent: TCastleVector2Persistent;
  function GetRotationCenterForPersistent: TVector2;
  procedure SetRotationCenterForPersistent(const AValue: TVector2);
published
  { @link(RotationCenter) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(RotationCenter) directly.

    @seealso RotationCenter }
  property RotationCenterPersistent: TCastleVector2Persistent read FRotationCenterPersistent ;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleImagePersistent.GetRotationCenterForPersistent: TVector2;
begin
  Result := RotationCenter;
end;

procedure TCastleImagePersistent.SetRotationCenterForPersistent(const AValue: TVector2);
begin
  RotationCenter := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FRotationCenterPersistent := TCastleVector2Persistent.Create(nil);
  { Note that some classes (like TCastleVector3Persistent) call SetSubComponent(true)
    on themselves, for backward compatibility. But we should not depend on it,
    some classes (like TFloatRectanglePersisten) may not call it.
    The responsibility of calling "SetSubComponent(true)" should be on the owner
    in general (this is more functional, and more standard too). }
  FRotationCenterPersistent.SetSubComponent(true);
  FRotationCenterPersistent.InternalGetValue := {$ifdef FPC}@{$endif}GetRotationCenterForPersistent;
  FRotationCenterPersistent.InternalSetValue := {$ifdef FPC}@{$endif}SetRotationCenterForPersistent;
  FRotationCenterPersistent.InternalDefaultValue := RotationCenter; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FRotationCenterPersistent);
{$endif read_implementation_destructor}

{ -*- buffer-read-only: t -*-

  Copyright 2018-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FRegionPersistent: TFloatRectanglePersistent;
  function GetRegionForPersistent: TFloatRectangle;
  procedure SetRegionForPersistent(const AValue: TFloatRectangle);
published
  { @link(Region) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(Region) directly.

    @seealso Region }
  property RegionPersistent: TFloatRectanglePersistent read FRegionPersistent ;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleImagePersistent.GetRegionForPersistent: TFloatRectangle;
begin
  Result := Region;
end;

procedure TCastleImagePersistent.SetRegionForPersistent(const AValue: TFloatRectangle);
begin
  Region := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FRegionPersistent := TFloatRectanglePersistent.Create(nil);
  { Note that some classes (like TCastleVector3Persistent) call SetSubComponent(true)
    on themselves, for backward compatibility. But we should not depend on it,
    some classes (like TFloatRectanglePersisten) may not call it.
    The responsibility of calling "SetSubComponent(true)" should be on the owner
    in general (this is more functional, and more standard too). }
  FRegionPersistent.SetSubComponent(true);
  FRegionPersistent.InternalGetValue := {$ifdef FPC}@{$endif}GetRegionForPersistent;
  FRegionPersistent.InternalSetValue := {$ifdef FPC}@{$endif}SetRegionForPersistent;
  FRegionPersistent.InternalDefaultValue := Region; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FRegionPersistent);
{$endif read_implementation_destructor}

