{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetRadius: Single;
    procedure SetRadius(const Value: Single);
    function GetTexCoord: TX3DNode;
    procedure SetTexCoord(const Value: TX3DNode);
    function GetSlices: Integer;
    procedure SetSlices(const Value: Integer);
    function GetStacks: Integer;
    procedure SetStacks(const Value: Integer);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdRadius: TSFFloat;
    { Internal wrapper for property @code(Radius). This wrapper API may change, we advise to access simpler @code(Radius) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRadius: TSFFloat read FFdRadius;
    {  }
    property Radius: Single read GetRadius write SetRadius;

    strict private FFdSolid: TSFBool;
    { Internal wrapper for property @code(Solid). This wrapper API may change, we advise to access simpler @code(Solid) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSolid: TSFBool read FFdSolid;

    strict private FFdTexCoord: TSFNode;
    { Internal wrapper for property @code(TexCoord). This wrapper API may change, we advise to access simpler @code(TexCoord) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTexCoord: TSFNode read FFdTexCoord;
    {  }
    property TexCoord: TX3DNode read GetTexCoord write SetTexCoord;

    strict private FFdSlices: TSFInt32;
    { Internal wrapper for property @code(Slices). This wrapper API may change, we advise to access simpler @code(Slices) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSlices: TSFInt32 read FFdSlices;
    { How many "slices" to use to approximate the sphere. The sphere is rendered using polygons (triangles and quads) that approximate the sphere shape. The more slices, the more the sphere will look like a sphere. Slices divide the objects like slices of a pizza. The default value of 0 means to follow global variable @link(DefaultTriangulationSlices). }
    property Slices: Integer read GetSlices write SetSlices;

    strict private FFdStacks: TSFInt32;
    { Internal wrapper for property @code(Stacks). This wrapper API may change, we advise to access simpler @code(Stacks) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdStacks: TSFInt32 read FFdStacks;
    { How many "stacks" to use to approximate the sphere. The sphere is rendered using polygons (triangles and quads) that approximate the sphere shape. The more stacks, the more the sphere will look like a sphere. Stacks divide the objects like stacks of a tower. The default value of 0 means to follow global variable @link(DefaultTriangulationStacks). }
    property Stacks: Integer read GetStacks write SetStacks;

{$endif read_interface}

{$ifdef read_implementation}

{ TSphereNode ----------------------------------------------- }

function TSphereNode.GetRadius: Single;
begin
  Result := FdRadius.Value;
end;

procedure TSphereNode.SetRadius(const Value: Single);
begin
  FdRadius.Send(Value);
end;

function TSphereNode.GetTexCoord: TX3DNode;
begin
  if FdTexCoord.Value is TX3DNode then
    Result := TX3DNode(FdTexCoord.Value)
  else
    Result := nil;
end;

procedure TSphereNode.SetTexCoord(const Value: TX3DNode);
begin
  FdTexCoord.Send(Value);
end;

function TSphereNode.GetSlices: Integer;
begin
  Result := FdSlices.Value;
end;

procedure TSphereNode.SetSlices(const Value: Integer);
begin
  FdSlices.Send(Value);
end;

function TSphereNode.GetStacks: Integer;
begin
  Result := FdStacks.Value;
end;

procedure TSphereNode.SetStacks(const Value: Integer);
begin
  FdStacks.Send(Value);
end;

class function TSphereNode.ClassX3DType: String;
begin
  Result := 'Sphere';
end;

procedure TSphereNode.CreateNode;
begin
  inherited;

  FFdRadius := TSFFloat.Create(Self, False, 'radius', 1);
   FdRadius.ChangeAlways := chGeometry;
   FdRadius.MustBeNonnegative := true;
  AddField(FFdRadius);

  FFdSolid := TSFBool.Create(Self, False, 'solid', true);
   FdSolid.ChangeAlways := chGeometry;
  AddField(FFdSolid);

  FFdTexCoord := TSFNode.Create(Self, True, 'texCoord', [TTextureCoordinateGeneratorNode, TProjectedTextureCoordinateNode, TMultiGeneratedTextureCoordinateNode]);
   FdTexCoord.ChangeAlways := chGeometry;
   FdTexCoord.OnBeforeValueChange := {$ifdef FPC}@{$endif}MoveShapeAssociations;
  AddField(FFdTexCoord);

  FFdSlices := TSFInt32.Create(Self, True, 'slices', 0);
   FdSlices.ChangeAlways := chGeometry;
  AddField(FFdSlices);

  FFdStacks := TSFInt32.Create(Self, True, 'stacks', 0);
   FdStacks.ChangeAlways := chGeometry;
  AddField(FFdStacks);
end;

{$endif read_implementation}
