#!/bin/sh

CR="
"

LIT_VERSION="$(sed -n -r '/^Build/,/^$/s/.*llvm-([0-9]+)-tools.*/\1/p' debian/control)"

cat <<EoF
# Generated from debian/tests/control.sh, do not edit manually!

Test-Command: cmake -Wno-dev -B \$AUTOPKGTEST_TMP -S debian/tests/cmake/libcudacxx
Features: test-name=cmake_find_package_libcudacxx
Depends:
 libcu++-dev,
 cmake,
 make,
 g++,
Restrictions:
 superficial,

Test-Command: cmake -Wno-dev -B \$AUTOPKGTEST_TMP -S debian/tests/cmake/cub
Features: test-name=cmake_find_package_CUB
Depends:
 libcub-dev,
 cmake,
 make,
 g++,
Restrictions:
 superficial,

Test-Command: cmake -Wno-dev -B \$AUTOPKGTEST_TMP -S debian/tests/cmake/thrust
Features: test-name=cmake_find_package_Thrust
Depends:
 libthrust-dev,
 cmake,
 make,
 g++,
 libtbb-dev,
Restrictions:
 superficial,

Test-Command: cmake -Wno-dev -B \$AUTOPKGTEST_TMP -S debian/tests/cmake/cccl
Features: test-name=cmake_find_package_cccl
Depends:
 libcccl-dev,
 cmake,
 make,
 g++,
Restrictions:
 superficial,

Test-Command: debian/tests/upstream-testsuite-cpp
Features: test-name=upstream-testsuite-cpp
Depends:
 libcccl-dev,
 cmake,
 make,
 llvm-${LIT_VERSION}-tools,
 python3,
 g++,
Restrictions:
 superficial,
 allow-stderr,

Test-Command: debian/tests/compile-upstream-testsuite-cuda
Features: test-name=compile-upstream-testsuite-cuda
Architecture: amd64
Depends:
 libcccl-dev,
 cmake,
 make,
 llvm-${LIT_VERSION}-tools,
 python3,
 nvidia-cuda-toolkit-gcc,
 git,
Restrictions:
 superficial,
 allow-stderr,
 needs-internet,

EoF

emit_normal()
{
	local dev="$1"
	local std="${2:-17}"
	local cxx="$3"
	local dep="${cxx:-g++}"
	local name=$(echo "run_testsuite_${dev}_C++${std}${cxx:+_$cxx}" | tr / _)
	cat <<EoF
Test-Command: debian/tests/upstream-testsuite ${dev} ${std}${cxx:+ $cxx}
Features: test-name=${name}
Depends:
 @,
 cmake,
 make,
 libtbb-dev,
 $dep,
Restrictions:
 powerful-cuda-machine,
 superficial,
 allow-stderr,
 flaky,

EoF
}

emit_cuda()
{
	local dev="$1"
	local std="${2:-17}"
	local cxx="$3"
	local dep="${cxx:-g++},${CR} nvidia-cuda-toolkit-gcc"
	local flaky="${CR} flaky,"
	local skippable="${CR} skippable,"
	case $cxx in
		cuda-g++)
			dep="nvidia-cuda-toolkit-gcc"
			test "$dev" = "TBB/CUDA" || flaky=
			skippable=
			;;
	esac
	local name=$(echo "compile_testsuite_${dev}_C++${std}${cxx:+_$cxx}" | tr / _)
	cat <<EoF
Test-Command: debian/tests/upstream-testsuite ${dev} ${std}${cxx:+ $cxx}
Features: test-name=${name}
Architecture: amd64
Depends:
 @,
 cmake,
 make,
 libtbb-dev,
 ${dep},
Restrictions:
 powerful-cuda-machine,
 superficial,
 allow-stderr,${flaky}${skippable}

EoF
}

emit_normal CPP 17 g++-12
emit_normal TBB

for DEVICE in CUDA; do
	for CXX in cuda-g++ ; do
		for STD in 17 ; do
			for HOST in CPP TBB ; do
				emit_cuda ${HOST}/${DEVICE} ${STD} ${CXX}
			done
		done
	done
done
