/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.javascript.rhino.head.ast.Assignment;
import com.google.javascript.rhino.head.ast.AstNode;
import com.google.javascript.rhino.head.ast.ObjectProperty;
import java.util.HashSet;
import java.util.Set;
import org.chromium.devtools.jsdoc.checks.AstUtil;
import org.chromium.devtools.jsdoc.checks.ContextTrackingChecker;
import org.chromium.devtools.jsdoc.checks.ContextTrackingState;
import org.chromium.devtools.jsdoc.checks.TypeRecord;

public final class ProtoFollowsExtendsChecker
extends ContextTrackingChecker {
    private static final String PROTO_PROPERTY_NAME = "__proto__";
    private final Set<TypeRecord> typesWithAssignedProto = new HashSet<TypeRecord>();

    @Override
    protected void enterNode(AstNode astNode) {
        if (astNode.getType() == 103) {
            this.handleColonNode((ObjectProperty)astNode);
            return;
        }
        if (astNode.getType() == 90) {
            this.handleAssignment((Assignment)astNode);
            return;
        }
    }

    @Override
    protected void leaveNode(AstNode astNode) {
        if (astNode.getType() == 136) {
            this.checkFinished();
        }
    }

    private void checkFinished() {
        for (TypeRecord typeRecord : this.getState().getTypeRecordsByTypeName().values()) {
            TypeRecord.InheritanceEntry inheritanceEntry;
            if (typeRecord.isInterface || this.typesWithAssignedProto.contains(typeRecord) || (inheritanceEntry = typeRecord.getFirstExtendedType()) == null) continue;
            this.getContext().reportErrorInNode(inheritanceEntry.jsDocNode, inheritanceEntry.offsetInJsDocText, String.format("No __proto__ assigned for type %s having @extends", typeRecord.typeName));
        }
    }

    private void handleColonNode(ObjectProperty objectProperty) {
        ContextTrackingState contextTrackingState = this.getState();
        TypeRecord typeRecord = contextTrackingState.getCurrentTypeRecord();
        if (typeRecord == null) {
            return;
        }
        String string = contextTrackingState.getNodeText(objectProperty.getLeft());
        if (!PROTO_PROPERTY_NAME.equals(string)) {
            return;
        }
        TypeRecord typeRecord2 = contextTrackingState.getCurrentTypeRecord();
        if (typeRecord2 == null) {
            return;
        }
        this.typesWithAssignedProto.add(typeRecord2);
        String string2 = contextTrackingState.getNodeText(objectProperty.getRight());
        if (!AstUtil.isPrototypeName(string2)) {
            contextTrackingState.getContext().reportErrorInNode(objectProperty.getRight(), 0, "__proto__ value is not a prototype");
            return;
        }
        String string3 = AstUtil.getTypeNameFromPrototype(string2);
        if (typeRecord.isInterface) {
            contextTrackingState.getContext().reportErrorInNode(objectProperty.getLeft(), 0, String.format("__proto__ defined for interface %s", typeRecord.typeName));
            return;
        }
        if (typeRecord.extendedTypes.isEmpty()) {
            contextTrackingState.getContext().reportErrorInNode(objectProperty.getRight(), 0, String.format("No @extends annotation for %s extending %s", typeRecord.typeName, string3));
            return;
        }
        TypeRecord.InheritanceEntry inheritanceEntry = typeRecord.getFirstExtendedType();
        String string4 = inheritanceEntry.superTypeName;
        if (!string3.equals(string4)) {
            contextTrackingState.getContext().reportErrorInNode(objectProperty.getRight(), 0, String.format("Supertype does not match %s declared in @extends for %s (line %d)", string4, typeRecord.typeName, contextTrackingState.getContext().getPosition((AstNode)inheritanceEntry.jsDocNode, (int)inheritanceEntry.offsetInJsDocText).line));
        }
    }

    private void handleAssignment(Assignment assignment) {
        String string = this.getState().getNodeText(AstUtil.getAssignedTypeNameNode(assignment));
        if (string == null) {
            return;
        }
        if (!AstUtil.isPrototypeName(string)) {
            return;
        }
        AstNode astNode = assignment.getRight();
        if (astNode.getType() == 66) {
            return;
        }
        ContextTrackingState contextTrackingState = this.getState();
        TypeRecord typeRecord = contextTrackingState.getCurrentTypeRecord();
        if (typeRecord == null) {
            return;
        }
        if (!typeRecord.extendedTypes.isEmpty()) {
            contextTrackingState.getContext().reportErrorInNode(astNode, 0, String.format("@extends found for type %s but its prototype is not an object containing __proto__", AstUtil.getTypeNameFromPrototype(string)));
        }
    }
}

