// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PPAPI_PROXY_PPP_PRINTING_PROXY_H_
#define PPAPI_PROXY_PPP_PRINTING_PROXY_H_

#include <string>
#include <vector>

#include "ppapi/c/dev/ppp_printing_dev.h"
#include "ppapi/proxy/interface_proxy.h"

struct PP_PrintPageNumberRange_Dev;

namespace ppapi {

class HostResource;

namespace proxy {

class PPP_Printing_Proxy : public InterfaceProxy {
 public:
  PPP_Printing_Proxy(Dispatcher* dispatcher);
  virtual ~PPP_Printing_Proxy();

  static const PPP_Printing_Dev* GetProxyInterface();

  // InterfaceProxy implementation.
  virtual bool OnMessageReceived(const IPC::Message& msg);

 private:
  // Message handlers.
  void OnPluginMsgQuerySupportedFormats(PP_Instance instance, uint32_t* result);
  void OnPluginMsgBegin(PP_Instance instance,
                        const std::string& settings_string,
                        int32_t* result);
  void OnPluginMsgPrintPages(
      PP_Instance instance,
      const std::vector<PP_PrintPageNumberRange_Dev>& pages,
      HostResource* result);
  void OnPluginMsgEnd(PP_Instance instance);
  void OnPluginMsgIsScalingDisabled(PP_Instance instance, bool* result);

  // When this proxy is in the plugin side, this value caches the interface
  // pointer so we don't have to retrieve it from the dispatcher each time.
  // In the host, this value is always NULL.
  const PPP_Printing_Dev* ppp_printing_impl_;

  DISALLOW_COPY_AND_ASSIGN(PPP_Printing_Proxy);
};

}  // namespace proxy
}  // namespace ppapi

#endif  // PPAPI_PROXY_PPP_PRINTING_PROXY_H_

