// Copyright 2013 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Created by postproc-cld2 4.0 on 2013-06-04 09:11:55
// From command line:
//  --cld2 --cc --just_read_raw --distinct_octa --standard --minchars=2
//  --mincount=2 --max_items_per_langscript=300 --flatmap --rr_alloc
//  --freq_alloc --boostcloseweakerpercent=00 --indirectbits=12 --thresh=224
//  --v25 --kentries=8 --tablename=DistinctOctaChrome0604
//  --remap=xxx-Latn=>ut-Latn    sh-Latn=>hr-Latn sh-Cyrl=>sr-Cyrl
//  nn-Latn=>no-Latn mo-Cyrl=>ro-Cyrl     --include=af-Latn ar-Arab be-Cyrl
//  bg-Cyrl ca-Latn cs-Latn cy-Latn    da-Latn de-Latn el-Grek en-Latn
//  es-Latn et-Latn fa-Arab fi-Latn fr-Latn    ga-Latn gd-Latn hi-Deva
//  hr-Latn hu-Latn id-Latn is-Latn it-Latn iw-Hebr    ja-Hani ko-Hani
//  lg-Latn lt-Latn lv-Latn mk-Cyrl ms-Latn nl-Latn no-Latn    pl-Latn
//  pt-Latn ro-Latn ro-Cyrl ru-Cyrl rw-Latn sh-Cyrl sh-Latn sk-Latn sl-Latn
//  sr-Cyrl    sv-Latn sw-Latn th-Thai tl-Latn tr-Latn uk-Cyrl vi-Latn
//  yi-Hebr    zh-Hani zh-TW    sq-Latn az-Latn eu-Latn bn-Beng gl-Latn
//  ht-Latn mt-Latn sr-Latn ur-Arab    bh-Deva mr-Deva ne-Deva lg-Latn
//  rw-Latn gd-Latn    ut-Latn ut-Deva    tlh-Latn ceb-Latn blu-Latn jw-Latn
//   --ko_english --force_to_lang_soft --nosoft_cram2 --nomsidlevel
//  --shapeflatprob --langpriorpercent=10 --skipnuc --noshapeforcetop
//  --noshapeeventop --noshapesteep2 --spread=15 --nodoubleclose
//  --langcounts --writebin --list_items=120 /tmp/xocta_octa2.utf8
//
// CLD2_pslangs
//
// See compact_lang_det.cc for usage
//
#include "cld2tablesummary.h"
namespace CLD2 {

static const uint32 kDistinctOctaChrome0604BuildDate = 20130604;    // yyyymmdd


// Of 4561 offered items into 8192 table entries:
// 4318 filled (94%), 9 merged (0%), 234 dropped (5%)

// Nil-grams: 19 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE
//     SYRIAC LIMBU ORIYA INUKTITUT

// Uni-grams: 4 languages
//     Japanese Korean Chinese ChineseT

// Words/Quads: 16 languages in range DANISH..KINYARWANDA:
//     DANISH NORWEGIAN PORTUGUESE SPANISH CZECH CROATIAN SERBIAN
//     GALICIAN HINDI INDONESIAN MALAY NEPALI BIHARI MARATHI SLOVAK
//     KINYARWANDA

//  DANISH 289
//  NORWEGIAN 290
//  PORTUGUESE 284
//  SPANISH 281
//  CZECH 283
//  CROATIAN 285
//  SERBIAN 567
//  GALICIAN 288
//  HINDI 283
//  INDONESIAN 287
//  MALAY 280
//  NEPALI 38
//  BIHARI 285
//  MARATHI 23
//  SLOVAK 277
//  KINYARWANDA 287



// Recognized language-script combinations [17]:
static const char* const kDistinctOctaChrome0604RecognizedLangScripts =
  "bh-Deva cs-Latn da-Latn es-Latn gl-Latn hi-Deva hr-Latn id-Latn "
  "mr-Deva ms-Latn ne-Deva no-Latn pt-Latn rw-Latn sk-Latn sr-Cyrl "
  "sr-Latn ";

static const uint32 kDistinctOctaChrome0604Size = 2048;    // Bucket count
static const uint32 kDistinctOctaChrome0604KeyMask = 0xfffff000;    // Mask hash key

static const IndirectProbBucket4 kDistinctOctaChrome0604[kDistinctOctaChrome0604Size] = {
  // hash_indirect[4], tokens[4] in UTF-8
   {{0x4b8dd002,0x53098003,0xb964a004,0x00000000}},	// [000] _जय_, _añadir_, _použití_, --,
   {{0xd47c1005,0x34427006,0x826d9007,0xdfa54007}},	//   _saat__itu_, _jen_, _terbuat__dari_, _desember_,
   {{0x47227008,0x00000000,0x00000000,0x00000000}},	//   _बाड़े_, --, --, --,
   {{0x54427009,0x5292500a,0x00000000,0x00000000}},	//   _len_, _intara_, --, --,
   {{0xd290200a,0x00000000,0x00000000,0x00000000}},	//   _inka_, --, --, --,
   {{0x1846800b,0xf438a00c,0x00000000,0x00000000}},	//   _dodatim__stepenom_, _en__conta_, --, --,
   {{0xeb5ab00d,0x1395400e,0x00000000,0x00000000}},	//   _je__prisutna_, _pjesma_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x7296f00d,0xc497200c,0x00000000,0x00000000}},	//   _je__prema_, _ou__non_, --, --,
   {{0x0306100f,0xc4427010,0x626de006,0x00000000}},	//   _terletak__dalam_, _cen_, _tyto_, --,
   {{0x73eb9009,0x00000000,0x00000000,0x00000000}},	//   _mesta_, --, --, --,
   {{0x227f4003,0x6290f011,0x00000000,0x00000000}},	//   _tienen_, _bahawa_, --, --,
   {{0x229f900b,0x00000000,0x00000000,0x00000000}},	//   _pad__broju_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x22001012,0x6e059013,0x00000000,0x00000000}},	//   _bahia_, _kendaraa, --, --,
   {{0xfa3e7008,0x02421014,0x00000000,0x00000000}},	//   _बनल_, _मामले_, --, --,
   {{0xe24ed00d,0x8291e010,0x747b9015,0x00000000}},	// [010] _je__jedino_, _dotaz_, _hver__dag_, --,
   {{0x6490600c,0x00000000,0x00000000,0x00000000}},	//   _ao__de_, --, --, --,
   {{0x36fee016,0x00000000,0x00000000,0x00000000}},	//   _करना_, --, --, --,
   {{0xb4677011,0x00000000,0x00000000,0x00000000}},	//   _sub__filum_, --, --, --,
   {{0x12248006,0x00000000,0x00000000,0x00000000}},	//   _velké_, --, --, --,
   {{0xe4ade015,0x627f000a,0x12fee00f,0xa7125012}},	//   _her__er_, _abandi_, _tanah__melayu_, _construç,
   {{0x2e442017,0x4a3e7008,0x00000000,0x00000000}},	//   _katapult_, _भरल_, --, --,
   {{0xfdf58017,0xc4906018,0xa9f56019,0x00000000}},	//   _sjednite_, _av__dem_, _según_, --,
   {{0xc27ee018,0x00000000,0x00000000,0x00000000}},	//   _mannen_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x36f94014,0xc4b6c00b,0x5bf81009,0x00000000}},	//   _सकता_, _lansiran_je_, _bydlisko_, --,
   {{0xe420900b,0x00000000,0x00000000,0x00000000}},	//   _metara__površina_, --, --, --,
   {{0xaf1b300b,0x42cb8018,0xf3755011,0x2eb1e00b}},	//   _види__још_, _verdi_, _menyumba_dengan_, _врста__је_,
   {{0xc527e01a,0x83ea0012,0x00000000,0x00000000}},	//   _इंटरनेट__विपणन_, _muito_, --, --,
   {{0x0f17a01b,0xc004c00f,0x00000000,0x00000000}},	//   _kornjača_, _elektrik_, --, --,
   {{0x82beb00c,0x2eb9800b,0x3292900b,0x4983a007}},	//   _que__unha_, _била__је_, _број__становни, _olahraga_,
   {{0xe2c57003,0xb3f85003,0x5bd00012,0x00000000}},	// [020] _además_, _salud_, _opinião_, --,
   {{0xd26a300b,0x92d8100a,0x92d58012,0x6c49c01c}},	//   _је__један_, _gihe_, _conosco_, _डाउनलोड_,
   {{0x6c905014,0x3c96000c,0x00000000,0x00000000}},	//   _लोगों_, _segundo__padrón_, --, --,
   {{0xeebc1015,0x0ed8801d,0x00000000,0x00000000}},	//   _aktuelle_, _menyumba, --, --,
   {{0x549c700b,0x0395c009,0x00000000,0x00000000}},	//   _opština__se_, _časť_, --, --,
   {{0x18ac8017,0x04426018,0x52d0c00b,0x00000000}},	//   _preskoči_, _slo_, _svetskog__rata_, --,
   {{0xccf5c014,0x72ef401b,0x00000000,0x00000000}},	//   _इलाकाई_, _na__svijetu_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf290a00a,0xc4907015,0x329df017,0x00000000}},	//   _kuba_, _en__del_, _srijeda_, --,
   {{0x9224000b,0x00000000,0x00000000,0x00000000}},	//   _slika_, --, --, --,
   {{0x725a9011,0x00000000,0x00000000,0x00000000}},	//   _itali_, --, --, --,
   {{0x12b2e008,0x00000000,0x00000000,0x00000000}},	//   _भावुक_, --, --, --,
   {{0xa2918003,0x00000000,0x00000000,0x00000000}},	//   _otra_, --, --, --,
   {{0xd2c8400c,0x82bfc00f,0x00000000,0x00000000}},	//   _nas__súas_, _sebahagi_besar_, --, --,
   {{0x5249901e,0x02731011,0x14b0200c,0x00000000}},	//   _mismo_, _tahun__bagi_, _non__foi_, --,
   {{0xa2d84015,0x09f43006,0x00000000,0x00000000}},	// [030] _timer_, _mají_, --, --,
   {{0xd2911013,0x00000000,0x00000000,0x00000000}},	//   _dibagi_, --, --, --,
   {{0xb9e79017,0x427f7003,0x1a3e7014,0xa32c8007}},	//   _balonima_, _cuando_, _मैं_, _menjabat__sebagai_,
   {{0xe46f5005,0xf27c000b,0xc1682005,0x00000000}},	//   _jawa__timur_, _kilogram_kosmos_, _pengadil, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc460400b,0x00000000,0x00000000,0x00000000}},	//   _učestvov_je_, --, --, --,
   {{0x54429018,0x42d89017,0x00000000,0x00000000}},	//   _ola_, _cijena_, --, --,
   {{0x3b881014,0x4442600a,0x00000000,0x00000000}},	//   _यह_, _bwo_, --, --,
   {{0x8a33e01f,0xd493100b,0x99f5b006,0x00000000}},	//   _जाई_, _računaru__su_, _navíc_, --,
   {{0xa2cb4009,0x6186700b,0x00000000,0x00000000}},	//   _predaj_, _su__slatkovo, --, --,
   {{0xa2e6c00c,0x73eb9010,0x00000000,0x00000000}},	//   _da__súa_, _odst_, --, --,
   {{0x6a3d5014,0xe3543011,0x00000000,0x00000000}},	//   _रहा_, _selepas_, --, --,
   {{0x1b19f003,0x6ee2e00b,0x00000000,0x00000000}},	//   _responde, _он_, --, --,
   {{0x68aa300b,0xb4429012,0xb2132003,0x12d8300b}},	//   _од__налази_, _ela_, _muchos_, _nije_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x4b612003,0x5d874020,0x6bef2014,0xc386000a}},	//   _también_, _međunaro, _अभी__भी_, _tpir_,
   {{0x7a3d5008,0x00000000,0x00000000,0x00000000}},	// [040] _रहि_, --, --, --,
   {{0x29ed5014,0x23ebe018,0xb943f009,0xa2902011}},	//   _का__प्रयोग_, _sette_, _počasie_, _askar_,
   {{0xf4909015,0x42d19018,0x24a3001e,0x00000000}},	//   _at__jeg_, _på__grunn_, _proyecto_, --,
   {{0x8ae1f018,0x00000000,0x00000000,0x00000000}},	//   _kostnade, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x64b3600c,0xac524017,0x8538600b,0x76824002}},	//   _concello__de_, _žetona_, _метара__максимал, _अरमान_,
   {{0x4224900a,0x00000000,0x00000000,0x00000000}},	//   _mwaka_, --, --, --,
   {{0x22d98009,0x2582000a,0x00000000,0x00000000}},	//   _hore_, _amategek, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc2d9600a,0x00000000,0x00000000,0x00000000}},	//   _kugeza_, --, --, --,
   {{0xf3ba8013,0x00000000,0x00000000,0x00000000}},	//   _jenis__lisensi_, --, --, --,
   {{0xba1e200b,0x00000000,0x00000000,0x00000000}},	//   _види_, --, --, --,
   {{0x7442600a,0xfa32a002,0xf442c009,0x5612c00e}},	//   _uwo_, _गजल_, _ked_, _licencom_,
   {{0xd490a018,0x5601900b,0x19711010,0xb2907013}},	//   _av__den_, _iznosi__geometri, _stažení_, _dinas_,
   {{0x45cc700b,0x7290b017,0x848f600c,0x0cdd0015}},	//   _на__надморск, _suca_, _de__ao_, _den__første_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xb223400e,0xd232a00b,0x82d5700a,0x13f8100c}},	// [050] _naselje__godine_, _tri__popisa_, _seromba_, _por__outra_,
   {{0xba33b008,0x7d8c0009,0x00000000,0x00000000}},	//   _आइल_, _počas_, --, --,
   {{0x7544a017,0xe2d9800a,0x00000000,0x00000000}},	//   _srušite_, _dore_, --, --,
   {{0x6442900a,0xe2d9000a,0x92d99015,0x00000000}},	//   _kwa_, _imbere_, _huset_, --,
   {{0xf2918012,0xe4b0e021,0x00000000,0x00000000}},	//   _fora_, _stand__til_, --, --,
   {{0x4b88201f,0x44192011,0x22d9900a,0x4290f022}},	//   _नु_, _mengikut__tempat_, _hose_, _lugar_,
   {{0xd2c7100f,0x72d8a01b,0xc3954012,0xfafb5006}},	//   _mana__mana_, _dijeli_, _acesso_, _žádné_,
   {{0x26fed008,0x00000000,0x00000000,0x00000000}},	//   _चोखा_, --, --, --,
   {{0xcd07a00b,0xaee97023,0x00000000,0x00000000}},	//   _је__град_, _de__saúde_, --, --,
   {{0x64b9b00c,0x7b62a01f,0xb2d6f006,0xd4b1a015}},	//   _millóns__de_, _जमाना_, _přes_, _til__den_,
   {{0xca00f007,0xa290400f,0x00000000,0x00000000}},	//   _surabaya_, _ramai_, --, --,
   {{0xd26dd00a,0xd442900a,0xe2fd6024,0x92019017}},	//   _ubwo_, _bwa_, _logger_, _nosi_,
   {{0x1ed1101e,0xd2e11019,0xb63e800e,0x727ef00a}},	//   _anuncios_, _anuncio_, _sastav__stanovni, _ikindi_,
   {{0xb26c8006,0x5c620005,0xd2d9e015,0x00000000}},	//   _nahoru_, _jurusan_, _enten_, --,
   {{0x02d87018,0xc2d9900a,0xd2fd5018,0x7cce1015}},	//   _inne_, _bose_, _kopiert_, _tyskland_,
   {{0xb3991003,0x7bbb9014,0xc2919003,0x7ddde013}},	//   _más_, _हैं__तो_, _cosa_, _menjabat_,
   {{0x226d200a,0x0ba27014,0x00000000,0x00000000}},	// [060] _icyo_, _रहा__है_, --, --,
   {{0x01a2a006,0x00000000,0x00000000,0x00000000}},	//   _hledání_, --, --, --,
   {{0x4f67800b,0x42026012,0x00000000,0x00000000}},	//   _је__насељено_, _equipe_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x4317f01e,0x00000000,0x00000000,0x00000000}},	//   _cruz_, --, --, --,
   {{0x62d8a01b,0x00000000,0x00000000,0x00000000}},	//   _cijeli_, --, --, --,
   {{0x338eb011,0x32d9900a,0x427f4004,0x00000000}},	//   _pautan__luar_, _yose_, _jednou_, --,
   {{0x73950023,0x72907018,0x00000000,0x00000000}},	//   _brasil_, _anna_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xd442900a,0x7711b014,0x00000000,0x00000000}},	//   _rwa_, _करना__चाहिए_, --, --,
   {{0xb51e3014,0xeaad6018,0x6c4ed01c,0x00000000}},	//   _के__कारण_, _konverte, _जैसे_, --,
   {{0x999ae00c,0x00000000,0x00000000,0x00000000}},	//   _súa__primeira_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x730b300b,0xc258400c,0xbe88101f,0xc40d800c}},	//   _према__попису_, _de__máis_, _कलकत्ता_, _dous__anos_,
   {{0x1c562008,0x00000000,0x00000000,0x00000000}},	//   _काहें_, --, --, --,
   {{0x0442900a,0x00000000,0x00000000,0x00000000}},	// [070] _uwa_, --, --, --,
   {{0x2f247006,0x00000000,0x00000000,0x00000000}},	//   _část_, --, --, --,
   {{0x6292700e,0xc48e600c,0x34bba00f,0xc4966018}},	//   _igrati_, _da__en_, _sama__ada_, _ta__en_,
   {{0x34c58012,0x1443e015,0xf2fce005,0x4469200b}},	//   _trabalho_, _amt_, _sangat_, _počeo__da_,
   {{0xf2e7200b,0x9248d012,0x33c2e005,0x64682018}},	//   _spoljašn_veze_, _quem_, _hindia__belanda_, _deg__for_,
   {{0x62019013,0xc344c010,0x22d9e018,0xdcac3005}},	//   _musik_, _inzerce_, _liten_, _yogyakar,
   {{0x2301f011,0x00000000,0x00000000,0x00000000}},	//   _masyarak_anda_, --, --, --,
   {{0x04868002,0x427eb009,0xd2011011,0x92b7700c}},	//   _बिहारी_, _jednej_, _fizik_, _de__polo_,
   {{0x0272f00f,0x2ac14004,0xd4940009,0x00000000}},	//   _tahun__beliau_, _lepší_, _sa__ako_, --,
   {{0x6bdfc00c,0x7443e003,0xf6d8b005,0x4b196013}},	//   _tamén__ligazóns_, _gmt_, _mahasisw, _keuangan_,
   {{0xc490e015,0x92242018,0x00000000,0x00000000}},	//   _få__en_, _rekke_, --, --,
   {{0xf2e1a017,0xe347c018,0xc4aa6018,0x1e28e00b}},	//   _kolovoz_, _handlar_, _del__av_, _ја_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x0495e025,0x00000000,0x00000000,0x00000000}},	//   _potrebuj, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x5080800b,0x00000000,0x00000000,0x00000000}},	//   _централн_године_, --, --, --,
   {{0x2442f018,0x57b5f018,0x00000000,0x00000000}},	// [080] _meg_, _arkeolog, --, --,
   {{0xc2489017,0x2e9a500b,0x7a3d3014,0xf229c006}},	//   _znam_, _што__је_, _हुआ_, _díky_,
   {{0xf2ca7007,0xa442d018,0x496e0023,0xd471b00c}},	//   _sunda_, _ble_, _moviment, _parte__das_,
   {{0x238a1006,0x5290b012,0x00000000,0x00000000}},	//   _fóru_, _dicas_, --, --,
   {{0xff18500b,0xaf669018,0xc442d006,0x00000000}},	//   _да__би_, _kampanje_, _dle_, --,
   {{0x4200700a,0x920ee006,0xd442d012,0x533b5007}},	//   _nini_, _při_, _ele_, _pergurua_tinggi_,
   {{0xc2613012,0xe5a3e026,0x22dcc005,0x42126012}},	//   _não_, _कर्मचारी_, _di__bidang_, _julho_,
   {{0x99aa200b,0x00000000,0x00000000,0x00000000}},	//   _нато__ознака_, --, --, --,
   {{0x9442f018,0x7297700b,0x00000000,0x00000000}},	//   _deg_, _ma__prema_, --, --,
   {{0x8300e013,0x82d87019,0x7249901e,0x00000000}},	//   _sepak__bola_, _cine_, _misma_, --,
   {{0xcc4ee008,0x3b1f3005,0x00000000,0x00000000}},	//   _करीं_, _komandan_, --, --,
   {{0x4471700c,0xaa3e7002,0x4a3dc01c,0xbc6f5006}},	//   _que__lle_, _मीट_, _तुम_, _ostrava_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x5201b013,0x00000000,0x00000000,0x00000000}},	//   _divisi_, --, --, --,
   {{0x426e700b,0x81ed4008,0x00000000,0x00000000}},	//   _nosač__nato_, _दोसरा_, --, --,
   {{0xf2d8f015,0x2a878027,0x00000000,0x00000000}},	//   _dagen_, _ortodoks, --, --,
   {{0x944a5007,0x647ad00c,0xe257500d,0x00000000}},	// [090] _karena__ia_, _illa__de_, _su__jedino_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc49ed00b,0x7dc2b007,0x12dfa00c,0x252f500a}},	//   _takođe__je_, _kebijaka, _na__zona_, _umuyoboz,
   {{0x9300f013,0x2281e00b,0x7291c018,0x9a3d3014}},	//   _lihat__pula_, _metara__maksimal, _lova_, _हुई_,
   {{0xe3eba01b,0x00000000,0x00000000,0x00000000}},	//   _lopte_, --, --, --,
   {{0x8442f018,0x9291c012,0xe4a36015,0x83eaf013}},	//   _seg_, _nova_, _når__du_, _kantor_,
   {{0x0a3d3014,0xadde700b,0x00000000,0x00000000}},	//   _हुए_, _да__су_, --, --,
   {{0xd2132003,0x00000000,0x00000000,0x00000000}},	//   _muchas_, --, --, --,
   {{0x12613012,0xf48e800c,0xb442f018,0xe466f018}},	//   _são_, _ao__ano_, _veg_, _deg__til_,
   {{0x0cca9007,0xf2785017,0x00000000,0x00000000}},	//   _untuk__pertama_, _vrtnja_, --, --,
   {{0x2236000e,0x52127012,0x337b9006,0x00000000}},	//   _dvije_, _junho_, _skladem_, --,
   {{0x1f49d00b,0x00000000,0x00000000,0x00000000}},	//   _производ, --, --, --,
   {{0x7e72e00b,0x00000000,0x00000000,0x00000000}},	//   _се_, --, --, --,
   {{0xaa4ca014,0x00000000,0x00000000,0x00000000}},	//   _के__लिए_, --, --, --,
   {{0xaf249015,0x00000000,0x00000000,0x00000000}},	//   _større_, --, --, --,
   {{0xd36a7007,0xd3ebe018,0xa1f79009,0x22010011}},	//   _bahasa__inggris_, _motta_, _najlepši, _dibina_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [0a0] --, --, --, --,
   {{0x7442000a,0x24431009,0xcf30200b,0xb226100b}},	//   _iti_, _cez_, _врста__има_, _avgusta__godine_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf442d00a,0x00000000,0x00000000,0x00000000}},	//   _bwe_, --, --, --,
   {{0x6465d00c,0xaac7f006,0xd279300b,0x00000000}},	//   _banda__de_, _kteří_, _ракета__носач_, --,
   {{0x3c4ee014,0xc291e013,0xa4432003,0x00000000}},	//   _करें_, _antar_, _ley_, --,
   {{0x0b8f8014,0xc3f91017,0xc2c3200f,0x00000000}},	//   _था_, _guzu_, _hanya__perlu_, --,
   {{0xc47a500c,0xa439000b,0x5200b003,0x00000000}},	//   _nado__en_, _staništa__vrste_, _hacia_, --,
   {{0x525b1013,0xc442000a,0x6bde800b,0x64079013}},	//   _publik_, _nti_, _opština__istočnoj_, _dukungan_,
   {{0xb4ba9007,0xb4b29011,0xc291600a,0xac612015}},	//   _yaitu__dan_, _iaitu__dan_, _hagati_, _består_,
   {{0xf442000a,0xc200c00a,0xa290c00a,0xc3cf7025}},	//   _ati_, _indi_, _inda_, _hlavne_,
   {{0x9236f01b,0xf2d75006,0x4c4e0008,0x00000000}},	//   _uvijek_, _třeba_, _कहले_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xd552f00b,0x42cb5003,0xdf2d6023,0xc290a00a}},	//   _становни_просјечн, _puedes_, _através_, _niba_,
   {{0x02fcf018,0x9a272011,0x1302700f,0xf4273018}},	//   _legge_, _sumbanga_daripada_, _ini__boleh_, _nettsted_ditt_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2200a00a,0x00000000,0x00000000,0x00000000}},	// [0b0] _bibi_, --, --, --,
   {{0x546dd00c,0xf473f00c,0xa2fc5018,0x00000000}},	//   _cando__se_, _mesmo__ano_, _selge_, --,
   {{0x4a4bb00a,0x00000000,0x00000000,0x00000000}},	//   _perezida_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x830b4017,0x92903013,0x00000000,0x00000000}},	//   _svibanj_, _pajak_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6290c018,0x42919017,0xd47ea00c,0x00000000}},	//   _enda_, _rezač_, _senón__que_, --,
   {{0xd496f00c,0x14b0a00c,0xca336014,0x00000000}},	//   _xa__que_, _non__son_, _किए_, --,
   {{0xeb8e801c,0xb2d8b017,0x23280018,0xa290b01b}},	//   _वे_, _lice_, _en__liten_, _lica_,
   {{0x0f097011,0x42f25014,0x5c625014,0x00000000}},	//   _amerika__syarikat_, _हो__सकती_, _हो__सकते_, --,
   {{0x78d01014,0x6b398018,0x00000000,0x00000000}},	//   _बच्चों_, _kombinas, --, --,
   {{0x62fc7003,0x02d8e003,0xdc282019,0x00000000}},	//   _tengo_, _manera_, _sociedad_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xd47fa00c,0xe47c700b,0x0bd3101f,0x00000000}},	//   _unha__das_, _vikipedi_na_, _तबियत_, --,
   {{0x72b33011,0x6eee4012,0xabbd7005,0x00000000}},	//   _pilihan__raya_, _milhões_, _soekarno_, --,
   {{0x3442000a,0x00000000,0x00000000,0x00000000}},	// [0c0] _uti_, --, --, --,
   {{0x83bc2005,0x00000000,0x00000000,0x00000000}},	//   _terdiri__atas_, --, --, --,
   {{0x327f7012,0x4290b012,0x00000000,0x00000000}},	//   _quando_, _fica_, --, --,
   {{0x248da015,0x0290500f,0x00000000,0x00000000}},	//   _de__kan_, _ialah_, --, --,
   {{0x2d427014,0x00000000,0x00000000,0x00000000}},	//   _किस__प्रकार_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x825e7013,0x00000000,0x00000000,0x00000000}},	//   _sebagai__bagian_, --, --, --,
   {{0x54444015,0x00000000,0x00000000,0x00000000}},	//   _om_, --, --, --,
   {{0x2eb3f00b,0x6b621008,0xa2d98010,0x00000000}},	//   _која__је_, _केतना_, _firem_, --,
   {{0xe4438015,0x93f9801d,0x00000000,0x00000000}},	//   _år_, _turut_, --, --,
   {{0x3c59f013,0x00000000,0x00000000,0x00000000}},	//   _listrik_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xff271017,0x2309c012,0xe6975015,0xb253b020}},	//   _isprinta, _também_, _offentli, _iz__knjige_,
   {{0x14420012,0xd386e012,0xc25b801d,0x00000000}},	//   _foi_, _bairro_, _perlu_, --,
   {{0xb4444012,0x1bb0a014,0x00000000,0x00000000}},	//   _em_, _यह__एक_, --, --,
   {{0x027f0018,0x4db0900b,0x8819900c,0x00000000}},	// [0d0] _etanol_, _око__планете_, _en__castelán_, --,
   {{0x9236400b,0x2212b003,0x00000000,0x00000000}},	//   _poslednj_godina_, _mucho_, --, --,
   {{0xbc59f013,0xc3c7f00c,0x00000000,0x00000000}},	//   _distrik_, _en__españa_, --, --,
   {{0x16d13008,0xc469e00b,0x00000000,0x00000000}},	//   _खातिर_, _gde__je_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x82c6b027,0xd2c90011,0x00000000,0x00000000}},	//   _kategori_, _wikipedi_telah_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x8b0b1024,0xe2d88003,0x00000000,0x00000000}},	//   _rapporte, _mejores_, --, --,
   {{0x13eb9003,0x00000000,0x00000000,0x00000000}},	//   _costa_, --, --, --,
   {{0x8b6b5018,0x00000000,0x00000000,0x00000000}},	//   _annonser, --, --, --,
   {{0x9bef4014,0x00000000,0x00000000,0x00000000}},	//   _करें__कि_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xb290f018,0x00000000,0x00000000,0x00000000}},	//   _inga_, --, --, --,
   {{0x44b08006,0xe2fba00b,0x32f9101b,0x00000000}},	//   _můžete_, _samom__gradu_, _ni__klub_, --,
   {{0x534ad00e,0x00000000,0x00000000,0x00000000}},	//   _godine__naselje_, --, --, --,
   {{0xc061b015,0x28464012,0x1bd27008,0x32d8900e}},	//   _forsknin, _qualidad, _बांये_, _tijela_,
   {{0x1ba52028,0x23eba01b,0x00000000,0x00000000}},	// [0e0] _ही__एक_, _lopti_, --, --,
   {{0xb4444012,0x2a27d00b,0x00000000,0x00000000}},	//   _um_, _може__бити_, --, --,
   {{0xb4444009,0xff8bf012,0x4edc500b,0x00000000}},	//   _id_, _além_, _више__од_, --,
   {{0x1315700f,0x00000000,0x00000000,0x00000000}},	//   _yang__boleh_, --, --, --,
   {{0xf9940017,0x6290700f,0x00000000,0x00000000}},	//   _uopće_, _kanak_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6ee8b014,0x00000000,0x00000000,0x00000000}},	//   _सूचक_, --, --, --,
   {{0x0bb48014,0xde5d7009,0x00000000,0x00000000}},	//   _नहीं__है_, _nehnuteľ, --, --,
   {{0x1b9e2014,0x00000000,0x00000000,0x00000000}},	//   _के__एक_, --, --, --,
   {{0x5469e00b,0x00000000,0x00000000,0x00000000}},	//   _gde__se_, --, --, --,
   {{0xfa4e4014,0xb2907017,0x00000000,0x00000000}},	//   _के__पास_, _crna_, --, --,
   {{0x29984006,0x00000000,0x00000000,0x00000000}},	//   _domů_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xb2e8500b,0x00000000,0x00000000,0x00000000}},	//   _poslednj, --, --, --,
   {{0x9f8bf006,0x2c75b006,0xe4422018,0xa303b006}},	//   _své_, _hlavní_, _bok_, _opravdu_,
   {{0x343d8015,0xc2caf01d,0x6201a013,0x00000000}},	//   _på__dette_, _bandar_, _sipil_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [0f0] --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc496e015,0x79a37012,0x37ab400b,0x5bacd00b}},	//   _se__en_, _ministér, _износи__астероид, _registro_žitelja_,
   {{0x8bc0c014,0x1326e00c,0x00000000,0x00000000}},	//   _करने__का_, _en__onde_, --, --,
   {{0xa291000a,0x00000000,0x00000000,0x00000000}},	//   _kubaka_, --, --, --,
   {{0xd33d0007,0x92019013,0x00000000,0x00000000}},	//   _bahwa__mereka_, _fisik_, --, --,
   {{0x84a9500c,0x00000000,0x00000000,0x00000000}},	//   _durante__os_, --, --, --,
   {{0x8d0f000e,0xf33df00c,0x38686009,0x00000000}},	//   _uklonite_, _en__galicia_, _vzdeláva, --,
   {{0xfe8f100b,0xeedd100b,0x5d84b017,0xf3e78009}},	//   _или_, _prirodno__stanište_, _odredite_, _dátum_,
   {{0x5675500c,0x54523021,0x00000000,0x00000000}},	//   _unha__diminuci, _den__mest_, --, --,
   {{0x0291000f,0xfecbd017,0x5c7c4003,0x00000000}},	//   _beliau__juga_, _najigran, _nuestra_, --,
   {{0x0201a003,0x82d8f021,0x00000000,0x00000000}},	//   _mexico_, _unge_, --, --,
   {{0xbca2a014,0x5429e011,0xf9f47006,0x00000000}},	//   _आप__अपने_, _merupaka_portal_, _nyní_, --,
   {{0xc26c4029,0x00000000,0x00000000,0x00000000}},	//   _pomoc_, --, --, --,
   {{0xab8fd007,0xe461f00f,0xa2a6301b,0xb4c05018}},	//   _हा_, _ialah__untuk_, _vidjeti_, _slik__at_,
   {{0xd2e61013,0x1407a01b,0x00000000,0x00000000}},	//   _pranala_, _na__sjeveru_, --, --,
   {{0xec0d9014,0x00000000,0x00000000,0x00000000}},	// [100] _बनाने__के_, --, --, --,
   {{0xc2ef6002,0x0399b012,0x00000000,0x00000000}},	//   _जरुर_, _mês_, --, --,
   {{0x04422018,0x4307500b,0x64af800c,0x446a600c}},	//   _tok_, _oko__planete_, _entidade_de_, _través__da_,
   {{0x94b87015,0x00000000,0x00000000,0x00000000}},	//   _kan__få_, --, --, --,
   {{0x627ff006,0x0a6e9014,0x9e61f007,0x00000000}},	//   _seznam_, _करते__हुए_, _pembagia, --,
   {{0x125a900f,0x00000000,0x00000000,0x00000000}},	//   _kuala_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc3ea6006,0xa2125012,0x00000000,0x00000000}},	//   _proto_, _filho_, --, --,
   {{0xfba82014,0x00000000,0x00000000,0x00000000}},	//   _कम__से_, --, --, --,
   {{0xe085c014,0x9201800a,0x1496e006,0x00000000}},	//   _सम्बंधित_, _kuri_, _se__mi_, --,
   {{0x84438018,0x84424024,0x3712a014,0x5cc2f010}},	//   _mer_, _kom_, _हो__सकता_, _český_,
   {{0xb201800a,0xa470c011,0x1a44b015,0x00000000}},	//   _muri_, _menyumba_semua_, _er__også_, --,
   {{0xe495e009,0x00000000,0x00000000,0x00000000}},	//   _sa__na_, --, --, --,
   {{0xe2b5d006,0xb2127012,0x00000000,0x00000000}},	//   _najdete_, _tinha_, --, --,
   {{0x122b8003,0x727ff013,0x00000000,0x00000000}},	//   _siempre_, _ujung_, --, --,
   {{0xc4426009,0x00000000,0x00000000,0x00000000}},	//   _kto_, --, --, --,
   {{0xd4438018,0x962f700b,0x00000000,0x00000000}},	// [110] _ber_, _demograf, --, --,
   {{0x1490200c,0x0201800a,0x00000000,0x00000000}},	//   _en__foi_, _buri_, --, --,
   {{0xf4424012,0xc8fc8006,0xf2918017,0xc26c401b}},	//   _bom_, _odpovědě, _cura_, _nemoj_,
   {{0x6c48d014,0xff3ca005,0x82de601f,0x52cad003}},	//   _होने_, _perusaha, _कुली_, _puedo_,
   {{0x14424009,0xe2920013,0xc4af6015,0xb83f6003}},	//   _dom_, _jepang_, _for__en_, _después_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2c8e8028,0x12d8e016,0x00000000,0x00000000}},	//   _कार्य__करते_, _सूची_, --, --,
   {{0x8300a007,0x00000000,0x00000000,0x00000000}},	//   _tidak__bisa_, --, --, --,
   {{0x8443901e,0x504a800b,0xd70d4012,0x00000000}},	//   _mes_, _познато__природно_, _experiên, --,
   {{0x74439003,0xeeb9100b,0x13ea700a,0x53f8f012}},	//   _les_, _био_, _muntu_, _água_,
   {{0x6d50701f,0x821cb006,0x00000000,0x00000000}},	//   _मुंगेर_, _během_, --, --,
   {{0xb77b900b,0xba09a009,0x00000000,0x00000000}},	//   _opština__severnoj_, _zodpoved, --, --,
   {{0x4e72e00b,0x1bd9702a,0xe2d8b025,0x00000000}},	//   _не_, _आपूर्ति_, _chcem_, --,
   {{0x78aeb017,0x22e6d008,0x00000000,0x00000000}},	//   _počnete_, _चाहीं_, --, --,
   {{0x0301900f,0x8e9bd017,0x00000000,0x00000000}},	//   _lihat__juga_, _pokupite_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xb4438018,0x9956a015,0x8d96a018,0xfea9d01b}},	// [120] _per_, _millione, _milliona, _postavke_,
   {{0x04424015,0x89992006,0x95c3300b,0x00000000}},	//   _som_, _když_, _је__једино_, --,
   {{0xe3eb8018,0xb291600a,0x00000000,0x00000000}},	//   _vert_, _kigali_, --, --,
   {{0x52366009,0xb290c020,0x00000000,0x00000000}},	//   _svoje_, _nalazi_, --, --,
   {{0xf4438012,0xf4425009,0xe489200d,0xb2019012}},	//   _ter_, _bol_, _ograniče_na_, _assim_,
   {{0x2201800a,0xe399b006,0x0e4ca013,0x00000000}},	//   _turi_, _místo_, _pelayana, --,
   {{0xf443e018,0x4e7a600b,0xd2ca6015,0x23430003}},	//   _åt_, _је__од_, _stod_, _acuerdo_,
   {{0xab594005,0x895eb003,0x228af007,0xebfaa014}},	//   _सचिन_, _cualquie, _praktik_, _देने__के_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x5e868017,0xc478d00c,0x00000000,0x00000000}},	//   _mjehurić, _nada__en_, --, --,
   {{0x84426027,0x00000000,0x00000000,0x00000000}},	//   _wto_, --, --, --,
   {{0x1e42900b,0x00000000,0x00000000,0x00000000}},	//   _је__као_, --, --, --,
   {{0xc4444018,0x0dd9201d,0x00000000,0x00000000}},	//   _av_, _perkataa, --, --,
   {{0xd443a012,0x00000000,0x00000000,0x00000000}},	//   _cep_, --, --, --,
   {{0x62d8b017,0xd2d8f018,0x00000000,0x00000000}},	//   _srce_, _laget_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x3b880008,0x12dca00b,0x62905013,0x0266701d}},	// [130] _बा_, _raketa__nosač_, _salat_, _dan__beliau_,
   {{0x9a1b4011,0xb2cad003,0x00000000,0x00000000}},	//   _terdiri__daripada_, _puede_, --, --,
   {{0x2a3e0002,0xa52bb00a,0xc4550003,0x00000000}},	//   _बाप_, _munyakaz, _producto_, --,
   {{0x13b0e012,0x00000000,0x00000000,0x00000000}},	//   _clique_, --, --, --,
   {{0xe2d8700b,0xce66c00c,0x00000000,0x00000000}},	//   _prema__procjeni_, _habitant_mulleres_, --, --,
   {{0x9468a011,0xe2ace00b,0x00000000,0x00000000}},	//   _bagi__tujuan_, _procjeni_, --, --,
   {{0x7a3d9002,0xce25f011,0x00000000,0x00000000}},	//   _दाल_, _baru__mendafta, --, --,
   {{0x4a3ed01f,0x82258018,0x3d4c800b,0x926c2020}},	//   _नरक_, _merke_, _potrebe__ilustrac, _tokom_,
   {{0x8442900a,0xf14dc00b,0x00000000,0x00000000}},	//   _nta_, _износи_, --, --,
   {{0x04918015,0x00000000,0x00000000,0x00000000}},	//   _at__det_, --, --, --,
   {{0x32026011,0xa275400b,0xa2e7c00c,0x00000000}},	//   _afrika_, _tabeli__ispod_, _de__súa_, --,
   {{0xd443a003,0x23f9a017,0x33f40006,0x348cd009}},	//   _sep_, _rupu_, _jestli_, _ktoré__sa_,
   {{0x54b2600c,0x2d209009,0x12927013,0x00000000}},	//   _non__se_, _vyhľadáv, _wisata_, --,
   {{0x12902018,0x00000000,0x00000000,0x00000000}},	//   _saka_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x12d8300a,0x00000000,0x00000000,0x00000000}},	// [140] _baje_, --, --, --,
   {{0xf968d015,0xeda8d013,0x125b0009,0x00000000}},	//   _aktivite, _aktivita, _ďalej_, --,
   {{0x83202010,0x00000000,0x00000000,0x00000000}},	//   _taky_, --, --, --,
   {{0x64c1f017,0x6bdd1014,0xe3458009,0xed73800b}},	//   _stanovni_te_, _यदि__आप_, _predmet_, _је__почео_,
   {{0x7f575008,0xc3940012,0x00000000,0x00000000}},	//   _जिनगी_, _coisa_, --, --,
   {{0x0e42600b,0x00000000,0x00000000,0x00000000}},	//   _је__за_, --, --, --,
   {{0x02018017,0x00000000,0x00000000,0x00000000}},	//   _igri_, --, --, --,
   {{0x7daa2007,0x00000000,0x00000000,0x00000000}},	//   _pariwisa, --, --, --,
   {{0xe4646015,0xa387f00a,0x00000000,0x00000000}},	//   _før__du_, _ukuri_, --, --,
   {{0x14427003,0x40b0f00b,0x00000000,0x00000000}},	//   _con_, _метра__површина_, --, --,
   {{0x62ca9018,0x22e7a00b,0x00000000,0x00000000}},	//   _stad_, _jedino__poznato_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x23a26013,0x00000000,0x00000000,0x00000000}},	//   _eropa_, --, --, --,
   {{0xbf24001b,0xd491a015,0x7a56c017,0x00000000}},	//   _loših_, _er__den_, _small__napomena_, --,
   {{0x40b8000b,0xbb52001d,0xa1e21008,0x00000000}},	//   _метара__површина_, _oleh__kerajaan_, _केकरा_, --,
   {{0xd290400a,0x52f5000c,0x00000000,0x00000000}},	//   _nama_, _político__galego_, --, --,
   {{0x12deb008,0x52327003,0xd472a021,0x00000000}},	// [150] _अउरी_, _ejemplo_, _som__den_, --,
   {{0xeae53003,0x9291c00a,0x00000000,0x00000000}},	//   _siguient, _kuva_, --, --,
   {{0x8c6ac014,0xc49db00b,0x08d1a002,0xc560a00b}},	//   _चिट्ठा_, _opštini__je_, _टमाटर_, _živjelo_,
   {{0xc471200c,0x12fdf00a,0x64a8200c,0xaa64100c}},	//   _que__non_, _avuga_, _listaxe__de_, _non__está_,
   {{0x3aa67014,0x00000000,0x00000000,0x00000000}},	//   _में__मदद_, --, --, --,
   {{0x7abbd014,0x00000000,0x00000000,0x00000000}},	//   _चाहते__हैं_, --, --, --,
   {{0xfbf82014,0xd4942015,0x00000000,0x00000000}},	//   _में__से_, _på__den_, --, --,
   {{0x64805015,0xa13f3021,0xd4adc012,0x00000000}},	//   _over__de_, _anmeldel, _serviço_, --,
   {{0xedbba00b,0x00000000,0x00000000,0x00000000}},	//   _је__постао_, --, --, --,
   {{0x5bc3b008,0x82fcd00a,0x92e95013,0x7e65800c}},	//   _आजु_, _rwego_, _artinya_, _cando__tiña_,
   {{0x94429012,0x00000000,0x00000000,0x00000000}},	//   _boa_, --, --, --,
   {{0x9200500a,0x00000000,0x00000000,0x00000000}},	//   _hali_, --, --, --,
   {{0x7ed4e00b,0x8a3e7002,0xbefb2017,0x00000000}},	//   _по_, _बडा_, _natjecan, --,
   {{0xd467e00c,0x7a3dc008,0x00000000,0x00000000}},	//   _aínda__que_, _हमर_, --, --,
   {{0xc2905009,0xc236c00e,0xfc48e008,0xe3167013}},	//   _mala_, _ovdje_, _संगे_, _pribadi_,
   {{0x9291d00a,0xd468700c,0xd036c029,0x00000000}},	//   _kuwa_, _ata__que_, _ubytovan, --,
   {{0x64bd500c,0x22d8e003,0x2290800a,0x00000000}},	// [160] _logo__de_, _quiero_, _bakaba_, --,
   {{0xb6ae300b,0x00000000,0x00000000,0x00000000}},	//   _iznosila__stanovni, --, --, --,
   {{0x6a3e7008,0x00000000,0x00000000,0x00000000}},	//   _बड़_, --, --, --,
   {{0xac61b017,0x344fd00b,0xb301f011,0x00000000}},	//   _udarite_, _oznaka__sa_, _ditubuhk_pada_, --,
   {{0x648fa00c,0xa38b5018,0x2ed5500b,0x00000000}},	//   _ao__sur_, _vårt_, _па__је_, --,
   {{0x82ffe007,0x329fd009,0x19b3a01b,0x00000000}},	//   _sebagian__besar_, _dňa_, _spomenic_znamenit, --,
   {{0xfef4800c,0x4ccf9006,0x00000000,0x00000000}},	//   _un__saúdo_, _opět_, --, --,
   {{0x434fc00e,0x00000000,0x00000000,0x00000000}},	//   _riječi_, --, --, --,
   {{0x62d85012,0x00000000,0x00000000,0x00000000}},	//   _fale_, --, --, --,
   {{0xa0e80015,0x00000000,0x00000000,0x00000000}},	//   _mobiltel, --, --, --,
   {{0x5640100a,0xee64400b,0x127ff01b,0x00000000}},	//   _abanyarw, _тако__да_, _neznam_, --,
   {{0x42e2f00d,0x75c6300c,0x00000000,0x00000000}},	//   _od__metara_, _de__santiago_, --, --,
   {{0xd442900a,0x22b9c011,0x00000000,0x00000000}},	//   _voa_, _dibahagi_kepada_, --, --,
   {{0x7b8e4002,0x1c013006,0x4bcec016,0x00000000}},	//   _आब_, _prostor_, _नही_, --,
   {{0x0086c006,0x00000000,0x00000000,0x00000000}},	//   _nábytek_, --, --, --,
   {{0x53ebe018,0xc4926018,0x0c4f0014,0x1bfd6014}},	//   _lett_, _en__av_, _इसके_, _प्राप्त__कर_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [170] --, --, --, --,
   {{0xdc498002,0x73ebe018,0x00000000,0x00000000}},	//   _पढ़े_, _nett_, --, --,
   {{0xc48f602b,0x00000000,0x00000000,0x00000000}},	//   _de__en_, --, --, --,
   {{0x73ead009,0x42127012,0x43cf5018,0x00000000}},	//   _preto_, _minha_, _elevar_, --,
   {{0xc2252011,0xd442c004,0x2d7c900b,0x00000000}},	//   _tinggal__hari_, _atd_, _не__може_, --,
   {{0x7de0c01b,0x00000000,0x00000000,0x00000000}},	//   _zvijezde_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc477d00e,0x00000000,0x00000000,0x00000000}},	//   _gdje__je_, --, --, --,
   {{0x5442b004,0x62ca702c,0xb249a00b,0x00000000}},	//   _moc_, _ainda_, _južnoj__godine_, --,
   {{0xabd2600c,0xb43ab00b,0x00000000,0x00000000}},	//   _súa__carreira_, _na__mestu_, --, --,
   {{0x52d9e00a,0xb9858021,0x9c4f101c,0x526c1007}},	//   _gute_, _konkurre, _उनके_, _pohon_,
   {{0x4c776013,0x00e13008,0x00000000,0x00000000}},	//   _populer_, _पंडीजी_, --, --,
   {{0x9443f012,0x3ea5f00e,0x00000000,0x00000000}},	//   _meu_, _djelovan, --, --,
   {{0x42129006,0x9fb66006,0xc72d3017,0x0c06e009}},	//   _praha_, _právě_, _lopticom_, _potreby_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x8e97900b,0xb442a012,0x00000000,0x00000000}},	//   _године__број_, _sob_, --, --,
   {{0xc2d8700a,0xce14a009,0x7e0d200b,0x00000000}},	// [180] _kane_, _zamestna, _два_, --,
   {{0xfccf9006,0x00000000,0x00000000,0x00000000}},	//   _zpět_, --, --, --,
   {{0x64c1000c,0xf2d99024,0x00000000,0x00000000}},	//   _parroqui_de_, _viser_, --, --,
   {{0x2ee3e00b,0x02f8e00f,0x7ab3d014,0x7290a013}},	//   _општини__је_, _bebas__dalam_, _जानते__हैं_, _kabar_,
   {{0xc48f6019,0x738fb00c,0x9b580008,0xf26c0012}},	//   _de__un_, _resumo__licenza_, _लोगन_, _meio_,
   {{0x2eb4b00b,0x6e42600b,0xd291e00d,0x00000000}},	//   _који__је_, _је__са_, _puta_, --,
   {{0xc2498017,0xf14a800b,0xdd2ff010,0x00000000}},	//   _farma_, _је__откривен_, _uživatel_, --,
   {{0x39aa700b,0xc3954018,0x222a700b,0x00000000}},	//   _који_, _greske_, _која_, --,
   {{0x52d8b003,0x2290700a,0x3201800a,0xf32a1011}},	//   _hacer_, _bana_, _kiri_, _berkahwi_dengan_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x4290700d,0x00000000,0x00000000,0x00000000}},	//   _dana_, --, --, --,
   {{0x7b4e6025,0x1c4f2014,0xe348801b,0xf2df2014}},	//   _slovakia_, _उसके_, _leteći_, _उसकी_,
   {{0x4442c017,0x32d84006,0xe48e600c,0x1490a00c}},	//   _kod_, _jsme_, _da__na_, _en__con_,
   {{0x226c3003,0x5477d00e,0x5c64e014,0x00000000}},	//   _mejor_, _gdje__se_, _का__सबसे_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x07c6602d,0x82d98003,0x726c2013,0x00000000}},	//   _प्रभावित_, _aire_, _rekor_, --,
   {{0xa201800a,0x02d9e014,0xd2cd001b,0x00000000}},	// [190] _biri_, _पूरी_, _poznate__osobe_, --,
   {{0xf443f012,0x6491e015,0x448e600c,0x62a0600a}},	//   _seu_, _at__de_, _da__da_, _ahubwo_,
   {{0xf3c6500b,0xf442d009,0x7a32f008,0x00000000}},	//   _samom__mjestu_, _ste_, _ओकर_, --,
   {{0xf2e6700a,0x7466d012,0x00000000,0x00000000}},	//   _cyangwa_, _dezembro_, --, --,
   {{0x62d8901b,0x62fc9015,0x00000000,0x00000000}},	//   _lijepo_, _slags_, --, --,
   {{0x73ead009,0x99cd1015,0x163f0009,0xc5aed01b}},	//   _tieto_, _myndighe, _komentár_, _je__živjelo_,
   {{0x4b88701f,0xfbc35008,0x847c3002,0xb264100b}},	//   _भा_, _कबो_, _देवनागरी_, _istočnoj__godine_,
   {{0xd468f00c,0x00000000,0x00000000,0x00000000}},	//   _hai__que_, --, --, --,
   {{0x1442d018,0x00000000,0x00000000,0x00000000}},	//   _ute_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x4291e027,0xf752d00b,0x00000000,0x00000000}},	//   _satan_, _референц, --, --,
   {{0xd379e012,0x00000000,0x00000000,0x00000000}},	//   _tamanho_, --, --, --,
   {{0x2eb3600b,0xaaea401b,0x00000000,0x00000000}},	//   _врсте__је_, _izbrisat, --, --,
   {{0xc46ae009,0x00000000,0x00000000,0x00000000}},	//   _ako__je_, --, --, --,
   {{0x5499e006,0x02765011,0x1b9f2016,0x00000000}},	//   _to__se_, _pengguna__bagi_, _को__एक_, --,
   {{0x1eb14003,0x7442d018,0x14138011,0x00000000}},	//   _importan, _noe_, _kristian_, --,
   {{0x5cdae009,0x0a337008,0xeaf53018,0x00000000}},	// [1a0] _katalóg_, _कवन_, _referans, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2ef4d00b,0x73ea1005,0x00000000,0x00000000}},	//   _које__је_, _tahta_, --, --,
   {{0x04202005,0x824d8007,0xd26e1012,0x0279f00b}},	//   _pada__saat_, _di__bagian_, _depois_, _orbite__iznosi_,
   {{0xb698400b,0x147d900c,0x00000000,0x00000000}},	//   _gustina__stanovni, _xunto__con_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x02499011,0x0202000b,0x00000000,0x00000000}},	//   _rasmi_, _visini_, --, --,
   {{0x2290a00a,0x00000000,0x00000000,0x00000000}},	//   _haba_, --, --, --,
   {{0xf8673003,0xbc773003,0xc27ee018,0x00000000}},	//   _mensajes_, _mensaje_, _hennes_, --,
   {{0x444fe00b,0x00000000,0x00000000,0x00000000}},	//   _je__otkriven_, --, --, --,
   {{0xb0a1d00b,0x00000000,0x00000000,0x00000000}},	//   _је__елиптичн, --, --, --,
   {{0x027f7018,0x62b40003,0x82162012,0x00000000}},	//   _spania_, _clic_, _conhecim, --,
   {{0xc42f000b,0x92cbf013,0x335c3008,0x225ad017}},	//   _grad__okrugu_, _studi_, _रहेला_, _stolni_,
   {{0x0239a00b,0xa200a00a,0x12d45009,0x00000000}},	//   _nadmorsk_visini_, _nabi_, _ľudia_, --,
   {{0x43c05010,0x0e73f02d,0xc3ead009,0x67d0c00b}},	//   _प्रस्तुत_, _बुद्ध_, _siete_, _много_,
   {{0x8201a017,0x00000000,0x00000000,0x00000000}},	//   _ispis_, --, --, --,
   {{0x83f86006,0x3a3ec008,0xb4750024,0x3aea1017}},	// [1b0] _jsou_, _नहि_, _kulturen_, _vjerojat,
   {{0x3a263013,0x00000000,0x00000000,0x00000000}},	//   _mencakup_, --, --, --,
   {{0xaf49f002,0x00000000,0x00000000,0x00000000}},	//   _मूंग_, --, --, --,
   {{0x82b8b00c,0x00000000,0x00000000,0x00000000}},	//   _foi__unha_, --, --, --,
   {{0xf3137007,0x8e6ec011,0x00000000,0x00000000}},	//   _berbeda__dengan_, _peluru__berpandu_, --, --,
   {{0xe2c1d00f,0x32d8b003,0x00000000,0x00000000}},	//   _anda__tidak_, _hace_, --, --,
   {{0x5a141015,0x3da90007,0xe315e012,0x9731901b}},	//   _finansie, _fasilita, _usuários_, _vjerujem_,
   {{0x12d8d028,0x4200c017,0x42d98013,0x00000000}},	//   _होती_, _palica_, _maret_, --,
   {{0x42257017,0x3290a00a,0xd48ff00c,0x00000000}},	//   _opakog_, _yaba_, _as__que_, --,
   {{0x04920018,0x4e94a00b,0x00000000,0x00000000}},	//   _av__det_, _удаљенос_од_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x44bbd00b,0x00000000,0x00000000,0x00000000}},	//   _uspeo__da_, --, --, --,
   {{0x7e72e00b,0x00000000,0x00000000,0x00000000}},	//   _те_, --, --, --,
   {{0xb669800d,0x00000000,0x00000000,0x00000000}},	//   _živjelo__stanovni, --, --, --,
   {{0xc3fb8015,0x00000000,0x00000000,0x00000000}},	//   _vil__være_, --, --, --,
   {{0x040e9009,0xe2d92008,0x81dfc01f,0xa3eb900b}},	//   _svoj__život_, _मछरी_, _अरहर_, _vrste_,
   {{0x2e6ac00b,0xfaf22009,0x0edbe012,0x726c5023}},	// [1c0] _промене__броја_, _prihláse, _conteúdo_, _pelos_,
   {{0x7291f01e,0x2ead700b,0x1290d00f,0x00000000}},	//   _agua_, _коју__је_, _melayu_, --,
   {{0x026c5003,0x43f9e007,0x00000000,0x00000000}},	//   _ellos_, _fitur_, --, --,
   {{0x54ba100c,0x00000000,0x00000000,0x00000000}},	//   _tamén__se_, --, --, --,
   {{0xd4444006,0x00000000,0x00000000,0x00000000}},	//   _ke_, --, --, --,
   {{0xb643700b,0xb2640003,0x04b30015,0x22d8e003}},	//   _iznosi__stanovni, _empleo_, _til__det_, _dinero_,
   {{0xf4444017,0xc3eb9015,0x425a500b,0xc442f00b}},	//   _me_, _liste_, _iznosila__kilogram, _bog_,
   {{0xe4444003,0xf3a4201b,0x00000000,0x00000000}},	//   _le_, _financij, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x3a3df01c,0xc321601e,0xe2911018,0xe2cfc006}},	//   _साथ_, _gracias_, _debatt_, _kancelář,
   {{0x148ea015,0x00000000,0x00000000,0x00000000}},	//   _de__har_, --, --, --,
   {{0xe404801d,0xa4420027,0x00000000,0x00000000}},	//   _tinggi__untuk_, _cgi_, --, --,
   {{0x2737400b,0x00000000,0x00000000,0x00000000}},	//   _heroji__jugoslav, --, --, --,
   {{0x54444017,0x5307f00f,0x5eb68010,0x00000000}},	//   _ce_, _pulau__pinang_, _zobrazit_, --,
   {{0x23f9e013,0x3e43d00b,0x00000000,0x00000000}},	//   _situs_, _односу__на_, --, --,
   {{0xd2494003,0x2e7ad00b,0x00000000,0x00000000}},	//   _tiempo_, _граду__је_, --, --,
   {{0xc2ab3011,0xe1e29008,0x84444003,0xe4424023}},	// [1d0] _belajar__jika_, _जेकरा_, _fe_, _num_,
   {{0x5be16009,0x42f1c01f,0x00000000,0x00000000}},	//   _navigáci, _सबेरे_, --, --,
   {{0x628cb00a,0x00000000,0x00000000,0x00000000}},	//   _abahutu_, --, --, --,
   {{0xba802018,0xb2d9e01e,0x00000000,0x00000000}},	//   _informas, _ante_, --, --,
   {{0xb444400a,0xb2d8f015,0x00000000,0x00000000}},	//   _ye_, _lager_, --, --,
   {{0xee42a00b,0xe1eb3006,0xadc5000b,0x00000000}},	//   _је__пад_, _obchodní_, _када__су_, --,
   {{0x4a4e8017,0xb53cb00b,0x749a400d,0xb316900a}},	//   _vrsta__porodica_, _на__копну_, _režirao__ga_, _amaze_,
   {{0xb4307011,0xb941f015,0x14973009,0x00000000}},	//   _mana__satu_, _kvalitet, _ktoré__sú_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x3cc41014,0x926c4013,0x00000000,0x00000000}},	//   _क्लिक__करें_, _nomor_, --, --,
   {{0x425b2006,0xe442f00b,0x00000000,0x00000000}},	//   _styl_, _tog_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x24444012,0xbaf78017,0x0490e015,0x4eb8e00b}},	//   _pe_, _rebubble, _en__god_, _ли_,
   {{0x33d1600c,0x00000000,0x00000000,0x00000000}},	//   _da__guerra_, --, --, --,
   {{0x72009017,0xf3435003,0xbc682003,0x00000000}},	//   _jajima_, _diseño_, _febrero_, --,
   {{0x22fc700a,0x8a4ee014,0x00000000,0x00000000}},	//   _kongo_, _एक__बार_, --, --,
   {{0x64444017,0xb25a0003,0x42729009,0x00000000}},	// [1e0] _te_, _chile_, _jún_, --,
   {{0xb4432003,0x00000000,0x00000000,0x00000000}},	//   _hoy_, --, --, --,
   {{0xf4444017,0xf200c017,0xf2d7b011,0x00000000}},	//   _il_, _radi_, _dipanggi_stub_, --,
   {{0xaac70006,0xa358a00a,0xe2919013,0x00000000}},	//   _zboží_, _umugore_, _pasal_, --,
   {{0xda3d9008,0x626c5012,0x00000000,0x00000000}},	//   _दाई_, _belo_, --, --,
   {{0xee42600b,0x00000000,0x00000000,0x00000000}},	//   _је__да_, --, --, --,
   {{0x93945015,0x00000000,0x00000000,0x00000000}},	//   _dels_, --, --, --,
   {{0xebc0a014,0x7a4c0014,0xb994c009,0x34af6009}},	//   _करने__के_, _के__रूप_, _môže_, _že__sa_,
   {{0xa2fc700a,0x1d1a5009,0xe3949013,0x5320c006}},	//   _congo_, _ďalšie_, _sukses_, _tady_,
   {{0x82c9200c,0x00000000,0x00000000,0x00000000}},	//   _para__unha_, --, --, --,
   {{0xabd5c00c,0xd3049011,0xae1ff02c,0x00000000}},	//   _tamén__bibliogr, _atau__mana_, _após_, --,
   {{0xf351900f,0x928d6005,0x00000000,0x00000000}},	//   _anda__hanya_, _ibukota_, --, --,
   {{0x2309d011,0x00000000,0x00000000,0x00000000}},	//   _sama__anda_, --, --, --,
   {{0x9bb93014,0x76f9301f,0x32267013,0x6e787006}},	//   _हैं__कि_, _भोला_, _berkas_, _pojištěn,
   {{0x7291600a,0x00000000,0x00000000,0x00000000}},	//   _magana_, --, --, --,
   {{0xb4444003,0x5997702e,0x42d9e018,0xf2d91012}},	//   _el_, _प्रशिक्ष, _lite_, _fazer_,
   {{0xe2e9c00c,0x00000000,0x00000000,0x00000000}},	// [1f0] _as__dúas_, --, --, --,
   {{0x6e834009,0x79e0e003,0x71d96008,0x00000000}},	//   _spoločno, _distingu, _दोसर_, --,
   {{0xf326d01d,0x63f9b017,0x00000000,0x00000000}},	//   _berkenaa_dengan_, _izvuci_, --, --,
   {{0x726c5017,0xe48f6015,0x926c1006,0x1be72014}},	//   _selo_, _de__er_, _mohou_, _और__एक_,
   {{0x34425012,0x426c5023,0x44a0100f,0x329c100b}},	//   _sul_, _pelo_, _rencana__ini_, _броју__становни,
   {{0xa31e900f,0x00000000,0x00000000,0x00000000}},	//   _biasa__yang_, --, --, --,
   {{0x8300300c,0x4291100a,0x3994d009,0x00000000}},	//   _por__unha_, _gacaca_, _môžu_, --,
   {{0xea3e701f,0x00000000,0x00000000,0x00000000}},	//   _भाव_, --, --, --,
   {{0x1b88d002,0x513f7017,0x826c5009,0x00000000}},	//   _ना_, _ponedjel, _telo_, --,
   {{0xf3b4f013,0x64432003,0x00000000,0x00000000}},	//   _bagian__selatan_, _soy_, --, --,
   {{0x1494500b,0xf81c800b,0xe23d900c,0x00000000}},	//   _visini__od_, _слика__слика_, _unha__serie_, --,
   {{0x2eed400b,0x5e99000b,0x634c7009,0x00000000}},	//   _насељено_је_, _килограм_космос_, _povedal_, --,
   {{0x39f34009,0xfeb7d012,0x00000000,0x00000000}},	//   _spoločen, _possível_, --, --,
   {{0xb472e01e,0xb4b65018,0x1f072012,0x00000000}},	//   _que__el_, _etter__at_, _disponív, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x5bc3501c,0xc313f00f,0x00000000,0x00000000}},	// [200] _कभी_, _rencana_, --, --,
   {{0xc4427024,0xec4e0008,0x92d8f018,0xc27e900a}},	//   _kun_, _काहे_, _lage_, _imana_,
   {{0x226c7009,0x39d76018,0x82441019,0x73a3a024}},	//   _meno_, _eigentle, _cómo_, _suppe_,
   {{0x2bccc008,0xa291e009,0x1deb5012,0xc38ab015}},	//   _एगो_, _sita_, _municípi, _bør_,
   {{0xd4427003,0xb4b15012,0x00000000,0x00000000}},	//   _lun_, _descriçã, --, --,
   {{0xd2e9c00c,0x6444400a,0xa3961006,0xb7764006}},	//   _as__súas_, _kw_, _napsal_, _zkušenos,
   {{0xe2d9e018,0x3e42600b,0x563fa00b,0xb273300b}},	//   _vite_, _је__на_, _je__geometri, _centraln_godine_,
   {{0x4f5de011,0xce834006,0x8444400a,0x23e1100c}},	//   _bahasa__inggeris_, _společno, _mw_, _de__dous_,
   {{0x92003013,0xb9f4300c,0x00000000,0x00000000}},	//   _pemilu_, _tamén_, --, --,
   {{0x93ea701e,0x00000000,0x00000000,0x00000000}},	//   _santa_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x5618601b,0xc4ab2018,0x00000000,0x00000000}},	//   _naslovni, _kan__bli_, --, --,
   {{0xe496e006,0xc37e200c,0xd3874006,0x00000000}},	//   _se__na_, _de__imaxes_, _kterou_, --,
   {{0xd444400a,0x00000000,0x00000000,0x00000000}},	//   _bw_, --, --, --,
   {{0x73c3201d,0x93eb9019,0x54746015,0x00000000}},	//   _adalah__seperti_, _gusta_, _som__om_, --,
   {{0xfb1bf011,0x00000000,0x00000000,0x00000000}},	//   _rencana__lanjutan_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [210] --, --, --, --,
   {{0x6492602f,0x7355d018,0x2e9ca00b,0x4225e017}},	//   _en__de_, _nyheter_, _астероид_је_, _netko_,
   {{0x825b7013,0x1721801f,0xf316900a,0xd3959012}},	//   _italia_, _बाड़ी_, _amazi_, _dessa_,
   {{0x52366009,0x0bd97014,0x93f2f018,0x00000000}},	//   _svoju_, _गया__है_, _deg__selv_, --,
   {{0xd30c6017,0x3af22009,0x12be9009,0x00000000}},	//   _naciljaj, _prihlási, _zatiaľ_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6a3c9016,0xba22d00c,0x42ac600b,0x00000000}},	//   _लेख_, _que__tamén_, _prvo__kolo_, --,
   {{0xc472d018,0x00000000,0x00000000,0x00000000}},	//   _skrevet__av_, --, --, --,
   {{0x3201100a,0x5053c00b,0x4163c00b,0xcf732006}},	//   _kazi_, _године_, _година_, _na__vašem_,
   {{0x6b8fe014,0xe9a5f009,0xfde5f009,0x00000000}},	//   _थे_, _diskusia_, _diskusie_, --,
   {{0x42d9100a,0x026c2009,0xb0458009,0x756fd015}},	//   _maze_, _rokov_, _vyhraden, _for__eksempel_,
   {{0xd444400a,0x00000000,0x00000000,0x00000000}},	//   _rw_, --, --, --,
   {{0x1248d006,0x825a9003,0x5d4fb006,0x5eeda00b}},	//   _jsem_, _cual_, _včetně_, _орбиту__око_,
   {{0xf3028007,0xbd09c005,0x53eab00a,0x6f207005}},	//   _sampai__dengan_, _sekretar, _ndetse_, _mendukun,
   {{0x26f8a014,0x00000000,0x00000000,0x00000000}},	//   _होगा_, --, --, --,
   {{0x229fe012,0x5e8fe012,0xbe82e009,0x00000000}},	//   _projeto_, _projetos_, _bývanie_, --,
   {{0x8291100a,0x025aa011,0x68b7400b,0x00000000}},	// [220] _baza_, _majlis_, _са__додатим_, --,
   {{0xf444400a,0xae73200b,0xd2912003,0x14b47019}},	//   _tw_, _без_, _haya_, _relacion_con_,
   {{0x0444400a,0x3a33f008,0x326c4025,0x29e70014}},	//   _uw_, _जवन_, _domov_, _घण्टे_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x5b8d001f,0xb2e2a011,0x2617c014,0x00000000}},	//   _छल_, _seramai__orang_, _है__क्योंकि_, --,
   {{0x1ebdc006,0x2972a017,0x00000000,0x00000000}},	//   _hodnocen, _ispitajt, --, --,
   {{0xddfc2017,0xd4bf900c,0x00000000,0x00000000}},	//   _sastavu__općine_, _parroqui_que_, --, --,
   {{0xc4429012,0x82d9a018,0x1a5eb015,0x00000000}},	//   _rua_, _adwords_, _kan__også_, --,
   {{0xd4429012,0xec072011,0x00000000,0x00000000}},	//   _sua_, _konsert_, --, --,
   {{0xb26ca009,0x00000000,0x00000000,0x00000000}},	//   _lebo_, --, --, --,
   {{0x93f9e006,0x7380d007,0x625a9012,0x63ca0011}},	//   _datum_, _luas__wilayah_, _qual_, _pada__ogos_,
   {{0xd26ca006,0x00000000,0x00000000,0x00000000}},	//   _nebo_, --, --, --,
   {{0x0fa3c01e,0x03ea0011,0xa2a2400c,0x00000000}},	//   _superior_, _iaitu_, _que__aínda_, --,
   {{0xc75de00a,0x00000000,0x00000000,0x00000000}},	//   _bizimung, --, --, --,
   {{0x72da5013,0x4231700f,0x00000000,0x00000000}},	// [230] _materi_, _bermula_, --, --,
   {{0x429c700b,0x3386d009,0x00000000,0x00000000}},	//   _drugo__kolo_, _ktorej_, --, --,
   {{0xb4926003,0x00000000,0x00000000,0x00000000}},	//   _en__el_, --, --, --,
   {{0x62d80008,0x6379a005,0x00000000,0x00000000}},	//   _रहनी_, _layanan_, --, --,
   {{0x6a3c5013,0xc2c6b01b,0xbb55b00b,0x00000000}},	//   _आता_, _mislite_, _opština__severois, --,
   {{0x52fd7003,0x00000000,0x00000000,0x00000000}},	//   _imagen_, --, --, --,
   {{0x09645010,0xc20ce011,0x00000000,0x00000000}},	//   _fotogale, _tujuan__kami_, --, --,
   {{0x6ac77006,0xfbbb0014,0xe2de3008,0x00000000}},	//   _další_, _बहुत__से_, _चाही_, --,
   {{0x6321400b,0x00000000,0x00000000,0x00000000}},	//   _насељено__мјесто_, --, --, --,
   {{0x06bec00b,0xa2e20003,0x0f3f8017,0xddae3011}},	//   _naselje__opština_, _calidad_, _ulogiran, _mengikut_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x227ff009,0x00000000,0x00000000,0x00000000}},	//   _zoznam_, --, --, --,
   {{0x227e7024,0x1f13100b,0x00000000,0x00000000}},	//   _henne_, _opština__južnoj_, --, --,
   {{0xd2da700c,0x1bf71014,0x00000000,0x00000000}},	//   _da__illa_, _में__एक_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x024ba030,0x6cd3600b,0x00000000,0x00000000}},	//   _श्रेणी_, _просјечн_густина_, --, --,
   {{0x03ea0013,0x00000000,0x00000000,0x00000000}},	// [240] _yaitu_, --, --, --,
   {{0x2ebf600b,0x6457d020,0x00000000,0x00000000}},	//   _мјесту__је_, _popisu__iz_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6ea17015,0x8e1c900a,0x00000000,0x00000000}},	//   _resultat_, _interaha, --, --,
   {{0xc3959012,0x494b6027,0x00000000,0x00000000}},	//   _nossa_, _minorite, --, --,
   {{0xf469f009,0x00000000,0x00000000,0x00000000}},	//   _aby__ste_, --, --, --,
   {{0x527e900a,0x00000000,0x00000000,0x00000000}},	//   _mwana_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf3f8900a,0x00000000,0x00000000,0x00000000}},	//   _inkuru_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xab882014,0x8274b005,0xd4438021,0xc2ed800c}},	//   _नए_, _tidak__memiliki_, _mor_, _coñecido__como_,
   {{0x32fba011,0x00000000,0x00000000,0x00000000}},	//   _sebelum__memasuki_, --, --, --,
   {{0xa27e900a,0x3c48d008,0x74424012,0x430c9017}},	//   _bwana_, _होके_, _mim_, _pomicanj,
   {{0x647cf00c,0x00000000,0x00000000,0x00000000}},	//   _provinci_de_, --, --, --,
   {{0x13781017,0x42d8d014,0x00000000,0x00000000}},	//   _zabavna_, _होगी_, --, --,
   {{0x02d9a024,0x34b6b00b,0x0200d00f,0x00000000}},	//   _typen_, _pojedina_sa_, _beliau_, --,
   {{0x476ba00b,0x91bed008,0x7205b00a,0x00000000}},	// [250] _na__srednjoj_, _चुकल_, _politiki_, --,
   {{0x4c48d008,0x32d8d008,0x34438012,0x00000000}},	//   _होखे_, _होखी_, _cor_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xd442c018,0x52df000c,0x00000000,0x00000000}},	//   _aud_, _en__finado_, --, --,
   {{0xf4426012,0xb21c300b,0x00000000,0x00000000}},	//   _ano_, _učesnik__godine_, --, --,
   {{0x612d000b,0x04424012,0x0685a00b,0x00000000}},	//   _март_, _fim_, _na__vikipedi, --,
   {{0x6bab8014,0x00000000,0x00000000,0x00000000}},	//   _कि__वह_, --, --, --,
   {{0x13dfd015,0x00000000,0x00000000,0x00000000}},	//   _de__fleste_, --, --, --,
   {{0xc4439003,0x82711005,0xbb617009,0x00000000}},	//   _los_, _mulai__dari_, _bystrica_, --,
   {{0xcc4e8031,0x3442c015,0x00000000,0x00000000}},	//   _जाते_, _gud_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x194f7018,0x00000000,0x00000000,0x00000000}},	//   _demokrat, --, --, --,
   {{0x14439012,0x63eb9015,0xa290f011,0x00000000}},	//   _aos_, _viste_, _sahaja_, --,
   {{0x13c47015,0xa2b9201f,0x00000000,0x00000000}},	//   _som__helst_, _मीनू_, --, --,
   {{0x923b1009,0x00000000,0x00000000,0x00000000}},	//   _máj_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [260] --, --, --, --,
   {{0xd4424012,0xa2c1c00c,0x83541009,0x6442000a}},	//   _sim_, _coa__súa_, _všetky_, _iri_,
   {{0xf7e7a008,0x53f99013,0xc4b0200c,0xe492a015}},	//   _पुखराज_, _kasus_, _non__hai_, _du__ser_,
   {{0x7b882014,0x4f9b700b,0x00000000,0x00000000}},	//   _ने_, _су__насељено_, --, --,
   {{0xf2b8300c,0x00000000,0x00000000,0x00000000}},	//   _da__época_, --, --, --,
   {{0x10eec01f,0xd2905006,0x10b1c00b,0xf2005006}},	//   _गाँव_, _byla_, _станиште__врсте_, _byli_,
   {{0x52858009,0x42bb7009,0x9e438012,0x43960012}},	//   _na__svoje_, _na__celom_, _atualiza, _nossos_,
   {{0x2442d003,0x2ebbc00b,0x00000000,0x00000000}},	//   _fue_, _како__је_, --, --,
   {{0x2ec8600b,0x00000000,0x00000000,0x00000000}},	//   _то__је_, --, --, --,
   {{0x13ee500b,0x00000000,0x00000000,0x00000000}},	//   _sa__objašnje, --, --, --,
   {{0xe442000a,0x91b1400b,0x00000000,0x00000000}},	//   _ari_, _је__такође_, --, --,
   {{0x3442601e,0xaf1bf006,0x72890007,0x00000000}},	//   _uno_, _stát_, _departem, --,
   {{0xbb5ed01f,0x7438a00c,0x3318a00c,0x00000000}},	//   _कारन_, _en__canto_, _en__cando_, --,
   {{0x0bc6e014,0x00000000,0x00000000,0x00000000}},	//   _होता__है_, --, --, --,
   {{0x1f945006,0x1201b009,0x00000000,0x00000000}},	//   _jméno_, _neviem_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x54874006,0x22ab7018,0x00000000,0x00000000}},	// [270] _नेपाली_, _melding_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc4906018,0x00000000,0x00000000,0x00000000}},	//   _ha__en_, --, --, --,
   {{0xac506015,0xa291000a,0x00000000,0x00000000}},	//   _du__ønsker_, _kibazo_, --, --,
   {{0x1a3e2008,0x4a3dc01f,0x00000000,0x00000000}},	//   _माई_, _सेर_, --, --,
   {{0x416af006,0xb8eaf006,0x00000000,0x00000000}},	//   _nabídka_, _nabídky_, --, --,
   {{0x64429006,0x442ca007,0x6386d024,0xd442600b}},	//   _ona_, _nomor__tahun_, _hvert_, _bio_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xe4425015,0x92fd5003,0x86f1f012,0xa35e1020}},	//   _til_, _juegos_, _portuguê, _beograd_,
   {{0xc46be006,0x00000000,0x00000000,0x00000000}},	//   _jak__je_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xd4420009,0x4547900b,0x2e72e00b,0x400e2012}},	//   _pri_, _poznato__prirodno_, _је_, _eletrôni,
   {{0x2e56e00b,0x3dbda012,0x8d1e200a,0x00000000}},	//   _из_, _cadastre_, _jenoside_, --,
   {{0x02c5400b,0x2f3dd00b,0x00000000,0x00000000}},	//   _opštine__iznosi_, _све__до_, --, --,
   {{0x540ab007,0xb27e600b,0x00000000,0x00000000}},	//   _mengatak_bahwa_, _severnoj__godine_, --, --,
   {{0x14420009,0x00000000,0x00000000,0x00000000}},	//   _tri_, --, --, --,
   {{0x2442000a,0xa3860023,0x3a3df01f,0x00000000}},	// [280] _uri_, _feira_, _देस_, --,
   {{0x42d98009,0x00000000,0x00000000,0x00000000}},	//   _okrem_, --, --, --,
   {{0x84ba500f,0xe5b3f006,0x59e19015,0xc2ca700a}},	//   _kami__di_, _nejlepší_, _mange__menneske, _bandi_,
   {{0xf26cf017,0x1241d014,0x00000000,0x00000000}},	//   _nego_, _हवाले_, --, --,
   {{0xd4426023,0xd466d00b,0x0cde8015,0xa248f01d}},	//   _rio_, _naselje__ma_, _det__første_, _rahman_,
   {{0x12cb2011,0xa394d012,0x00000000,0x00000000}},	//   _sila__lihat_, _eles_, --, --,
   {{0xcb8e6032,0xb46ed00b,0x00000000,0x00000000}},	//   _आव_, _време_, --, --,
   {{0x759e8002,0x83dc400a,0x00000000,0x00000000}},	//   _चाहत_, _kimwe_, --, --,
   {{0x62ca7027,0x059c6011,0xe2d9800a,0x8443c025}},	//   _bind_, _tujuan__mewujudk, _kare_, _stv_,
   {{0x93eb9018,0x00000000,0x00000000,0x00000000}},	//   _mista_, --, --, --,
   {{0xc48f601e,0x8224000a,0x326cf012,0x6e264011}},	//   _de__la_, _ariko_, _jogos_, _penyelia__terdapat_,
   {{0x04427018,0xe4d6f002,0xd2ca7007,0x82a0501e}},	//   _ein_, _मुखिया_, _candi_, _futbol_,
   {{0xe48f600c,0x64b8502c,0xdc58500c,0x00000000}},	//   _de__na_, _mecanism_de_, _na__tempada_, --,
   {{0xdf1b901b,0x71f1a00b,0x2188200b,0x8fd8c006}},	//   _miša_, _насељено__место_, _три__пописа_, _návštěvn,
   {{0x52bac006,0xd212e012,0x00000000,0x00000000}},	//   _něco_, _nenhum_, --, --,
   {{0xc4429003,0x546be006,0x83959012,0x00000000}},	//   _una_, _jak__se_, _fosse_, --,
   {{0x6201800a,0xc48d300b,0x63b0d003,0x00000000}},	// [290] _bari_, _primećen__je_, _aunque_, --,
   {{0xf488400b,0x00000000,0x00000000,0x00000000}},	//   _је__према_, --, --, --,
   {{0xc2259013,0x00000000,0x00000000,0x00000000}},	//   _meski_, --, --, --,
   {{0xd268d011,0xe443c015,0x15851006,0xa3c37023}},	//   _dalam__talian_, _lov_, _nemůžete_, _que__eles_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x0443c003,0xc201900a,0xdc754002,0xb984000a}},	//   _nov_, _hasi_, _तृप्ति_, _ibikorwa_,
   {{0xa3c0f00c,0x00000000,0x00000000,0x00000000}},	//   _entre__eles_, --, --, --,
   {{0xe4427024,0x69fd3023,0x00000000,0x00000000}},	//   _sin_, _pagament, --, --,
   {{0x9443e018,0x04b9e00c,0xd201800a,0xf498800c}},	//   _ett_, _dirixido__por_, _yari_, _un__ano_,
   {{0x9c5df00b,0x00000000,0x00000000,0x00000000}},	//   _prosječn_gustina_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x14426009,0x00000000,0x00000000,0x00000000}},	//   _čo_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xdc665017,0x998aa006,0x9a3e001f,0x00000000}},	//   _lopticu_, _době_, _मटर_, --,
   {{0xaa3d4014,0x6f8bf012,0x348f6009,0xe2267018}},	//   _लिए_, _até_, _ak__sa_, _bruker_,
   {{0xf35a8005,0x72019003,0x00000000,0x00000000}},	//   _dikenal__dengan_, _casi_, --, --,
   {{0xd2bc9011,0x00000000,0x00000000,0x00000000}},	// [2a0] _ini__kerana_, --, --, --,
   {{0x86128006,0x447b900c,0x00000000,0x00000000}},	//   _příspěvk, _historia__da_, --, --,
   {{0x226c001b,0x00000000,0x00000000,0x00000000}},	//   _htio_, --, --, --,
   {{0x4499b00c,0xb201800a,0x00000000,0x00000000}},	//   _un__dos_, _wari_, --, --,
   {{0x9467301d,0x929e3007,0x94579011,0x3a3dc008}},	//   _apa__apa_, _sumber__daya_, _rencana__baru_, _सेठ_,
   {{0x34432003,0xbb88701c,0x1c480008,0x02d80008}},	//   _muy_, _ये_, _रहले_, _रहली_,
   {{0xb289f00c,0xf2d9a009,0x00000000,0x00000000}},	//   _seu__fillo_, _mape_, --, --,
   {{0xa43b000b,0x72caf00b,0x00000000,0x00000000}},	//   _stanište__vrste_, _nato__oznaka_, --, --,
   {{0x67cc6015,0x02d89024,0xccf2e017,0xc2d99005}},	//   _personli, _enkelt_, _popis__pjesama_, _akses_,
   {{0x821d7007,0x00000000,0x00000000,0x00000000}},	//   _menjadi__bagian_, --, --, --,
   {{0xe47dd033,0xe2fca013,0x6471e00c,0x00000000}},	//   _skal__du_, _serikat_, _decembro__de_, --,
   {{0xd3ce102c,0xa6f82008,0x00000000,0x00000000}},	//   _no__entanto_, _रउवा_, --, --,
   {{0xace8c011,0x00000000,0x00000000,0x00000000}},	//   _kumpulan__pemuzik_, --, --, --,
   {{0x1be6a014,0xb6503003,0x00000000,0x00000000}},	//   _से__एक_, _ubicació, --, --,
   {{0xe443e018,0x06405018,0x00000000,0x00000000}},	//   _mot_, _optimali, --, --,
   {{0x638b5018,0xd17f501e,0xefd71006,0x00000000}},	//   _vår_, _desarrol, _protože_, --,
   {{0xc4b7600d,0xdda47010,0x00000000,0x00000000}},	// [2b0] _vrsta__je_, _reagovat_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x7231b007,0x0a63e014,0xb4a90005,0xada6600b}},	//   _rumah__sakit_, _वास्तव__में_, _nasional_, _што__су_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x0ef2f00c,0xc3ea700a,0xfcd4b014,0x00000000}},	//   _que__teñen_, _bantu_, _पर__निर्भर_, --,
   {{0xb242d014,0x00000000,0x00000000,0x00000000}},	//   _पिछले_, --, --, --,
   {{0x2442d00a,0xd498f00c,0x00000000,0x00000000}},	//   _ine_, _un__que_, --, --,
   {{0x04930015,0x5a3e2008,0x00000000,0x00000000}},	//   _er__det_, _नेह_, --, --,
   {{0x56f82008,0xba331008,0x00000000,0x00000000}},	//   _रउरा_, _चलल_, --, --,
   {{0x3442b004,0xa9827006,0xab1e7012,0x72afd008}},	//   _nic_, _možnost_, _pesquisa_, _इहाँ_,
   {{0x0c588014,0x04740015,0x6a3df01f,0x00000000}},	//   _के__बारे_, _som__det_, _देब_, --,
   {{0x685bb00b,0x3b5e1008,0x584bb00b,0x00000000}},	//   _се__налази_, _गइलन_, _се__налазе_, --,
   {{0x8324c00a,0x62f45013,0x0bc44014,0x9bede007}},	//   _habyarim, _standar_, _जाती__है_, _diperkir,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xae47e009,0xe833600b,0x00000000,0x00000000}},	// [2c0] _spravoda, _opština__zapadnoj_, --, --,
   {{0xa735d014,0x7202100d,0x00000000,0x00000000}},	//   _पर__क्लिक_, _popisu_, --, --,
   {{0xdb8c901a,0x04958015,0xfc567014,0x00000000}},	//   _ऑफ_, _på__det_, _खबरें_, --,
   {{0x97e2000c,0x781ee00b,0x2497a015,0x9f207005}},	//   _unha__parroqui, _slatkovo_područja_, _vi__kan_, _pendukun,
   {{0xd442d006,0x00000000,0x00000000,0x00000000}},	//   _dne_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x8f69700b,0x00000000,0x00000000,0x00000000}},	//   _самом__мјесту_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x44aa9011,0x02922011,0x00000000,0x00000000}},	//   _sebab__ini_, _secara__rasmi_, --, --,
   {{0xd2d8901b,0x23094011,0xed9c0009,0x00000000}},	//   _dijete_, _anda__saje_, _odpoveda, --,
   {{0xc27fc00c,0x8063000b,0x00000000,0x00000000}},	//   _moito__máis_, _je__učestvov, --, --,
   {{0x53fa100c,0xaf38d01b,0xe4a3f018,0x00000000}},	//   _un__grupo_, _gađanje_, _tilgang__til_, --,
   {{0xc3940012,0x00000000,0x00000000,0x00000000}},	//   _dois_, --, --, --,
   {{0x3410d011,0x00000000,0x00000000,0x00000000}},	//   _tentera__laut_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6bcd000c,0x4e63200d,0x00000000,0x00000000}},	//   _artigos__ligazóns_, _je__pojedina, --, --,
   {{0x8205a007,0xc3f48015,0x4c6bf01f,0xa499e006}},	// [2d0] _memiliki_, _kan__være_, _जिम्मे_, _to__co_,
   {{0x4443f012,0x1b8c901f,0x00000000,0x00000000}},	//   _sou_, _गो_, --, --,
   {{0xc3566007,0x73a3f00b,0x00000000,0x00000000}},	//   _sebesar_, _grupa_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xea3df034,0xf356a011,0x7443f012,0x92027013}},	//   _देत_, _telah__dicipta_, _vou_, _fisika_,
   {{0xb24e500b,0xb3434005,0xd2d34011,0x2d0f0014}},	//   _do__godine_, _dikenal_, _dikenali_, _इस__प्रकार_,
   {{0xf491f009,0x00000000,0x00000000,0x00000000}},	//   _by__ste_, --, --, --,
   {{0x82aff035,0x00000000,0x00000000,0x00000000}},	//   _उहाँ_, --, --, --,
   {{0x220cb007,0xf37f800b,0x00000000,0x00000000}},	//   _kurang__lebih_, _jugoslav_mladost_, --, --,
   {{0x82f99006,0xb9ab1017,0xf4b1a033,0x00000000}},	//   _přidat_, _nedjelja_, _til__din_, --,
   {{0xfc27a003,0x83940012,0x00000000,0x00000000}},	//   _artículo_, _pois_, --, --,
   {{0x44b57013,0x64b7e00c,0x04b38015,0x00000000}},	//   _keluraha_ini_, _preto__de_, _var__det_, --,
   {{0xec89900b,0x1366700a,0x00000000,0x00000000}},	//   _на__пример_, _itegeko_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xda3e3008,0xf291d00a,0x00000000,0x00000000}},	//   _फेर_, _kawa_, --, --,
   {{0x4442d009,0x00000000,0x00000000,0x00000000}},	//   _nie_, --, --, --,
   {{0x2a128015,0x5394e00a,0xf4ac1015,0x00000000}},	// [2e0] _på__internet, _benshi_, _kan__jeg_, --,
   {{0x3a33b01f,0xa2d8900e,0x00000000,0x00000000}},	//   _अपन_, _tijelo_, --, --,
   {{0x12d99012,0x02919012,0x00000000,0x00000000}},	//   _esse_, _essa_, --, --,
   {{0x32d9d00a,0x00000000,0x00000000,0x00000000}},	//   _nawe_, --, --, --,
   {{0x59c1400b,0xc0536012,0x0bdf5027,0x0499e018}},	//   _је__живело_, _mensagen, _kalender, _ut__som_,
   {{0x0b8cb016,0x2f21b00b,0x00000000,0x00000000}},	//   _को_, _godine__opštini_, --, --,
   {{0x326c200a,0x7348a01b,0x526c800a,0x22d8f011}},	//   _koko_, _nebeski_, _gukora_, _hehehe_,
   {{0x04426006,0x00000000,0x00000000,0x00000000}},	//   _pro_, --, --, --,
   {{0xa442c015,0x162fa018,0x52d9c027,0x63437015}},	//   _tid_, _etnograf, _pave_, _for__alle_,
   {{0x97f0000c,0x0d1b0017,0x64a9200c,0x1249f00a}},	//   _da__parroqui, _obiteljs_kućansta, _despois__de_, _nyuma_,
   {{0x3279800b,0xf236c007,0x19e6e018,0xebcf900b}},	//   _густина__становни, _produksi_, _korrektu, _је__имао_,
   {{0x92787006,0xd469e00b,0x64bb5023,0x00000000}},	//   _první_, _gde__su_, _mais__de_, --,
   {{0x2ed5200b,0x00000000,0x00000000,0x00000000}},	//   _под_, --, --, --,
   {{0x22be6008,0x5d49200b,0x22ae6008,0x022f701d}},	//   _केहू_, _при_, _केहु_, _itu__beliau_,
   {{0xe2d9d00a,0x00000000,0x00000000,0x00000000}},	//   _yawe_, --, --, --,
   {{0x33869015,0x322b0015,0xdc4e801f,0xc49be018}},	//   _klare_, _kommune_, _जाके_, _ut__av_,
   {{0xf4444015,0x9cd0b00b,0xf2908015,0xe2eac00c}},	// [2f0] _et_, _stanovni_gustina_, _lokale_, _en__dúas_,
   {{0x6394f013,0xdd699012,0x5cee300b,0x00000000}},	//   _kaisar_, _acessóri, _пред_, --,
   {{0xc498e00c,0xf26d601b,0x00000000,0x00000000}},	//   _ou__en_, _pogodi_, --, --,
   {{0xf2bb1006,0xfa3e5008,0x2d6e100b,0x00000000}},	//   _galerie_, _भइल_, _се__може_, --,
   {{0xc442d009,0x7201e00a,0x5345400d,0x15b01017}},	//   _vie_, _bati_, _naselje_, _granatom_,
   {{0xc4b13017,0x132b600c,0x00000000,0x00000000}},	//   _također__je_, _se__poden_, --, --,
   {{0x4a3d902a,0xa442d025,0xa2bc400b,0x00000000}},	//   _दिए_, _tie_, _planete__zemlje_, --,
   {{0xc02e2019,0x00000000,0x00000000,0x00000000}},	//   _condicio, --, --, --,
   {{0x86ff5008,0xb46ae009,0x00000000,0x00000000}},	//   _जाला_, _ako__to_, --, --,
   {{0xa4651011,0xc2d9d00a,0x2eecd00b,0x00000000}},	//   _daripada__semua_, _wawe_, _ово__је_, --,
   {{0x52ca700a,0xa3959012,0xa0189006,0x00000000}},	//   _kandi_, _nosso_, _přísluše, --,
   {{0xb4429018,0x17a09006,0x00000000,0x00000000}},	//   _bra_, _podmínky_, --, --,
   {{0x2ed4e00b,0xf2fcd003,0x00000000,0x00000000}},	//   _до_, _juego_, --, --,
   {{0xb9ffc00c,0x22018015,0xd4429018,0x12d8b006}},	//   _véxase__tamén_, _skriv_, _dra_, _akce_,
   {{0xc2da6013,0x294e1017,0x12fcd003,0x03273018}},	//   _karena_, _prolazit, _luego_, _av__robert_,
   {{0x33436012,0xd95a4015,0x00000000,0x00000000}},	//   _governo_, _medlemme, --, --,
   {{0xcef1200b,0x00000000,0x00000000,0x00000000}},	// [300] _има_, --, --, --,
   {{0x32f2200c,0xbc4e6008,0xe2e96002,0x00000000}},	//   _ano__cando_, _कइले_, _ससुर_, --,
   {{0xf4444018,0x00000000,0x00000000,0x00000000}},	//   _ut_, --, --, --,
   {{0x8201e00e,0x6291e00e,0x6466200c,0x8a331008}},	//   _sati_, _sata_, _padrón__de_, _चलि_,
   {{0x2444400a,0x540d3013,0x3ec71003,0x0a3e501f}},	//   _ko_, _menyatak_bahwa_, _nosotros_, _भेल_,
   {{0x3394901d,0x00000000,0x00000000,0x00000000}},	//   _kuasa_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x34444003,0xb2c0b005,0x23ea100c,0x1c967014}},	//   _lo_, _didirika_pada_, _os__dous_, _क्यों_,
   {{0xc49b6009,0xb63ef00b,0x442d800f,0x00000000}},	//   _tu__je_, _mesnog__stanovni, _merupaka_tahun_, --,
   {{0x1758d002,0xa26de029,0x8fcf1009,0x7ab81006}},	//   _संग्राम_, _potom_, _stránok_, _odpověď_,
   {{0x32258018,0x00000000,0x00000000,0x00000000}},	//   _merk_, --, --, --,
   {{0x84444012,0x94429012,0xc2de0014,0xbd83901b}},	//   _ao_, _pra_, _किसी_, _trči_,
   {{0x9444400a,0xda3e6008,0x00000000,0x00000000}},	//   _bo_, _बेर_, --, --,
   {{0xc3959012,0xebb0a014,0x00000000,0x00000000}},	//   _posso_, _लोगों__के_, --, --,
   {{0xd34c8007,0xadc6500b,0x430d200f,0x00000000}},	//   _yang__berbeda_, _били__су_, _pelajar_, --,
   {{0x526d801e,0xc470a00c,0xfec3400c,0x827ef00a}},	//   _foros_, _que__hai_, _ano__seguinte_, _ibintu_,
   {{0x96f98002,0xf31b9006,0x00000000,0x00000000}},	// [310] _मनवा_, _název_, --, --,
   {{0x64936036,0x54438027,0x00000000,0x00000000}},	//   _na__de_, _bur_, --, --,
   {{0x8386c015,0x00000000,0x00000000,0x00000000}},	//   _bedre_, --, --, --,
   {{0x14444009,0x00000000,0x00000000,0x00000000}},	//   _zo_, --, --, --,
   {{0x0444400a,0xb276900b,0x64746015,0x43195018}},	//   _yo_, _septembr_godine_, _som__de_, _er__veldig_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x16fed014,0xb4439021,0xd4425003,0x00000000}},	//   _किया_, _hus_, _él_, --,
   {{0x5472e019,0xc1ed6002,0xbcb43014,0x00000000}},	//   _que__no_, _बनारस_, _आपको__अपने_, --,
   {{0x8d82600b,0x00000000,0x00000000,0x00000000}},	//   _последња__три_, --, --, --,
   {{0x659f5008,0x00000000,0x00000000,0x00000000}},	//   _जाइत_, --, --, --,
   {{0x22c5e011,0x44420012,0xcc7e6003,0x2300c011}},	//   _ayat__anda_, _pai_, _nuestro_, _terbahag_kepada_,
   {{0x5479100c,0xa365800a,0x9fd78009,0x00000000}},	//   _localiza__no_, _tangazo_, _pretože_, --,
   {{0xa4420012,0x127b7006,0xc2feb024,0xe4627018}},	//   _vai_, _komentář, _aktiver_, _tilbake__til_,
   {{0x943c9011,0x02647003,0x32926013,0x00000000}},	//   _pandai__baru_, _carlos_, _sarana_, --,
   {{0xd4444009,0x926d800a,0xb2baa00c,0x00000000}},	//   _vo_, _rero_, _unha__gran_, --,
   {{0xe444400a,0x2ed59010,0x00000000,0x00000000}},	//   _wo_, _než_, --, --,
   {{0x64438003,0x726d8003,0x82dc4005,0x145b600c}},	// [320] _sur_, _pero_, _di__dekat_, _contaba__con_,
   {{0x8bcc6008,0x3f478014,0xac617003,0x00000000}},	//   _आवे_, _और__अधिक_, _alguien_, --,
   {{0xc2258018,0x54431012,0x198b4009,0x00000000}},	//   _verk_, _diz_, _prečo_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xb26c5009,0x00000000,0x00000000,0x00000000}},	//   _bolo_, --, --, --,
   {{0x526e1009,0xa98b4009,0x00000000,0x00000000}},	//   _šport_, _niečo_, --, --,
   {{0x82487013,0x13868009,0x2f1b9009,0xe320b003}},	//   _negara__bagian_, _ktoré_, _vaša_, _precios_,
   {{0xf4422006,0xbcc87006,0x00000000,0x00000000}},	//   _jak_, _světa_, --, --,
   {{0xc27f000a,0x00000000,0x00000000,0x00000000}},	//   _abantu_, --, --, --,
   {{0x9c67800a,0x00000000,0x00000000,0x00000000}},	//   _gahunda_, --, --, --,
   {{0xc3189011,0x0c07e014,0x00000000,0x00000000}},	//   _sebuah__rencana_, _लगता__है_, --, --,
   {{0x44444037,0x54a1b006,0x0c48e002,0x00000000}},	//   _af_, _se__dá_, _सुने_, --,
   {{0x647b500b,0x00000000,0x00000000,0x00000000}},	//   _procjeni__iz_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x64439003,0xd2c3400c,0x72d9e006,0x5f25b012}},	//   _sus_, _das__súas_, _jste_, _selecion,
   {{0x8b5e3008,0x101fa012,0xb47df018,0x00000000}},	//   _कइसन_, _endereço_, _hvor__mye_, --,
   {{0x22b7f013,0x1fee0012,0xd49b500b,0xe3cef017}},	// [330] _sebesar__jiwa_, _amazonas_, _спољашње_, _živci_,
   {{0x227c500b,0xac71b027,0xbe19f007,0x00000000}},	//   _iznosi__samom_, _startet_, _menemuka, --,
   {{0xe4427018,0x74431006,0x4a3c601f,0x00000000}},	//   _én_, _viz_, _आवत_, --,
   {{0xc26c501e,0x74439003,0x925dc00b,0x87aa600c}},	//   _solo_, _tus_, _beograd__godina_, _un__político_,
   {{0xf4926018,0x00000000,0x00000000,0x00000000}},	//   _av__et_, --, --, --,
   {{0x5326e00c,0x4a027017,0xaed5600b,0x00000000}},	//   _en__galego_, _nježno_, _још_, --,
   {{0xd3947015,0x230e100f,0x00000000,0x00000000}},	//   _kunst_, _apabila_, --, --,
   {{0xc9c64012,0x00000000,0x00000000,0x00000000}},	//   _apresent, --, --, --,
   {{0x22d9e009,0x04aa6015,0x00000000,0x00000000}},	//   _este_, _det__som_, --, --,
   {{0x48578013,0xc23bc00c,0xfc754012,0x00000000}},	//   _fakultas_, _que__máis_, _algumas_, --,
   {{0xb633600b,0xc2a6602c,0x00000000,0x00000000}},	//   _stanovni, _globo_, --, --,
   {{0xb4b36037,0xfb92e009,0x00000000,0x00000000}},	//   _til__at_, _prenájom_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc5596017,0x34423025,0x445ee00c,0xc4b65018}},	//   _lješnjak, _naj_, _maioría__dos_, _grunn__av_,
   {{0x54422006,0x00000000,0x00000000,0x00000000}},	//   _pak_, --, --, --,
   {{0xa442d018,0x93104011,0x4c01b013,0xf4b36015}},	//   _ore_, _dengan__sedaya_, _agustus_, _til__et_,
   {{0xcc80200b,0x73ac6018,0xd2ae5011,0x9256100b}},	// [340] _везе_, _gruppa_, _maklumat__lanjut_, _је__присутна_,
   {{0x6442000a,0x4eb5800b,0xe5b19009,0x00000000}},	//   _isi_, _једна__од_, _technoló, --,
   {{0x94423017,0xf4902015,0x52f46005,0x00000000}},	//   _daj_, _at__han_, _dikirim_, --,
   {{0xe451d020,0xb3fa6017,0x861ca018,0x00000000}},	//   _nalazi__na_, _kirurg_, _kontroll_, --,
   {{0xc3411011,0x00000000,0x00000000,0x00000000}},	//   _semua__rencana_, --, --, --,
   {{0x6301e013,0x03eb900e,0x00000000,0x00000000}},	//   _berarti_, _zasto_, --, --,
   {{0x0a24b00c,0x00000000,0x00000000,0x00000000}},	//   _que__supón_, --, --, --,
   {{0x0c0c6014,0xb27ec00d,0x00000000,0x00000000}},	//   _जाता__है_, _jedna_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xebc10014,0x00000000,0x00000000,0x00000000}},	//   _बच्चों__के_, --, --, --,
   {{0xc2e6800c,0x00000000,0x00000000,0x00000000}},	//   _coñecida__como_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x5492600c,0x7be0a015,0x00000000,0x00000000}},	//   _en__no_, _invester, --, --,
   {{0xe98a6006,0x00000000,0x00000000,0x00000000}},	//   _proč_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [350] --, --, --, --,
   {{0xa7401014,0xb492600b,0x00000000,0x00000000}},	//   _किया__जाता_, _je__do_, --, --,
   {{0xa2e9a01f,0x00000000,0x00000000,0x00000000}},	//   _मसूर_, --, --, --,
   {{0x1291e01d,0xb442d009,0x42cad009,0xb2366017}},	//   _bahasa__melayu_, _pre_, _pred_, _ovoj_,
   {{0xd5f05018,0x00000000,0x00000000,0x00000000}},	//   _kommersi, --, --, --,
   {{0x89b1b012,0x7b6a7013,0x00000000,0x00000000}},	//   _atividad, _britania_, --, --,
   {{0x927e0018,0xc2ba600c,0x00000000,0x00000000}},	//   _seint_, _en__como_, --, --,
   {{0x2fcde009,0x00000000,0x00000000,0x00000000}},	//   _článok_, --, --, --,
   {{0xbdb4000f,0x00000000,0x00000000,0x00000000}},	//   _sebuah__ensiklop, --, --, --,
   {{0x3ba58014,0xf333a00c,0x00000000,0x00000000}},	//   _है__जो_, _da__rexión_, --, --,
   {{0x5a3cc002,0x00000000,0x00000000,0x00000000}},	//   _एकर_, --, --, --,
   {{0x1dbe400b,0x0bb98014,0x00000000,0x00000000}},	//   _popisa__primećen_, _आवश्यकता__है_, --, --,
   {{0x5ade1011,0x6fe79006,0x00000000,0x00000000}},	//   _satu__penyelia_, _svůj_, --, --,
   {{0x4e9bd017,0x42cb4006,0x8f07e013,0x00000000}},	//   _sakupite_, _hledat_, _berbasis_, --,
   {{0x34425009,0x12d41009,0x23ef4017,0x1c5f4017}},	//   _mal_, _ľudí_, _obitelji_, _obitelj_,
   {{0x92003017,0x1c4e6008,0xc47ed00c,0x00000000}},	//   _uzmite_, _कइसे_, _hoxe__en_, --,
   {{0x82016013,0xf03de012,0xffd94012,0x5b599008}},	// [360] _bagian_, _anúncio_, _opção_, _नीमन_,
   {{0xd471f00c,0x00000000,0x00000000,0x00000000}},	//   _nos__que_, --, --, --,
   {{0x82c0300c,0x00000000,0x00000000,0x00000000}},	//   _no__caso_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x0bffc014,0xf26d000e,0xc4b6e018,0x00000000}},	//   _होती__है_, _subota_, _løpet__av_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x46322004,0x53eac018,0xf2366009,0x9c79b00b}},	//   _सम्बन्धि, _alltid_, _svoj_, _bio__gustina_,
   {{0x701b9038,0x6b8e4016,0x42926027,0x40598008}},	//   _प्रत्येक_, _आप_, _totalt_, _बरिस_,
   {{0xd34b500f,0xb3bb5007,0x12bbf017,0xcc5d6012}},	//   _juga__dikenali_, _juga__dikenal_, _studeni_, _gestão_,
   {{0x998ab009,0x00000000,0x00000000,0x00000000}},	//   _podľa_, --, --, --,
   {{0x2442000a,0xae61200b,0x4320e013,0xf394f003}},	//   _azi_, _где_, _sinyal_, _crisis_,
   {{0x82d0600c,0x00000000,0x00000000,0x00000000}},	//   _supón__unha_, --, --, --,
   {{0xe386c018,0x00000000,0x00000000,0x00000000}},	//   _aldri_, --, --, --,
   {{0x419e300b,0x6ba20006,0x00000000,0x00000000}},	//   _последњи_година_, _případě_, --, --,
   {{0xdc49e028,0x00000000,0x00000000,0x00000000}},	//   _पैसे_, --, --, --,
   {{0x3a3c4008,0x825ab021,0x426de025,0x00000000}},	//   _आपन_, _medlem_, _leto_, --,
   {{0xa3b75011,0x646ce00c,0x00000000,0x00000000}},	// [370] _menambah__koleksi_, _foi__de_, --, --,
   {{0x9435200c,0x34a1f015,0x00000000,0x00000000}},	//   _de__feito_, _se__på_, --, --,
   {{0x47154012,0x00000000,0x00000000,0x00000000}},	//   _seguranç, --, --, --,
   {{0x54426012,0x5224d00b,0x00000000,0x00000000}},	//   _nao_, _preko_, --, --,
   {{0xee40500b,0x00000000,0x00000000,0x00000000}},	//   _почео__да_, --, --, --,
   {{0x02eaa00b,0x4394700a,0x1ed64003,0x9b58d008}},	//   _stanovni_iznosi_, _munsi_, _mientras_, _रहलन_,
   {{0x4ab2a014,0xb435200c,0x00000000,0x00000000}},	//   _की__आवश्यकता_, _de__xeito_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x0c66e014,0xe7ee3024,0x00000000,0x00000000}},	//   _है__जिसे_, _betaling, --, --,
   {{0x7e8a9010,0x8a3ee01c,0x8a75c012,0x00000000}},	//   _प्रतिशत_, _फिर_, _ações_, --,
   {{0x06f9d008,0x647d300c,0x3394b00e,0x931b9009}},	//   _बीरा_, _externas__de_, _pjesme_, _názov_,
   {{0xec48d002,0x5699800f,0xb273500b,0x4210d01b}},	//   _रहीं_, _yang__berkuali, _mesto__godine_, _sljedeći_,
   {{0xa3317011,0x6395f012,0xe27f7004,0x00000000}},	//   _kelayaka_yang_, _meus_, _jedná_, --,
   {{0x7533600a,0x04ac8021,0x00000000,0x00000000}},	//   _emmanuel_, _med__det_, --, --,
   {{0xc2b4d009,0x00000000,0x00000000,0x00000000}},	//   _nieco_, --, --, --,
   {{0x1a437017,0x331fe017,0xc6c5f011,0x00000000}},	//   _veljača_, _nogometn_klub_, _sebahagi, --,
   {{0x6442000a,0x00000000,0x00000000,0x00000000}},	// [380] _uzi_, --, --, --,
   {{0x96554017,0x00000000,0x00000000,0x00000000}},	//   _namjesti, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xe2d02015,0x72ea000a,0x00000000,0x00000000}},	//   _på__denne_, _ingingo_, --, --,
   {{0xd395f012,0x3e93700b,0xd2ffc015,0x00000000}},	//   _deus_, _године__на_, _jeg__ikke_, --,
   {{0xa4426023,0x726cf010,0xd56ff003,0x00000000}},	//   _sao_, _tohoto_, _servicio_, --,
   {{0xc3d12009,0x73940003,0xc4b6f00c,0x00000000}},	//   _história_, _luis_, _diminuci_en_, --,
   {{0x03eb9003,0x13dc400a,0x9e5b3007,0xe685600c}},	//   _hasta_, _hamwe_, _perbedaa, _na__galipedi,
   {{0x5d1e200a,0x9eda1017,0x00000000,0x00000000}},	//   _genocide_, _pasijans_, --, --,
   {{0xaf1b9009,0x00000000,0x00000000,0x00000000}},	//   _naša_, --, --, --,
   {{0xa3869021,0x00000000,0x00000000,0x00000000}},	//   _svar_, --, --, --,
   {{0xf26cd006,0x42d9a024,0x9ce34014,0x4272500b}},	//   _budou_, _typer_, _तो__आपको_, _због__тога_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xbb80900b,0x12f1201f,0xc3949029,0x00000000}},	//   _је__насеље_, _जरुरत_, _čase_, --,
   {{0x426cb003,0xd477d00e,0xdf3bd013,0x9c53000b}},	//   _poco_, _gdje__su_, _kebutuha, _gustina_,
   {{0xf2fea00a,0x00000000,0x00000000,0x00000000}},	//   _uruhare_, --, --, --,
   {{0x3370f01d,0x7f8bf003,0xc4b9900c,0xaf875009}},	// [390] _lapangan__terbang_, _qué_, _distribu_en_, _košice_,
   {{0xc395f012,0x8d838009,0x4ae6b013,0x00000000}},	//   _seus_, _nič_, _parlemen_, --,
   {{0x32b5b00b,0xce00c00b,0x00000000,0x00000000}},	//   _износи__становни, _први__пут_, --, --,
   {{0x54439012,0xe491e015,0x8f30000b,0x336cb00f}},	//   _uns_, _at__du_, _пописа__примећен_, _kapal__terbang_,
   {{0xa9f54012,0x5091100b,0x644f1015,0x00000000}},	//   _preço_, _opština__centraln, _stedet__for_, --,
   {{0xc442600a,0x44438018,0x00000000,0x00000000}},	//   _aho_, _gir_, --, --,
   {{0xb490f009,0xd38ea006,0x00000000,0x00000000}},	//   _je__pre_, _ubytován, --, --,
   {{0x2dd0c01d,0x14adc012,0x00000000,0x00000000}},	//   _di__internet_, _serviços_, --, --,
   {{0xa4439003,0x00000000,0x00000000,0x00000000}},	//   _mis_, --, --, --,
   {{0x22cb4003,0x00000000,0x00000000,0x00000000}},	//   _pueden_, --, --, --,
   {{0xd4427003,0x00000000,0x00000000,0x00000000}},	//   _van_, --, --, --,
   {{0xc47e100c,0xe4946024,0x2eb0700b,0x00000000}},	//   _pero__non_, _må__du_, _месту__је_, --,
   {{0xcf1b9017,0x6c8e5008,0x5b3b2013,0xc6be5009}},	//   _miš_, _कौनो_, _berbatas, _súťaže_,
   {{0x5c575017,0x626c4003,0xf3e4601b,0x00000000}},	//   _loptice_, _humor_, _na__mjestu_, --,
   {{0x8efff00b,0x00000000,0x00000000,0x00000000}},	//   _maksimal_minimaln, --, --, --,
   {{0xe386a025,0x00000000,0x00000000,0x00000000}},	//   _dobre_, --, --, --,
   {{0x12a6d009,0x12c69011,0x00000000,0x00000000}},	// [3a0] _alebo_, _ensiklop_bebas_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc3870006,0xf2080009,0xd08b2006,0x5386900a}},	//   _které_, _informác, _domácí_, _ntara_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xd612101d,0xec52700a,0x00000000,0x00000000}},	//   _untuk__memudahk, _amatora_, --, --,
   {{0x12c5a017,0xf2bf5008,0x4e74e00b,0x00000000}},	//   _kuglice_, _जाईं_, _се__од_, --,
   {{0x626c200a,0xd3274015,0x0a328016,0x00000000}},	//   _kuko_, _er__ikke_, _खोज_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x3442900a,0x00000000,0x00000000,0x00000000}},	//   _saa_, --, --, --,
   {{0x83860018,0x83870006,0x04429015,0x64ad500c}},	//   _blir_, _která_, _paa_, _xaneiro__de_,
   {{0xb658000b,0x1999a006,0x69fc7018,0x00000000}},	//   _živelo__stanovni, _např_, _dette__nettsted, --,
   {{0xe23b0018,0xd7c0900b,0x03f2200b,0x926c200a}},	//   _innlegg_, _се__простире_, _je__galaksij, _nuko_,
   {{0x541f000b,0xb018300b,0x93f8800a,0xd3eb9018}},	//   _naseljen_mesto_, _je__registro, _bihugu_, _sist_,
   {{0x93947018,0x6a4b5014,0x74425018,0x00000000}},	//   _minst_, _की__तरह_, _xsl_, --,
   {{0xf53a300c,0x00000000,0x00000000,0x00000000}},	//   _foi__estreado_, --, --, --,
   {{0x34439015,0xc487701f,0x00000000,0x00000000}},	// [3b0] _vis_, _मिलावट_, --, --,
   {{0x6be79014,0x00000000,0x00000000,0x00000000}},	//   _जब__आप_, --, --, --,
   {{0x525bf023,0xe3f8800a,0x83528014,0x630e0011}},	//   _paulo_, _gihugu_, _के__संबंध_, _telah__berjaya_,
   {{0x547d502c,0x38e0b014,0x00000000,0x00000000}},	//   _para__se_, _इस__साइट_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xeb8c9014,0x42ee6018,0x83967012,0x00000000}},	//   _गई_, _stoff_, _pessoa_, --,
   {{0x73eb8007,0x00000000,0x00000000,0x00000000}},	//   _kartu_, --, --, --,
   {{0xadc0c00b,0x426c200a,0xef32300a,0x1b99301e}},	//   _који__су_, _yuko_, _amafaran, _gobierno_,
   {{0xd491f00c,0x286d701e,0xec7d7003,0x63368018}},	//   _na__que_, _personas_, _persona_, _noen__ganger_,
   {{0x5442900a,0x04917015,0xcb5eb008,0x9258800b}},	//   _aha_, _du__vil_, _जइसन_, _su__dati_,
   {{0xa2e30015,0x54426003,0xca830015,0x5478d020}},	//   _familie_, _eso_, _familien_, _grad__se_,
   {{0x0290c024,0xe4917015,0xc473500c,0xb38f7012}},	//   _irland_, _er__til_, _cada__un_, _brasília_,
   {{0xaed4e00b,0xa2e1d008,0xca0f8006,0x00000000}},	//   _то_, _बानीं_, _následuj, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc9b14006,0xc1f7600b,0xbe714009,0x425ef017}},	//   _ostatní_, _spoljašn, _ostatné_, _je__sljedeći_,
   {{0x026cf012,0x00000000,0x00000000,0x00000000}},	//   _jogo_, --, --, --,
   {{0xabc02014,0x00000000,0x00000000,0x00000000}},	// [3c0] _होने__की_, --, --, --,
   {{0x34438004,0xebf09014,0x00000000,0x00000000}},	//   _čr_, _देखने__के_, --, --,
   {{0xd380600a,0xf4941015,0x9d0cb014,0x00000000}},	//   _uburyo_, _og__jeg_, _लिए__आपको_, --,
   {{0x3ba4e014,0x00000000,0x00000000,0x00000000}},	//   _कि__यह_, --, --, --,
   {{0x4ed2500b,0x00000000,0x00000000,0x00000000}},	//   _да__ће_, --, --, --,
   {{0x5444400a,0x44b3600c,0x00000000,0x00000000}},	//   _ku_, _concello__da_, --, --,
   {{0x4444401b,0xc2d38005,0x22d89008,0x51744012}},	//   _ju_, _dari__berbagai_, _तानी_, _família_,
   {{0x7444400a,0xcfb51012,0x7a281011,0x00000000}},	//   _mu_, _início_, _menunggu__sehingga_, --,
   {{0x9316c009,0x00000000,0x00000000,0x00000000}},	//   _medzi_, --, --, --,
   {{0x94444012,0x7442900a,0xf62c1012,0x00000000}},	//   _ou_, _sha_, _condiçõe, --,
   {{0x1498a015,0x04bc9018,0x00000000,0x00000000}},	//   _vi__har_, _personer__som_, --, --,
   {{0x19f65012,0x00000000,0x00000000,0x00000000}},	//   _então_, --, --, --,
   {{0x4fa27011,0x00000000,0x00000000,0x00000000}},	//   _boleh__memulaka, --, --, --,
   {{0x33959024,0xd4ab100f,0xd442600a,0xbb89d003}},	//   _disse_, _selepas__itu_, _izo_, _noviembr,
   {{0xf367c013,0x6a29801f,0xd4444017,0xadbf800b}},	//   _berbatas_dengan_, _मनोज_, _cu_, _врсте__су_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf4444012,0xbab46006,0xb4ace01e,0x53178006}},	// [3d0] _eu_, _vlastní_, _con__el_, _verze_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6f1b9009,0x8b61b015,0x00000000,0x00000000}},	//   _vašu_, _tidliger, --, --,
   {{0xb3f40018,0x00000000,0x00000000,0x00000000}},	//   _har__vært_, --, --, --,
   {{0x52b46009,0xbf8bf009,0xb4b4601e,0x00000000}},	//   _troch_, _iné_, _por__el_, --,
   {{0x32c0f00b,0xae00e00b,0xf4942021,0x64ace015}},	//   _живело__становни, _које__су_, _på__din_, _med__de_,
   {{0x99990006,0x4a508017,0x00000000,0x00000000}},	//   _dobře_, _vrste__porodica_, --, --,
   {{0x84ea7039,0x0e55302d,0xb975d015,0x04ad0015}},	//   _तथा__अन्य_, _महत्वपूर, _abonneme, _kan__det_,
   {{0xf2d8d01f,0x76fa5008,0x00000000,0x00000000}},	//   _हँसी_, _पनवा_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x0450900c,0x00000000,0x00000000,0x00000000}},	//   _súa__morte_, --, --, --,
   {{0xf704000f,0x3f470014,0x04ac8015,0x00000000}},	//   _yang__dipanggi, _से__अधिक_, _har__det_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x93fde020,0x33fa5013,0x8254c006,0x00000000}},	//   _godine__selu_, _satuan_, _měla_, --,
   {{0x48536015,0xe4429003,0xf497f012,0x00000000}},	//   _milliard, _esa_, _relação_, --,
   {{0xf472e02c,0x8474a011,0x00000000,0x00000000}},	//   _que__eu_, _saya__atau_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [3e0] --, --, --, --,
   {{0x126d8003,0x92e1901f,0xc5d2f00c,0xf3cd0006}},	//   _otros_, _नाहीं_, _da__poboació, _osobní_,
   {{0x4def3009,0xff79f00e,0x00000000,0x00000000}},	//   _zaujímav, _možeš_, --, --,
   {{0xe521400c,0x00000000,0x00000000,0x00000000}},	//   _no__concello_, --, --, --,
   {{0x422a2006,0x00000000,0x00000000,0x00000000}},	//   _přihlási, --, --, --,
   {{0x02ba701d,0x63da7015,0x7a163017,0x00000000}},	//   _ini__ialah_, _du__får_, _rotacija_, --,
   {{0xb2e1600b,0x7c484014,0x00000000,0x00000000}},	//   _od__nalazi_, _वाले_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x7a3cb01c,0xf4b36018,0x00000000,0x00000000}},	//   _रूप_, _ser__ut_, --, --,
   {{0x3c8ad009,0x4c4ee008,0x00000000,0x00000000}},	//   _príspevk, _जइसे_, --, --,
   {{0x5c51d013,0xd6f98002,0x00000000,0x00000000}},	//   _tentara_, _बरखा_, --, --,
   {{0x630ed003,0x00000000,0x00000000,0x00000000}},	//   _tambien_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x7c8ad009,0x5c0e9017,0x7aadc014,0x00000000}},	//   _príspevo, _skupite_, _होती__हैं_, --,
   {{0x83ebe018,0xa38a8012,0x23869015,0x00000000}},	//   _mitt_, _fórum_, _klart_, --,
   {{0x9a6c0024,0xdddf2011,0xf9c49008,0x00000000}},	//   _kommunis, _perlu__menunggu_, _अँजोरिया_, --,
   {{0xa348101b,0x00000000,0x00000000,0x00000000}},	// [3f0] _vijesti_, --, --, --,
   {{0x6442900a,0x00000000,0x00000000,0x00000000}},	//   _iza_, --, --, --,
   {{0xab8cb016,0x00000000,0x00000000,0x00000000}},	//   _की_, --, --, --,
   {{0xe4996015,0x67125014,0x00000000,0x00000000}},	//   _vi__er_, _में__बहुत_, --, --,
   {{0xaa5a900c,0xeca16014,0x02739017,0x3bdbe014}},	//   _mulleres__distribu, _से__पहले_, _na__otoku_, _तो__यह_,
   {{0xec5a2017,0x00000000,0x00000000,0x00000000}},	//   _ožujak_, --, --, --,
   {{0xf3ebe018,0x54408011,0x827e9018,0x00000000}},	//   _ditt_, _di__portal_, _blant_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xcf33c003,0x0f0e9011,0x43b9a004,0x23ebe018}},	//   _presenta, _perlu__menyumba, _serveru_, _gitt_,
   {{0xe442900a,0xc6fe9008,0x00000000,0x00000000}},	//   _aza_, _टटका_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xe27f700a,0x9ab15009,0x00000000,0x00000000}},	//   _rwanda_, _telefón_, --, --,
   {{0xd6fed008,0x00000000,0x00000000,0x00000000}},	//   _कतना_, --, --, --,
   {{0xab8fd008,0x6e62b00b,0xd7377006,0x00000000}},	//   _हऽ_, _заједно__са_, _dalších_, --,

   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [400] --, --, --, --,
   {{0x9442000a,0xda3c6002,0x539ab006,0x644b500c}},	//   _iyi_, _उपर_, _město_, _álbum__de_,
   {{0x227e7018,0x00000000,0x00000000,0x00000000}},	//   _menn_, --, --, --,
   {{0xeed2800b,0x76f96008,0x03950009,0x00000000}},	//   _је__био_, _तहरा_, _časti_, --,
   {{0x7359c005,0xdb58a00c,0x00000000,0x00000000}},	//   _sebagai__berikut_, _de__cancións_, --, --,
   {{0xa2cb400c,0x00000000,0x00000000,0x00000000}},	//   _que__súa_, --, --, --,
   {{0xd2b7900b,0x0497900b,0xb3954018,0x12e86011}},	//   _је__била_, _је__било_, _pressa_, _baginda_,
   {{0xc493d00b,0x55469009,0x00000000,0x00000000}},	//   _mjestu__je_, _zobraziť_, --, --,
   {{0x24444015,0xd9f4e009,0x572c7008,0xf386900d}},	//   _og_, _minút_, _बाड़न_, _stare_,
   {{0x7c69f00a,0xb395401b,0x00000000,0x00000000}},	//   _burundi_, _pjesmu_, --, --,
   {{0x1b8fe008,0x00000000,0x00000000,0x00000000}},	//   _सभ_, --, --, --,
   {{0x6467700c,0x046be018,0x00000000,0x00000000}},	//   _produció_de_, _hva__som_, --, --,
   {{0xe46ce00a,0x00000000,0x00000000,0x00000000}},	//   _hamwe__na_, --, --, --,
   {{0xca32b01c,0x6444400a,0xe4b04011,0x00000000}},	//   _कोई_, _cg_, _filum__sub_, --,
   {{0x53dc1013,0x00000000,0x00000000,0x00000000}},	//   _bahwa_, --, --, --,
   {{0x84444018,0x0b5f1008,0x2e9c800b,0xbbb84014}},	//   _eg_, _अइसन_, _астероид__је_, _वेबसाइट__पर_,
   {{0x82561003,0xb3dc400a,0x00000000,0x00000000}},	// [410] _sólo_, _bamwe_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x026ce00b,0x00000000,0x00000000,0x00000000}},	//   _iznosi_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x33eaf015,0x54a8200c,0x00000000,0x00000000}},	//   _sagt_, _súa__vez_, --, --,
   {{0x96dcb008,0xf2db801b,0x00000000,0x00000000}},	//   _फिलिम_, _prije__nego_, --, --,
   {{0xc4ba100c,0x00000000,0x00000000,0x00000000}},	//   _tamén__en_, --, --, --,
   {{0x3eef303a,0x00000000,0x00000000,0x00000000}},	//   _अधिक_, --, --, --,
   {{0x6352e00c,0x4471a00f,0x0f1b7009,0x00000000}},	//   _outros__artigos_, _memasuki__tahun_, _odporúča, --,
   {{0x667a6014,0x00000000,0x00000000,0x00000000}},	//   _पसंद_, --, --, --,
   {{0x3c7fc027,0x00000000,0x00000000,0x00000000}},	//   _følgende_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xb3949012,0x4443e010,0x00000000,0x00000000}},	//   _duas_, _čt_, --, --,
   {{0x54946006,0xb367700b,0xe28c300a,0x26228029}},	//   _li__se_, _toku__poslednj, _igihugu_, _organizá,
   {{0x44781013,0x126d000a,0x00000000,0x00000000}},	//   _film__ini_, _kubona_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [420] --, --, --, --,
   {{0x44432003,0xfb8ff008,0xc489100b,0xa491e015}},	//   _hay_, _तऽ_, _računara__je_, _at__vi_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x52d8f008,0xcea1f00e,0xeb619027,0x00000000}},	//   _हमनी_, _posljedn, _inkluder, --,
   {{0x24444017,0x6cbe1014,0x34431012,0x32cb7015}},	//   _kn_, _प्राप्त__करने_, _faz_, _stadig_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xde843007,0x0442d003,0x7237e01e,0x9c51d011}},	//   _di__kecamata, _ese_, _primera_, _tentera_,
   {{0x2490e00b,0x54b70009,0x999f5015,0x00000000}},	//   _je__pad_, _môžete_, _sikkerhe, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x3e8fa00b,0x127e9003,0x00000000,0x00000000}},	//   _простире__на_, _sean_, --, --,
   {{0xffe82004,0xb2b25007,0xa3949012,0x4a3cc00c}},	//   _स्थानीय_, _diakses__pada_, _suas_, _na__actualid,
   {{0x45c8d00b,0x326c200a,0x00000000,0x00000000}},	//   _средњој__надморск, _niko_, --, --,
   {{0x31fda006,0x036a700c,0x33eb4017,0x00000000}},	//   _vyhledáv, _foi__nomeado_, _sretan_, --,
   {{0xfc0ba014,0xe26d8003,0x00000000,0x00000000}},	//   _रूप__से_, _otro_, --, --,
   {{0xf4431009,0x00000000,0x00000000,0x00000000}},	//   _raz_, --, --, --,
   {{0x5a329008,0x9c49c008,0xfa89b018,0x64ad6015}},	//   _गईल_, _नईखे_, _europeis, _kan__de_,
   {{0xb4936021,0x00000000,0x00000000,0x00000000}},	// [430] _er__at_, --, --, --,
   {{0xec499014,0xc2e6e00e,0x0046f018,0x00000000}},	//   _पहले_, _za__vrijeme_, _profesjo, --,
   {{0x3291d00b,0xd3869015,0x32916007,0x6f245009}},	//   _живјело__становни, _klar_, _diakses_, _práca_,
   {{0x8d3c3006,0x746ae009,0x00000000,0x00000000}},	//   _velikost_, _ako__si_, --, --,
   {{0xf4936015,0x0386900a,0x00000000,0x00000000}},	//   _er__et_, _atari_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf4746015,0xae1ce012,0x00000000,0x00000000}},	//   _som__et_, _pergunta, --, --,
   {{0xa369401d,0xef03e00b,0xf9f43006,0x92b59003}},	//   _daripada__yang_, _se__prostire_, _její_, _disco_,
   {{0xc2bc003b,0xc4439012,0xb495e021,0x0f4fa011}},	//   _फागुन_, _às_, _på__at_, _untuk__menyumba,
   {{0xd236001b,0x932ac005,0xc4bc5018,0x00000000}},	//   _prije_, _provinsi_, _bruk__av_, --,
   {{0x3224900a,0x04079011,0x94444012,0x00000000}},	//   _shaka_, _halaman__iaitu_, _rn_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6faf1013,0xf495e015,0x54ad6015,0xfd09901f}},	//   _desa__keluraha, _på__et_, _kan__se_, _महुआ_,
   {{0x0af1f018,0x00000000,0x00000000,0x00000000}},	//   _webserve, --, --, --,
   {{0x9c8e1008,0x3c6a8032,0xb442d006,0x00000000}},	//   _कवनो_, _चिन्ता_, _lze_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2442000a,0x5232e00f,0x645c500c,0x0c492014}},	// [440] _iki_, _ahli__ahli_, _ademais__de_, _मुझे_,
   {{0xc4444003,0xc2a7800e,0x623e4033,0x1477900b}},	//   _un_, _borba_, _danmark_, _poslednj_tri_,
   {{0x926c3003,0xd3ead009,0x34cef018,0x00000000}},	//   _dijo_, _azet_, _titt__på_, --,
   {{0xe464d00b,0x4a74e006,0x00000000,0x00000000}},	//   _objašnje_na_, _zprávy_, --, --,
   {{0xe46de015,0xf6314018,0x00000000,0x00000000}},	//   _dette__er_, _topograf, --, --,
   {{0xe4444006,0x96934014,0x00000000,0x00000000}},	//   _ji_, _के__दौरान_, --, --,
   {{0xebab6014,0x7eee600b,0x00000000,0x00000000}},	//   _कि__वे_, _је__по_, --, --,
   {{0x0bb10014,0x00000000,0x00000000,0x00000000}},	//   _यह__है_, --, --, --,
   {{0x8306200c,0xb371b02c,0x52f5d00c,0x00000000}},	//   _como__unha_, _no__mercado_, _súa__vida_, --,
   {{0x2444400a,0x32f30005,0x00000000,0x00000000}},	//   _ni_, _kalimat_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xda74e025,0xced67009,0xf43a0018,0x00000000}},	//   _správy_, _veľmi_, _en__titt_, --,
   {{0x5493600c,0xd2d83006,0x00000000,0x00000000}},	//   _na__no_, _nejen_, --, --,
   {{0x8494a018,0x00000000,0x00000000,0x00000000}},	//   _og__mer_, --, --, --,
   {{0x39a3b017,0x00000000,0x00000000,0x00000000}},	//   _posjetit, --, --, --,
   {{0x94444018,0xac916014,0x00000000,0x00000000}},	//   _ei_, _दिनों_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [450] --, --, --, --,
   {{0xb4444027,0x158fb018,0x00000000,0x00000000}},	//   _gi_, _historik, --, --,
   {{0xf480800c,0xa4622011,0xfb9b2014,0x00000000}},	//   _polo__seu_, _lima__ayat_, _तरह__से_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x226d8003,0x00000000,0x00000000,0x00000000}},	//   _foro_, --, --, --,
   {{0xc3946012,0xa2d88002,0xa35c900f,0x00000000}},	//   _anos_, _हाथी_, _perkara__yang_, --,
   {{0x62d9201f,0x0bd9d014,0x42bde006,0x00000000}},	//   _बानी_, _गया__था_, _prodám_, --,
   {{0xc2925024,0xe2cf800b,0x00000000,0x00000000}},	//   _totale_, _narodni__heroji_, --, --,
   {{0x12a7f02c,0x00000000,0x00000000,0x00000000}},	//   _clube_, --, --, --,
   {{0x48d0603c,0x00000000,0x00000000,0x00000000}},	//   _पश्चिम_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xeb421004,0xdb4f900b,0x83c80015,0x00000000}},	//   _doporuču, _podaci__računaru_, _ansvar_, --,
   {{0x44444009,0xf3ead01b,0x00000000,0x00000000}},	//   _pi_, _ljeto_, --, --,
   {{0x537f8007,0xdd47b010,0xd386d003,0xd2e13013}},	//   _jakarta_, _dispozic, _leer_, _spanyol_,
   {{0x0719d00b,0x56ff3008,0x00000000,0x00000000}},	//   _stanovni_opština_, _अतना_, --, --,
   {{0xe4198011,0x00000000,0x00000000,0x00000000}},	//   _dicipta__untuk_, --, --, --,
   {{0xcdc73009,0xe442000a,0xac6f700a,0x7387e020}},	// [460] _kliknite_, _ibi_, _afurika_, _metra_,
   {{0x5c5e2017,0x00000000,0x00000000,0x00000000}},	//   _te__obiteljs, --, --, --,
   {{0xb2b92002,0x614b300b,0xc1085009,0x6228c017}},	//   _बाबू_, _на__површини_, _užívateľ, _vještine_,
   {{0xe573101b,0xced59006,0x00000000,0x00000000}},	//   _amatersk, _což_, --, --,
   {{0x2442000a,0x4b1b900c,0x645a600c,0x6a335008}},	//   _mbi_, _pode__referirs, _poboació_de_, _छोट_,
   {{0x44425006,0xee3ce00b,0x00000000,0x00000000}},	//   _byl_, _се__да_, --, --,
   {{0x4d8c9013,0x8c7c500e,0x00000000,0x00000000}},	//   _mayorita, _mjeseca_, --, --,
   {{0x64424009,0xbc489008,0xc3f47013,0x4386c015}},	//   _tym_, _साथे_, _sastra_, _indre_,
   {{0x62cb800a,0xd73b6014,0x00000000,0x00000000}},	//   _bikorwa_, _में__शामिल_, --, --,
   {{0xc26cc012,0x3b53d00f,0x00000000,0x00000000}},	//   _tudo_, _dalam__golongan_, --, --,
   {{0xfd4c900b,0xe979a006,0x00000000,0x00000000}},	//   _je__eliptičn, _bydlení_, --, --,
   {{0x2386a01b,0x6492600b,0x03946003,0xb2b98014}},	//   _dobri_, _je__on_, _unos_, _यहां_,
   {{0xfb1c2003,0x44bee00d,0x93f9000a,0x00000000}},	//   _respuest, _mogu__da_, _kibuye_, --,
   {{0xc442600a,0x225a4017,0x42d85018,0x93e4c006}},	//   _iyo_, _probuši_, _delen_, _děti_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xe442100b,0xb9f89018,0xb2abe018,0x00000000}},	//   _metra__površina_, _samstund, _budding_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [470] --, --, --, --,
   {{0x0ba5b014,0xfbc33014,0x00000000,0x00000000}},	//   _है__और_, _करने__से_, --, --,
   {{0xc492602f,0x4ec8f009,0x93d7500a,0x39c34017}},	//   _en__en_, _zariaden, _abatutsi_, _skačuće_,
   {{0x63018017,0x26f9c002,0x9394d003,0x00000000}},	//   _trebate_, _भुला_, _pues_, --,
   {{0x06f83014,0x12d96008,0x00000000,0x00000000}},	//   _लिया_, _भउजी_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2301501d,0x7386d018,0x4442600a,0xa2d1a009}},	//   _bergantu_kepada_, _sterk_, _ayo_, _človek_,
   {{0xdfc70006,0x5442600a,0x8ccf8006,0x00000000}},	//   _článek_, _byo_, _dvě_, --,
   {{0x6442600a,0x8443f00a,0x6ab3e018,0x1993e018}},	//   _cyo_, _uru_, _marknads, _marknade,
   {{0xa4020009,0x00000000,0x00000000,0x00000000}},	//   _dovolenk, --, --, --,
   {{0xca3dd01f,0x00000000,0x00000000,0x00000000}},	//   _सकल_, --, --, --,
   {{0xa3940021,0x348c200b,0x43958013,0xd3404015}},	//   _pris_, _eliptičn_sa_, _kursi_, _det__ikke_,
   {{0x13cf5003,0x5a329014,0x3ef0e00b,0x00000000}},	//   _nuevos_, _ऐसा_, _им_, --,
   {{0xe7e79030,0x92495018,0xd4422009,0x00000000}},	//   _संपर्क_, _fremst_, _skk_, --,
   {{0x0b8d5016,0xc4b36015,0xa2025017,0x00000000}},	//   _और_, _til__en_, _vrtite_, --,
   {{0x327f501e,0xf26c700a,0x00000000,0x00000000}},	//   _buenos_, _hino_, --, --,
   {{0xf26da012,0x00000000,0x00000000,0x00000000}},	// [480] _topo_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x8248c015,0xd224700a,0xcc50b014,0xb27fc018}},	//   _nummer_, _banki_, _देखें_, _nevnt_,
   {{0x59f47006,0x00000000,0x00000000,0x00000000}},	//   _není_, --, --, --,
   {{0x7ed2500b,0xc4926019,0x934e0012,0xf4eeb00b}},	//   _да__се_, _en__un_, _edição_, _stanovni_prosečna_,
   {{0x5442600a,0x7e8d600b,0x00000000,0x00000000}},	//   _ryo_, _ће__се_, --, --,
   {{0x3e3ce00b,0xdb8d501f,0x00000000,0x00000000}},	//   _се__на_, _छी_, --, --,
   {{0xff01c00b,0x6480600c,0x7afd9009,0x00000000}},	//   _како__би_, _conxunto__de_, _prípade_, --,
   {{0x92132010,0x13eb8018,0xd2e3e009,0x00000000}},	//   _archiv_, _kart_, _ktorých_, --,
   {{0xa35e3007,0x946b8011,0xf495c014,0x00000000}},	//   _dikenal__sebagai_, _memulaka_sebuah_, _के__द्वारा_, --,
   {{0x64438003,0x04926006,0x0dbc5017,0x6bcde014}},	//   _mar_, _je__li_, _izbacite_, _सभी_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x1b8d601c,0x2492600e,0x00000000,0x00000000}},	//   _कर_, _je__ni_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2a33a008,0x3fcd900b,0x23c5e012,0x6471d00c}},	//   _अछि_, _од__стране_, _paraná_, _fillo__de_,
   {{0x5317f006,0x00000000,0x00000000,0x00000000}},	//   _pouze_, --, --, --,
   {{0x6225e017,0x00000000,0x00000000,0x00000000}},	// [490] _nitko_, --, --, --,
   {{0x6494e00c,0xe4aae015,0xf4ab2021,0x00000000}},	//   _km__de_, _den__er_, _med__din_, --,
   {{0x33f47015,0x00000000,0x00000000,0x00000000}},	//   _ekstra_, --, --, --,
   {{0xdb692024,0x7ab38014,0x00000000,0x00000000}},	//   _profilen_, _जाते__हैं_, --, --,
   {{0x7c755003,0x7290300f,0x6c69e013,0x00000000}},	//   _algunos_, _semasa_, _korupsi_, --,
   {{0xc26dc012,0xe49f6015,0x00000000,0x00000000}},	//   _novo_, _får__du_, --, --,
   {{0xd47c800f,0xede6200b,0x00000000,0x00000000}},	//   _oleh__itu_, _као__што_, --, --,
   {{0xc5802012,0x5f31500b,0xa26c7003,0x00000000}},	//   _informaç, _од__преко_, _sino_, --,
   {{0x64427027,0x00000000,0x00000000,0x00000000}},	//   _syn_, --, --, --,
   {{0x54439003,0x8f2f1018,0x00000000,0x00000000}},	//   _las_, _annonser_, --, --,
   {{0xd442900a,0x3f319018,0x00000000,0x00000000}},	//   _aya_, _konferan, --, --,
   {{0x74439012,0xe442900a,0x64ba300b,0xf3e69009}},	//   _nas_, _bya_, _skeniran_iz_, _túto_,
   {{0xc2806017,0x92fc7021,0xf442900a,0xb474600b}},	//   _kockice_, _ting_, _cya_, _sve__do_,
   {{0x62572006,0x00000000,0x00000000,0x00000000}},	//   _dále_, --, --, --,
   {{0xea99501b,0x00000000,0x00000000,0x00000000}},	//   _južnoafr, --, --, --,
   {{0x203de012,0x00000000,0x00000000,0x00000000}},	//   _anúncios_, --, --, --,
   {{0xd4439012,0x94438021,0x6c066014,0x2a336008}},	// [4a0] _das_, _par_, _किसी__भी_, _करब_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xa3609005,0xd29de00e,0x00000000,0x00000000}},	//   _lainnya__yang_, _svijeta_, --, --,
   {{0x4354d003,0x00000000,0x00000000,0x00000000}},	//   _tenemos_, --, --, --,
   {{0xd4438018,0x1029f002,0x2c486014,0x00000000}},	//   _tar_, _मुँह_, _लिये_, --,
   {{0xdbcde008,0x7b3f000b,0x00000000,0x00000000}},	//   _सभे_, _domaćins_prosečan_, --, --,
   {{0x6b413010,0x00000000,0x00000000,0x00000000}},	//   _pravidla_, --, --, --,
   {{0x49786003,0xf3f96023,0x226c400d,0x00000000}},	//   _administ, _alguns_, _samom_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x4b908006,0x3fc0b006,0xe442900a,0x00000000}},	//   _prostřed, _stránek_, _rya_, --,
   {{0xe3f82006,0xdbfc6018,0x227a301d,0x00000000}},	//   _pokud_, _konfigur, _adalah__lebih_, --,
   {{0x2b0cf017,0x00000000,0x00000000,0x00000000}},	//   _proslije, --, --, --,
   {{0x1047703d,0x32b49009,0x00000000,0x00000000}},	//   _विकल्प_, _viac_, --, --,
   {{0xb4444012,0x51b83008,0xe465a015,0x22fce00f}},	//   _br_, _लागल_, _hvordan__du_, _mangsa_,
   {{0x94439009,0x3297c00b,0x79765012,0xad7ef00b}},	//   _pas_, _износила__становни, _atendime, _су_,
   {{0x5b8c801f,0x927e7018,0x00000000,0x00000000}},	//   _ओह_, _minne_, --, --,
   {{0xe4444015,0xc4b9600b,0x00000000,0x00000000}},	// [4b0] _er_, _vrste__je_, --, --,
   {{0xc2e7600e,0x2fab5013,0x42369010,0x00000000}},	//   _to__vrijeme_, _gubernur_, _kraje_, --,
   {{0xb2f2d011,0x92cde00c,0x1ec9500b,0x00000000}},	//   _bermula__pada_, _unha__nova_, _ilustrac_stranice_, --,
   {{0xfe61c012,0x00000000,0x00000000,0x00000000}},	//   _trabalha, --, --, --,
   {{0xc985801a,0x1d0f7017,0x00000000,0x00000000}},	//   _टाइम्स_, _pomozite_, --, --,
   {{0xd4426009,0xca590009,0x5c2f900a,0x00000000}},	//   _ako_, _inzercia_, _cyangugu_, --,
   {{0x32fe6018,0xf2cde00d,0xe9de3003,0xf8f6900b}},	//   _bergen_, _na__jednu_, _contenid, _је__поставил,
   {{0xeba6a014,0xdf26b017,0x00000000,0x00000000}},	//   _प्रकार__के_, _gađajte_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x7a6e8014,0x04950015,0xed019011,0x00000000}},	//   _होते__हैं_, _og__det_, _maklumat_, --,
   {{0x3292500a,0x00000000,0x00000000,0x00000000}},	//   _butare_, --, --, --,
   {{0x111b8014,0x00000000,0x00000000,0x00000000}},	//   _इसके__अलावा_, --, --, --,
   {{0xc4444029,0x00000000,0x00000000,0x00000000}},	//   _sr_, --, --, --,
   {{0xc47d000b,0x8339e00c,0xde27e006,0x00000000}},	//   _stepenom__je_, _da__familia_, _nápověda_, --,
   {{0xe3706005,0x0b9e3014,0x00000000,0x00000000}},	//   _relatif_, _एक__और_, --, --,
   {{0x0c08e014,0x9212b006,0x00000000,0x00000000}},	//   _सकता__है_, _bych_, --, --,
   {{0xf29ea00b,0x73e5d00c,0x00000000,0x00000000}},	// [4c0] _zemlje__masa_, _de__véxase_, --, --,
   {{0xc23bf00d,0xd3dc900a,0xc4a97015,0x00000000}},	//   _godine__broj_, _ikawa_, _den__nye_, --,
   {{0x9301c00b,0x00000000,0x00000000,0x00000000}},	//   _detaljni__podaci_, --, --, --,
   {{0x2491a015,0x00000000,0x00000000,0x00000000}},	//   _du__kan_, --, --, --,
   {{0x6be36019,0x00000000,0x00000000,0x00000000}},	//   _comentar, --, --, --,
   {{0x4355a00b,0xd3414015,0xa2003007,0x00000000}},	//   _sa__dodatim_, _kan__ikke_, _komisi_, --,
   {{0x43966013,0xbb9e5014,0x33cf5003,0x6416800d}},	//   _persen_, _इंटरनेट__पर_, _nuevas_, _površini_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x83b3d017,0xd3169006,0xd340c015,0x5eb3c013}},	//   _travanj_, _praze_, _har__ikke_, _filsafat_,
   {{0x04426017,0xda5ea00b,0x00000000,0x00000000}},	//   _tko_, _imala__kapacite, --, --,
   {{0x1c625017,0x1442600a,0x6a565014,0x00000000}},	//   _šarene_, _uko_, _है__तथा_, --,
   {{0x2a330016,0x5375e020,0x95d42007,0x00000000}},	//   _टीम_, _ovo__naselje_, _membutuh, --,
   {{0xb2be2014,0xd4952015,0x00000000,0x00000000}},	//   _क्रं_, _om__den_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x4f6dd00b,0x547f200c,0x12e64014,0xf46b801b}},	// [4d0] _са__објашњењ, _unha__vez_, _की__सूची_, _kao__dio_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf33b3008,0xf2be5009,0x00000000,0x00000000}},	//   _भोजपुरी_, _predám_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x339c3007,0xebb6100c,0xa998d009,0x00000000}},	//   _pada__tanggal_, _da__historia_, _tiež_, --,
   {{0x9442600a,0x8290c018,0xee8f600e,0x42370003}},	//   _abo_, _medan_, _promijen, _viajes_,
   {{0x7bc33034,0xcb182013,0x6446d00c,0xac48901c}},	//   _घरी_, _sebagian_, _finado__de_, _देने_,
   {{0x3442900a,0x00000000,0x00000000,0x00000000}},	//   _nka_, --, --, --,
   {{0x94aaa011,0xc2c3f00c,0xdbaa300b,0x00000000}},	//   _faham__apa_, _un__novo_, _парламен, --,
   {{0x6442900a,0x92da6004,0xe280b006,0x00000000}},	//   _aka_, _hotelu_, _diskuse_, --,
   {{0x1c4d800c,0xd4bc400c,0x00000000,0x00000000}},	//   _de__persoas_, _non__só_, --, --,
   {{0xc6f94008,0xe2459009,0x82439008,0x238ca00c}},	//   _हमरा_, _témy_, _दिहलन_, _de__xaneiro_,
   {{0xa3eae005,0x00000000,0x00000000,0x00000000}},	//   _mantan_, --, --, --,
   {{0x92b8603e,0x82d8603f,0xac486002,0x768e6012}},	//   _लागू_, _लागी_, _लागे_, _profissi,
   {{0xf2eed018,0xe416800b,0x00000000,0x00000000}},	//   _treff_, _površina_, --, --,
   {{0x9a21e011,0x44bd500c,0x00000000,0x00000000}},	//   _sebahagi_daripada_, _logo__da_, --, --,
   {{0x4470f013,0xa0b1c00b,0x00000000,0x00000000}},	// [4e0] _kecamata_ini_, _график__промене_, --, --,
   {{0xc5d3f00c,0xc2c5f011,0x00000000,0x00000000}},	//   _de__poboació, _pada__julai_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x0442d00a,0x53866015,0x00000000,0x00000000}},	//   _bye_, _stort_, --, --,
   {{0xe2401008,0xc3ce502c,0xa386d003,0x00000000}},	//   _भोजपुरिय, _silva_, _enero_, --,
   {{0x72d8301b,0xb398a008,0x00000000,0x00000000}},	//   _gdje_, _हs_, --, --,
   {{0xf6f9101f,0xcc04d00e,0x00000000,0x00000000}},	//   _दाता_, _mjeseci_, --, --,
   {{0x0f411011,0x2a330002,0x00000000,0x00000000}},	//   _boleh__menyumba, _चना_, --, --,
   {{0x96fe2014,0x00000000,0x00000000,0x00000000}},	//   _क्या_, --, --, --,
   {{0xe26c7010,0x92ecb013,0x3a3d3014,0xfb235013}},	//   _brno_, _periode_, _हूँ_, _dibangun_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf3ebe018,0x1c492008,0x00000000,0x00000000}},	//   _hatt_, _बाडे_, --, --,
   {{0x0ab9d014,0x37572014,0x97f27009,0x00000000}},	//   _रूप__में_, _जा__सकता_, _možnosť_, --,
   {{0x4348e00a,0x00000000,0x00000000,0x00000000}},	//   _mugenzi_, --, --, --,
   {{0xc291c00e,0x5ac7e017,0x00000000,0x00000000}},	//   _vrijeme_, _čelični_, --, --,
   {{0x924d601b,0xd4ada015,0xec77b017,0x00000000}},	//   _još__uvijek_, _for__den_, _spasite_, --,
   {{0xa4429009,0x32485004,0xac484002,0x629f7011}},	// [4f0] _iba_, _velmi_, _लेले_, _berjaya_,
   {{0x9184800b,0x07b9900b,0x6c7ca024,0x326db020}},	//   _природно__станиште_, _од__метра_, _teksten_, _izvori_,
   {{0x8212d012,0x5312f023,0x83eab018,0x00000000}},	//   _melhor_, _para__obter_, _goethe_, --,
   {{0x5415b013,0x12cbf003,0x62fc0011,0x334ba015}},	//   _menunjuk_bahwa_, _ayuda_, _anda__pandai_, _er__mange_,
   {{0x82cea007,0xb4ace037,0x5202601b,0x422ab006}},	//   _yang__bisa_, _med__at_, _igrice_, _někdo_,
   {{0xf52e600a,0x00000000,0x00000000,0x00000000}},	//   _abayoboz, --, --, --,
   {{0xe443e006,0x4d32e00b,0x0bc14014,0x00000000}},	//   _dat_, _току__последњи, _सकती__है_, --,
   {{0x1a5c601d,0x00000000,0x00000000,0x00000000}},	//   _di__malaysia_, --, --, --,
   {{0xf4ace015,0xb4696011,0x83052005,0x00000000}},	//   _med__et_, _alam__filum_, _mataram_, --,
   {{0x2442900a,0x148b5015,0x00000000,0x00000000}},	//   _aba_, _sammen__med_, --, --,
   {{0xc312f007,0x554e8029,0x22d92008,0x22e3800b}},	//   _oleh__karena_, _slovensk, _बाती_, _knjige__narodni_,
   {{0x069c200b,0x0adc200b,0x00000000,0x00000000}},	//   _opština_, _opštine_, --, --,
   {{0x8427100c,0xa46f3011,0x00000000,0x00000000}},	//   _polo__tanto_, _laman__web_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x73ced003,0x27c65014,0xc8cdc012,0x00000000}},	// [500] _nuevo_, _उन्हें_, _prefeitu, --,
   {{0x32beb009,0xc3f47013,0x2eeae00b,0xe394d012}},	//   _všetko_, _partai_, _док__је_, _grosso_,
   {{0x506d300b,0xd2cf9009,0x50b6300b,0x00000000}},	//   _је__године_, _kancelár, _од__године_, --,
   {{0xb699f00d,0xc969603b,0x3200a006,0x30596002}},	//   _broja__stanovni, _साँझ_, _jejich_, _साँस_,
   {{0xd26c0012,0x64bad020,0x00000000,0x00000000}},	//   _maio_, _popis__iz_, --, --,
   {{0x2c0b8009,0xc48cd01b,0x00000000,0x00000000}},	//   _približn, _pjesma__je_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x23e4100c,0x00000000,0x00000000,0x00000000}},	//   _en__dous_, --, --, --,
   {{0xc6fe7008,0x00000000,0x00000000,0x00000000}},	//   _ओकरा_, --, --, --,
   {{0x0394e00a,0x7ed2e00b,0x00000000,0x00000000}},	//   _kristo_, _би__се_, --, --,
   {{0xd459000c,0x00000000,0x00000000,0x00000000}},	//   _poboació_que_, --, --, --,
   {{0x52493006,0x00000000,0x00000000,0x00000000}},	//   _přihláše, --, --, --,
   {{0x6bc36002,0x021ea017,0x3da78009,0xc275c00c}},	//   _करी_, _ostali__projekti_, _keď_, _con__máis_,
   {{0xc290401b,0x9a5cb01d,0xd479b011,0x00000000}},	//   _nemam_, _lebih__daripada_, _merupaka_ke_, --,
   {{0x2e92d00b,0x944ad011,0xf38a100f,0x00000000}},	//   _процјени__из_, _kerana__ia_, _merupaka_sejenis_, --,
   {{0x429dc003,0x758a0009,0x6201400a,0xa3949003}},	//   _día_, _registrá, _bafite_, _tras_,
   {{0xc6a95010,0x00000000,0x00000000,0x00000000}},	// [510] _समेत_, --, --, --,
   {{0x64956015,0x499bd015,0x00000000,0x00000000}},	//   _og__de_, _velkomme, --, --,
   {{0xa248d018,0x834c8011,0x00000000,0x00000000}},	//   _filmer_, _yang__berbeza_, --, --,
   {{0xe4936015,0x00000000,0x00000000,0x00000000}},	//   _er__du_, --, --, --,
   {{0x22c49011,0xd4b8700c,0x00000000,0x00000000}},	//   _sehingga__anda_, _xeito__que_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xe4746015,0x00000000,0x00000000,0x00000000}},	//   _som__du_, --, --, --,
   {{0x526d1003,0x00000000,0x00000000,0x00000000}},	//   _hizo_, --, --, --,
   {{0x7d54f00b,0x00000000,0x00000000,0x00000000}},	//   _према__процјени_, --, --, --,
   {{0xe26c100a,0xc46be015,0x0720501b,0x00000000}},	//   _naho_, _fra__en_, _osjećaj_, --,
   {{0xd4ba500b,0x00000000,0x00000000,0x00000000}},	//   _satelita__pri_, --, --, --,
   {{0x9f861011,0x51d8d008,0x62d87006,0x00000000}},	//   _anda__mempunya, _राउर_, _konec_, --,
   {{0xd6dcf008,0x00000000,0x00000000,0x00000000}},	//   _बाकिर_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6f85e00b,0x42d9f002,0x3499e009,0x1491b018}},	//   _gustina__naseljen, _नानी_, _to__sa_, _av__oss_,
   {{0x0436b018,0xe4b46015,0x527f5003,0x32903007}},	//   _de__beste_, _vil__du_, _tienes_, _romawi_,
   {{0xb229500b,0x73959012,0x00000000,0x00000000}},	// [520] _dve__godine_, _passa_, --, --,
   {{0x0b499031,0x7245c010,0xe46ae009,0x23e72009}},	//   _राष्ट्री, _tím_, _ako__na_, _táto_,
   {{0x3256200b,0x00000000,0x00000000,0x00000000}},	//   _становни, --, --, --,
   {{0xa33d9011,0x00000000,0x00000000,0x00000000}},	//   _haiwan__yang_, --, --, --,
   {{0xa26c2017,0x44a7d00d,0x00000000,0x00000000}},	//   _iako_, _trebalo__da_, --, --,
   {{0x43083003,0x00000000,0x00000000,0x00000000}},	//   _trabajo_, --, --, --,
   {{0x03866015,0x00000000,0x00000000,0x00000000}},	//   _stor_, --, --, --,
   {{0xb26c2006,0x7f1ff009,0x00000000,0x00000000}},	//   _jako_, _oblečeni, --, --,
   {{0xf284300b,0x92cb501b,0xcda78006,0x364a600b}},	//   _do__kraja_, _negdje_, _teď_, _при__лансирањ,
   {{0x61d94008,0x34d56016,0x9c4d000c,0x0b9da014}},	//   _हमार_, _वीडियो_, _pouco__despois_, _को__कम_,
   {{0x3b8ff008,0x00000000,0x00000000,0x00000000}},	//   _दू_, --, --, --,
   {{0xf26c200a,0x7791700b,0x00000000,0x00000000}},	//   _nako_, _на__удаљенос, --, --,
   {{0xbb03b003,0x2bfc6017,0x00000000,0x00000000}},	//   _herramie, _zvjezdic, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x0fbad006,0xba6c0006,0x00000000,0x00000000}},	//   _zařízení_, _přímo_, --, --,
   {{0x0a716014,0xc4b9e00b,0x06ddc01c,0x7c489008}},	//   _करने__में_, _mestu__je_, _पुलिस_, _देवे_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [530] --, --, --, --,
   {{0xfc492008,0xf2926009,0x52fd801e,0x00000000}},	//   _बाटे_, _strane_, _cargo_, --,
   {{0x8d0fa017,0xb2489007,0xf3c3b012,0x00000000}},	//   _pogodite_, _alami_, _nível_, --,
   {{0x4e77800b,0x94314011,0x346ae009,0xbc5fa014}},	//   _један__од_, _mewujudk_sebuah_, _ako__sa_, _को__अपने_,
   {{0xfd136003,0x7394600a,0x00000000,0x00000000}},	//   _consider, _byose_, --, --,
   {{0xd47f600c,0x49f65012,0xed00e00e,0x7504b027}},	//   _polo__que_, _estão_, _promjene_, _eksempel_,
   {{0xc2eb9007,0x84b6f011,0x6248f00b,0xa2fdd011}},	//   _di__berbagai_, _berkuali_di_, _primer_, _orang__ramai_,
   {{0x2dc3a005,0x00000000,0x00000000,0x00000000}},	//   _disingka, --, --, --,
   {{0xaa336034,0xa385a00b,0xfa0fe013,0x52fd7012}},	//   _करत_, _mladost__beograd_, _manajeme, _imagem_,
   {{0x53501015,0x00000000,0x00000000,0x00000000}},	//   _ikke__bare_, --, --, --,
   {{0xa2ebc00c,0x00000000,0x00000000,0x00000000}},	//   _na__súa_, --, --, --,
   {{0xe3581013,0xd3a8d005,0x00000000,0x00000000}},	//   _amerika__serikat_, _semarang_, --, --,
   {{0xf67f6007,0x17c9a00c,0x00000000,0x00000000}},	//   _peneliti, _da__provinci, --, --,
   {{0x66feb017,0x1c53f012,0xd38b3015,0xc314500c}},	//   _izbrišit, _contato_, _først_, _un__cordial_,
   {{0x06ea400b,0x7fc3f003,0x00000000,0x00000000}},	//   _je__opština_, _así_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x4495700c,0x9b80d00b,0x326c3003,0x00000000}},	// [540] _se__lle_, _memorija__računara_, _bajo_, --,
   {{0x56152006,0xc3c3800c,0x00000000,0x00000000}},	//   _příspěve, _nos__anos_, --, --,
   {{0x42242018,0xc9f8f017,0x526c200b,0x00000000}},	//   _takk_, _milijuna_, _tako_, --,
   {{0x8ed5200b,0x00000000,0x00000000,0x00000000}},	//   _том_, --, --, --,
   {{0xa26cd003,0x00000000,0x00000000,0x00000000}},	//   _creo_, --, --, --,
   {{0x740b501d,0x5d65f00b,0xb3869015,0x2284100a}},	//   _kuala__lumpur_, _stanovni_prosječn, _snart_, _amahoro_,
   {{0xd96bb006,0xa293e01d,0xd394d003,0x4201000d}},	//   _uživatel, _kadang__kala_, _eres_, _srbije_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x426df003,0x4c489008,0x00000000,0x00000000}},	//   _autos_, _देले_, --, --,
   {{0x154d8009,0xd236600d,0x7711b014,0x00000000}},	//   _prevádzk, _broja_, _होना__चाहिए_, --,
   {{0x93ced01e,0x00000000,0x00000000,0x00000000}},	//   _nueva_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xa6f91014,0x29fe602c,0x71ba6008,0x5d619008}},	//   _दिया_, _economia_, _पड़ल_, _बताईं_,
   {{0x34444015,0xc489500d,0x00000000,0x00000000}},	//   _ca_, _aviona__je_, --, --,
   {{0x22ab1007,0x5e62d019,0x0c016014,0xc2d84012}},	//   _bandung_, _descarga, _देता__है_, _homem_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x44b0d00d,0x00000000,0x00000000,0x00000000}},	// [550] _treba__da_, --, --, --,
   {{0xca33a002,0x00000000,0x00000000,0x00000000}},	//   _आईं_, --, --, --,
   {{0xe4421009,0xa8ddc00b,0x72640010,0x4ef8002c}},	//   _ich_, _iznosi__asteroid, _poslat_, _os__produtos_,
   {{0xc46e6009,0x00000000,0x00000000,0x00000000}},	//   _nie__je_, --, --, --,
   {{0x9444400a,0x82db300c,0xe8c6300a,0x00000000}},	//   _ya_, _de__unha_, _abaturag, --,
   {{0xb27ed003,0x2277d00d,0x00000000,0x00000000}},	//   _buena_, _maksimal, --, --,
   {{0x73954017,0xaf3ff012,0x4b882008,0xf4ace015}},	//   _mjesec_, _joão_, _नू_, _har__et_,
   {{0xc394d01e,0x00000000,0x00000000,0x00000000}},	//   _tres_, --, --, --,
   {{0xf37d200c,0xc2c93011,0xb2c4a015,0x00000000}},	//   _de__orixe_, _saje__jika_, _normalt_, --,
   {{0xd963e017,0xc3eb2003,0xf3ce6012,0x9a134011}},	//   _prosinac_, _sector_, _prova_, _berasal__daripada_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x34444009,0xd290600f,0x00000000,0x00000000}},	//   _sa_, _beliau__telah_, --, --,
   {{0x4e28e00b,0x4c48f008,0xf6dc701f,0x00000000}},	//   _па_, _हमके_, _बिपिन_, --,
   {{0xe483b00b,0x6eba100b,0x00000000,0x00000000}},	//   _prostire__na_, _после_, --, --,
   {{0x64444003,0xf26c5009,0x1387b012,0x00000000}},	//   _va_, _malo_, _livros_, --,
   {{0x7444400a,0x90373025,0xa2fdf00d,0x00000000}},	//   _wa_, _cestovan, _drugi_, --,
   {{0xc382d01d,0x81028017,0x00000000,0x00000000}},	// [560] _hari__sebelum_, _lančana_, --, --,
   {{0x44302012,0x9461201d,0x4473d00b,0xf2d85006}},	//   _processo_, _ialah__sebuah_, _mogao__da_, _kolem_,
   {{0x3335e030,0x97ce000c,0xec489008,0x00000000}},	//   _विधानसभा_, _lugares__parroqui, _देबे_, --,
   {{0x82ddb007,0xfd41b00b,0x8472e00c,0xf303e003}},	//   _di__desa_, _самом__граду_, _que__xa_, _regístra,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x334c1012,0x8c0b1024,0x00000000,0x00000000}},	//   _futebol_, _knappen_, --, --,
   {{0x0452e018,0x23f86006,0x00000000,0x00000000}},	//   _gjør__det_, _svou_, --, --,
   {{0x1be22014,0x82ef000b,0x00000000,0x00000000}},	//   _आप__एक_, _grafik_, --, --,
   {{0x4c684013,0x0a6a2014,0x00000000,0x00000000}},	//   _memulai_, _क्षेत्र__में_, --, --,
   {{0x7473e009,0x00000000,0x00000000,0x00000000}},	//   _ste__si_, --, --, --,
   {{0x447c9005,0x03d49015,0x00000000,0x00000000}},	//   _kota__ini_, _en__stor_, --, --,
   {{0xc4b9d006,0xfb4cf00a,0x123be006,0x00000000}},	//   _jako__je_, _kurwanya_, _můj_, --,
   {{0x93f6200c,0x3765200b,0x52d80018,0x00000000}},	//   _tamén__outros_, _је__астероид, _seier_, --,
   {{0x94ae1018,0x74460015,0x00000000,0x00000000}},	//   _for__deg_, _på__nettet_, --, --,
   {{0xccee300b,0x02c94012,0x4e394012,0x00000000}},	//   _град_, _esporte_, _esportes_, --,
   {{0x16f9602a,0xf200c00a,0x00000000,0x00000000}},	//   _साझा_, _polisi_, --, --,
   {{0x7e5d6005,0x00000000,0x00000000,0x00000000}},	// [570] _tercatat_, --, --, --,
   {{0x5c494010,0xc3954009,0xd21d7013,0x00000000}},	//   _दिने_, _miesto_, _maskapai_, --,
   {{0xc4936040,0xc011401e,0x00000000,0x00000000}},	//   _er__en_, _producto, --, --,
   {{0x32a7900b,0x02ca3017,0xc44cc006,0x7254c006}},	//   _броја__становни, _internac_linkovi_, _mě_, _měl_,
   {{0xb2254009,0x00000000,0x00000000,0x00000000}},	//   _niekto_, --, --, --,
   {{0xc4746015,0xec783012,0x00000000,0x00000000}},	//   _som__en_, _pessoal_, --, --,
   {{0x7a750014,0xa6f81008,0x00000000,0x00000000}},	//   _रहे__हैं_, _लइका_, --, --,
   {{0x6b8e501c,0x8e327013,0xee3d8006,0x00000000}},	//   _इन_, _kualitas_, _přejít_, --,
   {{0xd44e1012,0x228b2009,0x00000000,0x00000000}},	//   _só_, _poslať_, --, --,
   {{0xdad64012,0x00000000,0x00000000,0x00000000}},	//   _crianças_, --, --, --,
   {{0xd9b15015,0xc495e015,0xea3cf01f,0x00115029}},	//   _produkte, _på__en_, _वोह_, _produkto,
   {{0x91456003,0xb5144011,0x8a3dc008,0x00000000}},	//   _especial, _boleh__menanyak, _तूँ_, --,
   {{0xda336002,0x62d82018,0x00000000,0x00000000}},	//   _चीज_, _boken_, --, --,
   {{0xee32500b,0x9ae4b00d,0x00000000,0x00000000}},	//   _може__да_, _rezultat, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x13994008,0x00000000,0x00000000,0x00000000}},	//   _तs_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [580] --, --, --, --,
   {{0xa2480018,0x9d4e9006,0x00000000,0x00000000}},	//   _heim_, _předmět_, --, --,
   {{0x22cd5011,0x00000000,0x00000000,0x00000000}},	//   _sini__anda_, --, --, --,
   {{0xfc036007,0xf4ab2015,0x00000000,0x00000000}},	//   _lampung_, _han__var_, --, --,
   {{0x0bff4014,0x9387e006,0x14444003,0x00000000}},	//   _करती__है_, _petr_, _hs_, --,
   {{0xa32f3011,0xd3799009,0x22366020,0x00000000}},	//   _dikenali__sebagai_, _pridať_, _broju_, --,
   {{0x426e9011,0x62c66011,0x00000000,0x00000000}},	//   _yang__bermula_, _lain__sila_, --, --,
   {{0x7ec0500b,0x81d81016,0x3cbee014,0xd47cc00c}},	//   _су__се_, _लेकर_, _प्राप्त__करें_, _que__só_,
   {{0x027f4003,0x1f1f3007,0x310ff018,0xbca7a014}},	//   _cuenta_, _komunita, _denne__artikkel, _और__अपने_,
   {{0x84444023,0x92d5600c,0x426de010,0xa437b00c}},	//   _os_, _con__todo_, _tuto_, _ao__leste_,
   {{0xc4926003,0xb3ea9013,0x2d5a200b,0x00000000}},	//   _en__la_, _dokter_, _може_, --,
   {{0xcbddd014,0x00000000,0x00000000,0x00000000}},	//   _बताया_, --, --, --,
   {{0xc6f8103b,0xe492600c,0x50bdf00b,0x8af52006}},	//   _लेखा_, _en__na_, _североис_године_, _napříkla,
   {{0x0bc6e014,0x00000000,0x00000000,0x00000000}},	//   _करता__है_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x23ead009,0x928f100a,0x00000000,0x00000000}},	//   _svete_, _urukiko_, --, --,
   {{0xe4444003,0xeb8e6014,0xf4d0400b,0x689d3006}},	// [590] _es_, _इस_, _ма__према_, _soutěže_,
   {{0x63e79006,0x642f400b,0x00000000,0x00000000}},	//   _této_, _слатково_подручја_, --, --,
   {{0xb950700b,0x59c3f017,0x94b2800c,0x00000000}},	//   _дани__сећања_, _novčiće_, _por__iso_, --,
   {{0x263f5027,0x94438015,0x04be0015,0x0af52013}},	//   _digitali, _dyr_, _hvis__det_, _referens,
   {{0xc4b3e015,0x00000000,0x00000000,0x00000000}},	//   _var__en_, --, --, --,
   {{0xb6a0700e,0xb4bad033,0x8d42d00b,0x00000000}},	//   _imalo__stanovni, _ikke__at_, _информац, --,
   {{0x93ac700c,0x00000000,0x00000000,0x00000000}},	//   _entre__outros_, --, --, --,
   {{0x24aaa015,0xbd05b015,0x00000000,0x00000000}},	//   _det__kan_, _kvalitet_, --, --,
   {{0x96ff6008,0x4c50401f,0x12843003,0x00000000}},	//   _जवना_, _कैसेट_, _archivo_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x99f4b012,0x14439015,0x526cc023,0xc2d90008}},	//   _você_, _lys_, _dados_, _बेसी_,
   {{0x0ed59006,0x2f2b2006,0x00000000,0x00000000}},	//   _již_, _více__než_, --, --,
   {{0x3465400b,0x42cad018,0xfb8e7014,0x3249700a}},	//   _је__износила_, _bildet_, _उस_, _ijambo_,
   {{0x9444401e,0x00000000,0x00000000,0x00000000}},	//   _ps_, --, --, --,
   {{0x34926020,0x00000000,0x00000000,0x00000000}},	//   _je__sa_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf2d99011,0x00000000,0x00000000,0x00000000}},	// [5a0] _lesen_, --, --, --,
   {{0xa26c5018,0x4a41400b,0xd27ed003,0x00000000}},	//   _oslo_, _једну__државу_, _viene_, --,
   {{0xe4a9b011,0xf7d8000d,0x00000000,0x00000000}},	//   _kedua__dua_, _događaji_, --, --,
   {{0xb27ed003,0xaf539009,0x00000000,0x00000000}},	//   _tiene_, _byť_, --, --,
   {{0x642e600f,0xa4746021,0xa35a900f,0x92026009}},	//   _sebuah__kumpulan_, _som__vi_, _rencana__yang_, _firiem_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x7ee1e00b,0xc2480003,0x00000000,0x00000000}},	//   _општина__се_, _anime_, --, --,
   {{0x72f5f00b,0x146b2015,0x41b83008,0xd3294015}},	//   _veroispo_mesnog_, _jeg__har_, _लिखल_, _og__ikke_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xb141701f,0x00000000,0x00000000,0x00000000}},	//   _बाबूजी_, --, --, --,
   {{0xa42b6013,0x00000000,0x00000000,0x00000000}},	//   _berperan_, --, --, --,
   {{0xe2902017,0x745ed00d,0x00000000,0x00000000}},	//   _neka_, _sudeći__po_, --, --,
   {{0xb340200b,0x00000000,0x00000000,0x00000000}},	//   _licenca_, --, --, --,
   {{0xb26ca00a,0xee351003,0x00000000,0x00000000}},	//   _nabo_, _millones_, --, --,
   {{0x04444004,0x0202600a,0x00000000,0x00000000}},	//   _cz_, _harimo_, --, --,
   {{0x22918013,0xd4b6e00b,0x00000000,0x00000000}},	//   _peran_, _mesto__ma_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [5b0] --, --, --, --,
   {{0x3462c00b,0xb2249017,0x00000000,0x00000000}},	//   _на__једну_, _opaki_, --, --,
   {{0xc236f01b,0x6471e00c,0xc2259006,0x00000000}},	//   _svijet_, _febreiro__de_, _tisk_, --,
   {{0xc278b00b,0x8c714014,0x00000000,0x00000000}},	//   _године__када_, _यह__आपके_, --, --,
   {{0x82c6c011,0xa2905013,0xcafc6021,0x03f9a011}},	//   _menanyak_saya_, _gelar_, _undervis, _jepun_,
   {{0x5291a005,0x7443800a,0x0a15e015,0x0290c011}},	//   _depan_, _fpr_, _forbinde, _kedah_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xdc484008,0x3ee3100b,0x00000000,0x00000000}},	//   _लेके_, _они_, --, --,
   {{0x626ca00a,0xc9f78013,0x4edc601e,0x3e45d00a}},	//   _yabo_, _tionghoa_, _sociales_, _bagaraga,
   {{0x72a69005,0x64ad2015,0x00000000,0x00000000}},	//   _prabu_, _her__for_, --, --,
   {{0x72918012,0x644ce00c,0x1c0ae015,0x00000000}},	//   _geral_, _páxina__de_, _kroppen_, --,
   {{0x037d6017,0xd158400b,0x69f66012,0x00000000}},	//   _vozače_, _међунаро_сарадња_, _março_, --,
   {{0x0c6a100b,0x00000000,0x00000000,0x00000000}},	//   _представ, --, --, --,
   {{0x33961015,0x22919007,0x00000000,0x00000000}},	//   _altså_, _pesan_, --, --,
   {{0x72df501f,0x00000000,0x00000000,0x00000000}},	//   _अबकी_, --, --, --,
   {{0x15395012,0x00000000,0x00000000,0x00000000}},	//   _estadual_, --, --, --,
   {{0x1aabe006,0xfee3200b,0x00000000,0x00000000}},	// [5c0] _základní_, _она_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc477b00b,0x42903003,0x00000000,0x00000000}},	//   _naseljen_je_, _deja_, --, --,
   {{0x7eb8f00b,0x00000000,0x00000000,0x00000000}},	//   _када__се_, --, --, --,
   {{0x5086400b,0x4f18500b,0x00000000,0x00000000}},	//   _pri__lansiran, _да__ли_, --, --,
   {{0x026f700f,0xa290b013,0x00000000,0x00000000}},	//   _digunaka_bagi_, _terkait_, --, --,
   {{0x9b79f014,0xe2318003,0xc394a006,0x00000000}},	//   _की__तुलना_, _primero_, _nejsou_, --,
   {{0x130f900a,0x00000000,0x00000000,0x00000000}},	//   _ikibazo_, --, --, --,
   {{0x72cf3011,0x00000000,0x00000000,0x00000000}},	//   _bandar__raya_, --, --, --,
   {{0xd2d8f015,0x92a6d025,0x34640011,0x00000000}},	//   _regel_, _treba_, _reka__bentuk_, --,
   {{0x1492a015,0xbc37b010,0x72dc200c,0x26c9f008}},	//   _du__har_, _české_, _de__auga_, _बाति_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x7a33e005,0x8492600c,0x63874013,0x12ffd018}},	//   _जरा_, _en__os_, _energi_, _denne__siden_,
   {{0x226a400b,0x7eeaf00b,0x6c89b015,0x3d7f9017}},	//   _firme__koji_, _živi__punoletn, _samtidig_, _na__ljestvic,
   {{0x52d92016,0x6c492014,0x3c1b100e,0x00000000}},	//   _मेरी_, _मेरे_, _vatrogas, --,
   {{0x3bb90014,0x32903012,0x0288e007,0x00000000}},	//   _हैं__जो_, _seja_, _melayani_, --,
   {{0xe46be015,0x6b8da002,0xd3877012,0x00000000}},	// [5d0] _jeg__er_, _आउ_, _quarta_, --,
   {{0xb494e00b,0x9bed7012,0x00000000,0x00000000}},	//   _od__do_, _fevereir, --, --,
   {{0xc3c4f00c,0x62903012,0xa2cbf012,0x00000000}},	//   _de__españa_, _veja_, _ajuda_, --,
   {{0x32cb4017,0x00000000,0x00000000,0x00000000}},	//   _tjedna_, --, --, --,
   {{0x0af52018,0x0bef3014,0x00000000,0x00000000}},	//   _internas, _करें__और_, --, --,
   {{0x127b4009,0xafb96009,0x00000000,0x00000000}},	//   _komentár, _môže__byť_, --, --,
   {{0x72870017,0x0292601b,0x00000000,0x00000000}},	//   _blokove_, _toranj_, --, --,
   {{0x04af0015,0xa251a00b,0xc3e75018,0x00000000}},	//   _men__det_, _od__orbite_, _gått_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xb25ae015,0x32a5800c,0x00000000,0x00000000}},	//   _stille_, _de__xullo_, --, --,
   {{0x03c4300c,0x00000000,0x00000000,0x00000000}},	//   _foi__elixido_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x8b8cb002,0x00000000,0x00000000,0x00000000}},	//   _खा_, --, --, --,
   {{0xf1c7500b,0x84b3d00f,0xe2d9d01f,0x00000000}},	//   _становни_износи_, _didapati__di_, _माटी_, --,
   {{0x927b4012,0xd46de00c,0x00000000,0x00000000}},	//   _comentár, _dicir__que_, --, --,
   {{0xe2d91025,0x00000000,0x00000000,0x00000000}},	//   _jozef_, --, --, --,
   {{0x2fa30003,0x32569009,0x0290c00b,0x00000000}},	// [5e0] _director_, _júl_, _dodaj_, --,
   {{0x9780700b,0x00000000,0x00000000,0x00000000}},	//   _je__jugoslov, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc46ce00c,0xde381007,0xfebbd017,0x1280b006}},	//   _foi__un_, _kecamata, _nogometn, _diskuze_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x4e9bf00b,0x2eced00b,0x2eee600b,0x00000000}},	//   _површини__од_, _му__је_, _је__до_, --,
   {{0x2f37600b,0x52905023,0x00000000,0x00000000}},	//   _од__до_, _dela_, --, --,
   {{0xd44a1007,0x92d87003,0xe4ac6015,0x180a201f}},	//   _karena__itu_, _tener_, _det__du_, _बुढ़िया_,
   {{0xd291b00a,0x00000000,0x00000000,0x00000000}},	//   _umwana_, --, --, --,
   {{0x7ba81014,0x5dbe1018,0x02d8c012,0x00000000}},	//   _है__तो_, _russland_, _podem_, --,
   {{0x94a6e007,0x13d14009,0x9c8e900c,0x126dc01e}},	//   _bahwa__ia_, _partneri_, _anos__despois_, _vivo_,
   {{0x6b97400c,0xa45d300b,0x80368008,0x00000000}},	//   _bibliogr_ligazóns_, _istočnom__delu_, _घुरहु_, --,
   {{0x6480500c,0xd2914017,0xf3ff700a,0x03f46011}},	//   _unha__de_, _zadanu_, _ubuzima_, _pautan_,
   {{0x0a7ad014,0xd4f4b012,0x00000000,0x00000000}},	//   _तुलना__में_, _acompanh, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x20946006,0xca32b008,0xf691900d,0x00000000}},	//   _nabízí_, _खाय_, _generaci, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [5f0] --, --, --, --,
   {{0x92b4d00e,0x00000000,0x00000000,0x00000000}},	//   _djece_, --, --, --,
   {{0x822fc007,0x13ebe018,0xd2927012,0x00000000}},	//   _ini__memiliki_, _nytt_, _gerais_, --,
   {{0xe4936015,0xd52f500a,0x00000000,0x00000000}},	//   _du__er_, _ubuyoboz, --, --,
   {{0x12905012,0x525ad018,0xc291d013,0x00000000}},	//   _pela_, _vanlig_, _hewan_, --,
   {{0x22ba6011,0x00000000,0x00000000,0x00000000}},	//   _golongan__alam_, --, --, --,
   {{0x144e9009,0xcb6bb011,0x14cba00b,0x00000000}},	//   _sú_, _di__bahagian_, _документ, --,
   {{0xf33af00c,0x1bab2014,0x3d57000b,0x00000000}},	//   _de__galicia_, _का__एक_, _kao__korišten_, --,
   {{0x84783007,0xe2d9f011,0xc224c009,0x78e9f018}},	//   _ditemuka_di_, _negeri__pulau_, _celkom_, _leksikog,
   {{0xeeb5c004,0xa2d58006,0x00000000,0x00000000}},	//   _prezenta, _všech_, --, --,
   {{0x16f9c01f,0x00000000,0x00000000,0x00000000}},	//   _भइया_, --, --, --,
   {{0x244e9003,0xadd8500b,0x00000000,0x00000000}},	//   _tú_, _једино__познато_, --, --,
   {{0x726df01e,0x1386c01e,0x00000000,0x00000000}},	//   _estos_, _madre_, --, --,
   {{0x8324f007,0x53f8300f,0x00000000,0x00000000}},	//   _dibagi__menjadi_, _semula_, --, --,
   {{0x9be9002d,0x00000000,0x00000000,0x00000000}},	//   _अमेरिकी_, --, --, --,
   {{0xb2005011,0x00000000,0x00000000,0x00000000}},	//   _polis_, --, --, --,
   {{0x95fc903c,0xd387c012,0x41744009,0x00000000}},	// [600] _प्रथम_, _livre_, _galéria_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x633ed00c,0xf41e100c,0x00000000,0x00000000}},	//   _ás__veces_, _licenza__resumo_, --, --,
   {{0xe2780013,0x37f1f006,0x00000000,0x00000000}},	//   _bisnis_, _rozšířen, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xca336008,0xf313e013,0x00000000,0x00000000}},	//   _कहल_, _mencoba_, --, --,
   {{0x7410400c,0x93866003,0x53430012,0x9eb30012}},	//   _notas__véxase_, _ahora_, _direito_, _direitos_,
   {{0x148f600c,0x92905003,0xea6b800b,0xee1b800b}},	//   _de__km_, _ella_, _су__били_, _су__биле_,
   {{0x52d8700a,0xc495200c,0x40f25008,0x0b625014}},	//   _bene_, _se__non_, _बनावे_, _बनाने_,
   {{0xaa3d2041,0x6465a00d,0x00000000,0x00000000}},	//   _होत_, _na__površini_, --, --,
   {{0x4291a00b,0x9320d013,0x53ea900a,0x00000000}},	//   _treće__kolo_, _proyek_, _amata_, --,
   {{0xcc51e017,0x2229a00b,0x14799015,0x00000000}},	//   _erotska_, _satelit__orbitu_, _probleme_med_, --,
   {{0x29456003,0x00000000,0x00000000,0x00000000}},	//   _alquiler_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x11b91008,0x2224c006,0x00000000,0x00000000}},	//   _दिहल_, _celkem_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x3bcc6014,0x00000000,0x00000000,0x00000000}},	// [610] _इसी_, --, --, --,
   {{0x148d202b,0x648e600c,0x4452300b,0x00000000}},	//   _de__foi_, _da__de_, _može__da_, --,
   {{0x04708011,0x2399200e,0x00000000,0x00000000}},	//   _bagi__kegunaan_, _na__temelju_, --, --,
   {{0x4200b01e,0xf40c5009,0x00000000,0x00000000}},	//   _decir_, _aktuálne_, --, --,
   {{0x027e9003,0xc4b4600c,0x00000000,0x00000000}},	//   _juan_, _por__en_, --, --,
   {{0x5a34d00b,0xc38b1011,0x00000000,0x00000000}},	//   _je__iznosila_, _untuk__rencana_, --, --,
   {{0x4344a015,0x5b64a027,0xc452a00b,0x52fe6013}},	//   _adresse_, _adressen_, _opština__okrugu_, _dirilis_,
   {{0x0ea6300b,0x5290700a,0x00000000,0x00000000}},	//   _површина__општине_, _sena_, --, --,
   {{0xde85a00b,0xb443f00a,0xc2684012,0x26f96008}},	//   _је__општина_, _uyu_, _produção_, _देला_,
   {{0x71cda006,0xfa4da006,0x00000000,0x00000000}},	//   _všechny_, _všechna_, --, --,
   {{0x7e38a003,0x00000000,0x00000000,0x00000000}},	//   _entonces_, --, --, --,
   {{0x7ef1500b,0xe4b4100c,0x00000000,0x00000000}},	//   _град__се_, _poden__ser_, --, --,
   {{0x73ceb011,0x00000000,0x00000000,0x00000000}},	//   _dalam__tinggal_, --, --, --,
   {{0x5248600a,0xd23b500b,0xdad2e00a,0x00000000}},	//   _ngoma_, _još__uvek_, _ubuteget, --,
   {{0xe3f9a00a,0x00000000,0x00000000,0x00000000}},	//   _yavuze_, --, --, --,
   {{0x13506011,0x89e86006,0x00000000,0x00000000}},	//   _juga__boleh_, _samozřej, --, --,
   {{0x99fdc00f,0x225bd00b,0x00000000,0x00000000}},	// [620] _selain__daripada_, _su__etnički_, --, --,
   {{0xa200c010,0x00000000,0x00000000,0x00000000}},	//   _hodin_, --, --, --,
   {{0xdf3f8010,0x4497a017,0xe3eba00b,0xc4ace01e}},	//   _विभिन्न_, _lansiraj, _да__буде_, _con__un_,
   {{0x8b8fe01c,0x7bee200b,0xf011f006,0x00000000}},	//   _दो_, _само_, _potřebuj, --,
   {{0xb3ead023,0x526d2003,0x00000000,0x00000000}},	//   _voltar_, _mayo_, --, --,
   {{0x344d8006,0xc4b3500d,0xf3696012,0x3e9f600b}},	//   _kč_, _gradu__je_, _imagens_, _има__на_,
   {{0x02cf8009,0x22499013,0x535ca008,0xc8ab8015}},	//   _podobne_, _resmi_, _सकेला_, _nødvendi,
   {{0x626d200a,0xe0fc900c,0xc32d2011,0xd3871013}},	//   _nayo_, _galego__traxecto, _sedaya__upaya_, _pabrik_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x24b91015,0xf2a7700a,0x0eae1011,0x00000000}},	//   _ikke__kan_, _ntabwo_, _syarikat_, --,
   {{0xa091400b,0xaa339008,0x00000000,0x00000000}},	//   _надморск_висини_, _अउर_, --, --,
   {{0x72d80003,0xee70a00b,0xabcc6014,0x00000000}},	//   _quien_, _треба__да_, _इसे_, --,
   {{0xb3805005,0xd310500f,0x64e7e00b,0x32a9b021}},	//   _yang__dikenal_, _yang__dikenali_, _dani__sećanja_, _du__skal_,
   {{0xe3e6e006,0x00000000,0x00000000,0x00000000}},	//   _být_, --, --, --,
   {{0x625a200e,0x0c4e801f,0x26919003,0x7357401e}},	//   _rekla_, _चलीं_, _benefici, _agregar_,
   {{0x8d6f3021,0x046de018,0xa3874019,0x00000000}},	//   _kommenta, _noe__som_, _tierra_, --,
   {{0x327e2005,0x03ed3009,0xd6f9f008,0x55d11009}},	// [630] _yakni_, _kozmetik, _बिया_, _nemôžete_,
   {{0xe4ad6015,0xf35ef00f,0x7b618008,0x00000000}},	//   _kan__du_, _bermula__dengan_, _दहिने_, --,
   {{0x334c5017,0x12d8a003,0x00000000,0x00000000}},	//   _raketom_, _debe_, --, --,
   {{0xe46be020,0xe2dfb002,0x00000000,0x00000000}},	//   _ima__na_, _लौकी_, --, --,
   {{0x32b91011,0x00000000,0x00000000,0x00000000}},	//   _rencana__adalah_, --, --, --,
   {{0xe4ace015,0x62d82024,0x6627600a,0x4967600a}},	//   _har__du_, _enkel_, _minisiti, _minisite,
   {{0xc4ace015,0x5275700d,0x7c4e2014,0x00000000}},	//   _med__en_, _od__preko_, _घंटे_, --,
   {{0xbbcc7014,0xea336008,0x1ad2101f,0x6b98a014}},	//   _उसे_, _कहत_, _खर्चा_, _को__भी_,
   {{0xe277001d,0x0be52014,0x00000000,0x00000000}},	//   _untuk__menambah_, _से__कम_, --, --,
   {{0x04968015,0xc3f04007,0xc477900c,0x00000000}},	//   _om__det_, _prasasti_, _converte_en_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x32910017,0x3f41900b,0xaeea4002,0x00000000}},	//   _spojite_, _планете__земље_, _नाहक_, --,
   {{0x4e60e00b,0x04a30015,0x00000000,0x00000000}},	//   _од_, _når__det_, --, --,
   {{0x22da600a,0x00000000,0x00000000,0x00000000}},	//   _karere_, --, --, --,
   {{0xc28c300a,0x00000000,0x00000000,0x00000000}},	//   _ibihugu_, --, --, --,
   {{0x9a314011,0xf290a009,0x00000000,0x00000000}},	//   _satu__daripada_, _seba_, --, --,
   {{0x1307600c,0x00000000,0x00000000,0x00000000}},	// [640] _que__poden_, --, --, --,
   {{0x3e54300b,0x3753c027,0x00000000,0x00000000}},	//   _налази__на_, _kronolog, --, --,
   {{0x030c500f,0x1e29200b,0x00000000,0x00000000}},	//   _tergolon_dalam_, _као_, --, --,
   {{0x4b2c3005,0xe1b9a008,0xe3ead009,0x5444400a}},	//   _di__kabupate, _मिलल_, _sveta_, _iy_,
   {{0x12d8a017,0x00000000,0x00000000,0x00000000}},	//   _tebe_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x129df00b,0x0abc200b,0xc4ac6015,0x735fb00a}},	//   _za__vreme_, _masa__satelita_, _det__en_, _abagore_,
   {{0x647a500c,0xddbd5017,0x9683e014,0x00000000}},	//   _nado__de_, _ispalite_, _दौरान_, --,
   {{0xc81fc018,0x625ad018,0x0347300a,0x00000000}},	//   _er__tilgjeng, _hellas_, _kumenya_, --,
   {{0x8a336016,0x7f79f010,0x00000000,0x00000000}},	//   _कहा_, _možná_, --, --,
   {{0xa4444021,0xb453700b,0x42249018,0x00000000}},	//   _ny_, _orbitu__oko_, _dekker_, --,
   {{0x7ab00014,0xced60029,0x00000000,0x00000000}},	//   _सकते__हैं_, _možno_, --, --,
   {{0xd444400a,0x0200b00e,0x00000000,0x00000000}},	//   _ay_, _reci_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf444400a,0x00000000,0x00000000,0x00000000}},	//   _cy_, --, --, --,
   {{0xfefc700c,0x00000000,0x00000000,0x00000000}},	//   _cordial__saúdo_, --, --, --,
   {{0xcf57200d,0xa6ffb008,0x4200b009,0x00000000}},	// [650] _vidi__još_, _एकरा_, _veci_, --,
   {{0x437a6029,0x00000000,0x00000000,0x00000000}},	//   _zadarmo_, --, --, --,
   {{0xfa3c9008,0x00000000,0x00000000,0x00000000}},	//   _लीं_, --, --, --,
   {{0x7c7ba014,0x530ba014,0x00000000,0x00000000}},	//   _करने__वाले_, _करने__वाली_, --, --,
   {{0x13cd200b,0x72a13009,0x00000000,0x00000000}},	//   _postavil_satelit_, _pravidlá_, --, --,
   {{0xcadc7003,0x00000000,0x00000000,0x00000000}},	//   _imágenes_, --, --, --,
   {{0xd2cbf00b,0xcfd3000b,0x00000000,0x00000000}},	//   _ljudi_, _демократ, --, --,
   {{0x9e8ee011,0x4443f00a,0x0da01007,0x96174005}},	//   _mempunya_kelayaka, _uku_, _diantara, _partikel_,
   {{0xc493d00b,0x00000000,0x00000000,0x00000000}},	//   _kosmos__je_, --, --, --,
   {{0x6270f009,0x2eadb00b,0x00000000,0x00000000}},	//   _napríkla, _степеном__је_, --, --,
   {{0x44a8100f,0x00000000,0x00000000,0x00000000}},	//   _sebelum__ini_, --, --, --,
   {{0xe444400a,0x3d061003,0x5436b015,0x04af0015}},	//   _ry_, _reproduc, _de__mest_, _for__det_,
   {{0x0e28e00b,0x944f1012,0x00000000,0x00000000}},	//   _за_, _há_, --, --,
   {{0x4496e00c,0x00000000,0x00000000,0x00000000}},	//   _algúns__dos_, --, --, --,
   {{0xb44f1012,0x82903017,0x054d7015,0x00000000}},	//   _já_, _rujan_, _virksomh, --,
   {{0x36c9f008,0x6b625014,0x00000000,0x00000000}},	//   _बाकि_, _मैंने_, --, --,
   {{0xd44f1012,0xabc02014,0xbf245009,0x00000000}},	// [660] _lá_, _करने__की_, _práve_, --,
   {{0xd46cf00c,0x9ad51018,0x00000000,0x00000000}},	//   _dos__que_, _postadre, --, --,
   {{0x0b8f201c,0xdb8d3042,0x8476d00c,0x02d8c012}},	//   _है_, _टा_, _cara__ao_, _rede_,
   {{0xa27ed003,0x00000000,0x00000000,0x00000000}},	//   _buen_, --, --, --,
   {{0x2ed2500b,0x56978018,0x048d6024,0x73f40013}},	//   _да__је_, _liberali, _de__som_, _justru_,
   {{0xe475d00b,0x026c5006,0x00000000,0x00000000}},	//   _stanovni_toku_, _bylo_, --, --,
   {{0x3290c009,0x46614006,0x00000000,0x00000000}},	//   _veda_, _zaměstna, --, --,
   {{0x544f1012,0xd30f900a,0x54af6006,0xba3dc01f}},	//   _dá_, _ibibazo_, _že__se_, _तोर_,
   {{0x1290c025,0x7320c006,0x00000000,0x00000000}},	//   _teda_, _tedy_, --, --,
   {{0x44a9200c,0x3473e009,0x00000000,0x00000000}},	//   _despois__da_, _ste__sa_, --, --,
   {{0xf291800a,0x524a600a,0x00000000,0x00000000}},	//   _imyaka_, _ubumwe_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x83a8e020,0x00000000,0x00000000,0x00000000}},	//   _je__gradić_, --, --, --,
   {{0xab8f402d,0x00000000,0x00000000,0x00000000}},	//   _रन_, --, --, --,
   {{0xda994014,0x14676018,0x00000000,0x00000000}},	//   _की__अनुमति_, _deg__med_, --, --,
   {{0x9290b020,0x00000000,0x00000000,0x00000000}},	//   _podaci_, --, --, --,
   {{0x7c51c006,0xcf905012,0x00000000,0x00000000}},	// [670] _kultura_, _grátis_, --, --,
   {{0x649a500c,0x00000000,0x00000000,0x00000000}},	//   _máis__de_, --, --, --,
   {{0x2ef7600b,0x7387c012,0x00000000,0x00000000}},	//   _примећен__је_, _livro_, --, --,
   {{0x927f700a,0xc4b25015,0x9b55301b,0x00000000}},	//   _uganda_, _eller__en_, _kormilar, --,
   {{0x83ea3009,0xa386d012,0xb4b1900c,0x237d400a}},	//   _tejto_, _quer_, _de__decembro_, _rusange_,
   {{0x144f1010,0x00000000,0x00000000,0x00000000}},	//   _pá_, --, --, --,
   {{0x22d91012,0xf3d0d00b,0x28d54007,0x00000000}},	//   _vezes_, _nadmorsk, _pegunung, --,
   {{0x0443f00a,0xf3a2c005,0xb3ef6015,0x00000000}},	//   _ubu_, _kompas_, _med__andre_, --,
   {{0x0bb01014,0xbdcec00b,0x00000000,0x00000000}},	//   _लोगों__को_, _видео_, --, --,
   {{0x544f1009,0xe3f41017,0x6298200b,0x00000000}},	//   _tá_, _loptom_, _na__primer_, --,
   {{0xbbefb010,0x00000000,0x00000000,0x00000000}},	//   _pardubic, --, --, --,
   {{0x727f8017,0xaf5a3012,0x62bf9011,0x02d9d00a}},	//   _mirna_, _pesquisa, _mengatak_bahawa_, _umwe_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xaaa1a011,0x00000000,0x00000000,0x00000000}},	//   _semua__pengguna_, --, --, --,
   {{0x2eea600b,0x00000000,0x00000000,0x00000000}},	//   _био__је_, --, --, --,
   {{0xbc4f501c,0x00000000,0x00000000,0x00000000}},	//   _अपने_, --, --, --,
   {{0x2af2a01b,0x00000000,0x00000000,0x00000000}},	// [680] _izgradit, --, --, --,
   {{0x6212d012,0xb26de00f,0xb27f4003,0x00000000}},	//   _mulher_, _orang__asli_, _tienda_, --,
   {{0x82e5f007,0x03ac6013,0xa6103009,0x00000000}},	//   _lainnya_, _maupun_, _hľadám_, --,
   {{0x027ff02c,0xfcf1800a,0x00000000,0x00000000}},	//   _bruno_, _igiteker, --, --,
   {{0xa2bd0011,0x177c2017,0xf291801d,0x22014013}},	//   _bukan__sahaja_, _sudjelov, _perak_, _hadits_,
   {{0xea3d201f,0x4a4db014,0xfaffe012,0x00000000}},	//   _होई_, _के__बीच_, _imóveis_, --,
   {{0x2cace014,0x4200601e,0x4e86e00b,0x00000000}},	//   _का__उपयोग_, _julio_, _се__не_, --,
   {{0xa387f007,0x00000000,0x00000000,0x00000000}},	//   _putri_, --, --, --,
   {{0xd3445006,0x400ac006,0x00000000,0x00000000}},	//   _recenze_, _několik_, --, --,
   {{0x3444400a,0xc2918012,0x82127012,0x72d70003}},	//   _nk_, _foram_, _senha_, _antonio_,
   {{0x5d12f00b,0x00000000,0x00000000,0x00000000}},	//   _их_, --, --, --,
   {{0x64444009,0xf4866014,0x23958015,0x00000000}},	//   _ak_, _द्वारा_, _lars_, --,
   {{0x52cc7005,0xe3ea701e,0xe493600c,0x39d6100c}},	//   _rata__rata_, _venta_, _na__na_, _con__habitant,
   {{0xa4926015,0x00000000,0x00000000,0x00000000}},	//   _en__ny_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xa30d100f,0x00000000,0x00000000,0x00000000}},	//   _melayu__yang_, --, --, --,
   {{0x7421f027,0x00000000,0x00000000,0x00000000}},	// [690] _politikk, --, --, --,
   {{0x6496e015,0x82dfa00c,0x00000000,0x00000000}},	//   _om__de_, _en__xeral_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xb4a6903d,0x1a086017,0xc4ace015,0x7a4e8014}},	//   _स्वास्थ्, _uništi_, _har__en_, _गए__हैं_,
   {{0x02c5e00f,0x92ba5013,0x00000000,0x00000000}},	//   _pada__dalam_, _kondisi_, --, --,
   {{0x990c9006,0x00000000,0x00000000,0x00000000}},	//   _úvodní_, --, --, --,
   {{0x39b9600c,0x044f5015,0xb2575015,0x00000000}},	//   _tiña__habitant, _må_, _mål_, --,
   {{0x506e000b,0x3306900c,0x00000000,0x00000000}},	//   _delu__centraln, _unha__banda_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x72011006,0x5291100a,0x52007003,0xbbbac014}},	//   _mezi_, _meza_, _junio_, _साइट__पर_,
   {{0x84444025,0xe40c3006,0x00000000,0x00000000}},	//   _sk_, _může__být_, --, --,
   {{0x633ef007,0x8eb8e00b,0x6e28e00b,0x3e52d011}},	//   _yang__berarti_, _си_, _са_, _adalah__berkenaa,
   {{0x22b56011,0xa9964006,0x6291100a,0xe224e018}},	//   _apa__anda_, _může_, _neza_, _lenker_,
   {{0x12fe601d,0x34936009,0x46f9f016,0x69c5f00c}},	//   _orang__melayu_, _by__sa_, _मेरा_, _en__entidade,
   {{0x744f5018,0x6291500a,0x9348d005,0xf2921017}},	//   _då_, _kagame_, _setelah_, _srpanj_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [6a0] --, --, --, --,
   {{0x944f5015,0x8496e006,0x7e9a500b,0x00000000}},	//   _få_, _se__ve_, _што__се_, --,
   {{0xa44f5015,0x42921017,0x0bcee016,0x00000000}},	//   _gå_, _lipanj_, _पढे_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc6fa6002,0xc7c72012,0x1b9c2016,0x0b9de014}},	//   _पिया_, _mensagem_, _की__एक_, _शामिल__है_,
   {{0x7ee8600b,0x00000000,0x00000000,0x00000000}},	//   _где__се_, --, --, --,
   {{0xaeee600b,0x139cb00d,0x53d61015,0x00000000}},	//   _је__то_, _objašnje, _et__stort_, --,
   {{0xf26dc003,0xb2907005,0x4442000a,0xa3ea000a}},	//   _favor_, _sunan_, _ndi_, _afite_,
   {{0x8236d013,0x4292500d,0xd3ba001e,0x00000000}},	//   _merupaka_bagian_, _metara_, _informac_sobre_, --,
   {{0x22020007,0x2e95600b,0x00000000,0x00000000}},	//   _posisi_, _јер__је_, --, --,
   {{0x327fa017,0x2c7c8007,0xd26df003,0x00000000}},	//   _lupni_, _kristen_, _estoy_, --,
   {{0x2444400a,0x42fce024,0x5f666015,0x00000000}},	//   _ab_, _gangen_, _svært_, --,
   {{0x644f5021,0x6315b011,0x547a1018,0x00000000}},	//   _så_, _sambil__belajar_, _informas_om_, --,
   {{0x344f5015,0x54b06018,0x00000000,0x00000000}},	//   _på_, _mer__om_, --, --,
   {{0x526d9003,0x00000000,0x00000000,0x00000000}},	//   _paso_, --, --, --,
   {{0x21814008,0x7a0c900b,0x00000000,0x00000000}},	//   _रहुवे_, _од__којих_, --, --,
   {{0xb495e018,0x00000000,0x00000000,0x00000000}},	// [6b0] _sa__at_, --, --, --,
   {{0x84444003,0x00000000,0x00000000,0x00000000}},	//   _gb_, --, --, --,
   {{0x9396600a,0x914b3003,0x03e43020,0x00000000}},	//   _arusha_, _correspo, _je__srpski_, --,
   {{0x42caf015,0x64af6015,0x65765012,0x00000000}},	//   _kunder_, _for__de_, _publicaç, --,
   {{0x448ca011,0xa37ca022,0x1a10401d,0x6f21000b}},	//   _portal__ini_, _durante_, _malaysia_, _naseljen,
   {{0xaaa1a014,0xd6fed01f,0x52b4d00e,0x00000000}},	//   _आपके__लिए_, _चंदा_, _djeca_, --,
   {{0xd3edb010,0x00000000,0x00000000,0x00000000}},	//   _kosmetik, --, --, --,
   {{0x22d51006,0x00000000,0x00000000,0x00000000}},	//   _vše_, --, --, --,
   {{0xd48cf00c,0x2292001d,0x00000000,0x00000000}},	//   _da__que_, _kepada_, --, --,
   {{0x94637014,0xf4aba015,0x526df009,0x00000000}},	//   _कंपनियों_, _det__var_, _predchád, --,
   {{0xe46de018,0x00000000,0x00000000,0x00000000}},	//   _hva__du_, --, --, --,
   {{0x44444004,0x9250900b,0x00000000,0x00000000}},	//   _sb_, _slika__slika_, --, --,
   {{0xd46bb00c,0x92a62003,0x2b8c9016,0x72127012}},	//   _mentres__que_, _nombre_, _गए_, _tenho_,
   {{0x3314a00c,0xb3f46018,0x29f9d012,0x2bc2e014}},	//   _da__banda_, _setter_, _ação_, _किए__गए_,
   {{0x513c1006,0xc40a5011,0x32a6201e,0x00000000}},	//   _poslední_, _dalam__tempoh_, _hombre_, --,
   {{0x1eccc00c,0x00000000,0x00000000,0x00000000}},	//   _ligazóns__externas_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [6c0] --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x96ffb002,0x00000000,0x00000000,0x00000000}},	//   _एकटा_, --, --, --,
   {{0x9301f00b,0xcd3ea006,0xee88500b,0x00000000}},	//   _detaljni_podaci_, _navigace_, _да__га_, --,
   {{0x1437a00c,0x00000000,0x00000000,0x00000000}},	//   _ao__norte_, --, --, --,
   {{0xd3ea7024,0x129e700b,0x00000000,0x00000000}},	//   _bente_, _to__vreme_, --, --,
   {{0xe4ac6015,0xd4b9600d,0x00000000,0x00000000}},	//   _det__er_, _vrste__su_, --, --,
   {{0xb9f40014,0x00000000,0x00000000,0x00000000}},	//   _का__प्रयास_, --, --, --,
   {{0x3e5b600b,0x00000000,0x00000000,0x00000000}},	//   _објашњењ_на_, --, --, --,
   {{0x02a6900a,0x00000000,0x00000000,0x00000000}},	//   _akaba_, --, --, --,
   {{0x6b8ea016,0xb270e00c,0x00000000,0x00000000}},	//   _वह_, _por__medio_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x4e7df00b,0x00000000,0x00000000,0x00000000}},	//   _висини__од_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x8f1fb003,0xbfb61006,0xcdbbb003,0x00000000}},	//   _particip, _ještě_, _búsqueda_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [6d0] --, --, --, --,
   {{0xf2f76004,0xb495e009,0x00000000,0x00000000}},	//   _जरुरी_, _sa__do_, --, --,
   {{0xcadbc008,0x00000000,0x00000000,0x00000000}},	//   _मेहरारू_, --, --, --,
   {{0xe54b500c,0x00000000,0x00000000,0x00000000}},	//   _parroqui_concello_, --, --, --,
   {{0x43ca0011,0x5df5e006,0x06833002,0x00000000}},	//   _merupaka_biasa_, _představ, _संतान_, --,
   {{0xb2b9c006,0x726d9012,0xb2cec020,0x5212b003}},	//   _více_, _isso_, _na__kopnu_, _hecho_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x547cd00c,0xc236601b,0xb2ede00b,0x75234005}},	//   _onde__se_, _broj_, _godine__poslednj, _pernikah,
   {{0x9260c01e,0x42026015,0x33548003,0xc4bad015}},	//   _años_, _skrive_, _mujeres_, _ikke__en_,
   {{0x129e700c,0x00000000,0x00000000,0x00000000}},	//   _un__filme_, --, --, --,
   {{0xa387e025,0x00000000,0x00000000,0x00000000}},	//   _nitra_, --, --, --,
   {{0x3366a013,0x6a3d2008,0x00000000,0x00000000}},	//   _tanggal_, _हईं_, --, --,
   {{0x163f3006,0x00000000,0x00000000,0x00000000}},	//   _komentář_, --, --, --,
   {{0x53171017,0xc20d9005,0x00000000,0x00000000}},	//   _pizzu_, _sehari__hari_, --, --,
   {{0xa3e72009,0xd2d4501e,0x00000000,0x00000000}},	//   _ešte_, _ciudad_, --, --,
   {{0x1c0c1014,0x00000000,0x00000000,0x00000000}},	//   _लिए__एक_, --, --, --,
   {{0xd1e13014,0xf34c6017,0x1b8cb008,0x32007013}},	// [6e0] _हमारे_, _tijekom_, _कए_, _etnis_,
   {{0xc248900a,0xcfa3200f,0x92b4d00e,0x24aca021}},	//   _inama_, _boleh__digunaka, _djecu_, _man__kan_,
   {{0x427ed003,0x72a0200e,0x32cdf018,0x6a98a018}},	//   _bien_, _svijetu_, _er__noen_, _transaks,
   {{0x0c140027,0x527ed009,0x2edd600b,0xb495e009}},	//   _gruppen_, _cien_, _године__је_, _sa__to_,
   {{0x66c96043,0x844f8019,0x00000000,0x00000000}},	//   _देखि_, _sé_, --, --,
   {{0x8386d018,0x00000000,0x00000000,0x00000000}},	//   _eier_, --, --, --,
   {{0x0bb92014,0x42bff009,0x1e00f013,0x00000000}},	//   _हैं__और_, _po__celom_, _kesehata, --,
   {{0xe96b800b,0xe4b56018,0x00000000,0x00000000}},	//   _од__метара_, _vet__du_, --, --,
   {{0xc2906011,0x862ac018,0x00000000,0x00000000}},	//   _julai_, _navigeri, --, --,
   {{0x19f8c017,0x944f8006,0x7eb3f00b,0x5236d009}},	//   _odlična_, _té_, _која__се_, _svojom_,
   {{0x9c75b044,0x2386d00a,0xcc45e013,0xd972c003}},	//   _निर्णय_, _mbere_, _kompetis, _opinione,
   {{0x7394b009,0xa047300b,0x00000000,0x00000000}},	//   _mieste_, _текст_, --, --,
   {{0x7a3d2014,0x7f80701d,0x00000000,0x00000000}},	//   _हैं_, _yang__tergolon, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf44b000b,0x99a5f00c,0x326de023,0x72902018}},	//   _srednjoj__nadmorsk, _por__primeira_, _mato_, _boka_,
   {{0x025a5015,0x1c631012,0x00000000,0x00000000}},	//   _rolle_, _assunto_, --, --,
   {{0x6470600c,0x00000000,0x00000000,0x00000000}},	// [6f0] _rei__de_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x42d85015,0xc29f7007,0x0b57f009,0x53f99013}},	//   _bilen_, _berbagai_, _kultúra_, _yesus_,
   {{0x6bab1014,0x13ce9015,0x00000000,0x00000000}},	//   _कि__आप_, _krav_, --, --,
   {{0xe2d87018,0x99f65006,0x826de00a,0x00000000}},	//   _innen_, _zatím_, _bato_, --,
   {{0x0fd1c00f,0x00000000,0x00000000,0x00000000}},	//   _walau__bagaiman, --, --, --,
   {{0xa26de015,0x1778d014,0x00000000,0x00000000}},	//   _dato_, _पोस्ट__किया_, --, --,
   {{0x3b8ed008,0xa22f300b,0xe2d83012,0x00000000}},	//   _एह_, _grafik__promene_, _hoje_, --,
   {{0x02903017,0x00000000,0x00000000,0x00000000}},	//   _koja_, --, --, --,
   {{0xe2d94003,0xd26de00a,0x00000000,0x00000000}},	//   _videos_, _gato_, --, --,
   {{0x22903009,0x94b0200c,0x4340e013,0x00000000}},	//   _moja_, _non__sei_, _telepon_, --,
   {{0xb220c013,0x12903012,0x3290e009,0x00000000}},	//   _catatan__kaki_, _loja_, _trnava_, --,
   {{0xee28e00b,0x5ed96019,0xb4d6d008,0x72902009}},	//   _да_, _noticias_, _जिनिगी_, _roka_,
   {{0xeb8fd002,0x7368401d,0x131ea011,0x00000000}},	//   _सन_, _seperti__berikut_, _menyumba_sambil_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x9405c00b,0xb27e9003,0x0427a007,0x00000000}},	// [700] _je__živelo_, _gran_, _yang__saat_, --,
   {{0xbc74301e,0x62c22011,0x00000000,0x00000000}},	//   _saludos_, _menyatak_bahawa_, --, --,
   {{0x5075300b,0xfaa35014,0xb28cb014,0x00000000}},	//   _из__године_, _आपके__पास_, _उन्होंने_, --,
   {{0x5342a011,0x00000000,0x00000000,0x00000000}},	//   _jeneral_, --, --, --,
   {{0x5a32b002,0x5a60b012,0x00000000,0x00000000}},	//   _खाई_, _preços_, --, --,
   {{0xbf34d00a,0x00000000,0x00000000,0x00000000}},	//   _uburenga, --, --, --,
   {{0x13096011,0x144fc006,0x69226008,0x00000000}},	//   _anda__boleh_, _jí_, _ओहिजा_, --,
   {{0x9f286017,0x13e7c006,0xeb9fc012,0x444fc003}},	//   _također_, _mít_, _dinheiro_, _mí_,
   {{0xa26de010,0xc497600b,0xc9f4c006,0xf291800a}},	//   _tato_, _on__je_, _lidé_, _kera_,
   {{0x32cad006,0x00000000,0x00000000,0x00000000}},	//   _prodej_, --, --, --,
   {{0x544fc006,0x12904027,0x440c7006,0x00000000}},	//   _ní_, _koma_, _aktuální_, --,
   {{0xa91bc00b,0x00000000,0x00000000,0x00000000}},	//   _je__asteroid, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x44426006,0xd3695013,0x00000000,0x00000000}},	//   _kdo_, _inggris_, --, --,
   {{0x52d84012,0x92bcb008,0x82cd9007,0x62e3e020}},	//   _nome_, _पारुल_, _bagian__barat_, _iz__kada_,
   {{0x5a4d3014,0x00000000,0x00000000,0x00000000}},	// [710] _के__समय_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2b8fd014,0x1bb2c014,0xf3259011,0x00000000}},	//   _थी_, _नहीं__कर_, _berbandi_dengan_, --,
   {{0xed6d300b,0xf3f92009,0x00000000,0x00000000}},	//   _што_, _albumy_, --, --,
   {{0x86cef015,0x00000000,0x00000000,0x00000000}},	//   _behandli, --, --, --,
   {{0x82fda015,0xaebdb009,0x22bee011,0x8a640011}},	//   _forhold_, _hodnoten, _upaya__anda_, _nama__sainsnya_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xd498e00c,0xd0a92011,0x046c6018,0xc237400c}},	//   _máis__que_, _dan__kemudian, _gjøre__det_, _dos__máis_,
   {{0xec36a009,0xeaa5c018,0x00000000,0x00000000}},	//   _kategóri, _sosialis, --, --,
   {{0x92f59013,0x12d99018,0x72bad017,0x00000000}},	//   _program__studi_, _lese_, _uredski_, --,
   {{0xf863e003,0x00000000,0x00000000,0x00000000}},	//   _artículo, --, --, --,
   {{0xe2905003,0x7399a006,0x938d600c,0x00000000}},	//   _hola_, _místa_, _de__goberno_, --,
   {{0x3e28e00b,0xa44fc003,0x5eb8e00b,0x2444f011}},	//   _на_, _sí_, _ни_, _ialah__haiwan_,
   {{0x2380702c,0x00000000,0x00000000,0x00000000}},	//   _carros_, --, --, --,
   {{0xca33b002,0x7ae85024,0x00000000,0x00000000}},	//   _आँख_, _jacobsen_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x64907018,0x00000000,0x00000000,0x00000000}},	// [720] _av__jml_, --, --, --,
   {{0x9290400a,0x3a61b00b,0x7f80300b,0x2eec700b}},	//   _soma_, _međunaro_saradnja_, _је__имала_, _становни_је_,
   {{0xbbcc6008,0xd2f5e011,0x73f8e009,0xba5c7017}},	//   _इहे_, _senarai__nama_, _ponuka_, _uvjetima_,
   {{0xfa33e002,0x73d8800d,0xb269c01b,0x00000000}},	//   _जाय_, _od__metra_, _dvije__godine_, --,
   {{0x82905009,0xa2005009,0xadd99009,0x6be21014}},	//   _bola_, _boli_, _deň_, _तो__आप_,
   {{0x825af006,0x00000000,0x00000000,0x00000000}},	//   _mailem_, --, --, --,
   {{0x23f9900a,0x00000000,0x00000000,0x00000000}},	//   _yesu_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x247e7017,0x0292400a,0x00000000,0x00000000}},	//   _svjetsko_, _umwami_, --, --,
   {{0xc310f017,0x00000000,0x00000000,0x00000000}},	//   _zeebovu_, --, --, --,
   {{0xf291901e,0x22d5800c,0x00000000,0x00000000}},	//   _cosas_, _máis__grande_, --, --,
   {{0xf3291011,0x22326003,0x826de012,0x6e226003}},	//   _berhampi_dengan_, _miembro_, _isto_, _miembros_,
   {{0xfa33003d,0x6bae9014,0x00000000,0x00000000}},	//   _चयन_, _कोई__भी_, --, --,
   {{0x7a4be014,0x00000000,0x00000000,0x00000000}},	//   _शामिल__हैं_, --, --, --,
   {{0x041d4011,0x00000000,0x00000000,0x00000000}},	//   _rujukan__pautan_, --, --, --,
   {{0xb4429012,0xf31cf007,0xc2cb4017,0x00000000}},	//   _uma_, _menikah__dengan_, _tjedan_, --,
   {{0x14ba1015,0x00000000,0x00000000,0x00000000}},	// [730] _ikke__har_, --, --, --,
   {{0x8387802c,0xc2d9900a,0x33869009,0x00000000}},	//   _carro_, _wese_, _ktorí_, --,
   {{0xc317101d,0x43a33009,0x00000000,0x00000000}},	//   _di__bandar_, _televízi, --, --,
   {{0x6bc2f014,0x82b6300c,0x00000000,0x00000000}},	//   _क्या__आप_, _hai__unha_, --, --,
   {{0x4212b01e,0xa23ea011,0x00000000,0x00000000}},	//   _fecha_, _hasil__usaha_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xcb990014,0x1bee100b,0xf318f011,0x00000000}},	//   _साथ__ही_, _како_, _berbeza__dengan_, --,
   {{0xc446d00c,0xbbcea014,0x0442900a,0xa47c300b}},	//   _finado__en_, _किया__जा_, _nda_, _износила__килограм,
   {{0xa2d7b00c,0xb3869009,0x426de003,0x03c3900b}},	//   _pola__súa_, _ktorý_, _esto_, _на__основу_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc2d6f006,0x9ad29003,0x33f8f009,0x3066d008}},	//   _před_, _contrase, _ponuky_, _कहलसी_,
   {{0xc9a9e00b,0x0352c008,0x9bedf020,0x00000000}},	//   _на__средњој_, _करेला_, _ograniče, --,
   {{0xc566300b,0xf490e015,0x00000000,0x00000000}},	//   _godine__živjelo_, _få__et_, --, --,
   {{0x03eb302c,0x02ca9003,0x96fa4008,0x00000000}},	//   _sexta_, _edad_, _पइसा_, --,
   {{0x76d7f014,0xcbcc7008,0x00000000,0x00000000}},	//   _चाहिए_, _उहे_, --, --,
   {{0x4a32a008,0x8c49d008,0x00000000,0x00000000}},	//   _गइल_, _नइखे_, --, --,
   {{0x72fcd017,0x3be06014,0x00000000,0x00000000}},	// [740] _bloger_, _और__यह_, --, --,
   {{0xc4429004,0x6326a018,0x00000000,0x00000000}},	//   _zda_, _en__annen_, --, --,
   {{0x6c4e1014,0x227e600a,0xf9f47006,0x42d9e018}},	//   _करने_, _mbona_, _jiné_, _leter_,
   {{0x12add00d,0x6b881014,0x00000000,0x00000000}},	//   _je__postavil, _नई_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xd12bb003,0x2c729027,0x00000000,0x00000000}},	//   _servicio, _omtrent_, --, --,
   {{0xebc0a014,0x00000000,0x00000000,0x00000000}},	//   _होने__के_, --, --, --,
   {{0x447a1007,0x00000000,0x00000000,0x00000000}},	//   _saat__ini_, --, --, --,
   {{0x22922013,0x9982e024,0x00000000,0x00000000}},	//   _secara__resmi_, _beskrive, --, --,
   {{0xfbc92014,0x00000000,0x00000000,0x00000000}},	//   _आसानी__से_, --, --, --,
   {{0x146f600b,0xc3c4f021,0x00000000,0x00000000}},	//   _površini__od_, _skal__være_, --, --,
   {{0xc2763005,0x5316900b,0x9f769017,0xba3f500c}},	//   _laki__laki_, _je__takođe_, _je__također_, _de__tamén_,
   {{0x7ce9001b,0xcc79f00b,0x548e600c,0x00000000}},	//   _plastičn, _prosečna__starost_, _da__no_, --,
   {{0x3c071018,0x0afa701b,0x00000000,0x00000000}},	//   _prosent_, _ustuplje, --, --,
   {{0x1454500e,0x00000000,0x00000000,0x00000000}},	//   _iznosi__km_, --, --, --,
   {{0xc2918006,0xe47ab009,0x12f6900c,0x62da600a}},	//   _stran_, _kliknite__na_, _súa__obra_, _gereza_,
   {{0x5a32a01f,0x6e81c011,0x59b5600b,0x12907007}},	// [750] _गेल_, _memudahk_sumbanga, _додатим__степеном_, _lunak_,
   {{0x027e900a,0xd37fd017,0x7354d003,0x00000000}},	//   _cyane_, _povezani__članci_, _quieres_, --,
   {{0x038a000c,0x00000000,0x00000000,0x00000000}},	//   _parroqui_lugares_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x823d9007,0x52dc000c,0x00000000,0x00000000}},	//   _bagian__dari_, _de__finado_, --, --,
   {{0x12fd2013,0x00000000,0x00000000,0x00000000}},	//   _militer_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xe2de2013,0x00000000,0x00000000,0x00000000}},	//   _di__jepang_, --, --, --,
   {{0x7a6e8014,0xe4bad015,0x7b29d012,0x00000000}},	//   _करते__हैं_, _ikke__er_, _justiça_, --,
   {{0x5c61d014,0xb2d9c012,0xcb8f3008,0x00000000}},	//   _कर__सकते_, _deve_, _हँ_, --,
   {{0x226c1012,0x00000000,0x00000000,0x00000000}},	//   _acho_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x0b03400b,0x8543e013,0x00000000,0x00000000}},	//   _površina__opštine_, _berhasil_, --, --,
   {{0x6f3b0007,0xa396601b,0xd9ec5019,0x00000000}},	//   _keluraha, _spusti_, _colombia_, --,
   {{0xc2ae200f,0x00000000,0x00000000,0x00000000}},	//   _kegunaan__lain_, --, --, --,
   {{0xb28cf029,0x00000000,0x00000000,0x00000000}},	// [760] _archív_, --, --, --,
   {{0xa25ac006,0xf2906005,0x00000000,0x00000000}},	//   _podle_, _mulai_, --, --,
   {{0x5a3ca008,0x00000000,0x00000000,0x00000000}},	//   _रउआ_, --, --, --,
   {{0x34d6e002,0x43eae012,0x00000000,0x00000000}},	//   _बढ़िया_, _pontos_, --, --,
   {{0x2e8dd00b,0x43866027,0x00000000,0x00000000}},	//   _космос__је_, _spore_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x53981012,0x93e9000c,0x926d100e,0x00000000}},	//   _nós_, _con__outros_, _subotu_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6201c023,0x1c586015,0x0c51b014,0x00000000}},	//   _envie_, _faktisk_, _पढ़ें_, --,
   {{0x7ae86025,0x73a2c01d,0x00000000,0x00000000}},	//   _založený_, _lumpur_, --, --,
   {{0x84b4e00c,0x12eee018,0x2e96600b,0x00000000}},	//   _son__os_, _kaffi_, _он__је_, --,
   {{0xe27e900a,0x22d9000a,0xfe87100c,0x00000000}},	//   _abana_, _kubera_, _de__xuño_, --,
   {{0x3315a00c,0x42011003,0x00000000,0x00000000}},	//   _de__cando_, _cocina_, --, --,
   {{0xa4b4e00c,0x637f9007,0x7bca5017,0x00000000}},	//   _son__as_, _rahasia_, _animalia__chordata_, --,
   {{0x028d601d,0x00000000,0x00000000,0x00000000}},	//   _perkara_, --, --, --,
   {{0x1291e00a,0xb315e012,0xeb99e014,0xb4cf400b}},	//   _leta_, _usuário_, _की__गई_, _за__време_,
   {{0x0290c023,0x00000000,0x00000000,0x00000000}},	// [770] _ltda_, --, --, --,
   {{0xb442d009,0x5a33e008,0x00000000,0x00000000}},	//   _sme_, _जाव_, --, --,
   {{0xa2d8f015,0xc4956015,0x34429027,0x00000000}},	//   _ingen_, _og__en_, _hva_, --,
   {{0x9245e006,0x00000000,0x00000000,0x00000000}},	//   _dům_, --, --, --,
   {{0x6a329002,0xd2d89017,0x00000000,0x00000000}},	//   _खेत_, _htjela_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xb201e009,0x1291c009,0x00000000,0x00000000}},	//   _deti_, _tovar_, --, --,
   {{0x9ba5b014,0x22918009,0xb7c41023,0x12ca701e}},	//   _है__कि_, _teraz_, _brasilei, _donde_,
   {{0xd442d025,0x9f8b1011,0x00000000,0x00000000}},	//   _ide_, _perlu__mempunya, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xcbddd01f,0x00000000,0x00000000,0x00000000}},	//   _बढिया_, --, --, --,
   {{0x0b99f014,0xe442d006,0xf349f013,0x34b4500b}},	//   _की__ओर_, _jde_, _lisensi_, _galaksij_sa_,
   {{0x93806005,0xc3de4012,0x00000000,0x00000000}},	//   _aturan_, _avaliaçã, --, --,
   {{0x6200c00e,0x00000000,0x00000000,0x00000000}},	//   _vidio_, --, --, --,
   {{0x0bd2d017,0x9c3c100d,0xd2926011,0x32018018}},	//   _spajalic, _je__ograniče, _kerana_, _dorit_,
   {{0x2442d00a,0x00000000,0x00000000,0x00000000}},	//   _nde_, --, --, --,
   {{0x73ead015,0x4b2db00b,0x226d200a,0x1a086024}},	// [780] _kultur_, _густина__насељено, _ibyo_, _humanist,
   {{0xe4420018,0xb9ebe004,0x00000000,0x00000000}},	//   _hei_, _माओवादी_, --, --,
   {{0x827f8018,0x82139009,0x8a570009,0x00000000}},	//   _barna_, _najnovši, _domáce_, --,
   {{0x8258e024,0xb6a47020,0x00000000,0x00000000}},	//   _kontroll, _broju__stanovni, --, --,
   {{0x62603003,0xbeb32003,0x7343201e,0x00000000}},	//   _año_, _derechos_, _derecho_, --,
   {{0xfa3d503b,0x24420023,0x844d100c,0x9bcde008}},	//   _रहन_, _lei_, _relación__ao_, _तनी_,
   {{0xd471b011,0x82d83003,0x00000000,0x00000000}},	//   _lesen__hak_, _mujer_, --, --,
   {{0x44420018,0xb450500b,0x64a8d00c,0x62e67015}},	//   _nei_, _dolazi__do_, _goberno__de_, _din__egen_,
   {{0x43418012,0xc497e006,0x0bf85002,0x9761100b}},	//   _janeiro_, _si__je_, _एलबम_, _је__ограниче,
   {{0xe442d006,0x3bf06014,0x00000000,0x00000000}},	//   _zde_, _में__यह_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x24444012,0x63209013,0xb25a9013,0x00000000}},	//   _ac_, _biaya_, _nuklir_, --,
   {{0x42d8b006,0x8d09e008,0x00000000,0x00000000}},	//   _roce_, _बबुआ_, --, --,
   {{0x549ae00c,0xeae1d00e,0x00000000,0x00000000}},	//   _só__se_, _dopušten, --, --,
   {{0x83ef601d,0x00000000,0x00000000,0x00000000}},	//   _dalam__daerah_, --, --, --,
   {{0x23ee9013,0xc3ea1009,0x00000000,0x00000000}},	//   _di__eropa_, _tohto_, --, --,
   {{0x6f77400b,0x11d0e004,0xad90e012,0x00000000}},	// [790] _jednu__državu_, _telefony_, _telefone_, --,
   {{0x55f0e015,0xaa3cf01c,0x00000000,0x00000000}},	//   _hjemmesi, _शहर_, --, --,
   {{0xd2dc601d,0x00000000,0x00000000,0x00000000}},	//   _di__nama_, --, --, --,
   {{0x238a1009,0x00000000,0x00000000,0x00000000}},	//   _fóre_, --, --, --,
   {{0xccaec00b,0x348ea00c,0x00000000,0x00000000}},	//   _спољашње__везе_, _de__cor_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x62caf005,0xf36f2005,0xa00d5006,0x00000000}},	//   _mundur_, _tingkat_, _proveden, --,
   {{0x13fa5003,0xd2e8a013,0x00000000,0x00000000}},	//   _actual_, _pikiran_, --, --,
   {{0xb469400b,0x93ff2011,0x00000000,0x00000000}},	//   _stanovni_mestu_, _talian__tujuan_, --, --,
   {{0x53874003,0x00000000,0x00000000,0x00000000}},	//   _puerto_, --, --, --,
   {{0xe46de018,0x6321a025,0x00000000,0x00000000}},	//   _hva__er_, _dopyt_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x14444003,0x12414011,0xc48eb003,0xcd030005}},	//   _pc_, _mendafta_oleh_, _de__los_, _terlihat_,
   {{0x3a318002,0x72d85011,0x00000000,0x00000000}},	//   _इज्जत_, _filem_, --, --,
   {{0x32cad018,0x74444012,0x00000000,0x00000000}},	//   _bilder_, _vc_, --, --,
   {{0xcef3800b,0x00000000,0x00000000,0x00000000}},	//   _broj__država_, --, --, --,
   {{0xb26de017,0x4a32b014,0x62366017,0x00000000}},	// [7a0] _što_, _गया_, _spoji_, --,
   {{0x9488e018,0xf4a35006,0x00000000,0x00000000}},	//   _noen__få_, _počasí_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x52d8d029,0x33ebe024,0x2eb8f00b,0x00000000}},	//   _budem_, _dette_, _када__је_, --,
   {{0x32d8c012,0x84ad6018,0x00000000,0x00000000}},	//   _pode_, _kan__ha_, --, --,
   {{0x2c026012,0x7eb4b00b,0x00000000,0x00000000}},	//   _pessoas_, _који__се_, --, --,
   {{0x22f6b005,0xd3f8c00e,0xfbcc6008,0x00000000}},	//   _bahan__bakar_, _vodu_, _इहो_, --,
   {{0xd3234015,0x5200200a,0x00000000,0x00000000}},	//   _de__ikke_, _kuki_, --, --,
   {{0xfbe63014,0xf46ed00b,0x00000000,0x00000000}},	//   _कर__रहे_, _према_, --, --,
   {{0x92cbd012,0xb442000b,0x06fef01f,0x3321800a}},	//   _educação_, _ali_, _टोला_, _buryo_,
   {{0x4c88e004,0xc4420018,0x9a3de01f,0x7d2e4018}},	//   _त्यो_, _bli_, _दीं_, _registre_,
   {{0x64444009,0x3e9da00b,0x00000000,0x00000000}},	//   _aj_, _ограниче_на_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2387f013,0x00000000,0x00000000,0x00000000}},	//   _istri_, --, --, --,
   {{0xa3f87010,0x00000000,0x00000000,0x00000000}},	//   _minut_, --, --, --,
   {{0x1c90b014,0x00000000,0x00000000,0x00000000}},	//   _दोनों_, --, --, --,
   {{0x53eb9009,0xb496e021,0x49cef015,0x6212b01e}},	// [7b0] _mesto_, _om__at_, _forfatte, _noche_,
   {{0xf35c8011,0x00000000,0x00000000,0x00000000}},	//   _boleh__didapati_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xb3d7e015,0xcb1f9011,0x00000000,0x00000000}},	//   _og__andre_, _bahagian_, --, --,
   {{0x63871006,0xf27c3012,0x00000000,0x00000000}},	//   _který_, _necessár, --, --,
   {{0x0278600a,0x7e1b7007,0x00000000,0x00000000}},	//   _umuntu_, _ditemuka, --, --,
   {{0x42b54003,0x4d101003,0x00000000,0x00000000}},	//   _precio_, _encuentr, --, --,
   {{0xd30f7013,0x9f25b012,0x00000000,0x00000000}},	//   _berbeda_, _qualquer_, --, --,
   {{0x33e52013,0x8d8c0017,0x00000000,0x00000000}},	//   _pranala__luar_, _jučer_, --, --,
   {{0xf41ff00b,0x0abe6014,0x14423029,0xdea40006}},	//   _na__nadmorsk, _बारे__में_, _jej_, _řízení_,
   {{0x6a3cd008,0x74444012,0x27bda018,0x00000000}},	//   _एहि_, _rj_, _ytterlig, --,
   {{0x22fd5011,0x649c300c,0x63eb901b,0x00000000}},	//   _usaha__sama_, _xuño__de_, _nesto_, --,
   {{0x6e28e00b,0x8eb8e00b,0x00000000,0x00000000}},	//   _та_, _ти_, --, --,
   {{0x54423025,0xf3f82017,0x04523018,0x00000000}},	//   _nej_, _ruku_, _den__beste_, --,
   {{0x933fb018,0x1fd55006,0x00000000,0x00000000}},	//   _det__gjelder_, _předevší, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x53f8f017,0x7e9e200b,0x3b4b900a,0x00000000}},	// [7c0] _mogu_, _налази__се_, _ubutumwa_, --,
   {{0x5201600a,0x23b3b00e,0x44ad6018,0x0b43b00e}},	//   _kugira_, _čovjek_, _kan__ta_, _čovjeka_,
   {{0xf1be400b,0x94432006,0x2439f00b,0x00000000}},	//   _општине__износи_, _kdy_, _na__svetu_, --,
   {{0x7ef4d00b,0x4c61b00a,0x00000000,0x00000000}},	//   _које__се_, _akarere_, --, --,
   {{0x09f4c006,0x00000000,0x00000000,0x00000000}},	//   _lidí_, --, --, --,
   {{0x7651400b,0x1442d009,0x6d3d9017,0x00000000}},	//   _године__живјело_, _dve_, _povijest_, --,
   {{0x43ea6018,0x00000000,0x00000000,0x00000000}},	//   _flott_, --, --, --,
   {{0x3a4d5014,0x4a737014,0xf2cd4011,0x7e87100c}},	//   _के__साथ_, _किया__गया_, _mempunya_lima_, _de__tiña_,
   {{0x23947012,0xa3f8a007,0x00000000,0x00000000}},	//   _série_, _gedung_, --, --,
   {{0xc49d1015,0x00000000,0x00000000,0x00000000}},	//   _også__en_, --, --, --,
   {{0x5c48f014,0x1494a015,0x00000000,0x00000000}},	//   _सकते_, _og__har_, --, --,
   {{0x4c385009,0xc2cb100e,0x6a563014,0x00000000}},	//   _banská_, _mozda_, _कर__रहा_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xd4902015,0x00000000,0x00000000,0x00000000}},	//   _at__den_, --, --, --,
   {{0x8c4f6014,0x9c8f6014,0x00000000,0x00000000}},	//   _आपके_, _आपको_, --, --,
   {{0x64424012,0x02ff2011,0x00000000,0x00000000}},	//   _nem_, _tidak__faham_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [7d0] --, --, --, --,
   {{0xb496e006,0x078d7014,0x00000000,0x00000000}},	//   _se__do_, _प्रविष्ट, --, --,
   {{0xb4af6033,0xa4424012,0x327f7012,0xd3ead009}},	//   _for__at_, _bem_, _quanto_, _svet_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc4424024,0xb4423009,0xdee5c00b,0xa2ca7024}},	//   _dem_, _tej_, _становни_општина_, _sendt_,
   {{0x4c7d2013,0xa2ee000a,0x00000000,0x00000000}},	//   _stasiun_, _byinshi_, --, --,
   {{0xe4424015,0xfa3ca008,0xf4af6015,0x00000000}},	//   _fem_, _लखन_, _for__et_, --,
   {{0x847ed005,0x42c18009,0xc6b26008,0x00000000}},	//   _kota__di_, _žilina_, _बहुते_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x424bb01f,0xcdb6800a,0x00000000,0x00000000}},	//   _श्वेता_, _abanyama, --, --,
   {{0x049e7027,0x00000000,0x00000000,0x00000000}},	//   _du__må_, --, --, --,
   {{0x03eb9018,0x9e8fb00b,0x00000000,0x00000000}},	//   _beste_, _на__крају_, --, --,
   {{0x2e72800b,0xf30da00b,0x00000000,0x00000000}},	//   _попису__из_, _dati__tabeli_, --, --,
   {{0x52005021,0x5290201b,0x00000000,0x00000000}},	//   _juli_, _nemate_, --, --,
   {{0x8483d011,0xd2b1e013,0x73406011,0x8200500a}},	//   _stub__di_, _bandara_, _dalam__filem_, _muli_,
   {{0x3c4e5016,0x00000000,0x00000000,0x00000000}},	// [7e0] _कैसे_, --, --, --,
   {{0xb4424006,0x1f5d6027,0xd2918003,0xf2ea5012}},	//   _sem_, _komplett_, _otras_, _região_,
   {{0x4476500c,0x5175e012,0x647a500b,0x00000000}},	//   _lugar__da_, _notícias_, _film__iz_, --,
   {{0xb496e006,0x3a334008,0x0a3e4008,0x00000000}},	//   _se__to_, _कइल_, _भईल_, --,
   {{0xea4d6014,0xea32b01f,0x92907006,0xe4424012}},	//   _के__बाद_, _खतम_, _jinak_, _vem_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc4425003,0xc4424012,0x2c4e101c,0x99207006}},	//   _del_, _tem_, _करते_, _mobilní_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x93e51009,0x2eec900b,0x00000000,0x00000000}},	//   _podmienk, _лансирањ_је_, --, --,
   {{0xfdca2017,0x00000000,0x00000000,0x00000000}},	//   _naselje__općini_, --, --, --,
   {{0x4394e013,0x00000000,0x00000000,0x00000000}},	//   _konser_, --, --, --,
   {{0x876d6003,0x00000000,0x00000000,0x00000000}},	//   _converti, --, --, --,
   {{0xe4be6015,0x1b8fc002,0xe48b6015,0x00000000}},	//   _hvis__du_, _तँ_, _kommer__til_, --,
   {{0xd25b700b,0xae7d500c,0xb277f00b,0x00000000}},	//   _promene__broja_, _de__millóns_, _zapadnoj__godine_, --,
   {{0xb3334011,0xb2c43013,0x00000000,0x00000000}},	//   _penyelia__senarai_, _televisi_, --, --,
   {{0x81ec9008,0xa2011011,0x00000000,0x00000000}},	//   _तोहरा_, _muzik_, --, --,
   {{0x632c4006,0x649e7015,0xe2e7c00c,0x00000000}},	// [7f0] _těchto_, _er__så_, _de__dúas_, --,
   {{0xff298025,0x349e7015,0x00000000,0x00000000}},	//   _bratisla, _er__på_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xe4956015,0x00000000,0x00000000,0x00000000}},	//   _og__er_, --, --, --,
   {{0xc321900c,0x2f77f012,0x00000000,0x00000000}},	//   _máis__tarde_, _faça_, --, --,
   {{0x0c271017,0x59f3601e,0x00000000,0x00000000}},	//   _vanjske__poveznic, _constitu, --, --,
   {{0xe4425015,0x00000000,0x00000000,0x00000000}},	//   _vel_, --, --, --,
   {{0x9a3d5008,0xa333201d,0xdc684007,0xbe8f100b}},	//   _रहल_, _dilantik__sebagai_, _dimulai_, _али_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x3f2e201e,0xc04dc017,0x00000000,0x00000000}},	//   _editoria, _izvornik_, --, --,
   {{0xf4b5a00b,0x9bdf3014,0x00000000,0x00000000}},	//   _vrsta__ima_, _जो__कि_, --, --,
   {{0x82d96015,0x2587d011,0x2ef1500b,0x6e95701b}},	//   _dagens_, _portal__masyarak, _град__је_, _slijedeć,
   {{0x39f42010,0x1cb3d01b,0x2ea8e00b,0xd33ac018}},	//   _také_, _mjesto__sastavu_, _али__је_, _du__trenger_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x0212000a,0xc49a5015,0x00000000,0x00000000}},	//   _igihe_, _være__en_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,

  };
  // table_hash = cc32-b85b, unused_entries = 3874 (47.29%)

static const uint32 kDistinctOctaChrome0604SizeOne = 69;    // Bucket count one-lang
static const uint32 kDistinctOctaChrome0604Ind[69] = {
  // [0000]
  0x00000000, 0x00000000, 0x00001301, 0x00000b06,   // -- --  et.un.un_200 es.un.un_400
  0x00000d01, 0x00001c01, 0x00000d06, 0x00001c03,   // cs.un.un_200 id.un.un_200  cs.un.un_400 id.un.un_300
  0x00001306, 0x00002d06, 0x00005506, 0x00001706,   // et.un.un_400 sk.un.un_400  rw.un.un_400 sr.un.un_400
  0x00001906, 0x00001703, 0x00001601, 0x00001e03,   // gl.un.un_400 sr.un.un_300  hr.un.un_200 ms.un.un_300
  // [0010]
  0x00000d03, 0x00001e06, 0x00000a06, 0x00001c06,   // cs.un.un_300 ms.un.un_400  pt.un.un_400 id.un.un_400
  0x00000906, 0x08000209, 0x00000903, 0x00001606,   // pl.un.un_400 da.no.un_440  pl.un.un_300 hr.un.un_400
  0x00000806, 0x00000b01, 0x09001c09, 0x00001603,   // no.un.un_400 es.un.un_200  id.pl.un_440 hr.un.un_300
  0x00000901, 0x00001e01, 0x00000b03, 0x00001303,   // pl.un.un_200 ms.un.un_200  es.un.un_300 et.un.un_300
  // [0020]
  0x00001701, 0x08000208, 0x00001901, 0x00000a03,   // sr.un.un_200 da.no.un_430  gl.un.un_200 pt.un.un_300
  0x00000801, 0x00002d03, 0x091c0da4, 0x00000803,   // no.un.un_200 sk.un.un_300  cs.id.pl_433 no.un.un_300
  0x09001c08, 0x00002d01, 0x09000d09, 0x00001903,   // id.pl.un_430 sk.un.un_200  cs.pl.un_440 gl.un.un_300
  0x00000a01, 0x09000d02, 0x1c000d04, 0x08001909,   // pt.un.un_200 cs.pl.un_220  cs.id.un_320 gl.no.un_440
  // [0030]
  0x09001c02, 0x09001c05, 0x13000d02, 0x08000207,   // id.pl.un_220 id.pl.un_330  cs.et.un_220 da.no.un_420
  0x13001c08, 0x13000d09, 0x08021909, 0x00000206,   // id.et.un_430 cs.et.un_440  gl.da.no_444 da.un.un_400
  0x090d1ca4, 0x09000d08, 0x09001c04, 0x13000d05,   // id.cs.pl_433 cs.pl.un_430  id.pl.un_320 cs.et.un_330
  0x1c000d02, 0x09000d04, 0x091c0da0, 0x13000d08,   // cs.id.un_220 cs.pl.un_320  cs.id.pl_322 cs.et.un_430
  // [0040] --- double_langprob_start=0045 ---
  0x19080209, 0x13001c07, 0x13001c05, 0x13000d04,   // da.no.gl_444 id.et.un_420  id.et.un_330 cs.et.un_320
  0x091c0d07,                                       // cs.id.pl_432
  };

//  COMPILE_ASSERT(69 < (1 << 12), k_indirectbits_too_small);

extern const CLD2TableSummary kDistinctOcta_obj = {
  kDistinctOctaChrome0604,
  kDistinctOctaChrome0604Ind,
  kDistinctOctaChrome0604SizeOne,
  kDistinctOctaChrome0604Size,
  kDistinctOctaChrome0604KeyMask,
  kDistinctOctaChrome0604BuildDate,
  kDistinctOctaChrome0604RecognizedLangScripts,
};

}       // End namespace CLD2

// End of generated tables
