;; -*- Mode: Common-Lisp -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; FILE IDENTIFICATION
;;
;; Name:          compress.lisp
;; Purpose:       Uses zlib to compress and uncompress vectors of octets
;; Author:        Kevin Rosenberg
;; Date Started:  July 2011
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package #:memstore)

;; KMR: zlib gives compression errors on random tests:
;;    indices outside of input array size
;; Using salza2 as default compressor

(defun compress-zlib (data)
  (zlib:compress data :fixed))

(defun compress (data)
  (let ((comp (salza2:compress-data
               data
               (make-instance 'salza2:zlib-compressor))))
    (values comp (length comp))))

;; KMR: zlib appears to works fine with salza2 zlib compressor, but
;; moving to chipz as default decompressor as appears better supported
(defun uncompress-zlib (data)
  (zlib:uncompress data))

(defun uncompress (data)
  (chipz:decompress nil 'chipz:zlib data))
