/****************************************************************************
 *    lib/b/Printer.cpp - This file is part of coala						*
 *																			*
 *    Copyright (C) 2009-2010  Torsten Grote								*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "Printer.h"

using namespace B;

B::Printer::Printer(std::ostream* output_stream, int debug_level,
					bool fake_negation, bool incremental, bool reverse,
					bool no_where_check, bool no_dir_enc, string language) :
					C::Printer(output_stream, debug_level, fake_negation,
							   incremental, reverse, no_where_check, no_dir_enc,
							   language) {

}

B::Printer::~Printer() {

}

void B::Printer::printEncoding() {
	b << "\n%\n% Domain independent rules\n%\n";
	
	// #base.
	
	// % Guess initial state
//	b << "1 { holds(F,0), holds(neg(F),0) } 1 :- fluent(F).\n";

	// #cumulative t.
	
	// % generation of action occurences
//	c << "occ(A, "+T+"-1) :- action(A), possible(A, "+T+"-1), not nocc(A, "+T+"-1).\n";
//	c << "nocc(A, "+T+"-1) :- action(A), action(B), occ(B, "+T+"-1), A!=B.\n";
	c << "0 { occ(A, "+T+"-1) : action(A) } 1.\n";
	c << ":- occ(A, "+T+"-1), not possible(A, "+T+"-1), action(A).\n";
	c << ":- not occ(A, "+T+"-1), possible(A, "+T+"-1), action(A), not occ(B, "+T+"-1) : action(B).\n";


	// hide everything except actions and fluents
	if(debug < 3) b << "#hide.\n";
	b << "#show occ(X1,T).\n";
	if(debug > 0) b << "#show holds(X1,T).\n";
}
