/****************************************************************************
 *    lib/options.h - This file is part of coala							*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#ifndef OPTIONS_H
#define OPTIONS_H

#include <iostream>
#include <string>

using namespace std;

namespace Coala {

class CompilerOptions {
	public:
		CompilerOptions();
		virtual ~CompilerOptions();
		
		bool checkOptions();
		
		void setLanguage(string);
		string getLanguage();
		
		void setInputStream(istream&);
		istream* getInputStream();
		
		void setOutputStream(ostream&);
		ostream* getOutputStream();
		
		void setFakeClassicalNegation(bool);
		bool getFakeClassicalNegation();
		
		void setDebug(int);
		int getDebug();
		
		void setDirectEncoding(bool);
		bool getDirectEncoding();
		
		void setIncremental(bool);
		bool getIncremental();
		
		void setReverseIncremental(bool);
		bool getReverseIncremental();
		
		void setWhereCheck(bool);
		bool getWhereCheck();
		
	private:
		string language_;
		istream* inputStream_;
		ostream* outputStream_;
		bool fakeClassicalNegation_;
		int debug_;
		bool directEncoding_;
		bool incremental_;
		bool reverseIncremental_;
		bool whereCheck_;
	
};

};

#endif // OPTIONS_H
