#
# Copyright (C) 2005  Robert Collins  <robertc@squid-cache.org>
# 
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

def test_suite():
    import config_manager.implementations.tests
    return config_manager.implementations.tests.test_suite()


all_implementations = []
schemes = {}

def register(implementation):
    """Register a VCS implemenation."""
    all_implementations.append(implementation)
    for scheme in implementation.schemes:
        implementations = schemes.get(scheme, [])
        schemes[scheme] = implementations
        implementations.append(implementation)
    

def unregister(implementation):
    """Unregister a VCS implemenation."""
    global all_implementations
    all_implementations.remove(implementation)
    for scheme in implementation.schemes:
        schemes[scheme].remove(implementation)


class UnusableURL(RuntimeError):
    """A URL is unusable for some scheme, other than not having that VCS there.

    I.e. access denied, server down, incompatible version of the protocol.
    
    """

