// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/service/auth/v2/attribute_context.proto

package v2

import (
	fmt "fmt"
	io "io"
	math "math"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	types "github.com/gogo/protobuf/types"

	core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// An attribute is a piece of metadata that describes an activity on a network.
// For example, the size of an HTTP request, or the status code of an HTTP response.
//
// Each attribute has a type and a name, which is logically defined as a proto message field
// of the `AttributeContext`. The `AttributeContext` is a collection of individual attributes
// supported by Envoy authorization system.
type AttributeContext struct {
	// The source of a network activity, such as starting a TCP connection.
	// In a multi hop network activity, the source represents the sender of the
	// last hop.
	Source *AttributeContext_Peer `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The destination of a network activity, such as accepting a TCP connection.
	// In a multi hop network activity, the destination represents the receiver of
	// the last hop.
	Destination *AttributeContext_Peer `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// Represents a network request, such as an HTTP request.
	Request *AttributeContext_Request `protobuf:"bytes,4,opt,name=request,proto3" json:"request,omitempty"`
	// This is analogous to http_request.headers, however these contents will not be sent to the
	// upstream server. Context_extensions provide an extension mechanism for sending additional
	// information to the auth server without modifying the proto definition. It maps to the
	// internal opaque context in the filter chain.
	ContextExtensions    map[string]string `protobuf:"bytes,10,rep,name=context_extensions,json=contextExtensions,proto3" json:"context_extensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *AttributeContext) Reset()         { *m = AttributeContext{} }
func (m *AttributeContext) String() string { return proto.CompactTextString(m) }
func (*AttributeContext) ProtoMessage()    {}
func (*AttributeContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6030c9468e3591b, []int{0}
}
func (m *AttributeContext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AttributeContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *AttributeContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeContext.Merge(m, src)
}
func (m *AttributeContext) XXX_Size() int {
	return m.Size()
}
func (m *AttributeContext) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeContext.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeContext proto.InternalMessageInfo

func (m *AttributeContext) GetSource() *AttributeContext_Peer {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *AttributeContext) GetDestination() *AttributeContext_Peer {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *AttributeContext) GetRequest() *AttributeContext_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *AttributeContext) GetContextExtensions() map[string]string {
	if m != nil {
		return m.ContextExtensions
	}
	return nil
}

// This message defines attributes for a node that handles a network request.
// The node can be either a service or an application that sends, forwards,
// or receives the request. Service peers should fill in the `service`,
// `principal`, and `labels` as appropriate.
type AttributeContext_Peer struct {
	// The address of the peer, this is typically the IP address.
	// It can also be UDS path, or others.
	Address *core.Address `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// The canonical service name of the peer.
	// It should be set to :ref:`the HTTP x-envoy-downstream-service-cluster
	// <config_http_conn_man_headers_downstream-service-cluster>`
	// If a more trusted source of the service name is available through mTLS/secure naming, it
	// should be used.
	Service string `protobuf:"bytes,2,opt,name=service,proto3" json:"service,omitempty"`
	// The labels associated with the peer.
	// These could be pod labels for Kubernetes or tags for VMs.
	// The source of the labels could be an X.509 certificate or other configuration.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The authenticated identity of this peer.
	// For example, the identity associated with the workload such as a service account.
	// If an X.509 certificate is used to assert the identity this field should be sourced from
	// `Subject` or `Subject Alternative Names`. The primary identity should be the principal.
	// The principal format is issuer specific.
	//
	// Example:
	// *    SPIFFE format is `spiffe://trust-domain/path`
	// *    Google account format is `https://accounts.google.com/{userid}`
	Principal            string   `protobuf:"bytes,4,opt,name=principal,proto3" json:"principal,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttributeContext_Peer) Reset()         { *m = AttributeContext_Peer{} }
func (m *AttributeContext_Peer) String() string { return proto.CompactTextString(m) }
func (*AttributeContext_Peer) ProtoMessage()    {}
func (*AttributeContext_Peer) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6030c9468e3591b, []int{0, 0}
}
func (m *AttributeContext_Peer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AttributeContext_Peer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *AttributeContext_Peer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeContext_Peer.Merge(m, src)
}
func (m *AttributeContext_Peer) XXX_Size() int {
	return m.Size()
}
func (m *AttributeContext_Peer) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeContext_Peer.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeContext_Peer proto.InternalMessageInfo

func (m *AttributeContext_Peer) GetAddress() *core.Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *AttributeContext_Peer) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *AttributeContext_Peer) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *AttributeContext_Peer) GetPrincipal() string {
	if m != nil {
		return m.Principal
	}
	return ""
}

// Represents a network request, such as an HTTP request.
type AttributeContext_Request struct {
	// The timestamp when the proxy receives the first byte of the request.
	Time *types.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	// Represents an HTTP request or an HTTP-like request.
	Http                 *AttributeContext_HttpRequest `protobuf:"bytes,2,opt,name=http,proto3" json:"http,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *AttributeContext_Request) Reset()         { *m = AttributeContext_Request{} }
func (m *AttributeContext_Request) String() string { return proto.CompactTextString(m) }
func (*AttributeContext_Request) ProtoMessage()    {}
func (*AttributeContext_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6030c9468e3591b, []int{0, 1}
}
func (m *AttributeContext_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AttributeContext_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *AttributeContext_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeContext_Request.Merge(m, src)
}
func (m *AttributeContext_Request) XXX_Size() int {
	return m.Size()
}
func (m *AttributeContext_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeContext_Request.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeContext_Request proto.InternalMessageInfo

func (m *AttributeContext_Request) GetTime() *types.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *AttributeContext_Request) GetHttp() *AttributeContext_HttpRequest {
	if m != nil {
		return m.Http
	}
	return nil
}

// This message defines attributes for an HTTP request.
// HTTP/1.x, HTTP/2, gRPC are all considered as HTTP requests.
type AttributeContext_HttpRequest struct {
	// The unique ID for a request, which can be propagated to downstream
	// systems. The ID should have low probability of collision
	// within a single day for a specific service.
	// For HTTP requests, it should be X-Request-ID or equivalent.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The HTTP request method, such as `GET`, `POST`.
	Method string `protobuf:"bytes,2,opt,name=method,proto3" json:"method,omitempty"`
	// The HTTP request headers. If multiple headers share the same key, they
	// must be merged according to the HTTP spec. All header keys must be
	// lowercased, because HTTP header keys are case-insensitive.
	Headers map[string]string `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The request target, as it appears in the first line of the HTTP request. This includes
	// the URL path and query-string. No decoding is performed.
	Path string `protobuf:"bytes,4,opt,name=path,proto3" json:"path,omitempty"`
	// The HTTP request `Host` or 'Authority` header value.
	Host string `protobuf:"bytes,5,opt,name=host,proto3" json:"host,omitempty"`
	// The HTTP URL scheme, such as `http` and `https`.
	Scheme string `protobuf:"bytes,6,opt,name=scheme,proto3" json:"scheme,omitempty"`
	// This field is always empty, and exists for compatibility reasons. The HTTP URL query is
	// included in `path` field.
	Query string `protobuf:"bytes,7,opt,name=query,proto3" json:"query,omitempty"`
	// This field is always empty, and exists for compatibility reasons. The URL fragment is
	// not submitted as part of HTTP requests; it is unknowable.
	Fragment string `protobuf:"bytes,8,opt,name=fragment,proto3" json:"fragment,omitempty"`
	// The HTTP request size in bytes. If unknown, it must be -1.
	Size_ int64 `protobuf:"varint,9,opt,name=size,proto3" json:"size,omitempty"`
	// The network protocol used with the request, such as "HTTP/1.0", "HTTP/1.1", or "HTTP/2".
	//
	// See :repo:`headers.h:ProtocolStrings <source/common/http/headers.h>` for a list of all
	// possible values.
	Protocol string `protobuf:"bytes,10,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// The HTTP request body.
	Body                 string   `protobuf:"bytes,11,opt,name=body,proto3" json:"body,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttributeContext_HttpRequest) Reset()         { *m = AttributeContext_HttpRequest{} }
func (m *AttributeContext_HttpRequest) String() string { return proto.CompactTextString(m) }
func (*AttributeContext_HttpRequest) ProtoMessage()    {}
func (*AttributeContext_HttpRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6030c9468e3591b, []int{0, 2}
}
func (m *AttributeContext_HttpRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AttributeContext_HttpRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *AttributeContext_HttpRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeContext_HttpRequest.Merge(m, src)
}
func (m *AttributeContext_HttpRequest) XXX_Size() int {
	return m.Size()
}
func (m *AttributeContext_HttpRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeContext_HttpRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeContext_HttpRequest proto.InternalMessageInfo

func (m *AttributeContext_HttpRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *AttributeContext_HttpRequest) GetMethod() string {
	if m != nil {
		return m.Method
	}
	return ""
}

func (m *AttributeContext_HttpRequest) GetHeaders() map[string]string {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *AttributeContext_HttpRequest) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *AttributeContext_HttpRequest) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *AttributeContext_HttpRequest) GetScheme() string {
	if m != nil {
		return m.Scheme
	}
	return ""
}

func (m *AttributeContext_HttpRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *AttributeContext_HttpRequest) GetFragment() string {
	if m != nil {
		return m.Fragment
	}
	return ""
}

func (m *AttributeContext_HttpRequest) GetSize_() int64 {
	if m != nil {
		return m.Size_
	}
	return 0
}

func (m *AttributeContext_HttpRequest) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *AttributeContext_HttpRequest) GetBody() string {
	if m != nil {
		return m.Body
	}
	return ""
}

func init() {
	proto.RegisterType((*AttributeContext)(nil), "envoy.service.auth.v2.AttributeContext")
	proto.RegisterMapType((map[string]string)(nil), "envoy.service.auth.v2.AttributeContext.ContextExtensionsEntry")
	proto.RegisterType((*AttributeContext_Peer)(nil), "envoy.service.auth.v2.AttributeContext.Peer")
	proto.RegisterMapType((map[string]string)(nil), "envoy.service.auth.v2.AttributeContext.Peer.LabelsEntry")
	proto.RegisterType((*AttributeContext_Request)(nil), "envoy.service.auth.v2.AttributeContext.Request")
	proto.RegisterType((*AttributeContext_HttpRequest)(nil), "envoy.service.auth.v2.AttributeContext.HttpRequest")
	proto.RegisterMapType((map[string]string)(nil), "envoy.service.auth.v2.AttributeContext.HttpRequest.HeadersEntry")
}

func init() {
	proto.RegisterFile("envoy/service/auth/v2/attribute_context.proto", fileDescriptor_a6030c9468e3591b)
}

var fileDescriptor_a6030c9468e3591b = []byte{
	// 630 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x53, 0x4f, 0x6f, 0xd3, 0x4e,
	0x10, 0x95, 0x93, 0x34, 0x69, 0x26, 0x3f, 0xfd, 0x54, 0x56, 0x6d, 0x65, 0x59, 0x55, 0xa8, 0xe0,
	0xd2, 0x03, 0xac, 0xa5, 0x94, 0x43, 0xe9, 0x01, 0xd1, 0xd2, 0x8a, 0x22, 0xa1, 0x2a, 0xb2, 0x38,
	0x71, 0xa9, 0x36, 0xf6, 0x34, 0x5e, 0x91, 0x78, 0xdd, 0xdd, 0x75, 0xd4, 0x70, 0x03, 0x3e, 0x14,
	0x5f, 0x81, 0x23, 0x47, 0x8e, 0x28, 0x9f, 0x04, 0xed, 0x1f, 0x97, 0xa8, 0xf4, 0xd0, 0xf4, 0x94,
	0x99, 0xf1, 0x9b, 0xb7, 0x6f, 0xde, 0x4c, 0xe0, 0x39, 0x16, 0x33, 0x31, 0x8f, 0x15, 0xca, 0x19,
	0x4f, 0x31, 0x66, 0x95, 0xce, 0xe3, 0xd9, 0x20, 0x66, 0x5a, 0x4b, 0x3e, 0xaa, 0x34, 0x5e, 0xa4,
	0xa2, 0xd0, 0x78, 0xad, 0x69, 0x29, 0x85, 0x16, 0x64, 0xcb, 0xc2, 0xa9, 0x87, 0x53, 0x03, 0xa7,
	0xb3, 0x41, 0xb4, 0xe3, 0x58, 0x58, 0xc9, 0x4d, 0x73, 0x2a, 0x24, 0xc6, 0x23, 0xa6, 0xd0, 0x35,
	0x45, 0x8f, 0xff, 0xfd, 0xca, 0xb2, 0x4c, 0xa2, 0x52, 0x35, 0x60, 0x2c, 0xc4, 0x78, 0x82, 0xb1,
	0xcd, 0x46, 0xd5, 0x65, 0xac, 0xf9, 0x14, 0x95, 0x66, 0xd3, 0xd2, 0x03, 0x36, 0xc7, 0x62, 0x2c,
	0x6c, 0x18, 0x9b, 0xc8, 0x55, 0x9f, 0x7c, 0xef, 0xc2, 0xc6, 0x51, 0x2d, 0xf4, 0x8d, 0xd3, 0x49,
	0x4e, 0xa0, 0xad, 0x44, 0x25, 0x53, 0x0c, 0x83, 0xdd, 0x60, 0xaf, 0x37, 0x78, 0x46, 0xef, 0x94,
	0x4c, 0x6f, 0x37, 0xd2, 0x21, 0xa2, 0x4c, 0x7c, 0x2f, 0x39, 0x87, 0x5e, 0x86, 0x4a, 0xf3, 0x82,
	0x69, 0x2e, 0x8a, 0xb0, 0xf1, 0x00, 0xaa, 0x65, 0x02, 0xf2, 0x0e, 0x3a, 0x12, 0xaf, 0x2a, 0x54,
	0x3a, 0x6c, 0x59, 0xae, 0xf8, 0xbe, 0x5c, 0x89, 0x6b, 0x4b, 0xea, 0x7e, 0x32, 0x05, 0xe2, 0x77,
	0x72, 0x81, 0xd7, 0x1a, 0x0b, 0xc5, 0x45, 0xa1, 0x42, 0xd8, 0x6d, 0xee, 0xf5, 0x06, 0xaf, 0xee,
	0xcb, 0xea, 0x7f, 0x4f, 0x6f, 0x08, 0x4e, 0x0b, 0x2d, 0xe7, 0xc9, 0xa3, 0xf4, 0x76, 0x3d, 0xfa,
	0xd2, 0x80, 0x96, 0x99, 0x87, 0xbc, 0x80, 0x8e, 0xdf, 0x9a, 0x77, 0x36, 0xf2, 0x8f, 0xb1, 0x92,
	0x9b, 0x37, 0xcc, 0x5e, 0xe9, 0x91, 0x43, 0x24, 0x35, 0x94, 0x84, 0xd0, 0xf1, 0x62, 0xac, 0x89,
	0xdd, 0xa4, 0x4e, 0xc9, 0x10, 0xda, 0x13, 0x36, 0xc2, 0x89, 0x0a, 0x9b, 0x56, 0xfb, 0xc1, 0x2a,
	0xee, 0xd2, 0xf7, 0xb6, 0xd5, 0xa9, 0xf6, 0x3c, 0x64, 0x07, 0xba, 0xa5, 0xe4, 0x45, 0xca, 0x4b,
	0x36, 0xb1, 0x36, 0x77, 0x93, 0xbf, 0x85, 0xe8, 0x25, 0xf4, 0x96, 0x9a, 0xc8, 0x06, 0x34, 0x3f,
	0xe1, 0xdc, 0x8e, 0xd2, 0x4d, 0x4c, 0x48, 0x36, 0x61, 0x6d, 0xc6, 0x26, 0x55, 0x2d, 0xd4, 0x25,
	0x87, 0x8d, 0x83, 0x20, 0xfa, 0x1a, 0x40, 0xc7, 0xef, 0x81, 0x50, 0x68, 0x99, 0xeb, 0xbc, 0xf1,
	0xc0, 0x9d, 0x2e, 0xad, 0x4f, 0x97, 0x7e, 0xa8, 0x4f, 0x37, 0xb1, 0x38, 0xf2, 0x16, 0x5a, 0xb9,
	0xd6, 0xa5, 0x3f, 0xa1, 0xfd, 0xfb, 0x0e, 0x79, 0xa6, 0x75, 0x59, 0xaf, 0xde, 0x12, 0x44, 0xdf,
	0x9a, 0xd0, 0x5b, 0xaa, 0x92, 0xff, 0xa1, 0xc1, 0x33, 0xaf, 0xbf, 0xc1, 0x33, 0xb2, 0x0d, 0xed,
	0x29, 0xea, 0x5c, 0x64, 0x5e, 0xbf, 0xcf, 0xc8, 0x47, 0xe8, 0xe4, 0xc8, 0x32, 0x94, 0xb5, 0xd1,
	0xaf, 0x1f, 0xa0, 0x81, 0x9e, 0x39, 0x0a, 0x67, 0x78, 0x4d, 0x48, 0x08, 0xb4, 0x4a, 0xa6, 0x73,
	0x6f, 0xb6, 0x8d, 0x4d, 0x2d, 0x17, 0x4a, 0x87, 0x6b, 0xae, 0x66, 0x62, 0xa3, 0x4d, 0xa5, 0x39,
	0x4e, 0x31, 0x6c, 0x3b, 0x6d, 0x2e, 0x33, 0x96, 0x5f, 0x55, 0x28, 0xe7, 0x61, 0xc7, 0x59, 0x6e,
	0x13, 0x12, 0xc1, 0xfa, 0xa5, 0x64, 0xe3, 0x29, 0x16, 0x3a, 0x5c, 0xb7, 0x1f, 0x6e, 0x72, 0xc3,
	0xae, 0xf8, 0x67, 0x0c, 0xbb, 0xbb, 0xc1, 0x5e, 0x33, 0xb1, 0xb1, 0xc1, 0x5b, 0xfb, 0x53, 0x31,
	0x09, 0xc1, 0xe1, 0xeb, 0xdc, 0xe0, 0x47, 0x22, 0x9b, 0x87, 0x3d, 0xa7, 0xc6, 0xc4, 0xd1, 0x21,
	0xfc, 0xb7, 0x3c, 0xce, 0x4a, 0xa7, 0x70, 0x02, 0xdb, 0x77, 0xff, 0x77, 0x56, 0x61, 0x39, 0x3e,
	0xff, 0xb1, 0xe8, 0x07, 0x3f, 0x17, 0xfd, 0xe0, 0xd7, 0xa2, 0x1f, 0xfc, 0x5e, 0xf4, 0x03, 0x78,
	0xca, 0x85, 0x5b, 0x4b, 0x29, 0xc5, 0xf5, 0xfc, 0xee, 0x0d, 0x1d, 0x6f, 0xdd, 0x5e, 0xd1, 0xd0,
	0x8c, 0x39, 0x0c, 0x46, 0x6d, 0x3b, 0xef, 0xfe, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x3a, 0x3a,
	0x48, 0x43, 0xce, 0x05, 0x00, 0x00,
}

func (m *AttributeContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttributeContext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Source != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(m.Source.Size()))
		n1, err := m.Source.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Destination != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(m.Destination.Size()))
		n2, err := m.Destination.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.Request != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(m.Request.Size()))
		n3, err := m.Request.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if len(m.ContextExtensions) > 0 {
		keysForContextExtensions := make([]string, 0, len(m.ContextExtensions))
		for k, _ := range m.ContextExtensions {
			keysForContextExtensions = append(keysForContextExtensions, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForContextExtensions)
		for _, k := range keysForContextExtensions {
			dAtA[i] = 0x52
			i++
			v := m.ContextExtensions[string(k)]
			mapSize := 1 + len(k) + sovAttributeContext(uint64(len(k))) + 1 + len(v) + sovAttributeContext(uint64(len(v)))
			i = encodeVarintAttributeContext(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAttributeContext(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAttributeContext(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AttributeContext_Peer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttributeContext_Peer) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Address != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(m.Address.Size()))
		n4, err := m.Address.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if len(m.Service) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(len(m.Service)))
		i += copy(dAtA[i:], m.Service)
	}
	if len(m.Labels) > 0 {
		keysForLabels := make([]string, 0, len(m.Labels))
		for k, _ := range m.Labels {
			keysForLabels = append(keysForLabels, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
		for _, k := range keysForLabels {
			dAtA[i] = 0x1a
			i++
			v := m.Labels[string(k)]
			mapSize := 1 + len(k) + sovAttributeContext(uint64(len(k))) + 1 + len(v) + sovAttributeContext(uint64(len(v)))
			i = encodeVarintAttributeContext(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAttributeContext(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAttributeContext(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.Principal) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(len(m.Principal)))
		i += copy(dAtA[i:], m.Principal)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AttributeContext_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttributeContext_Request) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Time != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(m.Time.Size()))
		n5, err := m.Time.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.Http != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(m.Http.Size()))
		n6, err := m.Http.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AttributeContext_HttpRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttributeContext_HttpRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Method) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(len(m.Method)))
		i += copy(dAtA[i:], m.Method)
	}
	if len(m.Headers) > 0 {
		keysForHeaders := make([]string, 0, len(m.Headers))
		for k, _ := range m.Headers {
			keysForHeaders = append(keysForHeaders, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForHeaders)
		for _, k := range keysForHeaders {
			dAtA[i] = 0x1a
			i++
			v := m.Headers[string(k)]
			mapSize := 1 + len(k) + sovAttributeContext(uint64(len(k))) + 1 + len(v) + sovAttributeContext(uint64(len(v)))
			i = encodeVarintAttributeContext(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAttributeContext(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAttributeContext(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.Path) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	if len(m.Host) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(len(m.Host)))
		i += copy(dAtA[i:], m.Host)
	}
	if len(m.Scheme) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(len(m.Scheme)))
		i += copy(dAtA[i:], m.Scheme)
	}
	if len(m.Query) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(len(m.Query)))
		i += copy(dAtA[i:], m.Query)
	}
	if len(m.Fragment) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(len(m.Fragment)))
		i += copy(dAtA[i:], m.Fragment)
	}
	if m.Size_ != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(m.Size_))
	}
	if len(m.Protocol) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(len(m.Protocol)))
		i += copy(dAtA[i:], m.Protocol)
	}
	if len(m.Body) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintAttributeContext(dAtA, i, uint64(len(m.Body)))
		i += copy(dAtA[i:], m.Body)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintAttributeContext(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *AttributeContext) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Source != nil {
		l = m.Source.Size()
		n += 1 + l + sovAttributeContext(uint64(l))
	}
	if m.Destination != nil {
		l = m.Destination.Size()
		n += 1 + l + sovAttributeContext(uint64(l))
	}
	if m.Request != nil {
		l = m.Request.Size()
		n += 1 + l + sovAttributeContext(uint64(l))
	}
	if len(m.ContextExtensions) > 0 {
		for k, v := range m.ContextExtensions {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAttributeContext(uint64(len(k))) + 1 + len(v) + sovAttributeContext(uint64(len(v)))
			n += mapEntrySize + 1 + sovAttributeContext(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AttributeContext_Peer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Address != nil {
		l = m.Address.Size()
		n += 1 + l + sovAttributeContext(uint64(l))
	}
	l = len(m.Service)
	if l > 0 {
		n += 1 + l + sovAttributeContext(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAttributeContext(uint64(len(k))) + 1 + len(v) + sovAttributeContext(uint64(len(v)))
			n += mapEntrySize + 1 + sovAttributeContext(uint64(mapEntrySize))
		}
	}
	l = len(m.Principal)
	if l > 0 {
		n += 1 + l + sovAttributeContext(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AttributeContext_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Time != nil {
		l = m.Time.Size()
		n += 1 + l + sovAttributeContext(uint64(l))
	}
	if m.Http != nil {
		l = m.Http.Size()
		n += 1 + l + sovAttributeContext(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AttributeContext_HttpRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovAttributeContext(uint64(l))
	}
	l = len(m.Method)
	if l > 0 {
		n += 1 + l + sovAttributeContext(uint64(l))
	}
	if len(m.Headers) > 0 {
		for k, v := range m.Headers {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAttributeContext(uint64(len(k))) + 1 + len(v) + sovAttributeContext(uint64(len(v)))
			n += mapEntrySize + 1 + sovAttributeContext(uint64(mapEntrySize))
		}
	}
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovAttributeContext(uint64(l))
	}
	l = len(m.Host)
	if l > 0 {
		n += 1 + l + sovAttributeContext(uint64(l))
	}
	l = len(m.Scheme)
	if l > 0 {
		n += 1 + l + sovAttributeContext(uint64(l))
	}
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovAttributeContext(uint64(l))
	}
	l = len(m.Fragment)
	if l > 0 {
		n += 1 + l + sovAttributeContext(uint64(l))
	}
	if m.Size_ != 0 {
		n += 1 + sovAttributeContext(uint64(m.Size_))
	}
	l = len(m.Protocol)
	if l > 0 {
		n += 1 + l + sovAttributeContext(uint64(l))
	}
	l = len(m.Body)
	if l > 0 {
		n += 1 + l + sovAttributeContext(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovAttributeContext(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozAttributeContext(x uint64) (n int) {
	return sovAttributeContext(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *AttributeContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAttributeContext
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AttributeContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AttributeContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Source == nil {
				m.Source = &AttributeContext_Peer{}
			}
			if err := m.Source.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Destination", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Destination == nil {
				m.Destination = &AttributeContext_Peer{}
			}
			if err := m.Destination.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Request", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Request == nil {
				m.Request = &AttributeContext_Request{}
			}
			if err := m.Request.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContextExtensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContextExtensions == nil {
				m.ContextExtensions = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributeContext
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributeContext
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAttributeContext
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAttributeContext
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributeContext
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthAttributeContext
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthAttributeContext
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributeContext(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributeContext
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ContextExtensions[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAttributeContext(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AttributeContext_Peer) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAttributeContext
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Peer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Peer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Address == nil {
				m.Address = &core.Address{}
			}
			if err := m.Address.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Service = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributeContext
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributeContext
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAttributeContext
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAttributeContext
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributeContext
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthAttributeContext
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthAttributeContext
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributeContext(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributeContext
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Principal = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAttributeContext(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AttributeContext_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAttributeContext
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Time == nil {
				m.Time = &types.Timestamp{}
			}
			if err := m.Time.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Http == nil {
				m.Http = &AttributeContext_HttpRequest{}
			}
			if err := m.Http.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAttributeContext(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AttributeContext_HttpRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAttributeContext
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HttpRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HttpRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Method = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Headers == nil {
				m.Headers = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributeContext
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributeContext
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAttributeContext
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAttributeContext
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributeContext
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthAttributeContext
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthAttributeContext
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributeContext(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributeContext
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Headers[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Host", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Host = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scheme", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Scheme = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Fragment", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Fragment = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size_", wireType)
			}
			m.Size_ = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Size_ |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Protocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Body", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAttributeContext
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Body = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAttributeContext(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAttributeContext
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAttributeContext(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAttributeContext
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAttributeContext
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthAttributeContext
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthAttributeContext
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAttributeContext
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAttributeContext(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthAttributeContext
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAttributeContext = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAttributeContext   = fmt.Errorf("proto: integer overflow")
)
