/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class Err {
    public static final int ELEMENT = 1;
    public static final int ATTRIBUTE = 2;
    public static final int FUNCTION = 3;
    public static final int VALUE = 4;
    public static final int VARIABLE = 5;
    public static final int GENERAL = 6;
    public static final int URI = 7;

    public static String wrap(CharSequence charSequence) {
        return Err.wrap(charSequence, 6);
    }

    public static String wrap(CharSequence charSequence, int n) {
        if (charSequence == null) {
            return "(NULL)";
        }
        String string = charSequence.toString();
        string = string.replace('\n', ' ');
        string = string.replace('\t', ' ');
        if ((string = string.replace('\r', ' ')).length() > 30) {
            string = n == 7 ? "..." + string.substring(string.length() - 30) : string.substring(0, 30) + "...";
        }
        switch (n) {
            case 1: {
                return "<" + string + ">";
            }
            case 2: {
                return "@" + string;
            }
            case 3: {
                return string + "()";
            }
            case 5: {
                return "$" + string;
            }
            case 4: {
                return "\"" + string + "\"";
            }
        }
        return "{" + string + "}";
    }

    public static CharSequence depict(Item item) {
        if (item instanceof AtomicValue) {
            CharSequence charSequence = item.getStringValueCS();
            if (item instanceof StringValue) {
                return '\"' + Err.truncate30(charSequence).toString() + '\"';
            }
            return Err.truncate30(charSequence);
        }
        NodeInfo nodeInfo = (NodeInfo)item;
        switch (nodeInfo.getNodeKind()) {
            case 9: {
                return "document-node()";
            }
            case 1: {
                return "<" + nodeInfo.getDisplayName() + "/>";
            }
            case 2: {
                return "@" + nodeInfo.getDisplayName();
            }
            case 3: {
                return "text(\"" + Err.truncate30(nodeInfo.getStringValue()) + "\")";
            }
            case 8: {
                return "<!--" + Err.truncate30(nodeInfo.getStringValue()) + "-->";
            }
            case 7: {
                return "<?" + nodeInfo.getDisplayName() + "?>";
            }
            case 13: {
                String string = nodeInfo.getLocalPart();
                return "xmlns" + (string.equals("") ? "" : ":" + string) + "=\"" + nodeInfo.getStringValue() + '\"';
            }
        }
        return "";
    }

    private static CharSequence truncate30(CharSequence charSequence) {
        if (charSequence.length() <= 30) {
            return Whitespace.collapseWhitespace(charSequence);
        }
        return Whitespace.collapseWhitespace(charSequence.subSequence(0, 30)).toString() + "...";
    }
}

