#include "balancer"

void Balancer::addbackend (Backend const &b,
			   bool is_up, bool is_live, bool do_check) {
    debugmsg("Adding back end " << b.description() << " to list\n");

    int lock;
    mutex_lock(&lock);
    backends.push_back (b);    
    backends[backends.size() - 1].up(is_up);
    backends[backends.size() - 1].live(is_live);
    backends[backends.size() - 1].balancerindex(backends.size() - 1);
    mutex_unlock(&lock);

    if (do_check) {
	debugmsg("Verifying added back end " << b.description() << '\n');
	backends[backends.size() - 1].check();
    }

    debugmsg("Back end " << b.description() << " added to list\n");
}
