DACS_PASSWD(8)             DACS Web Services Manual             DACS_PASSWD(8)



[1mNAME[0m
       dacs_passwd - manage private [1mDACS [22mpasswords

[1mSYNOPSIS[0m
       [1mdacs_passwd [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacs_passwd [22mweb service is used to manage usernames and passwords
       recognized by [34m[1mlocal_passwd_authenticate[0m[1m[22m[2], a [1mDACS [22mauthentication
       module. This utility serves a similar purpose for
       [1mlocal_passwd_authenticate [22mthat [1mApache[22m's [34m[1mhtpasswd(1)[0m[1m[22m[3] command does for
       its [34m[1mmod_auth[0m[1m[22m[4] and [34m[1mmod_auth_dbm[0m[1m[22m[5] modules. These accounts and
       passwords are used only by [1mlocal_passwd_authenticate [22mand are completely
       separate from any other accounts and passwords.

           [1mNote[0m
           Much of the functionality of this program is also available as a
           [1mDACS [22mutility, [34m[1mdacspasswd(1)[0m[1m[22m[6], which operates on the same password
           files. Because [34m[1mdacs_admin(8)[0m[1m[22m[7] provides the same functionality and
           more, [1mdacs_passwd [22mmay be removed in a future release.

           [1mSecurity[0m
           The default [1mDACS [22mACL restricts use of this web service to a [1mDACS[0m
           administrator and to users who are setting the password for their
           own [1mDACS [22maccount at the receiving jurisdiction. Administrators
           should ensure that the ACL for [1mdacs_passwd [22mis correct for their
           environment.

[1mOPTIONS[0m
   [1mWeb Service Arguments[0m
       In addition to the [34m[1mstandard CGI arguments[0m[1m[22m[8], [1mdacs_passwd [22munderstands
       the following CGI arguments:

       [4mOPERATION[0m
           The following operations are supported:

           +o   [4mADD[0m

               Like [4mSET[24m but add or replace an entry for [4mUSERNAME[24m.

           +o   [4mDELETE[0m

               Delete the account for [4mUSERNAME[24m.

           +o   [4mDISABLE[0m

               Disable the account for [4mUSERNAME[24m.

           +o   [4mENABLE[0m

               Enable the account for [4mUSERNAME[24m.

           +o   [4mLIST[0m

               List [4mUSERNAME[24m, if it exists, otherwise all usernames. A
               disabled account is indicated by a '*' (which is not a valid
               character in a username).

           +o   [4mSET[0m

               Sets or resets a [1mDACS [22mpassword for [4mUSERNAME[24m to [4mNEW_PASSWORD[24m.
               The [4mCONFIRM_NEW_PASSWORD[24m argument must also be given and be
               identical to [4mNEW_PASSWORD[24m. Unless the operation is performed by
               a [1mDACS [22madministrator (i.e., an [34m[1mADMIN_IDENTITY[0m[1m[22m[9]) or disabled
               by the [34m[1mPASSWORD_OPS_NEED_PASSWORD[0m[1m[22m[10] directive, the current
               password for [4mUSERNAME[24m must be given as [4mPASSWORD[24m.

                   [1mSecurity[0m
                   For users other than a [1mDACS [22madministrator, a password must
                   meet certain requirements on its length and the character
                   set from which it is comprised. Note that these
                   requirements are only significant at the time a password is
                   set or changed; existing passwords are unaffected by
                   changes to the configuration directives. Please refer to
                   the [34m[1mPASSWORD_CONSTRAINTS[0m[1m[22m[11] directive.

                   Users should be made aware of security issues related to
                   passwords, including better techniques for selecting
                   passwords and keeping them private.

                   [1mHow to choose better passwords[0m
                   Users might consider adopting a method such as the one
                   described in [34m[1mthis proposal[0m[1m[22m[12]. It suggests that users
                   construct [4msite-specific[24m [4mpasswords[24m from three components:

                    1. PIN-1, a short, [4mrandom[24m string that is common to all of
                       the user's passwords, kept secret, and not likely to be
                       in any dictionary;

                    2. SITE, a string that is derived from the site's domain
                       name using some simple and easy-to-remember procedure
                       (e.g., using the first four letters or consonents); and

                    3. PIN-2, a short, site-specific [4mrandom[24m string (this
                       component is different for each of a user's passwords,
                       and is something not likely to be in any dictionary).

                       PIN-1 is memorized by the user. The other two
                       components may be written down but must be kept in a
                       relatively secure location (such as in the user's
                       wallet or in a desk drawer). The user forms his or her
                       passwords by combining these three components in any
                       order that is easy to remember.

                       For the site www.example.net, a user might select the
                       password "examRB8s#i8", where "exam" (component 2,
                       SITE) is derived from the site's domain name, "RB8s" is
                       a random string used with this password only (component
                       3, PIN-2), and "#i8" is the user's secret PIN
                       (component 1, PIN-1). Because it is probably difficult
                       to remember, the user might create a note with
                       "examRB8s" written on it (SITE and PIN-2), but not
                       PIN-1.

                       For the site dacs.dss.ca, the same user might select
                       the password "dssceIM#i8".

                       Since most people are not very good at it, the random
                       strings should be chosen using a good-quality random
                       generator, such as the [34m[1mrandom()[0m[1m[22m[13] function:

                           % dacsexpr -e "random(string, 4, 'a-zA-Z0-9,./;@#')"
                           "y2FJ"

                       In addition to being difficult to guess because of
                       their random components and reasonably large character
                       set, these passwords are different for each site;
                       should one password be compromised, the others are not
                       immediately available to an attacker. Similarly, the
                       written strings cannot be immediately exploited if they
                       are stolen or copied. The strength of the method can be
                       increased by making either or both PIN components
                       longer, or chosen from a larger space of characters.

               [4mACCOUNT[0m
                   Either PASSWD (the default) or SIMPLE, case insensitively,
                   to select between the item types passwds and simple,
                   respectively. The requested item type must be configured
                   (see [34m[1mdacs.conf(5)[0m[1m[22m[14]).

               [4mUSERNAME[0m
                   The [1mDACS [22musername of interest.

               [4mFORMAT[0m
                   By default, output is emitted in HTML. Several varieties of
                   XML output can be selected, however, using the [4mFORMAT[0m
                   argument (please refer to [34m[1mdacs(1)[0m[1m[22m[15] and
                   [34m[1mdacs_passwd.dtd[0m[1m[22m[16]).

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mSEE ALSO[0m
       [34m[1mdacspasswd(1)[0m[1m[22m[6], [34m[1mdacs.conf(5)[0m[1m[22m[17]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[18])

[1mCOPYING[0m
       Copyright (C) 2003-2013 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[19] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. local_passwd_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_passwd_authenticate

        3. htpasswd(1)
           http://httpd.apache.org/docs/2.2/programs/htpasswd.html

        4. mod_auth
           http://httpd.apache.org/docs-2.2/mod/mod_auth.html

        5. mod_auth_dbm
           http://httpd.apache.org/docs-2.2/mod/mod_auth_dbm.html

        6. dacspasswd(1)
           http://dacs.dss.ca/man/dacspasswd.1.html

        7. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

        8. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

        9. ADMIN_IDENTITY
           http://dacs.dss.ca/man/dacs.conf.5.html#ADMIN_IDENTITY

       10. PASSWORD_OPS_NEED_PASSWORD
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_OPS_NEED_PASSWORD

       11. PASSWORD_CONSTRAINTS
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_CONSTRAINTS

       12. this proposal
           http://www.f-secure.com/weblog/archives/00001691.html

       13. random()
           http://dacs.dss.ca/man/dacs.exprs.5.html#random

       14. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

       15. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       16. dacs_passwd.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_passwd.dtd

       17. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       18. www.dss.ca
           http://www.dss.ca

       19. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.28b                      03/01/2013                    DACS_PASSWD(8)
