DACSEMAIL(1)                 DACS Commands Manual                 DACSEMAIL(1)



[1mNAME[0m
       dacsemail - Simple outgoing email agent

[1mSYNOPSIS[0m
       [1mdacsemail [22m[[1m-bcc [4m[22maddr[24m] [{[1m-bf [22m| [1m--bodyfile[22m} [4mpath[24m]
                 [{[1m-bs [22m| [1m--bodystring[22m} [4mstring[24m] [[1m-cc [4m[22maddr[24m]
                 [[1m-ct [4m[22mvalue[24m] [{[1m-f [22m| [1m--from[22m} [4mfrom[24m] [[1m-h [22m| [1m--help[22m]
                 [[1m-header [4m[22mname[24m [4mvalue[24m]
                 [{[1m-mailer [22m| [1m-mta[22m} [4mpath[24m] [{[1m-mailer-flags [22m| [1m-mta-flags[22m} [4mstring[24m]
                 [[1m-p [22m| [1m--prompt[22m] [[1m-save [4m[22mpath[24m] [{[1m-s [22m| [1m--subject[22m} [4msubject[24m]
                 [[1m-sender [4m[22msender[24m] [{[1m-t [22m| [1m--to[22m} [4maddr[24m] [[1m-transform[22m] [[1m-v [22m|
                 [1m--verbose[22m] [[1m-var [4m[22mname[24m [4mvalue[24m]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacsemail [22mutility is a simple agent for sending email messages. It
       is a stand-alone program that neither accepts the usual [1mDACS [22mcommand
       line options ([34m[1mdacsoptions[0m[1m[22m[1]) nor accesses any [1mDACS [22mconfiguration
       files.

       [1mdacsemail [22mconstructs an [34m[1mRFC 822[0m[1m[22m[2] format message but does not transmit
       it. It requires an external mailer, such as [34m[1msendmail(8)[0m[1m[22m[3], to transfer
       the message. The mailer command and its arguments can be specified on
       the [1mdacsemail [22mcommand line (see [1m-mailer[22m) or at build time (see
       [34m[1mdacs.install(7)[0m[1m[22m[4]).

[1mOPTIONS[0m
       If the source for the message body is not specified on the command
       line, it will be read from the standard input. At least one recipient
       must be specified using [1m-t[22m, [1m-cc[22m, or [1m-bcc[22m.

       [1m-bcc [4m[22maddr[0m
           Send the message to the undisclosed recipient address [4maddr[24m. It is
           the responsibility of the mailer to delete these recipient
           addresses before transmitting the message. This flag may be
           repeated.

       [1m-bf [4m[22mpath[0m
       [1m--bodyfile [4m[22mpath[0m
           Read the message body from [4mpath[24m. If [4mpath[24m is -, the standard input
           is read.

       [1m-bs [4m[22mstring[0m
       [1m--bodystring [4m[22mstring[0m
           Use [4mstring[24m as the message body.

       [1m-cc [4m[22maddr[0m
           Send the message to recipient [4maddr[24m as a carbon copy. This flag may
           be repeated.

       [1m-ct [4m[22mvalue[0m
           Add a Content-type header of MIME type [4mvalue[24m to the message. If
           [4mvalue[24m is multipart/alternative, an appropriate [4mboundary[24m variable
           will be created, unless one has already been specified on the
           command line with the [1m-var [22mflag. It is assumed that the message
           body has already been correctly formatted for this MIME type, or
           will be after it has been transformed (see [1m-transform[22m).

       [1m-f [4m[22mfrom[0m
       [1m--from [4m[22mfrom[0m
           Use [4mfrom[24m as the value of the message's From header.

       [1m-h[0m
       [1m--help[0m
           Print usage information and then exit.

       [1m-header [4m[22mname[24m [4mvalue[0m
           Add a message header named [4mname[24m with value [4mvalue[24m. This flag should
           only be used for headers that do not have specific flags ([1m-t[22m, [1m-ct[22m,
           [1m-f[22m, and so on).

       [1m-mailer [4m[22mpath[0m
       [1m-mta [4m[22mpath[0m
           Use the message transfer agent command [4mpath[24m (a full pathname)
           instead of the configured program. This program must read the
           message from its standard input and extract the list of recipients
           from the message's To, Cc, and Bcc headers. (If such a mailer is
           unavailable, it will be necessary to write a small program to wrap
           a mailer and provide the required interface to [1mdacsemail[22m.) The
           default is to run [34m[1msendmail(8)[0m[1m[22m[3] with its [1m-t [22mflag.

       [1m-mailer-flags [4m[22mstring[0m
       [1m-mta-flags [4m[22mstring[0m
           Regardless of the mailer, use [4mstring[24m for its command line flags.

       [1m-p[0m
       [1m--prompt[0m
           Just before the message is to be sent, display it (to stderr) and
           wait for the user to respond to a prompt. At the prompt, the user
           may abort the message or allow it to be sent.

       [1m-save [4m[22mpath[0m
           Just before sending (or prompting), write a copy of the outgoing
           message to [4mpath[24m, replacing any previous contents of the file.

       [1m-s [4m[22msubject[0m
       [1m--subject [4m[22msubject[0m
           Set the message's Subject header to [4msubject[24m.

       [1m-sender [4m[22msender[0m
           Set the message's Sender header to [4msender[24m.

       [1m-t [4m[22maddr[0m
       [1m--to [4m[22maddr[0m
           Add [4maddr[24m as a "To" recipient. This flag may be repeated.

       [1m-transform[0m
           The message body, regardless of how it is specified, is filtered
           through the [1mDACS [22mtransformation function. Please refer to
           [34m[1mdacs_transform(8)[0m[1m[22m[5] for details. No access control rules may be
           associated with any transformation; i.e., they are all
           unconditional. A similar effect can be obtained by piping the
           output of [34m[1mdacstransform(1)[0m[1m[22m[6] into [1mdacsemail[22m.

       [1m-v[0m
       [1m--verbose[0m
           Enable verbose output for debugging.

       [1m-var [4m[22mname[24m [4mvalue[0m
           Create [34m[1ma variable[0m[1m[22m[7] named [4mname[24m set to [4mvalue[24m for the transform
           function. The variable's value can be referenced within the message
           body in the [4mDACS[24m namespace as [4m${DACS::name}[24m. The variable must not
           already be defined.

[1mEXAMPLES[0m
       Suppose myfile contains the following text:


           <!--DACS expand="*" -->
           This is a multi-part message in MIME format.

           --${DACS::boundary}
           Content-Type: text/plain; charset=us-ascii
           Content-Disposition: inline
           Content-Transfer-Encoding: 7bit

           Hello, ${DACS::user}!

           --${DACS::boundary}
           Content-Type: text/html; charset=us-ascii
           Content-Disposition: inline
           Content-Transfer-Encoding: 7bit

           <p>
           <font color="red">Hello, ${DACS::user}!</font>
           </p>
           --${DACS::boundary}--
           <!--DACS end="*" -->

       The following command might be used to send a message with a
       multipart/alternative structured body:

           % dacsemail -ct multipart/alternative -f auggie@example.com \
                 -t harley@example.com -s "Hello" -transform -var user Auggie -bf myfile

       The resulting message will look something like the following:

           To: harley@example.com
           From: auggie@example.com
           Subject: Hello
           Content-type: multipart/alternative; boundary="_----------=_03885942562898683484"
           Date: Wed, 07 Apr 2010 16:48:41 -0700 (PDT)
           Content-transfer-encoding: 7bit
           X-mailer: DACS 1.4.24a

           This is a multi-part message in MIME format.

           --_----------=_03885942562898683484
           Content-Type: text/plain; charset=us-ascii
           Content-Disposition: inline
           Content-Transfer-Encoding: 7bit

           Hello, Auggie!

           --_----------=_03885942562898683484
           Content-Type: text/html; charset=us-ascii
           Content-Disposition: inline
           Content-Transfer-Encoding: 7bit

           <p>
           <font color="red">Hello, Auggie!</font>
           </p>
           --_----------=_03885942562898683484--


[1mFILES[0m
       None.

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.
       Error messages are printed to stderr. Errors and routine messages from
       the mailer are recorded wherever they are normally logged, outside of
       [1mDACS[0m

[1mBUGS[0m
       This program's primary purpose is for testing [1mDACS [22mfunctionality that
       is needed for internal purposes. No significant improvements are
       envisioned. You could throw a rock and hit a better email agent.

[1mSEE ALSO[0m
       [34m[1mdacs.exprs(5)[0m[1m[22m[8], [34m[1mdacs.install(7)[0m[1m[22m[4], [34m[1mdacs_transform(8)[0m[1m[22m[5],
       [34m[1msendmail(8)[0m[1m[22m[3]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[9])

[1mCOPYING[0m
       Copyright (C) 2003-2013 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[10] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. RFC 822
           http://www.rfc-editor.org/rfc/rfc822.txt

        3. sendmail(8)
           http://www.freebsd.org/cgi/man.cgi?query=sendmail&apropos=0&sektion=8&manpath=FreeBSD+9.1-RELEASE&format=html

        4. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html#configure_options

        5. dacs_transform(8)
           http://dacs.dss.ca/man/dacs_transform.8.html

        6. dacstransform(1)
           http://dacs.dss.ca/man/dacstransform.1.html

        7. a variable
           http://dacs.dss.ca/man/dacs.exprs.5.html#variable_syntax

        8. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html#transform

        9. www.dss.ca
           http://www.dss.ca

       10. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.28b                      03/01/2013                      DACSEMAIL(1)
