﻿/* Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com */
using System;
using System.Collections.Generic;
using System.IO;
using Db4objects.Db4o;
using Db4objects.Db4o.Config;
using Db4objects.Db4o.IO;
using Db4objects.Db4o.Query;

namespace Db4odoc.Storage
{
    class CachingStorageExample
    {
        

	private const string Db4oFileName = "reference.db4o";
	private const int ObjectCount = 10000;
	
	private const int PageCount = 6;
	private const int PageSize = 1024;
	

	public static void Main(string[] args){
		CreateDatabase(GetFileStorageConfig());
		QueryDatabase(GetFileStorageConfig());
		CreateDatabase(GetConfig());
		QueryDatabase(GetConfig());
		CreateDatabase(GetDefaultConfig());
		QueryDatabase(GetDefaultConfig());
	}
	// end main


	private static IEmbeddedConfiguration GetConfig() {
		IEmbeddedConfiguration config = Db4oEmbedded.NewConfiguration();
		config.File.Storage = new CachingStorage(new FileStorage(), PageCount, PageSize);
		return config;
	}
	// end GetConfig
	
	private static IEmbeddedConfiguration GetFileStorageConfig() {
		IEmbeddedConfiguration config = Db4oEmbedded.NewConfiguration();
		config.File.Storage = new FileStorage();
		return config;
	}
	// end GetFileStorageConfig
	
	private static IEmbeddedConfiguration GetDefaultConfig() {
		IEmbeddedConfiguration config = Db4oEmbedded.NewConfiguration();
		return config;
	}
	// end GetDefaultConfig


	private static void CreateDatabase(IEmbeddedConfiguration config) {
		File.Delete(Db4oFileName);

	    long startTime = DateTime.Now.Ticks;
		IObjectContainer container = Db4oEmbedded.OpenFile(config, Db4oFileName);
		try {
			ItemStore itemStore = new ItemStore();
			for (int i = 0; i < ObjectCount; i++) {
				itemStore.AddItem(new Item(i, "title" + i));
			}
			container.Store(itemStore);
			Item item  = (Item) container.QueryByExample(
					new Item(1, "title1"))[0];
			System.Console.WriteLine(item);
		} finally {
			container.Close();
		}
		System.Console.WriteLine(String.Format("Time to create a database: {0} ms",
            (DateTime.Now.Ticks - startTime)/TimeSpan.TicksPerMillisecond));
	}
	// end CreateDatabase



	private static void QueryDatabase(IEmbeddedConfiguration config) {

		IObjectContainer container = Db4oEmbedded
				.OpenFile(config, Db4oFileName);
		try {
			List<Item> temp = new List<Item>();
		    long startTime = DateTime.Now.Ticks;
			IQuery q = container.Query();
			q.Constrain(typeof(Item));
			q.Descend("id").Constrain(1).Greater();
			IObjectSet result = q.Execute();
			foreach (Item i in result){
				temp.Add(i);
			}
			System.Console.WriteLine(String.Format("Time to get an objects first time: {0} ms",
					(DateTime.Now.Ticks - startTime)/TimeSpan.TicksPerMillisecond));
			//
			temp = new List<Item>();
		    startTime = DateTime.Now.Ticks;
			foreach (Item i in result){
				temp.Add(i);
			}
			System.Console.WriteLine(String.Format("Time to get an objects second time: {0} ms",
					(DateTime.Now.Ticks - startTime)/TimeSpan.TicksPerMillisecond));
		} finally {
			container.Close();
		}
	}
	// end QueryDatabase

	private class Item{
		int id;
		String name;
		
		public Item(int id, String name){
			this.id = id;
			this.name = name;
		}
		

		public override string ToString(){
			return String.Format("{0} [{1}]", name, id);
		}
	}
	// end Item
	
	private class ItemStore{
		List<Item> items;
		
		public ItemStore(){
			this.items = new List<Item>();
		}
		
		public void AddItem(Item item){
			this.items.Add(item);
		}
	}
	// end ItemStore

    }
}
