//
// C++ Implementation: QueueModel
//
// Description: 
//
//
// Author: Rikard Björklind <olof@linux.nu>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "queuemodel.h"
#include <QtCore>
#include "log.h"
#include "user.h"
#include "util.h"

QVariant QueueModel::data ( const QModelIndex & index, int role ) const
{
	User *u;
	if(!index.isValid()) return QVariant();
    if(index.row() < 0 || index.row() >= itemList.size()) return QVariant();
    if(index.column() < 0 || index.column()>6) return QVariant();
    if(role == Qt::DisplayRole) {
        int i = index.row();
        switch(index.column()) {

            case 0:
				return itemList[i]->status ? tr("RUN") : tr("WAIT");
            case 1:
                return itemList[i]->target;
            case 2:
				return Util::bytesToStr(itemList[i]->size);
            case 3:
                return itemList[i]->downloadedBytes;
            case 4:
				if(itemList[i]->currentSource==-1) return QVariant();
				//u = sessionCfg->findUser(itemList[i]->currentSource);
				u = userModel->getUser( itemList[i]->currentSource);
				if(u) return u->nick;
                return itemList[i]->currentSource;
            case 5:
                return itemList[i]->priority;
        }
    }
    return QVariant();
}

QVariant QueueModel::headerData ( int section, Qt::Orientation orientation, int role ) const
{
    if (role != Qt::DisplayRole)
        return QVariant();

    if(orientation==Qt::Horizontal) {
		
		if(section==0) return tr("Status");
		if(section==1) return tr("Target");
		if(section==2) return tr("Size");
		if(section==3) return tr("Downloaded");
		if(section==4) return tr("Current Source");
		if(section==5) return tr("Priority");

    }
    return QVariant();
}

void QueueModel::onItemAdded( const QueueItem& item)
{
	logger->debug("onItemAdded: %d",item.id);
    items[item.id] = item;
    itemList.append( &items[item.id] );
	emit layoutChanged();
}

void QueueModel::onItemsAdded( const QList< QueueItem > &ql )
{
	for(int i = 0;i < ql.size(); i++ )
	{
		items[ql[i].id] = ql[i];
		itemList.append( &items[ql[i].id] );
	}
	emit layoutChanged();
}

void QueueModel::onItemRemoved( int id )
{
	logger->debug("onItemRemoved: %d",id);
    itemList.removeAll(&items[id]);   
    items.remove(id);
	emit layoutChanged();
}

void QueueModel::onFinished( int id)
{
	logger->debug("queueFinished: %d",id);
    // hmm skip this for now...
}

void QueueModel::onSourcesUpdated( int id, QList<int> sources)
{
	logger->debug("sourcesUpdated: %d",id );
    items[id].sources = sources;
	if(sources.size()==0) {
		items[id].currentSource=-1;
		items[id].status=0;
	}
	emit layoutChanged();
}

void QueueModel::onStatusUpdated(int id,int status,int currentSource,int priority)
{
	logger->debug("statusUpdated: %id",id);
    items[id].status = status;
	items[id].currentSource = currentSource;
	items[id].priority = priority;
	int index = itemList.indexOf(&items[id],0);
	emit dataChanged(createIndex(index,4),createIndex(index,4));
}

QueueItem * QueueModel::getItem( int row ) const throw( IndexOutOfBoundsException )
{
	if(row < 0 || row>= itemList.size()) throw IndexOutOfBoundsException();
	return itemList[row];
}

