// ---------------------------------------------------------------------
//
// Copyright (C) 2013, 2014 by the deal.II authors
//
// This file is part of the deal.II library.
//
// The deal.II library is free software; you can use it, redistribute
// it, and/or modify it under the terms of the GNU Lesser General
// Public License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// The full text of the license can be found in the file LICENSE.md at
// the top level directory of deal.II.
//
// ---------------------------------------------------------------------

/**
 * @page changes_between_2_0_and_3_0 Changes between Version 2.0 and 3.0

<p>
Version 3.0  of the deal.II object-oriented finite  element library is
available on the deal.II home-page at
</p>
<p align="center">
<a href="http://www.dealii.org" target="_top">
      http://www.dealii.org
</a>
</p>

<p>
deal.II is a C++ program  library targeted at adaptive finite elements
and error estimation.  It uses state-of-the-art programming techniques
of the C++ programming language to offer you a modern interface to the
complex  data structures  and algorithms  required for  adaptivity and
enables you to use a variety of finite elements in one, two, and three
space dimensions, as well as support for time-dependent problems.
</p>

<p>
The library is written for research purposes and offers many features:
<ul>
<li><p> Support  for one, two, and  three space dimensions,  using a unified
  interface that enables writing programs almost dimension independent.</p>

<li><p> Handling of locally  refined  grids,  including  different  adaptive
  refinement strategies based  on  local error  indicators  and  error
  estimators.</p>

<li><p> Support  for  a  variety  of  finite  elements,  including  Lagrange 
  elements of order one through four, and discontinuous elements.</p>

<li><p> Extensive documentation: all documentation is available online in  a
  logical tree structure to allow fast access to the  information  you 
  need. If printed it comprises about 200 pages of tutorials,  several
  reports, and far more than  1,000  pages  of  programming  interface
  documentation with  explanations  of  all  classes,  functions,  and 
  variables.</p>

<li><p> Modern software techniques that make  access  to  the  complex  data
  structures and algorithms as transparent as  possible.  The  use  of 
  object oriented programming allows for program structures similar to
  the structures in mathematical analysis.</p>

<li><p> Fast algorithms that enable you to solve problems with up to several
  millions of degrees of freedom quickly. As  opposed  to  programming 
  symbolic algebra packages the penalty for readability is low.</p>

<li><p> Support for several output formats, including  some  common  formats 
  for visualization of scientific data.</p>

<li><p> Support for  a  variety  of  computer  platforms,  including  multi-
  processor machines.</p>

<li><p> Free source code under an Open Source license, and the invitation to
  contribute to further development of the library.</p>
</ul>
</p>

<p>
Wolfgang Bangerth, Guido Kanschat, the deal.II team
</p>

*/
