#!/usr/bin/perl
use warnings;
use strict;
use Debian::Debhelper::Dh_Lib;
use constant USE_LEGACY => 1;

add_command_options( 'dh_makeshlibs', '--noscripts', '-XlibHS' );
add_command_options( 'dh_shlibdeps', '-u -xlibgmp10 --ignore-missing-info' );

if (USE_LEGACY) {
    add_command_options( 'dh_shlibdeps', '-XlibHS' );
}

if (USE_LEGACY) {
    add_command_options( 'dh_gencontrol',
        '-u-DGHC-Package=${haskell:ghc-package}' );
}

# We must forbid debhelper compress interface description files,
# otherwise hoogle would be unhappy. FIXME: It it true?
add_command_options( 'dh_compress', '-X.txt' );
insert_after( 'dh_installchangelogs', 'dh_buildinfo' );
1;
