# -*- coding: utf-8 -*-
# Copyright (C) 2011 Anders Logg, Kristian Oelgaard, and Marie E. Rognes
#
# This file is part of DOLFIN.
#
# DOLFIN is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# DOLFIN is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
#
# First added:  2011-05-23
# Last changed: 2011-05-27

library_index_cpp_template = """\
.. _programmers_reference_index:

#############################################
C++ Programmer's reference for DOLFIN-%s
#############################################

.. toctree::
   :glob:
   :maxdepth: 2

   */index
"""

module_index_cpp_template = """\
.. _programmers_reference_%s_index:

**********************************
DOLFIN %s module
**********************************

.. toctree::
   :glob:
   :maxdepth: 1

   *
"""

header_cpp_template = """\

.. Documentation for the header file dolfin/%(module)s/%(header)s

.. _programmers_reference_cpp_%(module)s_%(prefix)s:

%(title)s
%(formatting)s

.. note::
%(note)s

%(text)s
"""

note_template = """
The documentation on this page was automatically extracted from the
DOLFIN C++ code and may need to be edited or expanded.
"""

automodule_template = """

%(title)s
%(formatting)s

.. automodule:: %(module)s
   :members:
   :undoc-members:
   :show-inheritance:
"""

def generate_library_index(version):
    return library_index_cpp_template % version

def generate_module_index(module):
    return module_index_cpp_template % (module, module)

def generate_automodule(title, formatting, module_name):
    options = {"module": module_name, "title": title,
               "formatting": len(title)*formatting}
    return automodule_template % options


