!{\src2tex{textfont=tt}}
!!****m* etsf_electrons/etsf_io_electrons_def
!! NAME
!!  etsf_io_electrons_def
!!
!! FUNCTION
!!    The given ETSF file must be opened and in define state (see
!!    etsf_io_low_set_define_mode() to change it). Then, all variable of the group
!!    are defined. All required dimensions must have already defined (see
!!    etsf_io_dims_def(). If some dimensions are missing, then the variable
!!    is not defined and no error are generated.
!!
!!    One can specify which variable may be splitted using the optional argument
!!    @split. For each associated array in this structure, variable with appropriated
!!    dimensions will use my_<something> instead of <something>.
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * ncid = 
!!     integer returned by an 'open' NetCDF call. The file can be 
!!     either in define or write mode. This status can be changed
!!     by the call.
!! * k_dependent = (optional) 
!!     use this argument to set the attribute flag 'k_dependent' to 'yes'
!!     or 'no' on variables that have it. If no variable in the group has
!!     the attribute 'k_dependent', this argument has no effect. The default
!!     value is .true. (which puts 'yes' in the file).
!! * flags = (optional) 
!!     One can choose the variables of the group
!!     that will be defined (and disk allocated) using this flag. This is a sum
!!     of values taken from #FLAGS_VARIABLES.
!! * split <type(etsf_split)> = (optional) 
!!     for each array associated in the type, the dimension used to declared the
!!     variables sizes will be 'my_/something/'.
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_electrons_def(ncid, lstat, error_data, k_dependent, flags, &
  & split)

  !Arguments ------------------------------------
  integer, intent(in) :: ncid
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data
  logical, optional, intent(in) :: k_dependent
  integer, optional, intent(in) :: flags
  type(etsf_split), optional, intent(in) :: split

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_electrons_def'
  logical :: my_k_dependent
  integer :: my_flags
  type(etsf_split) :: my_split
  integer :: ivar
  type(split_dim_names) :: split_dims


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_electrons_def : enter'
!ENDDEBUG

  ! Get values for optional arguments, set default.
  if (present(k_dependent)) then
    my_k_dependent = k_dependent
  else
    my_k_dependent = .true.
  end if
  if (present(flags)) then
    my_flags = flags
  else
    my_flags = etsf_electrons_all
  end if
  ! Consistency checks.
  if (my_flags < etsf_electrons_none .or. my_flags > etsf_electrons_all) then
    call etsf_io_low_error_set(error_data, ERROR_MODE_DEF, ERROR_TYPE_ARG, my_name, &
                             & tgtname = "flags", errmess = "value out of bounds")
    lstat = .false.
    return
  end if
  
  ! Set the name for dimensions that could be splitted.
  if (present(split)) then
    if (associated(split%my_kpoints)) then
      write(split_dims%number_of_kpoints, "(A)") &
        & "my_number_of_kpoints"
    end if
    if (associated(split%my_spins)) then
      write(split_dims%number_of_spins, "(A)") &
        & "my_number_of_spins"
    end if
    if (associated(split%my_states)) then
      write(split_dims%max_number_of_states, "(A)") &
        & "my_max_number_of_states"
    end if
  end if
  
  if (iand(my_flags, etsf_electrons_number_of_electrons) /= 0) then
    call etsf_io_low_def_var(ncid, "number_of_electrons", &
      & etsf_io_low_integer, &
      & lstat, ncvarid = ivar, error_data = error_data)
    ! We raise don't raise an error if a dimension is missing.
    if (.not. lstat .and. (error_data%access_mode_id /= ERROR_MODE_INQ .or. &
      & error_data%target_type_id /= ERROR_TYPE_DID)) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (iand(my_flags, etsf_electrons_x_functional) /= 0) then
    call etsf_io_low_def_var(ncid, "exchange_functional", &
      & etsf_io_low_character, &
      & (/ pad("character_string_length") /), &
      & lstat, ncvarid = ivar, error_data = error_data)
    ! We raise don't raise an error if a dimension is missing.
    if (.not. lstat .and. (error_data%access_mode_id /= ERROR_MODE_INQ .or. &
      & error_data%target_type_id /= ERROR_TYPE_DID)) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (iand(my_flags, etsf_electrons_c_functional) /= 0) then
    call etsf_io_low_def_var(ncid, "correlation_functional", &
      & etsf_io_low_character, &
      & (/ pad("character_string_length") /), &
      & lstat, ncvarid = ivar, error_data = error_data)
    ! We raise don't raise an error if a dimension is missing.
    if (.not. lstat .and. (error_data%access_mode_id /= ERROR_MODE_INQ .or. &
      & error_data%target_type_id /= ERROR_TYPE_DID)) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (iand(my_flags, etsf_electrons_fermi_energy) /= 0) then
    call etsf_io_low_def_var(ncid, "fermi_energy", &
      & etsf_io_low_double, &
      & lstat, ncvarid = ivar, error_data = error_data)
    ! We raise don't raise an error if a dimension is missing.
    if (.not. lstat .and. (error_data%access_mode_id /= ERROR_MODE_INQ .or. &
      & error_data%target_type_id /= ERROR_TYPE_DID)) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    if (ivar >= 0) then
      ! Handle the units attribute.
      call etsf_io_low_write_att(ncid, ivar, &
                              & "units", &
                              & "atomic units", &
                              & lstat, error_data = error_data)
      if (.not. lstat) return
      call etsf_io_low_write_att(ncid, ivar, &
                              & "scale_to_atomic_units", &
                              & 1.0d0, &
                              & lstat, error_data = error_data)
      if (.not. lstat) then
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
  end if
  
  if (iand(my_flags, etsf_electrons_smearing_scheme) /= 0) then
    call etsf_io_low_def_var(ncid, "smearing_scheme", &
      & etsf_io_low_character, &
      & (/ pad("character_string_length") /), &
      & lstat, ncvarid = ivar, error_data = error_data)
    ! We raise don't raise an error if a dimension is missing.
    if (.not. lstat .and. (error_data%access_mode_id /= ERROR_MODE_INQ .or. &
      & error_data%target_type_id /= ERROR_TYPE_DID)) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (iand(my_flags, etsf_electrons_smearing_width) /= 0) then
    call etsf_io_low_def_var(ncid, "smearing_width", &
      & etsf_io_low_double, &
      & lstat, ncvarid = ivar, error_data = error_data)
    ! We raise don't raise an error if a dimension is missing.
    if (.not. lstat .and. (error_data%access_mode_id /= ERROR_MODE_INQ .or. &
      & error_data%target_type_id /= ERROR_TYPE_DID)) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    if (ivar >= 0) then
      ! Handle the units attribute.
      call etsf_io_low_write_att(ncid, ivar, &
                              & "units", &
                              & "atomic units", &
                              & lstat, error_data = error_data)
      if (.not. lstat) return
      call etsf_io_low_write_att(ncid, ivar, &
                              & "scale_to_atomic_units", &
                              & 1.0d0, &
                              & lstat, error_data = error_data)
      if (.not. lstat) then
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
  end if
  
  if (iand(my_flags, etsf_electrons_number_of_states) /= 0) then
    call etsf_io_low_def_var(ncid, "number_of_states", &
      & etsf_io_low_integer, &
      & (/ split_dims%number_of_kpoints, &
      &    split_dims%number_of_spins /), &
      & lstat, ncvarid = ivar, error_data = error_data)
    ! We raise don't raise an error if a dimension is missing.
    if (.not. lstat .and. (error_data%access_mode_id /= ERROR_MODE_INQ .or. &
      & error_data%target_type_id /= ERROR_TYPE_DID)) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (iand(my_flags, etsf_electrons_eigenvalues) /= 0) then
    call etsf_io_low_def_var(ncid, "eigenvalues", &
      & etsf_io_low_double, &
      & (/ split_dims%max_number_of_states, &
      &    split_dims%number_of_kpoints, &
      &    split_dims%number_of_spins /), &
      & lstat, ncvarid = ivar, error_data = error_data)
    ! We raise don't raise an error if a dimension is missing.
    if (.not. lstat .and. (error_data%access_mode_id /= ERROR_MODE_INQ .or. &
      & error_data%target_type_id /= ERROR_TYPE_DID)) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    if (ivar >= 0) then
      ! Handle the units attribute.
      call etsf_io_low_write_att(ncid, ivar, &
                              & "units", &
                              & "atomic units", &
                              & lstat, error_data = error_data)
      if (.not. lstat) return
      call etsf_io_low_write_att(ncid, ivar, &
                              & "scale_to_atomic_units", &
                              & 1.0d0, &
                              & lstat, error_data = error_data)
      if (.not. lstat) then
        call etsf_io_low_error_update(error_data, my_name)
        return
      end if
    end if
  end if
  
  if (iand(my_flags, etsf_electrons_occupations) /= 0) then
    call etsf_io_low_def_var(ncid, "occupations", &
      & etsf_io_low_double, &
      & (/ split_dims%max_number_of_states, &
      &    split_dims%number_of_kpoints, &
      &    split_dims%number_of_spins /), &
      & lstat, ncvarid = ivar, error_data = error_data)
    ! We raise don't raise an error if a dimension is missing.
    if (.not. lstat .and. (error_data%access_mode_id /= ERROR_MODE_INQ .or. &
      & error_data%target_type_id /= ERROR_TYPE_DID)) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  ! If we reach the end, then it should be OK.
  lstat = .true.


!DEBUG
!write (*,*) 'etsf_io_electrons_def : exit'
!ENDDEBUG

end subroutine etsf_io_electrons_def
!!***
