/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.algorithm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.zip.Checksum;
import jonelo.jacksum.util.Service;
import jonelo.sugar.util.Base32;
import jonelo.sugar.util.Base64;
import jonelo.sugar.util.BubbleBabble;
import jonelo.sugar.util.EncodingException;
import jonelo.sugar.util.GeneralString;

public abstract class AbstractChecksum
implements Checksum {
    public static final String BIN = "bin";
    public static final String DEC = "dec";
    public static final String OCT = "oct";
    public static final String HEX = "hex";
    public static final String HEX_UPPERCASE = "hexup";
    public static final String BASE16 = "base16";
    public static final String BASE32 = "base32";
    public static final String BASE64 = "base64";
    public static final String BUBBLEBABBLE = "bubblebabble";
    public static final int BUFFERSIZE = 8192;
    protected long value = 0L;
    protected long length = 0L;
    protected String separator = "\t";
    protected String filename = null;
    protected String encoding = "";
    protected int group = 0;
    protected char groupChar = (char)32;
    protected String timestampFormat = null;
    protected Format timestampFormatter = null;
    protected long timestamp = 0L;
    protected String name = null;

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void reset() {
        this.value = 0L;
        this.length = 0L;
    }

    public void update(int n) {
        ++this.length;
    }

    public void update(byte by) {
        this.update(by & 0xFF);
    }

    public void update(byte[] byArray, int n, int n2) {
        for (int i = n; i < n2 + n; ++i) {
            this.update(byArray[i]);
        }
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public long getValue() {
        return this.value;
    }

    public long getLength() {
        return this.length;
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public String getSeparator() {
        return this.separator;
    }

    public byte[] getByteArray() {
        return new byte[]{(byte)(this.value & 0xFFL)};
    }

    public String toString() {
        return this.getFormattedValue() + this.separator + this.length + this.separator + (this.isTimestampWanted() ? this.getTimestampFormatted() + this.separator : "") + this.filename;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AbstractChecksum) {
            AbstractChecksum abstractChecksum = (AbstractChecksum)object;
            return Arrays.equals(this.getByteArray(), abstractChecksum.getByteArray());
        }
        return false;
    }

    public int hashCode() {
        byte[] byArray = this.getByteArray();
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n = ((n << 8) + byArray[i]) % 0x7FFFF1;
        }
        return n;
    }

    public String getFormattedValue() {
        if (this.encoding.equalsIgnoreCase(HEX)) {
            return Service.format(this.getByteArray(), false, this.group, this.groupChar);
        }
        if (this.encoding.equalsIgnoreCase(HEX_UPPERCASE)) {
            return Service.format(this.getByteArray(), true, this.group, this.groupChar);
        }
        if (this.encoding.equalsIgnoreCase(BASE16)) {
            return Service.format(this.getByteArray(), true, 0, this.groupChar);
        }
        if (this.encoding.equalsIgnoreCase(BASE32)) {
            return Base32.encode(this.getByteArray());
        }
        if (this.encoding.equalsIgnoreCase(BASE64)) {
            return Base64.encodeBytes(this.getByteArray(), 8);
        }
        if (this.encoding.equalsIgnoreCase(BUBBLEBABBLE)) {
            return BubbleBabble.encode(this.getByteArray());
        }
        if (this.encoding.equalsIgnoreCase(DEC)) {
            BigInteger bigInteger = new BigInteger(1, this.getByteArray());
            return bigInteger.toString();
        }
        if (this.encoding.equalsIgnoreCase(BIN)) {
            return Service.formatAsBits(this.getByteArray());
        }
        if (this.encoding.equalsIgnoreCase(OCT)) {
            BigInteger bigInteger = new BigInteger(1, this.getByteArray());
            return bigInteger.toString(8);
        }
        return Long.toString(this.getValue());
    }

    public void firstFormat(StringBuffer stringBuffer) {
        GeneralString.replaceAllStrings(stringBuffer, "#FINGERPRINT", "#CHECKSUM");
    }

    public String format(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        this.firstFormat(stringBuffer);
        GeneralString.replaceAllStrings(stringBuffer, "#CHECKSUM{i}", "#CHECKSUM");
        GeneralString.replaceAllStrings(stringBuffer, "#ALGONAME{i}", "#ALGONAME");
        GeneralString.replaceAllStrings(stringBuffer, "#ALGONAME", this.getName());
        GeneralString.replaceAllStrings(stringBuffer, "#CHECKSUM", this.getFormattedValue());
        GeneralString.replaceAllStrings(stringBuffer, "#FILESIZE", Long.toString(this.length));
        if (stringBuffer.toString().indexOf("#FILENAME{") > -1) {
            File file = new File(this.filename);
            GeneralString.replaceAllStrings(stringBuffer, "#FILENAME{NAME}", file.getName());
            String string2 = file.getParent();
            if (string2 == null) {
                string2 = "";
            } else if (!string2.endsWith(File.separator) && !string2.endsWith(":") && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                string2 = string2 + File.separator;
            }
            GeneralString.replaceAllStrings(stringBuffer, "#FILENAME{PATH}", string2);
        }
        GeneralString.replaceAllStrings(stringBuffer, "#FILENAME", this.filename);
        if (this.isTimestampWanted()) {
            GeneralString.replaceAllStrings(stringBuffer, "#TIMESTAMP", this.getTimestampFormatted());
        }
        GeneralString.replaceAllStrings(stringBuffer, "#SEPARATOR", this.separator);
        GeneralString.replaceAllStrings(stringBuffer, "#QUOTE", "\"");
        return stringBuffer.toString();
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setEncoding(String string) throws EncodingException {
        if (string == null) {
            this.encoding = "";
        } else if (string.equalsIgnoreCase("bb")) {
            this.encoding = BUBBLEBABBLE;
        } else if (string.length() == 0 || string.equalsIgnoreCase(HEX) || string.equalsIgnoreCase(HEX_UPPERCASE) || string.equalsIgnoreCase(DEC) || string.equalsIgnoreCase(BIN) || string.equalsIgnoreCase(OCT) || string.equalsIgnoreCase(BASE16) || string.equalsIgnoreCase(BASE32) || string.equalsIgnoreCase(BASE64) || string.equalsIgnoreCase(BUBBLEBABBLE)) {
            this.encoding = string;
        } else {
            throw new EncodingException("Encoding is not supported");
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isGroupWanted() {
        return this.group > 0;
    }

    public void setGroup(int n) {
        this.group = n;
    }

    public int getGroup() {
        return this.group;
    }

    public void setGroupChar(char c) {
        this.groupChar = c;
    }

    public char getGroupChar() {
        return this.groupChar;
    }

    public void setGrouping(int n, char c) {
        this.setGroup(n);
        this.setGroupChar(c);
    }

    public void setHex(boolean bl) {
        this.encoding = bl ? HEX : "";
    }

    public void setUpperCase(boolean bl) {
        this.encoding = bl ? HEX_UPPERCASE : HEX;
    }

    public String getHexValue() {
        return Service.format(this.getByteArray(), this.encoding.equalsIgnoreCase(HEX_UPPERCASE), this.group, this.groupChar);
    }

    public void setTimestamp(String string) {
        File file = new File(string);
        this.timestamp = file.lastModified();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestampFormat(String string) {
        this.timestampFormat = string;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public String getTimestampFormatted() {
        if (this.timestampFormatter == null) {
            this.timestampFormatter = new SimpleDateFormat(this.timestampFormat);
        }
        return this.timestampFormatter.format(new Date(this.timestamp));
    }

    public boolean isTimestampWanted() {
        return this.timestampFormat != null;
    }

    public long readFile(String string) throws IOException {
        return this.readFile(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readFile(String string, boolean bl) throws IOException {
        this.filename = string;
        if (this.isTimestampWanted()) {
            this.setTimestamp(string);
        }
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        long l = 0L;
        try {
            fileInputStream = new FileInputStream(string);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            if (bl) {
                this.reset();
            }
            l = this.length;
            int n = 0;
            byte[] byArray = new byte[8192];
            while ((n = bufferedInputStream.read(byArray)) > -1) {
                this.update(byArray, 0, n);
            }
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return this.length - l;
    }
}

