/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.controller.DispatcherServlet;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesServletException;
import net.sourceforge.stripes.util.Log;

public class DynamicMappingFilter
implements Filter {
    private static final String INCLUDE_BUFFER_SIZE_PARAM = "IncludeBufferSize";
    private static int includeBufferSize = 1024;
    private static Log log = Log.getInstance(DynamicMappingFilter.class);
    private boolean initialized = false;
    private ServletContext servletContext;
    private StripesFilter stripesFilter;
    private DispatcherServlet stripesDispatcher;

    public void init(final FilterConfig config) throws ServletException {
        try {
            includeBufferSize = Integer.valueOf(config.getInitParameter(INCLUDE_BUFFER_SIZE_PARAM).trim());
            log.info(DynamicMappingFilter.class.getName(), " include buffer size is ", includeBufferSize);
        }
        catch (NullPointerException e) {
        }
        catch (Exception e) {
            log.warn(e, "Could not interpret '", config.getInitParameter(INCLUDE_BUFFER_SIZE_PARAM), "' as a number for init-param '", INCLUDE_BUFFER_SIZE_PARAM, "'. Using default value of ", includeBufferSize, ".");
        }
        this.servletContext = config.getServletContext();
        this.stripesDispatcher = new DispatcherServlet();
        this.stripesDispatcher.init(new ServletConfig(){

            public String getInitParameter(String name) {
                return config.getInitParameter(name);
            }

            public Enumeration<?> getInitParameterNames() {
                return config.getInitParameterNames();
            }

            public ServletContext getServletContext() {
                return config.getServletContext();
            }

            public String getServletName() {
                return config.getFilterName();
            }
        });
    }

    public void destroy() {
        this.stripesDispatcher.destroy();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.initialized) {
            this.doOneTimeConfiguration();
        }
        final ErrorTrappingResponseWrapper wrapper = new ErrorTrappingResponseWrapper((HttpServletResponse)response);
        wrapper.setInclude(request.getAttribute("javax.servlet.include.request_uri") != null);
        chain.doFilter(request, (ServletResponse)wrapper);
        Integer errorCode = wrapper.getErrorCode();
        if (errorCode != null && errorCode == 404) {
            this.stripesFilter.doFilter(request, response, new FilterChain(){

                public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                    String uri = DynamicMappingFilter.this.getRequestURI((HttpServletRequest)request);
                    Class<? extends ActionBean> beanType = StripesFilter.getConfiguration().getActionResolver().getActionBeanType(uri);
                    if (beanType == null) {
                        wrapper.proceed();
                    } else {
                        DynamicMappingFilter.this.stripesDispatcher.service(request, response);
                    }
                }
            });
        } else {
            wrapper.proceed();
        }
    }

    protected void doOneTimeConfiguration() throws ServletException {
        this.stripesFilter = (StripesFilter)this.servletContext.getAttribute(StripesFilter.class.getName());
        if (this.stripesFilter == null) {
            throw new StripesServletException("Could not get a reference to StripesFilter from the servlet context. The dynamic mapping filter works in conjunction with StripesFilter and requires that it be defined in web.xml");
        }
        this.initialized = true;
    }

    protected String getRequestURI(HttpServletRequest request) {
        String contextPath;
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        if (uri == null) {
            uri = request.getRequestURI();
        }
        if ((contextPath = request.getContextPath()).length() > 1) {
            uri = uri.substring(contextPath.length());
        }
        return uri;
    }

    public static class ErrorTrappingResponseWrapper
    extends HttpServletResponseWrapper {
        private Integer errorCode;
        private String errorMessage;
        private boolean include;
        private PrintWriter printWriter;
        private TempBufferWriter tempBufferWriter;

        public ErrorTrappingResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int errorCode, String errorMessage) throws IOException {
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
        }

        public void sendError(int errorCode) throws IOException {
            this.errorCode = errorCode;
            this.errorMessage = null;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.isInclude() && includeBufferSize > 0) {
                if (this.printWriter == null) {
                    this.tempBufferWriter = new TempBufferWriter(super.getWriter());
                    this.printWriter = new PrintWriter(this.tempBufferWriter);
                }
                return this.printWriter;
            }
            return super.getWriter();
        }

        public boolean isInclude() {
            return this.include;
        }

        public void setInclude(boolean include) {
            this.include = include;
        }

        public Integer getErrorCode() {
            return this.errorCode;
        }

        public void clearError() {
            this.errorCode = null;
            this.errorMessage = null;
        }

        public void proceed() throws IOException {
            if (this.tempBufferWriter != null) {
                this.tempBufferWriter.overflow();
            }
            if (this.errorCode != null) {
                if (this.errorMessage == null) {
                    super.sendError(this.errorCode.intValue());
                } else {
                    super.sendError(this.errorCode.intValue(), this.errorMessage);
                }
            }
        }
    }

    public static class TempBufferWriter
    extends Writer {
        private StringWriter buffer;
        private PrintWriter out;

        public TempBufferWriter(PrintWriter out) {
            this.out = out;
            this.buffer = new StringWriter(includeBufferSize);
        }

        public void close() throws IOException {
            this.flush();
            this.out.close();
        }

        public void flush() throws IOException {
            this.overflow();
            this.out.flush();
        }

        public void write(char[] chars, int offset, int length) throws IOException {
            if (this.buffer == null) {
                this.out.write(chars, offset, length);
            } else if (this.buffer.getBuffer().length() + length > includeBufferSize) {
                this.overflow();
                this.out.write(chars, offset, length);
            } else {
                this.buffer.write(chars, offset, length);
            }
        }

        protected void overflow() {
            if (this.buffer != null) {
                this.out.print(this.buffer.toString());
                this.buffer = null;
            }
        }
    }
}

