/* Generated by JTB 1.4.8 */
package EDU.purdue.jtb.visitor;

import EDU.purdue.jtb.syntaxtree.*;
import java.util.*;

/**
 * Provides default methods which visit each node in the tree in depth-first order.<br>
 * In your "Void" visitors extend this class and override part or all of these methods.
 *
 */
public class DepthFirstVoidVisitor implements IVoidVisitor {


  /*
   * Base nodes classes visit methods (to be overridden if necessary)
   */

  /**
   * Visits a {@link NodeChoice} node.
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final NodeChoice n) {
    n.choice.accept(this);
    return;
  }

  /**
   * Visits a {@link NodeList} node.
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final NodeList n) {
    for (final Iterator<INode> e = n.elements(); e.hasNext();) {
      e.next().accept(this);
    }
    return;
  }

  /**
   * Visits a {@link NodeListOptional} node.
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final NodeListOptional n) {
    if (n.present()) {
      for (final Iterator<INode> e = n.elements(); e.hasNext();) {
        e.next().accept(this);
        }
      return;
    } else
      return;
  }

  /**
   * Visits a {@link NodeOptional} node.
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final NodeOptional n) {
    if (n.present()) {
      n.node.accept(this);
      return;
    } else
      return;
  }

  /**
   * Visits a {@link NodeSequence} node.
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final NodeSequence n) {
    for (final Iterator<INode> e = n.elements(); e.hasNext();) {
      e.next().accept(this);
    }
    return;
  }

  /**
   * Visits a {@link NodeTCF} node.
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final NodeTCF n) {
    @SuppressWarnings("unused")
    final String tkIm = n.tokenImage;
    return;
  }

  /**
   * Visits a {@link NodeToken} node.
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final NodeToken n) {
    @SuppressWarnings("unused")
    final String tkIm = n.tokenImage;
    return;
  }

  /*
   * User grammar generated visit methods (to be overridden if necessary)
   */

  /**
   * Visits a {@link JavaCCInput} node, whose children are the following :
   * <p>
   * f0 -> JavaCCOptions()<br>
   * f1 -> "PARSER_BEGIN"<br>
   * f2 -> "("<br>
   * f3 -> IdentifierAsString()<br>
   * f4 -> ")"<br>
   * f5 -> CompilationUnit()<br>
   * f6 -> "PARSER_END"<br>
   * f7 -> "("<br>
   * f8 -> IdentifierAsString()<br>
   * f9 -> ")"<br>
   * f10 -> ( Production() )+<br>
   * f11 -> <EOF><br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final JavaCCInput n) {
    // f0 -> JavaCCOptions()
    final JavaCCOptions n0 = n.f0;
    n0.accept(this);
    // f1 -> "PARSER_BEGIN"
    final NodeToken n1 = n.f1;
    n1.accept(this);
    // f2 -> "("
    final NodeToken n2 = n.f2;
    n2.accept(this);
    // f3 -> IdentifierAsString()
    final IdentifierAsString n3 = n.f3;
    n3.accept(this);
    // f4 -> ")"
    final NodeToken n4 = n.f4;
    n4.accept(this);
    // f5 -> CompilationUnit()
    final CompilationUnit n5 = n.f5;
    n5.accept(this);
    // f6 -> "PARSER_END"
    final NodeToken n6 = n.f6;
    n6.accept(this);
    // f7 -> "("
    final NodeToken n7 = n.f7;
    n7.accept(this);
    // f8 -> IdentifierAsString()
    final IdentifierAsString n8 = n.f8;
    n8.accept(this);
    // f9 -> ")"
    final NodeToken n9 = n.f9;
    n9.accept(this);
    // f10 -> ( Production() )+
    final NodeList n10 = n.f10;
    for (int i = 0; i < n10.size(); i++) {
      final INode lsteai = n10.elementAt(i);
      lsteai.accept(this);
    }
    // f11 -> <EOF>
    final NodeToken n11 = n.f11;
    n11.accept(this);
  }

  /**
   * Visits a {@link JavaCCOptions} node, whose child is the following :
   * <p>
   * f0 -> [ #0 "options" #1 "{"<br>
   * .. .. . #2 ( OptionBinding() )*<br>
   * .. .. . #3 "}" ]<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final JavaCCOptions n) {
    // f0 -> [ #0 "options" #1 "{"
    // .. .. . #2 ( OptionBinding() )*
    // .. .. . #3 "}" ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      final NodeSequence seq = (NodeSequence) n0.node;
      // #0 "options"
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 "{"
      final INode seq2 = seq.elementAt(1);
      seq2.accept(this);
      // #2 ( OptionBinding() )*
      final INode seq3 = seq.elementAt(2);
      final NodeListOptional nlo = (NodeListOptional) seq3;
      if (nlo.present()) {
        for (int i = 0; i < nlo.size(); i++) {
          final INode nloeai = nlo.elementAt(i);
          nloeai.accept(this);
        }
      }
      // #3 "}"
      final INode seq4 = seq.elementAt(3);
      seq4.accept(this);
    }
  }

  /**
   * Visits a {@link OptionBinding} node, whose children are the following :
   * <p>
   * f0 -> ( %0 <IDENTIFIER><br>
   * .. .. | %1 "LOOKAHEAD"<br>
   * .. .. | %2 "IGNORE_CASE"<br>
   * .. .. | %3 "static" )<br>
   * f1 -> "="<br>
   * f2 -> ( %0 IntegerLiteral()<br>
   * .. .. | %1 BooleanLiteral()<br>
   * .. .. | %2 StringLiteral() )<br>
   * f3 -> ";"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final OptionBinding n) {
    // f0 -> ( %0 <IDENTIFIER>
    // .. .. | %1 "LOOKAHEAD"
    // .. .. | %2 "IGNORE_CASE"
    // .. .. | %3 "static" )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 <IDENTIFIER>
        ich.accept(this);
        break;
      case 1:
        // %1 "LOOKAHEAD"
        ich.accept(this);
        break;
      case 2:
        // %2 "IGNORE_CASE"
        ich.accept(this);
        break;
      case 3:
        // %3 "static"
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    // f1 -> "="
    final NodeToken n1 = n.f1;
    n1.accept(this);
    // f2 -> ( %0 IntegerLiteral()
    // .. .. | %1 BooleanLiteral()
    // .. .. | %2 StringLiteral() )
    final NodeChoice n2 = n.f2;
    final NodeChoice nch1 = n2;
    final INode ich1 = nch1.choice;
    switch (nch1.which) {
      case 0:
        // %0 IntegerLiteral()
        ich1.accept(this);
        break;
      case 1:
        // %1 BooleanLiteral()
        ich1.accept(this);
        break;
      case 2:
        // %2 StringLiteral()
        ich1.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    // f3 -> ";"
    final NodeToken n3 = n.f3;
    n3.accept(this);
  }

  /**
   * Visits a {@link Production} node, whose child is the following :
   * <p>
   * f0 -> . %0 JavaCodeProduction()<br>
   * .. .. | %1 RegularExprProduction()<br>
   * .. .. | %2 TokenManagerDecls()<br>
   * .. .. | %3 BNFProduction()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final Production n) {
    // f0 -> . %0 JavaCodeProduction()
    // .. .. | %1 RegularExprProduction()
    // .. .. | %2 TokenManagerDecls()
    // .. .. | %3 BNFProduction()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 JavaCodeProduction()
        ich.accept(this);
        break;
      case 1:
        // %1 RegularExprProduction()
        ich.accept(this);
        break;
      case 2:
        // %2 TokenManagerDecls()
        ich.accept(this);
        break;
      case 3:
        // %3 BNFProduction()
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link JavaCodeProduction} node, whose children are the following :
   * <p>
   * f0 -> "JAVACODE"<br>
   * f1 -> AccessModifier()<br>
   * f2 -> ResultType()<br>
   * f3 -> IdentifierAsString()<br>
   * f4 -> FormalParameters()<br>
   * f5 -> [ #0 "throws" #1 Name()<br>
   * .. .. . #2 ( $0 "," $1 Name() )* ]<br>
   * f6 -> [ "%" ]<br>
   * f7 -> Block()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final JavaCodeProduction n) {
    // f0 -> "JAVACODE"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> AccessModifier()
    final AccessModifier n1 = n.f1;
    n1.accept(this);
    // f2 -> ResultType()
    final ResultType n2 = n.f2;
    n2.accept(this);
    // f3 -> IdentifierAsString()
    final IdentifierAsString n3 = n.f3;
    n3.accept(this);
    // f4 -> FormalParameters()
    final FormalParameters n4 = n.f4;
    n4.accept(this);
    // f5 -> [ #0 "throws" #1 Name()
    // .. .. . #2 ( $0 "," $1 Name() )* ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      final NodeSequence seq = (NodeSequence) n5.node;
      // #0 "throws"
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 Name()
      final INode seq2 = seq.elementAt(1);
      seq2.accept(this);
      // #2 ( $0 "," $1 Name() )*
      final INode seq3 = seq.elementAt(2);
      final NodeListOptional nlo = (NodeListOptional) seq3;
      if (nlo.present()) {
        for (int i = 0; i < nlo.size(); i++) {
          final INode nloeai = nlo.elementAt(i);
          final NodeSequence seq4 = (NodeSequence) nloeai;
          // $0 ","
          final INode seq5 = seq4.elementAt(0);
          seq5.accept(this);
          // $1 Name()
          final INode seq6 = seq4.elementAt(1);
          seq6.accept(this);
        }
      }
    }
    // f6 -> [ "%" ]
    final NodeOptional n6 = n.f6;
    if (n6.present()) {
      n6.accept(this);
    }
    // f7 -> Block()
    final Block n7 = n.f7;
    n7.accept(this);
  }

  /**
   * Visits a {@link BNFProduction} node, whose children are the following :
   * <p>
   * f0 -> AccessModifier()<br>
   * f1 -> ResultType()<br>
   * f2 -> IdentifierAsString()<br>
   * f3 -> FormalParameters()<br>
   * f4 -> [ #0 "throws" #1 Name()<br>
   * .. .. . #2 ( $0 "," $1 Name() )* ]<br>
   * f5 -> [ "!" ]<br>
   * f6 -> ":"<br>
   * f7 -> Block()<br>
   * f8 -> "{"<br>
   * f9 -> ExpansionChoices()<br>
   * f10 -> "}"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final BNFProduction n) {
    // f0 -> AccessModifier()
    final AccessModifier n0 = n.f0;
    n0.accept(this);
    // f1 -> ResultType()
    final ResultType n1 = n.f1;
    n1.accept(this);
    // f2 -> IdentifierAsString()
    final IdentifierAsString n2 = n.f2;
    n2.accept(this);
    // f3 -> FormalParameters()
    final FormalParameters n3 = n.f3;
    n3.accept(this);
    // f4 -> [ #0 "throws" #1 Name()
    // .. .. . #2 ( $0 "," $1 Name() )* ]
    final NodeOptional n4 = n.f4;
    if (n4.present()) {
      final NodeSequence seq = (NodeSequence) n4.node;
      // #0 "throws"
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 Name()
      final INode seq2 = seq.elementAt(1);
      seq2.accept(this);
      // #2 ( $0 "," $1 Name() )*
      final INode seq3 = seq.elementAt(2);
      final NodeListOptional nlo = (NodeListOptional) seq3;
      if (nlo.present()) {
        for (int i = 0; i < nlo.size(); i++) {
          final INode nloeai = nlo.elementAt(i);
          final NodeSequence seq4 = (NodeSequence) nloeai;
          // $0 ","
          final INode seq5 = seq4.elementAt(0);
          seq5.accept(this);
          // $1 Name()
          final INode seq6 = seq4.elementAt(1);
          seq6.accept(this);
        }
      }
    }
    // f5 -> [ "!" ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      n5.accept(this);
    }
    // f6 -> ":"
    final NodeToken n6 = n.f6;
    n6.accept(this);
    // f7 -> Block()
    final Block n7 = n.f7;
    n7.accept(this);
    // f8 -> "{"
    final NodeToken n8 = n.f8;
    n8.accept(this);
    // f9 -> ExpansionChoices()
    final ExpansionChoices n9 = n.f9;
    n9.accept(this);
    // f10 -> "}"
    final NodeToken n10 = n.f10;
    n10.accept(this);
  }

  /**
   * Visits a {@link AccessModifier} node, whose child is the following :
   * <p>
   * f0 -> ( %0 "public"<br>
   * .. .. | %1 "protected"<br>
   * .. .. | %2 "private"<br>
   * .. .. | %3 "final" )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final AccessModifier n) {
    // f0 -> ( %0 "public"
    // .. .. | %1 "protected"
    // .. .. | %2 "private"
    // .. .. | %3 "final" )*
    final NodeListOptional n0 = n.f0;
    if (n0.present()) {
      for (int i = 0; i < n0.size(); i++) {
        final INode nloeai = n0.elementAt(i);
        final NodeChoice nch = (NodeChoice) nloeai;
        final INode ich = nch.choice;
        switch (nch.which) {
          case 0:
            // %0 "public"
            ich.accept(this);
            break;
          case 1:
            // %1 "protected"
            ich.accept(this);
            break;
          case 2:
            // %2 "private"
            ich.accept(this);
            break;
          case 3:
            // %3 "final"
            ich.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
      }
    }
  }

  /**
   * Visits a {@link RegularExprProduction} node, whose children are the following :
   * <p>
   * f0 -> [ %0 #0 "<" #1 "*" #2 ">"<br>
   * .. .. | %1 #0 "<" #1 <IDENTIFIER><br>
   * .. .. . .. #2 ( $0 "," $1 <IDENTIFIER> )*<br>
   * .. .. . .. #3 ">" ]<br>
   * f1 -> RegExprKind()<br>
   * f2 -> [ #0 "[" #1 "IGNORE_CASE" #2 "]" ]<br>
   * f3 -> ":"<br>
   * f4 -> "{"<br>
   * f5 -> RegExprSpec()<br>
   * f6 -> ( #0 "|" #1 RegExprSpec() )*<br>
   * f7 -> "}"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final RegularExprProduction n) {
    // f0 -> [ %0 #0 "<" #1 "*" #2 ">"
    // .. .. | %1 #0 "<" #1 <IDENTIFIER>
    // .. .. . .. #2 ( $0 "," $1 <IDENTIFIER> )*
    // .. .. . .. #3 ">" ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      final NodeChoice nch = (NodeChoice) n0.node;
      final INode ich = nch.choice;
      switch (nch.which) {
        case 0:
          // %0 #0 "<" #1 "*" #2 ">"
          final NodeSequence seq = (NodeSequence) ich;
          // #0 "<"
          final INode seq1 = seq.elementAt(0);
          seq1.accept(this);
          // #1 "*"
          final INode seq2 = seq.elementAt(1);
          seq2.accept(this);
          // #2 ">"
          final INode seq3 = seq.elementAt(2);
          seq3.accept(this);
          break;
        case 1:
          // %1 #0 "<" #1 <IDENTIFIER>
          // .. #2 ( $0 "," $1 <IDENTIFIER> )*
          // .. #3 ">"
          final NodeSequence seq4 = (NodeSequence) ich;
          // #0 "<"
          final INode seq5 = seq4.elementAt(0);
          seq5.accept(this);
          // #1 <IDENTIFIER>
          final INode seq6 = seq4.elementAt(1);
          seq6.accept(this);
          // #2 ( $0 "," $1 <IDENTIFIER> )*
          final INode seq7 = seq4.elementAt(2);
          final NodeListOptional nlo = (NodeListOptional) seq7;
          if (nlo.present()) {
            for (int i = 0; i < nlo.size(); i++) {
              final INode nloeai = nlo.elementAt(i);
              final NodeSequence seq8 = (NodeSequence) nloeai;
              // $0 ","
              final INode seq9 = seq8.elementAt(0);
              seq9.accept(this);
              // $1 <IDENTIFIER>
              final INode seq10 = seq8.elementAt(1);
              seq10.accept(this);
            }
          }
          // #3 ">"
          final INode seq11 = seq4.elementAt(3);
          seq11.accept(this);
          break;
        default:
          // should not occur !!!
          break;
      }
    }
    // f1 -> RegExprKind()
    final RegExprKind n1 = n.f1;
    n1.accept(this);
    // f2 -> [ #0 "[" #1 "IGNORE_CASE" #2 "]" ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      final NodeSequence seq12 = (NodeSequence) n2.node;
      // #0 "["
      final INode seq13 = seq12.elementAt(0);
      seq13.accept(this);
      // #1 "IGNORE_CASE"
      final INode seq14 = seq12.elementAt(1);
      seq14.accept(this);
      // #2 "]"
      final INode seq15 = seq12.elementAt(2);
      seq15.accept(this);
    }
    // f3 -> ":"
    final NodeToken n3 = n.f3;
    n3.accept(this);
    // f4 -> "{"
    final NodeToken n4 = n.f4;
    n4.accept(this);
    // f5 -> RegExprSpec()
    final RegExprSpec n5 = n.f5;
    n5.accept(this);
    // f6 -> ( #0 "|" #1 RegExprSpec() )*
    final NodeListOptional n6 = n.f6;
    if (n6.present()) {
      for (int i = 0; i < n6.size(); i++) {
        final INode nloeai = n6.elementAt(i);
        final NodeSequence seq16 = (NodeSequence) nloeai;
        // #0 "|"
        final INode seq17 = seq16.elementAt(0);
        seq17.accept(this);
        // #1 RegExprSpec()
        final INode seq18 = seq16.elementAt(1);
        seq18.accept(this);
      }
    }
    // f7 -> "}"
    final NodeToken n7 = n.f7;
    n7.accept(this);
  }

  /**
   * Visits a {@link TokenManagerDecls} node, whose children are the following :
   * <p>
   * f0 -> "TOKEN_MGR_DECLS"<br>
   * f1 -> ":"<br>
   * f2 -> ClassOrInterfaceBody()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final TokenManagerDecls n) {
    // f0 -> "TOKEN_MGR_DECLS"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> ":"
    final NodeToken n1 = n.f1;
    n1.accept(this);
    // f2 -> ClassOrInterfaceBody()
    final ClassOrInterfaceBody n2 = n.f2;
    n2.accept(this);
  }

  /**
   * Visits a {@link RegExprKind} node, whose child is the following :
   * <p>
   * f0 -> . %0 "TOKEN"<br>
   * .. .. | %1 "SPECIAL_TOKEN"<br>
   * .. .. | %2 "SKIP"<br>
   * .. .. | %3 "MORE"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final RegExprKind n) {
    // f0 -> . %0 "TOKEN"
    // .. .. | %1 "SPECIAL_TOKEN"
    // .. .. | %2 "SKIP"
    // .. .. | %3 "MORE"
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 "TOKEN"
        ich.accept(this);
        break;
      case 1:
        // %1 "SPECIAL_TOKEN"
        ich.accept(this);
        break;
      case 2:
        // %2 "SKIP"
        ich.accept(this);
        break;
      case 3:
        // %3 "MORE"
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link RegExprSpec} node, whose children are the following :
   * <p>
   * f0 -> RegularExpression()<br>
   * f1 -> [ "!" ]<br>
   * f2 -> [ Block() ]<br>
   * f3 -> [ #0 ":" #1 <IDENTIFIER> ]<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final RegExprSpec n) {
    // f0 -> RegularExpression()
    final RegularExpression n0 = n.f0;
    n0.accept(this);
    // f1 -> [ "!" ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this);
    }
    // f2 -> [ Block() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      n2.accept(this);
    }
    // f3 -> [ #0 ":" #1 <IDENTIFIER> ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence seq = (NodeSequence) n3.node;
      // #0 ":"
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 <IDENTIFIER>
      final INode seq2 = seq.elementAt(1);
      seq2.accept(this);
    }
  }

  /**
   * Visits a {@link ExpansionChoices} node, whose children are the following :
   * <p>
   * f0 -> Expansion()<br>
   * f1 -> ( #0 "|" #1 Expansion() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ExpansionChoices n) {
    // f0 -> Expansion()
    final Expansion n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 "|" #1 Expansion() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 "|"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 Expansion()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link Expansion} node, whose children are the following :
   * <p>
   * f0 -> ( #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")" )?<br>
   * f1 -> ( ExpansionUnit() )+<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final Expansion n) {
    // f0 -> ( #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")" )?
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      final NodeSequence seq = (NodeSequence) n0.node;
      // #0 "LOOKAHEAD"
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 "("
      final INode seq2 = seq.elementAt(1);
      seq2.accept(this);
      // #2 LocalLookahead()
      final INode seq3 = seq.elementAt(2);
      seq3.accept(this);
      // #3 ")"
      final INode seq4 = seq.elementAt(3);
      seq4.accept(this);
    }
    // f1 -> ( ExpansionUnit() )+
    final NodeList n1 = n.f1;
    for (int i = 0; i < n1.size(); i++) {
      final INode lsteai = n1.elementAt(i);
      lsteai.accept(this);
    }
  }

  /**
   * Visits a {@link LocalLookahead} node, whose children are the following :
   * <p>
   * f0 -> [ IntegerLiteral() ]<br>
   * f1 -> [ "," ]<br>
   * f2 -> [ ExpansionChoices() ]<br>
   * f3 -> [ "," ]<br>
   * f4 -> [ #0 "{" #1 Expression() #2 "}" ]<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final LocalLookahead n) {
    // f0 -> [ IntegerLiteral() ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      n0.accept(this);
    }
    // f1 -> [ "," ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this);
    }
    // f2 -> [ ExpansionChoices() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      n2.accept(this);
    }
    // f3 -> [ "," ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      n3.accept(this);
    }
    // f4 -> [ #0 "{" #1 Expression() #2 "}" ]
    final NodeOptional n4 = n.f4;
    if (n4.present()) {
      final NodeSequence seq = (NodeSequence) n4.node;
      // #0 "{"
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 Expression()
      final INode seq2 = seq.elementAt(1);
      seq2.accept(this);
      // #2 "}"
      final INode seq3 = seq.elementAt(2);
      seq3.accept(this);
    }
  }

  /**
   * Visits a {@link ExpansionUnit} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")"<br>
   * .. .. | %1 Block()<br>
   * .. .. | %2 #0 "[" #1 ExpansionChoices() #2 "]"<br>
   * .. .. | %3 ExpansionUnitTCF()<br>
   * .. .. | %4 #0 [ $0 PrimaryExpression() $1 "=" ]<br>
   * .. .. . .. #1 ( &0 $0 IdentifierAsString() $1 Arguments()<br>
   * .. .. . .. .. . .. $2 [ "!" ]<br>
   * .. .. . .. .. | &1 $0 RegularExpression()<br>
   * .. .. . .. .. . .. $1 [ ?0 "." ?1 <IDENTIFIER> ]<br>
   * .. .. . .. .. . .. $2 [ "!" ] )<br>
   * .. .. | %5 #0 "(" #1 ExpansionChoices() #2 ")"<br>
   * .. .. . .. #3 ( &0 "+"<br>
   * .. .. . .. .. | &1 "*"<br>
   * .. .. . .. .. | &2 "?" )?<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ExpansionUnit n) {
    // f0 -> . %0 #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")"
    // .. .. | %1 Block()
    // .. .. | %2 #0 "[" #1 ExpansionChoices() #2 "]"
    // .. .. | %3 ExpansionUnitTCF()
    // .. .. | %4 #0 [ $0 PrimaryExpression() $1 "=" ]
    // .. .. . .. #1 ( &0 $0 IdentifierAsString() $1 Arguments()
    // .. .. . .. .. . .. $2 [ "!" ]
    // .. .. . .. .. | &1 $0 RegularExpression()
    // .. .. . .. .. . .. $1 [ ?0 "." ?1 <IDENTIFIER> ]
    // .. .. . .. .. . .. $2 [ "!" ] )
    // .. .. | %5 #0 "(" #1 ExpansionChoices() #2 ")"
    // .. .. . .. #3 ( &0 "+"
    // .. .. . .. .. | &1 "*"
    // .. .. . .. .. | &2 "?" )?
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")"
        final NodeSequence seq = (NodeSequence) ich;
        // #0 "LOOKAHEAD"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 "("
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
        // #2 LocalLookahead()
        final INode seq3 = seq.elementAt(2);
        seq3.accept(this);
        // #3 ")"
        final INode seq4 = seq.elementAt(3);
        seq4.accept(this);
        break;
      case 1:
        // %1 Block()
        ich.accept(this);
        break;
      case 2:
        // %2 #0 "[" #1 ExpansionChoices() #2 "]"
        final NodeSequence seq5 = (NodeSequence) ich;
        // #0 "["
        final INode seq6 = seq5.elementAt(0);
        seq6.accept(this);
        // #1 ExpansionChoices()
        final INode seq7 = seq5.elementAt(1);
        seq7.accept(this);
        // #2 "]"
        final INode seq8 = seq5.elementAt(2);
        seq8.accept(this);
        break;
      case 3:
        // %3 ExpansionUnitTCF()
        ich.accept(this);
        break;
      case 4:
        // %4 #0 [ $0 PrimaryExpression() $1 "=" ]
        // .. #1 ( &0 $0 IdentifierAsString() $1 Arguments()
        // .. .. .. $2 [ "!" ]
        // .. .. | &1 $0 RegularExpression()
        // .. .. .. $1 [ ?0 "." ?1 <IDENTIFIER> ]
        // .. .. .. $2 [ "!" ] )
        final NodeSequence seq9 = (NodeSequence) ich;
        // #0 [ $0 PrimaryExpression() $1 "=" ]
        final INode seq10 = seq9.elementAt(0);
        final NodeOptional opt = (NodeOptional) seq10;
        if (opt.present()) {
          final NodeSequence seq11 = (NodeSequence) opt.node;
          // $0 PrimaryExpression()
          final INode seq12 = seq11.elementAt(0);
          seq12.accept(this);
          // $1 "="
          final INode seq13 = seq11.elementAt(1);
          seq13.accept(this);
        }
        // #1 ( &0 $0 IdentifierAsString() $1 Arguments()
        // .. .. $2 [ "!" ]
        // .. | &1 $0 RegularExpression()
        // .. .. $1 [ ?0 "." ?1 <IDENTIFIER> ]
        // .. .. $2 [ "!" ] )
        final INode seq14 = seq9.elementAt(1);
        final NodeChoice nch1 = (NodeChoice) seq14;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            // &0 $0 IdentifierAsString() $1 Arguments()
            // .. $2 [ "!" ]
            final NodeSequence seq15 = (NodeSequence) ich1;
            // $0 IdentifierAsString()
            final INode seq16 = seq15.elementAt(0);
            seq16.accept(this);
            // $1 Arguments()
            final INode seq17 = seq15.elementAt(1);
            seq17.accept(this);
            // $2 [ "!" ]
            final INode seq18 = seq15.elementAt(2);
            final NodeOptional opt1 = (NodeOptional) seq18;
            if (opt1.present()) {
              opt1.accept(this);
            }
            break;
          case 1:
            // &1 $0 RegularExpression()
            // .. $1 [ ?0 "." ?1 <IDENTIFIER> ]
            // .. $2 [ "!" ]
            final NodeSequence seq19 = (NodeSequence) ich1;
            // $0 RegularExpression()
            final INode seq20 = seq19.elementAt(0);
            seq20.accept(this);
            // $1 [ ?0 "." ?1 <IDENTIFIER> ]
            final INode seq21 = seq19.elementAt(1);
            final NodeOptional opt2 = (NodeOptional) seq21;
            if (opt2.present()) {
              final NodeSequence seq22 = (NodeSequence) opt2.node;
              // ?0 "."
              final INode seq23 = seq22.elementAt(0);
              seq23.accept(this);
              // ?1 <IDENTIFIER>
              final INode seq24 = seq22.elementAt(1);
              seq24.accept(this);
            }
            // $2 [ "!" ]
            final INode seq25 = seq19.elementAt(2);
            final NodeOptional opt3 = (NodeOptional) seq25;
            if (opt3.present()) {
              opt3.accept(this);
            }
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      case 5:
        // %5 #0 "(" #1 ExpansionChoices() #2 ")"
        // .. #3 ( &0 "+"
        // .. .. | &1 "*"
        // .. .. | &2 "?" )?
        final NodeSequence seq26 = (NodeSequence) ich;
        // #0 "("
        final INode seq27 = seq26.elementAt(0);
        seq27.accept(this);
        // #1 ExpansionChoices()
        final INode seq28 = seq26.elementAt(1);
        seq28.accept(this);
        // #2 ")"
        final INode seq29 = seq26.elementAt(2);
        seq29.accept(this);
        // #3 ( &0 "+"
        // .. | &1 "*"
        // .. | &2 "?" )?
        final INode seq30 = seq26.elementAt(3);
        final NodeOptional opt4 = (NodeOptional) seq30;
        if (opt4.present()) {
          final NodeChoice nch2 = (NodeChoice) opt4.node;
          final INode ich2 = nch2.choice;
          switch (nch2.which) {
            case 0:
              // &0 "+"
              ich2.accept(this);
              break;
            case 1:
              // &1 "*"
              ich2.accept(this);
              break;
            case 2:
              // &2 "?"
              ich2.accept(this);
              break;
            default:
              // should not occur !!!
              break;
          }
        }
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ExpansionUnitTCF} node, whose children are the following :
   * <p>
   * f0 -> "try"<br>
   * f1 -> "{"<br>
   * f2 -> ExpansionChoices()<br>
   * f3 -> "}"<br>
   * f4 -> ( #0 "catch" #1 "(" #2 Name() #3 <IDENTIFIER> #4 ")" #5 Block() )*<br>
   * f5 -> [ #0 "finally" #1 Block() ]<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ExpansionUnitTCF n) {
    // f0 -> "try"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> "{"
    final NodeToken n1 = n.f1;
    n1.accept(this);
    // f2 -> ExpansionChoices()
    final ExpansionChoices n2 = n.f2;
    n2.accept(this);
    // f3 -> "}"
    final NodeToken n3 = n.f3;
    n3.accept(this);
    // f4 -> ( #0 "catch" #1 "(" #2 Name() #3 <IDENTIFIER> #4 ")" #5 Block() )*
    final NodeListOptional n4 = n.f4;
    if (n4.present()) {
      for (int i = 0; i < n4.size(); i++) {
        final INode nloeai = n4.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 "catch"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 "("
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
        // #2 Name()
        final INode seq3 = seq.elementAt(2);
        seq3.accept(this);
        // #3 <IDENTIFIER>
        final INode seq4 = seq.elementAt(3);
        seq4.accept(this);
        // #4 ")"
        final INode seq5 = seq.elementAt(4);
        seq5.accept(this);
        // #5 Block()
        final INode seq6 = seq.elementAt(5);
        seq6.accept(this);
      }
    }
    // f5 -> [ #0 "finally" #1 Block() ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      final NodeSequence seq7 = (NodeSequence) n5.node;
      // #0 "finally"
      final INode seq8 = seq7.elementAt(0);
      seq8.accept(this);
      // #1 Block()
      final INode seq9 = seq7.elementAt(1);
      seq9.accept(this);
    }
  }

  /**
   * Visits a {@link RegularExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 StringLiteral()<br>
   * .. .. | %1 #0 "<"<br>
   * .. .. . .. #1 [ $0 [ "#" ]<br>
   * .. .. . .. .. . $1 IdentifierAsString() $2 ":" ]<br>
   * .. .. . .. #2 ComplexRegularExpressionChoices() #3 ">"<br>
   * .. .. | %2 #0 "<" #1 IdentifierAsString() #2 ">"<br>
   * .. .. | %3 #0 "<" #1 "EOF" #2 ">"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final RegularExpression n) {
    // f0 -> . %0 StringLiteral()
    // .. .. | %1 #0 "<"
    // .. .. . .. #1 [ $0 [ "#" ]
    // .. .. . .. .. . $1 IdentifierAsString() $2 ":" ]
    // .. .. . .. #2 ComplexRegularExpressionChoices() #3 ">"
    // .. .. | %2 #0 "<" #1 IdentifierAsString() #2 ">"
    // .. .. | %3 #0 "<" #1 "EOF" #2 ">"
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 StringLiteral()
        ich.accept(this);
        break;
      case 1:
        // %1 #0 "<"
        // .. #1 [ $0 [ "#" ]
        // .. .. . $1 IdentifierAsString() $2 ":" ]
        // .. #2 ComplexRegularExpressionChoices() #3 ">"
        final NodeSequence seq = (NodeSequence) ich;
        // #0 "<"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 [ $0 [ "#" ]
        // .. . $1 IdentifierAsString() $2 ":" ]
        final INode seq2 = seq.elementAt(1);
        final NodeOptional opt = (NodeOptional) seq2;
        if (opt.present()) {
          final NodeSequence seq3 = (NodeSequence) opt.node;
          // $0 [ "#" ]
          final INode seq4 = seq3.elementAt(0);
          final NodeOptional opt1 = (NodeOptional) seq4;
          if (opt1.present()) {
            opt1.accept(this);
          }
          // $1 IdentifierAsString()
          final INode seq5 = seq3.elementAt(1);
          seq5.accept(this);
          // $2 ":"
          final INode seq6 = seq3.elementAt(2);
          seq6.accept(this);
        }
        // #2 ComplexRegularExpressionChoices()
        final INode seq7 = seq.elementAt(2);
        seq7.accept(this);
        // #3 ">"
        final INode seq8 = seq.elementAt(3);
        seq8.accept(this);
        break;
      case 2:
        // %2 #0 "<" #1 IdentifierAsString() #2 ">"
        final NodeSequence seq9 = (NodeSequence) ich;
        // #0 "<"
        final INode seq10 = seq9.elementAt(0);
        seq10.accept(this);
        // #1 IdentifierAsString()
        final INode seq11 = seq9.elementAt(1);
        seq11.accept(this);
        // #2 ">"
        final INode seq12 = seq9.elementAt(2);
        seq12.accept(this);
        break;
      case 3:
        // %3 #0 "<" #1 "EOF" #2 ">"
        final NodeSequence seq13 = (NodeSequence) ich;
        // #0 "<"
        final INode seq14 = seq13.elementAt(0);
        seq14.accept(this);
        // #1 "EOF"
        final INode seq15 = seq13.elementAt(1);
        seq15.accept(this);
        // #2 ">"
        final INode seq16 = seq13.elementAt(2);
        seq16.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ComplexRegularExpressionChoices} node, whose children are the following :
   * <p>
   * f0 -> ComplexRegularExpression()<br>
   * f1 -> ( #0 "|" #1 ComplexRegularExpression() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ComplexRegularExpressionChoices n) {
    // f0 -> ComplexRegularExpression()
    final ComplexRegularExpression n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 "|" #1 ComplexRegularExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 "|"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 ComplexRegularExpression()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link ComplexRegularExpression} node, whose child is the following :
   * <p>
   * f0 -> ( ComplexRegularExpressionUnit() )+<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ComplexRegularExpression n) {
    // f0 -> ( ComplexRegularExpressionUnit() )+
    final NodeList n0 = n.f0;
    for (int i = 0; i < n0.size(); i++) {
      final INode lsteai = n0.elementAt(i);
      lsteai.accept(this);
    }
  }

  /**
   * Visits a {@link ComplexRegularExpressionUnit} node, whose child is the following :
   * <p>
   * f0 -> . %0 StringLiteral()<br>
   * .. .. | %1 #0 "<" #1 IdentifierAsString() #2 ">"<br>
   * .. .. | %2 CharacterList()<br>
   * .. .. | %3 #0 "(" #1 ComplexRegularExpressionChoices() #2 ")"<br>
   * .. .. . .. #3 ( &0 "+"<br>
   * .. .. . .. .. | &1 "*"<br>
   * .. .. . .. .. | &2 "?"<br>
   * .. .. . .. .. | &3 $0 "{" $1 IntegerLiteral()<br>
   * .. .. . .. .. . .. $2 [ ?0 ","<br>
   * .. .. . .. .. . .. .. . ?1 [ IntegerLiteral() ] ]<br>
   * .. .. . .. .. . .. $3 "}" )?<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ComplexRegularExpressionUnit n) {
    // f0 -> . %0 StringLiteral()
    // .. .. | %1 #0 "<" #1 IdentifierAsString() #2 ">"
    // .. .. | %2 CharacterList()
    // .. .. | %3 #0 "(" #1 ComplexRegularExpressionChoices() #2 ")"
    // .. .. . .. #3 ( &0 "+"
    // .. .. . .. .. | &1 "*"
    // .. .. . .. .. | &2 "?"
    // .. .. . .. .. | &3 $0 "{" $1 IntegerLiteral()
    // .. .. . .. .. . .. $2 [ ?0 ","
    // .. .. . .. .. . .. .. . ?1 [ IntegerLiteral() ] ]
    // .. .. . .. .. . .. $3 "}" )?
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 StringLiteral()
        ich.accept(this);
        break;
      case 1:
        // %1 #0 "<" #1 IdentifierAsString() #2 ">"
        final NodeSequence seq = (NodeSequence) ich;
        // #0 "<"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 IdentifierAsString()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
        // #2 ">"
        final INode seq3 = seq.elementAt(2);
        seq3.accept(this);
        break;
      case 2:
        // %2 CharacterList()
        ich.accept(this);
        break;
      case 3:
        // %3 #0 "(" #1 ComplexRegularExpressionChoices() #2 ")"
        // .. #3 ( &0 "+"
        // .. .. | &1 "*"
        // .. .. | &2 "?"
        // .. .. | &3 $0 "{" $1 IntegerLiteral()
        // .. .. .. $2 [ ?0 ","
        // .. .. .. .. . ?1 [ IntegerLiteral() ] ]
        // .. .. .. $3 "}" )?
        final NodeSequence seq4 = (NodeSequence) ich;
        // #0 "("
        final INode seq5 = seq4.elementAt(0);
        seq5.accept(this);
        // #1 ComplexRegularExpressionChoices()
        final INode seq6 = seq4.elementAt(1);
        seq6.accept(this);
        // #2 ")"
        final INode seq7 = seq4.elementAt(2);
        seq7.accept(this);
        // #3 ( &0 "+"
        // .. | &1 "*"
        // .. | &2 "?"
        // .. | &3 $0 "{" $1 IntegerLiteral()
        // .. .. $2 [ ?0 ","
        // .. .. .. . ?1 [ IntegerLiteral() ] ]
        // .. .. $3 "}" )?
        final INode seq8 = seq4.elementAt(3);
        final NodeOptional opt = (NodeOptional) seq8;
        if (opt.present()) {
          final NodeChoice nch1 = (NodeChoice) opt.node;
          final INode ich1 = nch1.choice;
          switch (nch1.which) {
            case 0:
              // &0 "+"
              ich1.accept(this);
              break;
            case 1:
              // &1 "*"
              ich1.accept(this);
              break;
            case 2:
              // &2 "?"
              ich1.accept(this);
              break;
            case 3:
              // &3 $0 "{" $1 IntegerLiteral()
              // .. $2 [ ?0 ","
              // .. .. . ?1 [ IntegerLiteral() ] ]
              // .. $3 "}"
              final NodeSequence seq9 = (NodeSequence) ich1;
              // $0 "{"
              final INode seq10 = seq9.elementAt(0);
              seq10.accept(this);
              // $1 IntegerLiteral()
              final INode seq11 = seq9.elementAt(1);
              seq11.accept(this);
              // $2 [ ?0 ","
              // .. . ?1 [ IntegerLiteral() ] ]
              final INode seq12 = seq9.elementAt(2);
              final NodeOptional opt1 = (NodeOptional) seq12;
              if (opt1.present()) {
                final NodeSequence seq13 = (NodeSequence) opt1.node;
                // ?0 ","
                final INode seq14 = seq13.elementAt(0);
                seq14.accept(this);
                // ?1 [ IntegerLiteral() ]
                final INode seq15 = seq13.elementAt(1);
                final NodeOptional opt2 = (NodeOptional) seq15;
                if (opt2.present()) {
                  opt2.accept(this);
                }
              }
              // $3 "}"
              final INode seq16 = seq9.elementAt(3);
              seq16.accept(this);
              break;
            default:
              // should not occur !!!
              break;
          }
        }
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link CharacterList} node, whose children are the following :
   * <p>
   * f0 -> [ "~" ]<br>
   * f1 -> "["<br>
   * f2 -> [ #0 CharacterDescriptor()<br>
   * .. .. . #1 ( $0 "," $1 CharacterDescriptor() )* ]<br>
   * f3 -> "]"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final CharacterList n) {
    // f0 -> [ "~" ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      n0.accept(this);
    }
    // f1 -> "["
    final NodeToken n1 = n.f1;
    n1.accept(this);
    // f2 -> [ #0 CharacterDescriptor()
    // .. .. . #1 ( $0 "," $1 CharacterDescriptor() )* ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      final NodeSequence seq = (NodeSequence) n2.node;
      // #0 CharacterDescriptor()
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 ( $0 "," $1 CharacterDescriptor() )*
      final INode seq2 = seq.elementAt(1);
      final NodeListOptional nlo = (NodeListOptional) seq2;
      if (nlo.present()) {
        for (int i = 0; i < nlo.size(); i++) {
          final INode nloeai = nlo.elementAt(i);
          final NodeSequence seq3 = (NodeSequence) nloeai;
          // $0 ","
          final INode seq4 = seq3.elementAt(0);
          seq4.accept(this);
          // $1 CharacterDescriptor()
          final INode seq5 = seq3.elementAt(1);
          seq5.accept(this);
        }
      }
    }
    // f3 -> "]"
    final NodeToken n3 = n.f3;
    n3.accept(this);
  }

  /**
   * Visits a {@link CharacterDescriptor} node, whose children are the following :
   * <p>
   * f0 -> StringLiteral()<br>
   * f1 -> [ #0 "-" #1 StringLiteral() ]<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final CharacterDescriptor n) {
    // f0 -> StringLiteral()
    final StringLiteral n0 = n.f0;
    n0.accept(this);
    // f1 -> [ #0 "-" #1 StringLiteral() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence seq = (NodeSequence) n1.node;
      // #0 "-"
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 StringLiteral()
      final INode seq2 = seq.elementAt(1);
      seq2.accept(this);
    }
  }

  /**
   * Visits a {@link IdentifierAsString} node, whose child is the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final IdentifierAsString n) {
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    n0.accept(this);
  }

  /**
   * Visits a {@link JavaIdentifier} node, whose child is the following :
   * <p>
   * f0 -> ( %00 <IDENTIFIER><br>
   * .. .. | %01 "LOOKAHEAD"<br>
   * .. .. | %02 "IGNORE_CASE"<br>
   * .. .. | %03 "PARSER_BEGIN"<br>
   * .. .. | %04 "PARSER_END"<br>
   * .. .. | %05 "JAVACODE"<br>
   * .. .. | %06 "TOKEN"<br>
   * .. .. | %07 "SPECIAL_TOKEN"<br>
   * .. .. | %08 "MORE"<br>
   * .. .. | %09 "SKIP"<br>
   * .. .. | %10 "TOKEN_MGR_DECLS"<br>
   * .. .. | %11 "EOF" )<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final JavaIdentifier n) {
    // f0 -> ( %00 <IDENTIFIER>
    // .. .. | %01 "LOOKAHEAD"
    // .. .. | %02 "IGNORE_CASE"
    // .. .. | %03 "PARSER_BEGIN"
    // .. .. | %04 "PARSER_END"
    // .. .. | %05 "JAVACODE"
    // .. .. | %06 "TOKEN"
    // .. .. | %07 "SPECIAL_TOKEN"
    // .. .. | %08 "MORE"
    // .. .. | %09 "SKIP"
    // .. .. | %10 "TOKEN_MGR_DECLS"
    // .. .. | %11 "EOF" )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %00 <IDENTIFIER>
        ich.accept(this);
        break;
      case 1:
        // %01 "LOOKAHEAD"
        ich.accept(this);
        break;
      case 2:
        // %02 "IGNORE_CASE"
        ich.accept(this);
        break;
      case 3:
        // %03 "PARSER_BEGIN"
        ich.accept(this);
        break;
      case 4:
        // %04 "PARSER_END"
        ich.accept(this);
        break;
      case 5:
        // %05 "JAVACODE"
        ich.accept(this);
        break;
      case 6:
        // %06 "TOKEN"
        ich.accept(this);
        break;
      case 7:
        // %07 "SPECIAL_TOKEN"
        ich.accept(this);
        break;
      case 8:
        // %08 "MORE"
        ich.accept(this);
        break;
      case 9:
        // %09 "SKIP"
        ich.accept(this);
        break;
      case 10:
        // %10 "TOKEN_MGR_DECLS"
        ich.accept(this);
        break;
      case 11:
        // %11 "EOF"
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link CompilationUnit} node, whose children are the following :
   * <p>
   * f0 -> [ PackageDeclaration() ]<br>
   * f1 -> ( ImportDeclaration() )*<br>
   * f2 -> ( TypeDeclaration() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final CompilationUnit n) {
    // f0 -> [ PackageDeclaration() ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      n0.accept(this);
    }
    // f1 -> ( ImportDeclaration() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        nloeai.accept(this);
      }
    }
    // f2 -> ( TypeDeclaration() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        nloeai.accept(this);
      }
    }
  }

  /**
   * Visits a {@link PackageDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "package"<br>
   * f1 -> Name()<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final PackageDeclaration n) {
    // f0 -> "package"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> Name()
    final Name n1 = n.f1;
    n1.accept(this);
    // f2 -> ";"
    final NodeToken n2 = n.f2;
    n2.accept(this);
  }

  /**
   * Visits a {@link ImportDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "import"<br>
   * f1 -> [ "static" ]<br>
   * f2 -> Name()<br>
   * f3 -> [ #0 "." #1 "*" ]<br>
   * f4 -> ";"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ImportDeclaration n) {
    // f0 -> "import"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> [ "static" ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this);
    }
    // f2 -> Name()
    final Name n2 = n.f2;
    n2.accept(this);
    // f3 -> [ #0 "." #1 "*" ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence seq = (NodeSequence) n3.node;
      // #0 "."
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 "*"
      final INode seq2 = seq.elementAt(1);
      seq2.accept(this);
    }
    // f4 -> ";"
    final NodeToken n4 = n.f4;
    n4.accept(this);
  }

  /**
   * Visits a {@link Modifiers} node, whose child is the following :
   * <p>
   * f0 -> ( ( %00 "public"<br>
   * .. .. . | %01 "static"<br>
   * .. .. . | %02 "protected"<br>
   * .. .. . | %03 "private"<br>
   * .. .. . | %04 "final"<br>
   * .. .. . | %05 "abstract"<br>
   * .. .. . | %06 "synchronized"<br>
   * .. .. . | %07 "native"<br>
   * .. .. . | %08 "transient"<br>
   * .. .. . | %09 "volatile"<br>
   * .. .. . | %10 "strictfp"<br>
   * .. .. . | %11 Annotation() ) )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final Modifiers n) {
    // f0 -> ( ( %00 "public"
    // .. .. . | %01 "static"
    // .. .. . | %02 "protected"
    // .. .. . | %03 "private"
    // .. .. . | %04 "final"
    // .. .. . | %05 "abstract"
    // .. .. . | %06 "synchronized"
    // .. .. . | %07 "native"
    // .. .. . | %08 "transient"
    // .. .. . | %09 "volatile"
    // .. .. . | %10 "strictfp"
    // .. .. . | %11 Annotation() ) )*
    final NodeListOptional n0 = n.f0;
    if (n0.present()) {
      for (int i = 0; i < n0.size(); i++) {
        final INode nloeai = n0.elementAt(i);
        final NodeChoice nch = (NodeChoice) nloeai;
        final INode ich = nch.choice;
        switch (nch.which) {
          case 0:
            // %00 "public"
            ich.accept(this);
            break;
          case 1:
            // %01 "static"
            ich.accept(this);
            break;
          case 2:
            // %02 "protected"
            ich.accept(this);
            break;
          case 3:
            // %03 "private"
            ich.accept(this);
            break;
          case 4:
            // %04 "final"
            ich.accept(this);
            break;
          case 5:
            // %05 "abstract"
            ich.accept(this);
            break;
          case 6:
            // %06 "synchronized"
            ich.accept(this);
            break;
          case 7:
            // %07 "native"
            ich.accept(this);
            break;
          case 8:
            // %08 "transient"
            ich.accept(this);
            break;
          case 9:
            // %09 "volatile"
            ich.accept(this);
            break;
          case 10:
            // %10 "strictfp"
            ich.accept(this);
            break;
          case 11:
            // %11 Annotation()
            ich.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
      }
    }
  }

  /**
   * Visits a {@link TypeDeclaration} node, whose child is the following :
   * <p>
   * f0 -> . %0 ";"<br>
   * .. .. | %1 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &1 EnumDeclaration()<br>
   * .. .. . .. .. | &2 AnnotationTypeDeclaration() )<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final TypeDeclaration n) {
    // f0 -> . %0 ";"
    // .. .. | %1 #0 Modifiers()
    // .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()
    // .. .. . .. .. | &1 EnumDeclaration()
    // .. .. . .. .. | &2 AnnotationTypeDeclaration() )
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 ";"
        ich.accept(this);
        break;
      case 1:
        // %1 #0 Modifiers()
        // .. #1 ( &0 ClassOrInterfaceDeclaration()
        // .. .. | &1 EnumDeclaration()
        // .. .. | &2 AnnotationTypeDeclaration() )
        final NodeSequence seq = (NodeSequence) ich;
        // #0 Modifiers()
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 ( &0 ClassOrInterfaceDeclaration()
        // .. | &1 EnumDeclaration()
        // .. | &2 AnnotationTypeDeclaration() )
        final INode seq2 = seq.elementAt(1);
        final NodeChoice nch1 = (NodeChoice) seq2;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            // &0 ClassOrInterfaceDeclaration()
            ich1.accept(this);
            break;
          case 1:
            // &1 EnumDeclaration()
            ich1.accept(this);
            break;
          case 2:
            // &2 AnnotationTypeDeclaration()
            ich1.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ClassOrInterfaceDeclaration} node, whose children are the following :
   * <p>
   * f0 -> ( %0 "class"<br>
   * .. .. | %1 "interface" )<br>
   * f1 -> <IDENTIFIER><br>
   * f2 -> [ TypeParameters() ]<br>
   * f3 -> [ ExtendsList() ]<br>
   * f4 -> [ ImplementsList() ]<br>
   * f5 -> ClassOrInterfaceBody()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ClassOrInterfaceDeclaration n) {
    // f0 -> ( %0 "class"
    // .. .. | %1 "interface" )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 "class"
        ich.accept(this);
        break;
      case 1:
        // %1 "interface"
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
    // f1 -> <IDENTIFIER>
    final NodeToken n1 = n.f1;
    n1.accept(this);
    // f2 -> [ TypeParameters() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      n2.accept(this);
    }
    // f3 -> [ ExtendsList() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      n3.accept(this);
    }
    // f4 -> [ ImplementsList() ]
    final NodeOptional n4 = n.f4;
    if (n4.present()) {
      n4.accept(this);
    }
    // f5 -> ClassOrInterfaceBody()
    final ClassOrInterfaceBody n5 = n.f5;
    n5.accept(this);
  }

  /**
   * Visits a {@link ExtendsList} node, whose children are the following :
   * <p>
   * f0 -> "extends"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "," #1 ClassOrInterfaceType() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ExtendsList n) {
    // f0 -> "extends"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> ClassOrInterfaceType()
    final ClassOrInterfaceType n1 = n.f1;
    n1.accept(this);
    // f2 -> ( #0 "," #1 ClassOrInterfaceType() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 ","
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 ClassOrInterfaceType()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link ImplementsList} node, whose children are the following :
   * <p>
   * f0 -> "implements"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "," #1 ClassOrInterfaceType() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ImplementsList n) {
    // f0 -> "implements"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> ClassOrInterfaceType()
    final ClassOrInterfaceType n1 = n.f1;
    n1.accept(this);
    // f2 -> ( #0 "," #1 ClassOrInterfaceType() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 ","
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 ClassOrInterfaceType()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link EnumDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "enum"<br>
   * f1 -> <IDENTIFIER><br>
   * f2 -> [ ImplementsList() ]<br>
   * f3 -> EnumBody()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final EnumDeclaration n) {
    // f0 -> "enum"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> <IDENTIFIER>
    final NodeToken n1 = n.f1;
    n1.accept(this);
    // f2 -> [ ImplementsList() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      n2.accept(this);
    }
    // f3 -> EnumBody()
    final EnumBody n3 = n.f3;
    n3.accept(this);
  }

  /**
   * Visits a {@link EnumBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> [ #0 EnumConstant()<br>
   * .. .. . #1 ( $0 "," $1 EnumConstant() )* ]<br>
   * f2 -> [ "," ]<br>
   * f3 -> [ #0 ";"<br>
   * .. .. . #1 ( ClassOrInterfaceBodyDeclaration() )* ]<br>
   * f4 -> "}"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final EnumBody n) {
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> [ #0 EnumConstant()
    // .. .. . #1 ( $0 "," $1 EnumConstant() )* ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence seq = (NodeSequence) n1.node;
      // #0 EnumConstant()
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 ( $0 "," $1 EnumConstant() )*
      final INode seq2 = seq.elementAt(1);
      final NodeListOptional nlo = (NodeListOptional) seq2;
      if (nlo.present()) {
        for (int i = 0; i < nlo.size(); i++) {
          final INode nloeai = nlo.elementAt(i);
          final NodeSequence seq3 = (NodeSequence) nloeai;
          // $0 ","
          final INode seq4 = seq3.elementAt(0);
          seq4.accept(this);
          // $1 EnumConstant()
          final INode seq5 = seq3.elementAt(1);
          seq5.accept(this);
        }
      }
    }
    // f2 -> [ "," ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      n2.accept(this);
    }
    // f3 -> [ #0 ";"
    // .. .. . #1 ( ClassOrInterfaceBodyDeclaration() )* ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence seq6 = (NodeSequence) n3.node;
      // #0 ";"
      final INode seq7 = seq6.elementAt(0);
      seq7.accept(this);
      // #1 ( ClassOrInterfaceBodyDeclaration() )*
      final INode seq8 = seq6.elementAt(1);
      final NodeListOptional nlo1 = (NodeListOptional) seq8;
      if (nlo1.present()) {
        for (int i = 0; i < nlo1.size(); i++) {
          final INode nloeai = nlo1.elementAt(i);
          nloeai.accept(this);
        }
      }
    }
    // f4 -> "}"
    final NodeToken n4 = n.f4;
    n4.accept(this);
  }

  /**
   * Visits a {@link EnumConstant} node, whose children are the following :
   * <p>
   * f0 -> Modifiers()<br>
   * f1 -> <IDENTIFIER><br>
   * f2 -> [ Arguments() ]<br>
   * f3 -> [ ClassOrInterfaceBody() ]<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final EnumConstant n) {
    // f0 -> Modifiers()
    final Modifiers n0 = n.f0;
    n0.accept(this);
    // f1 -> <IDENTIFIER>
    final NodeToken n1 = n.f1;
    n1.accept(this);
    // f2 -> [ Arguments() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      n2.accept(this);
    }
    // f3 -> [ ClassOrInterfaceBody() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      n3.accept(this);
    }
  }

  /**
   * Visits a {@link TypeParameters} node, whose children are the following :
   * <p>
   * f0 -> "<"<br>
   * f1 -> TypeParameter()<br>
   * f2 -> ( #0 "," #1 TypeParameter() )*<br>
   * f3 -> ">"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final TypeParameters n) {
    // f0 -> "<"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> TypeParameter()
    final TypeParameter n1 = n.f1;
    n1.accept(this);
    // f2 -> ( #0 "," #1 TypeParameter() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 ","
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 TypeParameter()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
    // f3 -> ">"
    final NodeToken n3 = n.f3;
    n3.accept(this);
  }

  /**
   * Visits a {@link TypeParameter} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> [ TypeBound() ]<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final TypeParameter n) {
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> [ TypeBound() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this);
    }
  }

  /**
   * Visits a {@link TypeBound} node, whose children are the following :
   * <p>
   * f0 -> "extends"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "&" #1 ClassOrInterfaceType() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final TypeBound n) {
    // f0 -> "extends"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> ClassOrInterfaceType()
    final ClassOrInterfaceType n1 = n.f1;
    n1.accept(this);
    // f2 -> ( #0 "&" #1 ClassOrInterfaceType() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 "&"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 ClassOrInterfaceType()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link ClassOrInterfaceBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( ClassOrInterfaceBodyDeclaration() )*<br>
   * f2 -> "}"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ClassOrInterfaceBody n) {
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> ( ClassOrInterfaceBodyDeclaration() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        nloeai.accept(this);
      }
    }
    // f2 -> "}"
    final NodeToken n2 = n.f2;
    n2.accept(this);
  }

  /**
   * Visits a {@link ClassOrInterfaceBodyDeclaration} node, whose child is the following :
   * <p>
   * f0 -> . %0 Initializer()<br>
   * .. .. | %1 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &1 EnumDeclaration()<br>
   * .. .. . .. .. | &2 AnnotationTypeDeclaration()<br>
   * .. .. . .. .. | &3 ConstructorDeclaration()<br>
   * .. .. . .. .. | &4 FieldDeclaration()<br>
   * .. .. . .. .. | &5 MethodDeclaration() )<br>
   * .. .. | %2 ";"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ClassOrInterfaceBodyDeclaration n) {
    // f0 -> . %0 Initializer()
    // .. .. | %1 #0 Modifiers()
    // .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()
    // .. .. . .. .. | &1 EnumDeclaration()
    // .. .. . .. .. | &2 AnnotationTypeDeclaration()
    // .. .. . .. .. | &3 ConstructorDeclaration()
    // .. .. . .. .. | &4 FieldDeclaration()
    // .. .. . .. .. | &5 MethodDeclaration() )
    // .. .. | %2 ";"
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 Initializer()
        ich.accept(this);
        break;
      case 1:
        // %1 #0 Modifiers()
        // .. #1 ( &0 ClassOrInterfaceDeclaration()
        // .. .. | &1 EnumDeclaration()
        // .. .. | &2 AnnotationTypeDeclaration()
        // .. .. | &3 ConstructorDeclaration()
        // .. .. | &4 FieldDeclaration()
        // .. .. | &5 MethodDeclaration() )
        final NodeSequence seq = (NodeSequence) ich;
        // #0 Modifiers()
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 ( &0 ClassOrInterfaceDeclaration()
        // .. | &1 EnumDeclaration()
        // .. | &2 AnnotationTypeDeclaration()
        // .. | &3 ConstructorDeclaration()
        // .. | &4 FieldDeclaration()
        // .. | &5 MethodDeclaration() )
        final INode seq2 = seq.elementAt(1);
        final NodeChoice nch1 = (NodeChoice) seq2;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            // &0 ClassOrInterfaceDeclaration()
            ich1.accept(this);
            break;
          case 1:
            // &1 EnumDeclaration()
            ich1.accept(this);
            break;
          case 2:
            // &2 AnnotationTypeDeclaration()
            ich1.accept(this);
            break;
          case 3:
            // &3 ConstructorDeclaration()
            ich1.accept(this);
            break;
          case 4:
            // &4 FieldDeclaration()
            ich1.accept(this);
            break;
          case 5:
            // &5 MethodDeclaration()
            ich1.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      case 2:
        // %2 ";"
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link FieldDeclaration} node, whose children are the following :
   * <p>
   * f0 -> Type()<br>
   * f1 -> VariableDeclarator()<br>
   * f2 -> ( #0 "," #1 VariableDeclarator() )*<br>
   * f3 -> ";"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final FieldDeclaration n) {
    // f0 -> Type()
    final Type n0 = n.f0;
    n0.accept(this);
    // f1 -> VariableDeclarator()
    final VariableDeclarator n1 = n.f1;
    n1.accept(this);
    // f2 -> ( #0 "," #1 VariableDeclarator() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 ","
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 VariableDeclarator()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
    // f3 -> ";"
    final NodeToken n3 = n.f3;
    n3.accept(this);
  }

  /**
   * Visits a {@link VariableDeclarator} node, whose children are the following :
   * <p>
   * f0 -> VariableDeclaratorId()<br>
   * f1 -> [ #0 "=" #1 VariableInitializer() ]<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final VariableDeclarator n) {
    // f0 -> VariableDeclaratorId()
    final VariableDeclaratorId n0 = n.f0;
    n0.accept(this);
    // f1 -> [ #0 "=" #1 VariableInitializer() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence seq = (NodeSequence) n1.node;
      // #0 "="
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 VariableInitializer()
      final INode seq2 = seq.elementAt(1);
      seq2.accept(this);
    }
  }

  /**
   * Visits a {@link VariableDeclaratorId} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> ( #0 "[" #1 "]" )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final VariableDeclaratorId n) {
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 "[" #1 "]" )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 "["
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 "]"
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link VariableInitializer} node, whose child is the following :
   * <p>
   * f0 -> . %0 ArrayInitializer()<br>
   * .. .. | %1 Expression()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final VariableInitializer n) {
    // f0 -> . %0 ArrayInitializer()
    // .. .. | %1 Expression()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 ArrayInitializer()
        ich.accept(this);
        break;
      case 1:
        // %1 Expression()
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ArrayInitializer} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> [ #0 VariableInitializer()<br>
   * .. .. . #1 ( $0 "," $1 VariableInitializer() )* ]<br>
   * f2 -> [ "," ]<br>
   * f3 -> "}"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ArrayInitializer n) {
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> [ #0 VariableInitializer()
    // .. .. . #1 ( $0 "," $1 VariableInitializer() )* ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence seq = (NodeSequence) n1.node;
      // #0 VariableInitializer()
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 ( $0 "," $1 VariableInitializer() )*
      final INode seq2 = seq.elementAt(1);
      final NodeListOptional nlo = (NodeListOptional) seq2;
      if (nlo.present()) {
        for (int i = 0; i < nlo.size(); i++) {
          final INode nloeai = nlo.elementAt(i);
          final NodeSequence seq3 = (NodeSequence) nloeai;
          // $0 ","
          final INode seq4 = seq3.elementAt(0);
          seq4.accept(this);
          // $1 VariableInitializer()
          final INode seq5 = seq3.elementAt(1);
          seq5.accept(this);
        }
      }
    }
    // f2 -> [ "," ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      n2.accept(this);
    }
    // f3 -> "}"
    final NodeToken n3 = n.f3;
    n3.accept(this);
  }

  /**
   * Visits a {@link MethodDeclaration} node, whose children are the following :
   * <p>
   * f0 -> [ TypeParameters() ]<br>
   * f1 -> ResultType()<br>
   * f2 -> MethodDeclarator()<br>
   * f3 -> [ #0 "throws" #1 NameList() ]<br>
   * f4 -> ( %0 Block()<br>
   * .. .. | %1 ";" )<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final MethodDeclaration n) {
    // f0 -> [ TypeParameters() ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      n0.accept(this);
    }
    // f1 -> ResultType()
    final ResultType n1 = n.f1;
    n1.accept(this);
    // f2 -> MethodDeclarator()
    final MethodDeclarator n2 = n.f2;
    n2.accept(this);
    // f3 -> [ #0 "throws" #1 NameList() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence seq = (NodeSequence) n3.node;
      // #0 "throws"
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 NameList()
      final INode seq2 = seq.elementAt(1);
      seq2.accept(this);
    }
    // f4 -> ( %0 Block()
    // .. .. | %1 ";" )
    final NodeChoice n4 = n.f4;
    final NodeChoice nch = n4;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 Block()
        ich.accept(this);
        break;
      case 1:
        // %1 ";"
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link MethodDeclarator} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> FormalParameters()<br>
   * f2 -> ( #0 "[" #1 "]" )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final MethodDeclarator n) {
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> FormalParameters()
    final FormalParameters n1 = n.f1;
    n1.accept(this);
    // f2 -> ( #0 "[" #1 "]" )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 "["
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 "]"
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link FormalParameters} node, whose children are the following :
   * <p>
   * f0 -> "("<br>
   * f1 -> [ #0 FormalParameter()<br>
   * .. .. . #1 ( $0 "," $1 FormalParameter() )* ]<br>
   * f2 -> ")"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final FormalParameters n) {
    // f0 -> "("
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> [ #0 FormalParameter()
    // .. .. . #1 ( $0 "," $1 FormalParameter() )* ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence seq = (NodeSequence) n1.node;
      // #0 FormalParameter()
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 ( $0 "," $1 FormalParameter() )*
      final INode seq2 = seq.elementAt(1);
      final NodeListOptional nlo = (NodeListOptional) seq2;
      if (nlo.present()) {
        for (int i = 0; i < nlo.size(); i++) {
          final INode nloeai = nlo.elementAt(i);
          final NodeSequence seq3 = (NodeSequence) nloeai;
          // $0 ","
          final INode seq4 = seq3.elementAt(0);
          seq4.accept(this);
          // $1 FormalParameter()
          final INode seq5 = seq3.elementAt(1);
          seq5.accept(this);
        }
      }
    }
    // f2 -> ")"
    final NodeToken n2 = n.f2;
    n2.accept(this);
  }

  /**
   * Visits a {@link FormalParameter} node, whose children are the following :
   * <p>
   * f0 -> Modifiers()<br>
   * f1 -> Type()<br>
   * f2 -> [ "..." ]<br>
   * f3 -> VariableDeclaratorId()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final FormalParameter n) {
    // f0 -> Modifiers()
    final Modifiers n0 = n.f0;
    n0.accept(this);
    // f1 -> Type()
    final Type n1 = n.f1;
    n1.accept(this);
    // f2 -> [ "..." ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      n2.accept(this);
    }
    // f3 -> VariableDeclaratorId()
    final VariableDeclaratorId n3 = n.f3;
    n3.accept(this);
  }

  /**
   * Visits a {@link ConstructorDeclaration} node, whose children are the following :
   * <p>
   * f0 -> [ TypeParameters() ]<br>
   * f1 -> <IDENTIFIER><br>
   * f2 -> FormalParameters()<br>
   * f3 -> [ #0 "throws" #1 NameList() ]<br>
   * f4 -> "{"<br>
   * f5 -> [ ExplicitConstructorInvocation() ]<br>
   * f6 -> ( BlockStatement() )*<br>
   * f7 -> "}"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ConstructorDeclaration n) {
    // f0 -> [ TypeParameters() ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      n0.accept(this);
    }
    // f1 -> <IDENTIFIER>
    final NodeToken n1 = n.f1;
    n1.accept(this);
    // f2 -> FormalParameters()
    final FormalParameters n2 = n.f2;
    n2.accept(this);
    // f3 -> [ #0 "throws" #1 NameList() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence seq = (NodeSequence) n3.node;
      // #0 "throws"
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 NameList()
      final INode seq2 = seq.elementAt(1);
      seq2.accept(this);
    }
    // f4 -> "{"
    final NodeToken n4 = n.f4;
    n4.accept(this);
    // f5 -> [ ExplicitConstructorInvocation() ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      n5.accept(this);
    }
    // f6 -> ( BlockStatement() )*
    final NodeListOptional n6 = n.f6;
    if (n6.present()) {
      for (int i = 0; i < n6.size(); i++) {
        final INode nloeai = n6.elementAt(i);
        nloeai.accept(this);
      }
    }
    // f7 -> "}"
    final NodeToken n7 = n.f7;
    n7.accept(this);
  }

  /**
   * Visits a {@link ExplicitConstructorInvocation} node, whose child is the following :
   * <p>
   * f0 -> ( %0 #0 [ $0 "<" $1 ReferenceType()<br>
   * .. .. . .. .. . $2 ( ?0 "," ?1 ReferenceType() )*<br>
   * .. .. . .. .. . $3 ">" ]<br>
   * .. .. . .. #1 ( &0 $0 "this" $1 Arguments() $2 ";"<br>
   * .. .. . .. .. | &1 $0 "super" $1 Arguments() $2 ";" )<br>
   * .. .. | %1 ( #0 PrimaryExpression() #1 "." #2 "super" #3 Arguments() #4 ";" ) )<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ExplicitConstructorInvocation n) {
    // f0 -> ( %0 #0 [ $0 "<" $1 ReferenceType()
    // .. .. . .. .. . $2 ( ?0 "," ?1 ReferenceType() )*
    // .. .. . .. .. . $3 ">" ]
    // .. .. . .. #1 ( &0 $0 "this" $1 Arguments() $2 ";"
    // .. .. . .. .. | &1 $0 "super" $1 Arguments() $2 ";" )
    // .. .. | %1 ( #0 PrimaryExpression() #1 "." #2 "super" #3 Arguments() #4 ";" ) )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 #0 [ $0 "<" $1 ReferenceType()
        // .. .. . $2 ( ?0 "," ?1 ReferenceType() )*
        // .. .. . $3 ">" ]
        // .. #1 ( &0 $0 "this" $1 Arguments() $2 ";"
        // .. .. | &1 $0 "super" $1 Arguments() $2 ";" )
        final NodeSequence seq = (NodeSequence) ich;
        // #0 [ $0 "<" $1 ReferenceType()
        // .. . $2 ( ?0 "," ?1 ReferenceType() )*
        // .. . $3 ">" ]
        final INode seq1 = seq.elementAt(0);
        final NodeOptional opt = (NodeOptional) seq1;
        if (opt.present()) {
          final NodeSequence seq2 = (NodeSequence) opt.node;
          // $0 "<"
          final INode seq3 = seq2.elementAt(0);
          seq3.accept(this);
          // $1 ReferenceType()
          final INode seq4 = seq2.elementAt(1);
          seq4.accept(this);
          // $2 ( ?0 "," ?1 ReferenceType() )*
          final INode seq5 = seq2.elementAt(2);
          final NodeListOptional nlo = (NodeListOptional) seq5;
          if (nlo.present()) {
            for (int i = 0; i < nlo.size(); i++) {
              final INode nloeai = nlo.elementAt(i);
              final NodeSequence seq6 = (NodeSequence) nloeai;
              // ?0 ","
              final INode seq7 = seq6.elementAt(0);
              seq7.accept(this);
              // ?1 ReferenceType()
              final INode seq8 = seq6.elementAt(1);
              seq8.accept(this);
            }
          }
          // $3 ">"
          final INode seq9 = seq2.elementAt(3);
          seq9.accept(this);
        }
        // #1 ( &0 $0 "this" $1 Arguments() $2 ";"
        // .. | &1 $0 "super" $1 Arguments() $2 ";" )
        final INode seq10 = seq.elementAt(1);
        final NodeChoice nch1 = (NodeChoice) seq10;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            // &0 $0 "this" $1 Arguments() $2 ";"
            final NodeSequence seq11 = (NodeSequence) ich1;
            // $0 "this"
            final INode seq12 = seq11.elementAt(0);
            seq12.accept(this);
            // $1 Arguments()
            final INode seq13 = seq11.elementAt(1);
            seq13.accept(this);
            // $2 ";"
            final INode seq14 = seq11.elementAt(2);
            seq14.accept(this);
            break;
          case 1:
            // &1 $0 "super" $1 Arguments() $2 ";"
            final NodeSequence seq15 = (NodeSequence) ich1;
            // $0 "super"
            final INode seq16 = seq15.elementAt(0);
            seq16.accept(this);
            // $1 Arguments()
            final INode seq17 = seq15.elementAt(1);
            seq17.accept(this);
            // $2 ";"
            final INode seq18 = seq15.elementAt(2);
            seq18.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      case 1:
        // %1 ( #0 PrimaryExpression() #1 "." #2 "super" #3 Arguments() #4 ";" )
        final NodeSequence seq19 = (NodeSequence) ich;
        // #0 PrimaryExpression()
        final INode seq20 = seq19.elementAt(0);
        seq20.accept(this);
        // #1 "."
        final INode seq21 = seq19.elementAt(1);
        seq21.accept(this);
        // #2 "super"
        final INode seq22 = seq19.elementAt(2);
        seq22.accept(this);
        // #3 Arguments()
        final INode seq23 = seq19.elementAt(3);
        seq23.accept(this);
        // #4 ";"
        final INode seq24 = seq19.elementAt(4);
        seq24.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link Initializer} node, whose children are the following :
   * <p>
   * f0 -> [ "static" ]<br>
   * f1 -> Block()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final Initializer n) {
    // f0 -> [ "static" ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      n0.accept(this);
    }
    // f1 -> Block()
    final Block n1 = n.f1;
    n1.accept(this);
  }

  /**
   * Visits a {@link Type} node, whose child is the following :
   * <p>
   * f0 -> . %0 ReferenceType()<br>
   * .. .. | %1 PrimitiveType()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final Type n) {
    // f0 -> . %0 ReferenceType()
    // .. .. | %1 PrimitiveType()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 ReferenceType()
        ich.accept(this);
        break;
      case 1:
        // %1 PrimitiveType()
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ReferenceType} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 PrimitiveType()<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )+<br>
   * .. .. | %1 #0 ClassOrInterfaceType()<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ReferenceType n) {
    // f0 -> . %0 #0 PrimitiveType()
    // .. .. . .. #1 ( $0 "[" $1 "]" )+
    // .. .. | %1 #0 ClassOrInterfaceType()
    // .. .. . .. #1 ( $0 "[" $1 "]" )*
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 #0 PrimitiveType()
        // .. #1 ( $0 "[" $1 "]" )+
        final NodeSequence seq = (NodeSequence) ich;
        // #0 PrimitiveType()
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 ( $0 "[" $1 "]" )+
        final INode seq2 = seq.elementAt(1);
        final NodeList lst = (NodeList) seq2;
        for (int i = 0; i < lst.size(); i++) {
          final INode lsteai = lst.elementAt(i);
          final NodeSequence seq3 = (NodeSequence) lsteai;
          // $0 "["
          final INode seq4 = seq3.elementAt(0);
          seq4.accept(this);
          // $1 "]"
          final INode seq5 = seq3.elementAt(1);
          seq5.accept(this);
        }
        break;
      case 1:
        // %1 #0 ClassOrInterfaceType()
        // .. #1 ( $0 "[" $1 "]" )*
        final NodeSequence seq6 = (NodeSequence) ich;
        // #0 ClassOrInterfaceType()
        final INode seq7 = seq6.elementAt(0);
        seq7.accept(this);
        // #1 ( $0 "[" $1 "]" )*
        final INode seq8 = seq6.elementAt(1);
        final NodeListOptional nlo = (NodeListOptional) seq8;
        if (nlo.present()) {
          for (int i = 0; i < nlo.size(); i++) {
            final INode nloeai = nlo.elementAt(i);
            final NodeSequence seq9 = (NodeSequence) nloeai;
            // $0 "["
            final INode seq10 = seq9.elementAt(0);
            seq10.accept(this);
            // $1 "]"
            final INode seq11 = seq9.elementAt(1);
            seq11.accept(this);
          }
        }
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ClassOrInterfaceType} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> [ TypeArguments() ]<br>
   * f2 -> ( #0 "." #1 <IDENTIFIER><br>
   * .. .. . #2 [ TypeArguments() ] )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ClassOrInterfaceType n) {
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> [ TypeArguments() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this);
    }
    // f2 -> ( #0 "." #1 <IDENTIFIER>
    // .. .. . #2 [ TypeArguments() ] )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 "."
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 <IDENTIFIER>
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
        // #2 [ TypeArguments() ]
        final INode seq3 = seq.elementAt(2);
        final NodeOptional opt = (NodeOptional) seq3;
        if (opt.present()) {
          opt.accept(this);
        }
      }
    }
  }

  /**
   * Visits a {@link TypeArguments} node, whose children are the following :
   * <p>
   * f0 -> "<"<br>
   * f1 -> TypeArgument()<br>
   * f2 -> ( #0 "," #1 TypeArgument() )*<br>
   * f3 -> ">"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final TypeArguments n) {
    // f0 -> "<"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> TypeArgument()
    final TypeArgument n1 = n.f1;
    n1.accept(this);
    // f2 -> ( #0 "," #1 TypeArgument() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 ","
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 TypeArgument()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
    // f3 -> ">"
    final NodeToken n3 = n.f3;
    n3.accept(this);
  }

  /**
   * Visits a {@link TypeArgument} node, whose child is the following :
   * <p>
   * f0 -> . %0 ReferenceType()<br>
   * .. .. | %1 #0 "?"<br>
   * .. .. . .. #1 [ WildcardBounds() ]<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final TypeArgument n) {
    // f0 -> . %0 ReferenceType()
    // .. .. | %1 #0 "?"
    // .. .. . .. #1 [ WildcardBounds() ]
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 ReferenceType()
        ich.accept(this);
        break;
      case 1:
        // %1 #0 "?"
        // .. #1 [ WildcardBounds() ]
        final NodeSequence seq = (NodeSequence) ich;
        // #0 "?"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 [ WildcardBounds() ]
        final INode seq2 = seq.elementAt(1);
        final NodeOptional opt = (NodeOptional) seq2;
        if (opt.present()) {
          opt.accept(this);
        }
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link WildcardBounds} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "extends" #1 ReferenceType()<br>
   * .. .. | %1 #0 "super" #1 ReferenceType()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final WildcardBounds n) {
    // f0 -> . %0 #0 "extends" #1 ReferenceType()
    // .. .. | %1 #0 "super" #1 ReferenceType()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 #0 "extends" #1 ReferenceType()
        final NodeSequence seq = (NodeSequence) ich;
        // #0 "extends"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 ReferenceType()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
        break;
      case 1:
        // %1 #0 "super" #1 ReferenceType()
        final NodeSequence seq3 = (NodeSequence) ich;
        // #0 "super"
        final INode seq4 = seq3.elementAt(0);
        seq4.accept(this);
        // #1 ReferenceType()
        final INode seq5 = seq3.elementAt(1);
        seq5.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link PrimitiveType} node, whose child is the following :
   * <p>
   * f0 -> . %0 "boolean"<br>
   * .. .. | %1 "char"<br>
   * .. .. | %2 "byte"<br>
   * .. .. | %3 "short"<br>
   * .. .. | %4 "int"<br>
   * .. .. | %5 "long"<br>
   * .. .. | %6 "float"<br>
   * .. .. | %7 "double"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final PrimitiveType n) {
    // f0 -> . %0 "boolean"
    // .. .. | %1 "char"
    // .. .. | %2 "byte"
    // .. .. | %3 "short"
    // .. .. | %4 "int"
    // .. .. | %5 "long"
    // .. .. | %6 "float"
    // .. .. | %7 "double"
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 "boolean"
        ich.accept(this);
        break;
      case 1:
        // %1 "char"
        ich.accept(this);
        break;
      case 2:
        // %2 "byte"
        ich.accept(this);
        break;
      case 3:
        // %3 "short"
        ich.accept(this);
        break;
      case 4:
        // %4 "int"
        ich.accept(this);
        break;
      case 5:
        // %5 "long"
        ich.accept(this);
        break;
      case 6:
        // %6 "float"
        ich.accept(this);
        break;
      case 7:
        // %7 "double"
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ResultType} node, whose child is the following :
   * <p>
   * f0 -> ( %0 "void"<br>
   * .. .. | %1 Type() )<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ResultType n) {
    // f0 -> ( %0 "void"
    // .. .. | %1 Type() )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 "void"
        ich.accept(this);
        break;
      case 1:
        // %1 Type()
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link Name} node, whose children are the following :
   * <p>
   * f0 -> JavaIdentifier()<br>
   * f1 -> ( #0 "." #1 JavaIdentifier() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final Name n) {
    // f0 -> JavaIdentifier()
    final JavaIdentifier n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 "." #1 JavaIdentifier() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 "."
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 JavaIdentifier()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link NameList} node, whose children are the following :
   * <p>
   * f0 -> Name()<br>
   * f1 -> ( #0 "," #1 Name() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final NameList n) {
    // f0 -> Name()
    final Name n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 "," #1 Name() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 ","
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 Name()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link Expression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalExpression()<br>
   * f1 -> [ #0 AssignmentOperator() #1 Expression() ]<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final Expression n) {
    // f0 -> ConditionalExpression()
    final ConditionalExpression n0 = n.f0;
    n0.accept(this);
    // f1 -> [ #0 AssignmentOperator() #1 Expression() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence seq = (NodeSequence) n1.node;
      // #0 AssignmentOperator()
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 Expression()
      final INode seq2 = seq.elementAt(1);
      seq2.accept(this);
    }
  }

  /**
   * Visits a {@link AssignmentOperator} node, whose child is the following :
   * <p>
   * f0 -> . %00 "="<br>
   * .. .. | %01 "*="<br>
   * .. .. | %02 "/="<br>
   * .. .. | %03 "%="<br>
   * .. .. | %04 "+="<br>
   * .. .. | %05 "-="<br>
   * .. .. | %06 "<<="<br>
   * .. .. | %07 ">>="<br>
   * .. .. | %08 ">>>="<br>
   * .. .. | %09 "&="<br>
   * .. .. | %10 "^="<br>
   * .. .. | %11 "|="<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final AssignmentOperator n) {
    // f0 -> . %00 "="
    // .. .. | %01 "*="
    // .. .. | %02 "/="
    // .. .. | %03 "%="
    // .. .. | %04 "+="
    // .. .. | %05 "-="
    // .. .. | %06 "<<="
    // .. .. | %07 ">>="
    // .. .. | %08 ">>>="
    // .. .. | %09 "&="
    // .. .. | %10 "^="
    // .. .. | %11 "|="
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %00 "="
        ich.accept(this);
        break;
      case 1:
        // %01 "*="
        ich.accept(this);
        break;
      case 2:
        // %02 "/="
        ich.accept(this);
        break;
      case 3:
        // %03 "%="
        ich.accept(this);
        break;
      case 4:
        // %04 "+="
        ich.accept(this);
        break;
      case 5:
        // %05 "-="
        ich.accept(this);
        break;
      case 6:
        // %06 "<<="
        ich.accept(this);
        break;
      case 7:
        // %07 ">>="
        ich.accept(this);
        break;
      case 8:
        // %08 ">>>="
        ich.accept(this);
        break;
      case 9:
        // %09 "&="
        ich.accept(this);
        break;
      case 10:
        // %10 "^="
        ich.accept(this);
        break;
      case 11:
        // %11 "|="
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ConditionalExpression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalOrExpression()<br>
   * f1 -> [ #0 "?" #1 Expression() #2 ":" #3 Expression() ]<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ConditionalExpression n) {
    // f0 -> ConditionalOrExpression()
    final ConditionalOrExpression n0 = n.f0;
    n0.accept(this);
    // f1 -> [ #0 "?" #1 Expression() #2 ":" #3 Expression() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence seq = (NodeSequence) n1.node;
      // #0 "?"
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 Expression()
      final INode seq2 = seq.elementAt(1);
      seq2.accept(this);
      // #2 ":"
      final INode seq3 = seq.elementAt(2);
      seq3.accept(this);
      // #3 Expression()
      final INode seq4 = seq.elementAt(3);
      seq4.accept(this);
    }
  }

  /**
   * Visits a {@link ConditionalOrExpression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalAndExpression()<br>
   * f1 -> ( #0 "||" #1 ConditionalAndExpression() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ConditionalOrExpression n) {
    // f0 -> ConditionalAndExpression()
    final ConditionalAndExpression n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 "||" #1 ConditionalAndExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 "||"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 ConditionalAndExpression()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link ConditionalAndExpression} node, whose children are the following :
   * <p>
   * f0 -> InclusiveOrExpression()<br>
   * f1 -> ( #0 "&&" #1 InclusiveOrExpression() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ConditionalAndExpression n) {
    // f0 -> InclusiveOrExpression()
    final InclusiveOrExpression n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 "&&" #1 InclusiveOrExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 "&&"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 InclusiveOrExpression()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link InclusiveOrExpression} node, whose children are the following :
   * <p>
   * f0 -> ExclusiveOrExpression()<br>
   * f1 -> ( #0 "|" #1 ExclusiveOrExpression() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final InclusiveOrExpression n) {
    // f0 -> ExclusiveOrExpression()
    final ExclusiveOrExpression n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 "|" #1 ExclusiveOrExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 "|"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 ExclusiveOrExpression()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link ExclusiveOrExpression} node, whose children are the following :
   * <p>
   * f0 -> AndExpression()<br>
   * f1 -> ( #0 "^" #1 AndExpression() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ExclusiveOrExpression n) {
    // f0 -> AndExpression()
    final AndExpression n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 "^" #1 AndExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 "^"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 AndExpression()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link AndExpression} node, whose children are the following :
   * <p>
   * f0 -> EqualityExpression()<br>
   * f1 -> ( #0 "&" #1 EqualityExpression() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final AndExpression n) {
    // f0 -> EqualityExpression()
    final EqualityExpression n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 "&" #1 EqualityExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 "&"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 EqualityExpression()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link EqualityExpression} node, whose children are the following :
   * <p>
   * f0 -> InstanceOfExpression()<br>
   * f1 -> ( #0 ( %0 "=="<br>
   * .. .. . .. | %1 "!=" )<br>
   * .. .. . #1 InstanceOfExpression() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final EqualityExpression n) {
    // f0 -> InstanceOfExpression()
    final InstanceOfExpression n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 ( %0 "=="
    // .. .. . .. | %1 "!=" )
    // .. .. . #1 InstanceOfExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 ( %0 "=="
        // .. | %1 "!=" )
        final INode seq1 = seq.elementAt(0);
        final NodeChoice nch = (NodeChoice) seq1;
        final INode ich = nch.choice;
        switch (nch.which) {
          case 0:
            // %0 "=="
            ich.accept(this);
            break;
          case 1:
            // %1 "!="
            ich.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 InstanceOfExpression()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link InstanceOfExpression} node, whose children are the following :
   * <p>
   * f0 -> RelationalExpression()<br>
   * f1 -> [ #0 "instanceof" #1 Type() ]<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final InstanceOfExpression n) {
    // f0 -> RelationalExpression()
    final RelationalExpression n0 = n.f0;
    n0.accept(this);
    // f1 -> [ #0 "instanceof" #1 Type() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence seq = (NodeSequence) n1.node;
      // #0 "instanceof"
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 Type()
      final INode seq2 = seq.elementAt(1);
      seq2.accept(this);
    }
  }

  /**
   * Visits a {@link RelationalExpression} node, whose children are the following :
   * <p>
   * f0 -> ShiftExpression()<br>
   * f1 -> ( #0 ( %0 "<"<br>
   * .. .. . .. | %1 ">"<br>
   * .. .. . .. | %2 "<="<br>
   * .. .. . .. | %3 ">=" )<br>
   * .. .. . #1 ShiftExpression() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final RelationalExpression n) {
    // f0 -> ShiftExpression()
    final ShiftExpression n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 ( %0 "<"
    // .. .. . .. | %1 ">"
    // .. .. . .. | %2 "<="
    // .. .. . .. | %3 ">=" )
    // .. .. . #1 ShiftExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 ( %0 "<"
        // .. | %1 ">"
        // .. | %2 "<="
        // .. | %3 ">=" )
        final INode seq1 = seq.elementAt(0);
        final NodeChoice nch = (NodeChoice) seq1;
        final INode ich = nch.choice;
        switch (nch.which) {
          case 0:
            // %0 "<"
            ich.accept(this);
            break;
          case 1:
            // %1 ">"
            ich.accept(this);
            break;
          case 2:
            // %2 "<="
            ich.accept(this);
            break;
          case 3:
            // %3 ">="
            ich.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 ShiftExpression()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link ShiftExpression} node, whose children are the following :
   * <p>
   * f0 -> AdditiveExpression()<br>
   * f1 -> ( #0 ( %0 "<<"<br>
   * .. .. . .. | %1 RUnsignedShift()<br>
   * .. .. . .. | %2 RSignedShift() )<br>
   * .. .. . #1 AdditiveExpression() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ShiftExpression n) {
    // f0 -> AdditiveExpression()
    final AdditiveExpression n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 ( %0 "<<"
    // .. .. . .. | %1 RUnsignedShift()
    // .. .. . .. | %2 RSignedShift() )
    // .. .. . #1 AdditiveExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 ( %0 "<<"
        // .. | %1 RUnsignedShift()
        // .. | %2 RSignedShift() )
        final INode seq1 = seq.elementAt(0);
        final NodeChoice nch = (NodeChoice) seq1;
        final INode ich = nch.choice;
        switch (nch.which) {
          case 0:
            // %0 "<<"
            ich.accept(this);
            break;
          case 1:
            // %1 RUnsignedShift()
            ich.accept(this);
            break;
          case 2:
            // %2 RSignedShift()
            ich.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 AdditiveExpression()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link RSignedShift} node, whose child is the following :
   * <p>
   * f0 -> ">>"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final RSignedShift n) {
    // f0 -> ">>"
    final NodeToken n0 = n.f0;
    n0.accept(this);
  }

  /**
   * Visits a {@link RUnsignedShift} node, whose child is the following :
   * <p>
   * f0 -> ">>>"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final RUnsignedShift n) {
    // f0 -> ">>>"
    final NodeToken n0 = n.f0;
    n0.accept(this);
  }

  /**
   * Visits a {@link AdditiveExpression} node, whose children are the following :
   * <p>
   * f0 -> MultiplicativeExpression()<br>
   * f1 -> ( #0 ( %0 "+"<br>
   * .. .. . .. | %1 "-" )<br>
   * .. .. . #1 MultiplicativeExpression() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final AdditiveExpression n) {
    // f0 -> MultiplicativeExpression()
    final MultiplicativeExpression n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 ( %0 "+"
    // .. .. . .. | %1 "-" )
    // .. .. . #1 MultiplicativeExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 ( %0 "+"
        // .. | %1 "-" )
        final INode seq1 = seq.elementAt(0);
        final NodeChoice nch = (NodeChoice) seq1;
        final INode ich = nch.choice;
        switch (nch.which) {
          case 0:
            // %0 "+"
            ich.accept(this);
            break;
          case 1:
            // %1 "-"
            ich.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 MultiplicativeExpression()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link MultiplicativeExpression} node, whose children are the following :
   * <p>
   * f0 -> UnaryExpression()<br>
   * f1 -> ( #0 ( %0 "*"<br>
   * .. .. . .. | %1 "/"<br>
   * .. .. . .. | %2 "%" )<br>
   * .. .. . #1 UnaryExpression() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final MultiplicativeExpression n) {
    // f0 -> UnaryExpression()
    final UnaryExpression n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 ( %0 "*"
    // .. .. . .. | %1 "/"
    // .. .. . .. | %2 "%" )
    // .. .. . #1 UnaryExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 ( %0 "*"
        // .. | %1 "/"
        // .. | %2 "%" )
        final INode seq1 = seq.elementAt(0);
        final NodeChoice nch = (NodeChoice) seq1;
        final INode ich = nch.choice;
        switch (nch.which) {
          case 0:
            // %0 "*"
            ich.accept(this);
            break;
          case 1:
            // %1 "/"
            ich.accept(this);
            break;
          case 2:
            // %2 "%"
            ich.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 UnaryExpression()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link UnaryExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 ( &0 "+"<br>
   * .. .. . .. .. | &1 "-" )<br>
   * .. .. . .. #1 UnaryExpression()<br>
   * .. .. | %1 PreIncrementExpression()<br>
   * .. .. | %2 PreDecrementExpression()<br>
   * .. .. | %3 UnaryExpressionNotPlusMinus()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final UnaryExpression n) {
    // f0 -> . %0 #0 ( &0 "+"
    // .. .. . .. .. | &1 "-" )
    // .. .. . .. #1 UnaryExpression()
    // .. .. | %1 PreIncrementExpression()
    // .. .. | %2 PreDecrementExpression()
    // .. .. | %3 UnaryExpressionNotPlusMinus()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 #0 ( &0 "+"
        // .. .. | &1 "-" )
        // .. #1 UnaryExpression()
        final NodeSequence seq = (NodeSequence) ich;
        // #0 ( &0 "+"
        // .. | &1 "-" )
        final INode seq1 = seq.elementAt(0);
        final NodeChoice nch1 = (NodeChoice) seq1;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            // &0 "+"
            ich1.accept(this);
            break;
          case 1:
            // &1 "-"
            ich1.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 UnaryExpression()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
        break;
      case 1:
        // %1 PreIncrementExpression()
        ich.accept(this);
        break;
      case 2:
        // %2 PreDecrementExpression()
        ich.accept(this);
        break;
      case 3:
        // %3 UnaryExpressionNotPlusMinus()
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link PreIncrementExpression} node, whose children are the following :
   * <p>
   * f0 -> "++"<br>
   * f1 -> PrimaryExpression()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final PreIncrementExpression n) {
    // f0 -> "++"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> PrimaryExpression()
    final PrimaryExpression n1 = n.f1;
    n1.accept(this);
  }

  /**
   * Visits a {@link PreDecrementExpression} node, whose children are the following :
   * <p>
   * f0 -> "--"<br>
   * f1 -> PrimaryExpression()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final PreDecrementExpression n) {
    // f0 -> "--"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> PrimaryExpression()
    final PrimaryExpression n1 = n.f1;
    n1.accept(this);
  }

  /**
   * Visits a {@link UnaryExpressionNotPlusMinus} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 ( &0 "~"<br>
   * .. .. . .. .. | &1 "!" )<br>
   * .. .. . .. #1 UnaryExpression()<br>
   * .. .. | %1 CastExpression()<br>
   * .. .. | %2 PostfixExpression()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final UnaryExpressionNotPlusMinus n) {
    // f0 -> . %0 #0 ( &0 "~"
    // .. .. . .. .. | &1 "!" )
    // .. .. . .. #1 UnaryExpression()
    // .. .. | %1 CastExpression()
    // .. .. | %2 PostfixExpression()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 #0 ( &0 "~"
        // .. .. | &1 "!" )
        // .. #1 UnaryExpression()
        final NodeSequence seq = (NodeSequence) ich;
        // #0 ( &0 "~"
        // .. | &1 "!" )
        final INode seq1 = seq.elementAt(0);
        final NodeChoice nch1 = (NodeChoice) seq1;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            // &0 "~"
            ich1.accept(this);
            break;
          case 1:
            // &1 "!"
            ich1.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 UnaryExpression()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
        break;
      case 1:
        // %1 CastExpression()
        ich.accept(this);
        break;
      case 2:
        // %2 PostfixExpression()
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link CastLookahead} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "(" #1 PrimitiveType()<br>
   * .. .. | %1 #0 "(" #1 Type() #2 "[" #3 "]"<br>
   * .. .. | %2 #0 "(" #1 Type() #2 ")"<br>
   * .. .. . .. #3 ( &0 "~"<br>
   * .. .. . .. .. | &1 "!"<br>
   * .. .. . .. .. | &2 "("<br>
   * .. .. . .. .. | &3 <IDENTIFIER><br>
   * .. .. . .. .. | &4 "this"<br>
   * .. .. . .. .. | &5 "super"<br>
   * .. .. . .. .. | &6 "new"<br>
   * .. .. . .. .. | &7 Literal() )<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final CastLookahead n) {
    // f0 -> . %0 #0 "(" #1 PrimitiveType()
    // .. .. | %1 #0 "(" #1 Type() #2 "[" #3 "]"
    // .. .. | %2 #0 "(" #1 Type() #2 ")"
    // .. .. . .. #3 ( &0 "~"
    // .. .. . .. .. | &1 "!"
    // .. .. . .. .. | &2 "("
    // .. .. . .. .. | &3 <IDENTIFIER>
    // .. .. . .. .. | &4 "this"
    // .. .. . .. .. | &5 "super"
    // .. .. . .. .. | &6 "new"
    // .. .. . .. .. | &7 Literal() )
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 #0 "(" #1 PrimitiveType()
        final NodeSequence seq = (NodeSequence) ich;
        // #0 "("
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 PrimitiveType()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
        break;
      case 1:
        // %1 #0 "(" #1 Type() #2 "[" #3 "]"
        final NodeSequence seq3 = (NodeSequence) ich;
        // #0 "("
        final INode seq4 = seq3.elementAt(0);
        seq4.accept(this);
        // #1 Type()
        final INode seq5 = seq3.elementAt(1);
        seq5.accept(this);
        // #2 "["
        final INode seq6 = seq3.elementAt(2);
        seq6.accept(this);
        // #3 "]"
        final INode seq7 = seq3.elementAt(3);
        seq7.accept(this);
        break;
      case 2:
        // %2 #0 "(" #1 Type() #2 ")"
        // .. #3 ( &0 "~"
        // .. .. | &1 "!"
        // .. .. | &2 "("
        // .. .. | &3 <IDENTIFIER>
        // .. .. | &4 "this"
        // .. .. | &5 "super"
        // .. .. | &6 "new"
        // .. .. | &7 Literal() )
        final NodeSequence seq8 = (NodeSequence) ich;
        // #0 "("
        final INode seq9 = seq8.elementAt(0);
        seq9.accept(this);
        // #1 Type()
        final INode seq10 = seq8.elementAt(1);
        seq10.accept(this);
        // #2 ")"
        final INode seq11 = seq8.elementAt(2);
        seq11.accept(this);
        // #3 ( &0 "~"
        // .. | &1 "!"
        // .. | &2 "("
        // .. | &3 <IDENTIFIER>
        // .. | &4 "this"
        // .. | &5 "super"
        // .. | &6 "new"
        // .. | &7 Literal() )
        final INode seq12 = seq8.elementAt(3);
        final NodeChoice nch1 = (NodeChoice) seq12;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            // &0 "~"
            ich1.accept(this);
            break;
          case 1:
            // &1 "!"
            ich1.accept(this);
            break;
          case 2:
            // &2 "("
            ich1.accept(this);
            break;
          case 3:
            // &3 <IDENTIFIER>
            ich1.accept(this);
            break;
          case 4:
            // &4 "this"
            ich1.accept(this);
            break;
          case 5:
            // &5 "super"
            ich1.accept(this);
            break;
          case 6:
            // &6 "new"
            ich1.accept(this);
            break;
          case 7:
            // &7 Literal()
            ich1.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link PostfixExpression} node, whose children are the following :
   * <p>
   * f0 -> PrimaryExpression()<br>
   * f1 -> [ %0 "++"<br>
   * .. .. | %1 "--" ]<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final PostfixExpression n) {
    // f0 -> PrimaryExpression()
    final PrimaryExpression n0 = n.f0;
    n0.accept(this);
    // f1 -> [ %0 "++"
    // .. .. | %1 "--" ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeChoice nch = (NodeChoice) n1.node;
      final INode ich = nch.choice;
      switch (nch.which) {
        case 0:
          // %0 "++"
          ich.accept(this);
          break;
        case 1:
          // %1 "--"
          ich.accept(this);
          break;
        default:
          // should not occur !!!
          break;
      }
    }
  }

  /**
   * Visits a {@link CastExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "(" #1 Type() #2 ")" #3 UnaryExpression()<br>
   * .. .. | %1 #0 "(" #1 Type() #2 ")" #3 UnaryExpressionNotPlusMinus()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final CastExpression n) {
    // f0 -> . %0 #0 "(" #1 Type() #2 ")" #3 UnaryExpression()
    // .. .. | %1 #0 "(" #1 Type() #2 ")" #3 UnaryExpressionNotPlusMinus()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 #0 "(" #1 Type() #2 ")" #3 UnaryExpression()
        final NodeSequence seq = (NodeSequence) ich;
        // #0 "("
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 Type()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
        // #2 ")"
        final INode seq3 = seq.elementAt(2);
        seq3.accept(this);
        // #3 UnaryExpression()
        final INode seq4 = seq.elementAt(3);
        seq4.accept(this);
        break;
      case 1:
        // %1 #0 "(" #1 Type() #2 ")" #3 UnaryExpressionNotPlusMinus()
        final NodeSequence seq5 = (NodeSequence) ich;
        // #0 "("
        final INode seq6 = seq5.elementAt(0);
        seq6.accept(this);
        // #1 Type()
        final INode seq7 = seq5.elementAt(1);
        seq7.accept(this);
        // #2 ")"
        final INode seq8 = seq5.elementAt(2);
        seq8.accept(this);
        // #3 UnaryExpressionNotPlusMinus()
        final INode seq9 = seq5.elementAt(3);
        seq9.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link PrimaryExpression} node, whose children are the following :
   * <p>
   * f0 -> PrimaryPrefix()<br>
   * f1 -> ( PrimarySuffix() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final PrimaryExpression n) {
    // f0 -> PrimaryPrefix()
    final PrimaryPrefix n0 = n.f0;
    n0.accept(this);
    // f1 -> ( PrimarySuffix() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        nloeai.accept(this);
      }
    }
  }

  /**
   * Visits a {@link MemberSelector} node, whose children are the following :
   * <p>
   * f0 -> "."<br>
   * f1 -> TypeArguments()<br>
   * f2 -> <IDENTIFIER><br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final MemberSelector n) {
    // f0 -> "."
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> TypeArguments()
    final TypeArguments n1 = n.f1;
    n1.accept(this);
    // f2 -> <IDENTIFIER>
    final NodeToken n2 = n.f2;
    n2.accept(this);
  }

  /**
   * Visits a {@link PrimaryPrefix} node, whose child is the following :
   * <p>
   * f0 -> . %0 Literal()<br>
   * .. .. | %1 "this"<br>
   * .. .. | %2 #0 "super" #1 "." #2 <IDENTIFIER><br>
   * .. .. | %3 #0 "(" #1 Expression() #2 ")"<br>
   * .. .. | %4 AllocationExpression()<br>
   * .. .. | %5 #0 ResultType() #1 "." #2 "class"<br>
   * .. .. | %6 Name()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final PrimaryPrefix n) {
    // f0 -> . %0 Literal()
    // .. .. | %1 "this"
    // .. .. | %2 #0 "super" #1 "." #2 <IDENTIFIER>
    // .. .. | %3 #0 "(" #1 Expression() #2 ")"
    // .. .. | %4 AllocationExpression()
    // .. .. | %5 #0 ResultType() #1 "." #2 "class"
    // .. .. | %6 Name()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 Literal()
        ich.accept(this);
        break;
      case 1:
        // %1 "this"
        ich.accept(this);
        break;
      case 2:
        // %2 #0 "super" #1 "." #2 <IDENTIFIER>
        final NodeSequence seq = (NodeSequence) ich;
        // #0 "super"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 "."
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
        // #2 <IDENTIFIER>
        final INode seq3 = seq.elementAt(2);
        seq3.accept(this);
        break;
      case 3:
        // %3 #0 "(" #1 Expression() #2 ")"
        final NodeSequence seq4 = (NodeSequence) ich;
        // #0 "("
        final INode seq5 = seq4.elementAt(0);
        seq5.accept(this);
        // #1 Expression()
        final INode seq6 = seq4.elementAt(1);
        seq6.accept(this);
        // #2 ")"
        final INode seq7 = seq4.elementAt(2);
        seq7.accept(this);
        break;
      case 4:
        // %4 AllocationExpression()
        ich.accept(this);
        break;
      case 5:
        // %5 #0 ResultType() #1 "." #2 "class"
        final NodeSequence seq8 = (NodeSequence) ich;
        // #0 ResultType()
        final INode seq9 = seq8.elementAt(0);
        seq9.accept(this);
        // #1 "."
        final INode seq10 = seq8.elementAt(1);
        seq10.accept(this);
        // #2 "class"
        final INode seq11 = seq8.elementAt(2);
        seq11.accept(this);
        break;
      case 6:
        // %6 Name()
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link PrimarySuffix} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "." #1 "this"<br>
   * .. .. | %1 #0 "." #1 AllocationExpression()<br>
   * .. .. | %2 MemberSelector()<br>
   * .. .. | %3 #0 "[" #1 Expression() #2 "]"<br>
   * .. .. | %4 #0 "." #1 <IDENTIFIER><br>
   * .. .. | %5 Arguments()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final PrimarySuffix n) {
    // f0 -> . %0 #0 "." #1 "this"
    // .. .. | %1 #0 "." #1 AllocationExpression()
    // .. .. | %2 MemberSelector()
    // .. .. | %3 #0 "[" #1 Expression() #2 "]"
    // .. .. | %4 #0 "." #1 <IDENTIFIER>
    // .. .. | %5 Arguments()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 #0 "." #1 "this"
        final NodeSequence seq = (NodeSequence) ich;
        // #0 "."
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 "this"
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
        break;
      case 1:
        // %1 #0 "." #1 AllocationExpression()
        final NodeSequence seq3 = (NodeSequence) ich;
        // #0 "."
        final INode seq4 = seq3.elementAt(0);
        seq4.accept(this);
        // #1 AllocationExpression()
        final INode seq5 = seq3.elementAt(1);
        seq5.accept(this);
        break;
      case 2:
        // %2 MemberSelector()
        ich.accept(this);
        break;
      case 3:
        // %3 #0 "[" #1 Expression() #2 "]"
        final NodeSequence seq6 = (NodeSequence) ich;
        // #0 "["
        final INode seq7 = seq6.elementAt(0);
        seq7.accept(this);
        // #1 Expression()
        final INode seq8 = seq6.elementAt(1);
        seq8.accept(this);
        // #2 "]"
        final INode seq9 = seq6.elementAt(2);
        seq9.accept(this);
        break;
      case 4:
        // %4 #0 "." #1 <IDENTIFIER>
        final NodeSequence seq10 = (NodeSequence) ich;
        // #0 "."
        final INode seq11 = seq10.elementAt(0);
        seq11.accept(this);
        // #1 <IDENTIFIER>
        final INode seq12 = seq10.elementAt(1);
        seq12.accept(this);
        break;
      case 5:
        // %5 Arguments()
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link Literal} node, whose child is the following :
   * <p>
   * f0 -> . %0 <INTEGER_LITERAL><br>
   * .. .. | %1 <FLOATING_POINT_LITERAL><br>
   * .. .. | %2 <CHARACTER_LITERAL><br>
   * .. .. | %3 <STRING_LITERAL><br>
   * .. .. | %4 BooleanLiteral()<br>
   * .. .. | %5 NullLiteral()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final Literal n) {
    // f0 -> . %0 <INTEGER_LITERAL>
    // .. .. | %1 <FLOATING_POINT_LITERAL>
    // .. .. | %2 <CHARACTER_LITERAL>
    // .. .. | %3 <STRING_LITERAL>
    // .. .. | %4 BooleanLiteral()
    // .. .. | %5 NullLiteral()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 <INTEGER_LITERAL>
        ich.accept(this);
        break;
      case 1:
        // %1 <FLOATING_POINT_LITERAL>
        ich.accept(this);
        break;
      case 2:
        // %2 <CHARACTER_LITERAL>
        ich.accept(this);
        break;
      case 3:
        // %3 <STRING_LITERAL>
        ich.accept(this);
        break;
      case 4:
        // %4 BooleanLiteral()
        ich.accept(this);
        break;
      case 5:
        // %5 NullLiteral()
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link IntegerLiteral} node, whose child is the following :
   * <p>
   * f0 -> <INTEGER_LITERAL><br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final IntegerLiteral n) {
    // f0 -> <INTEGER_LITERAL>
    final NodeToken n0 = n.f0;
    n0.accept(this);
  }

  /**
   * Visits a {@link BooleanLiteral} node, whose child is the following :
   * <p>
   * f0 -> . %0 "true"<br>
   * .. .. | %1 "false"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final BooleanLiteral n) {
    // f0 -> . %0 "true"
    // .. .. | %1 "false"
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 "true"
        ich.accept(this);
        break;
      case 1:
        // %1 "false"
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link StringLiteral} node, whose child is the following :
   * <p>
   * f0 -> <STRING_LITERAL><br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final StringLiteral n) {
    // f0 -> <STRING_LITERAL>
    final NodeToken n0 = n.f0;
    n0.accept(this);
  }

  /**
   * Visits a {@link NullLiteral} node, whose child is the following :
   * <p>
   * f0 -> "null"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final NullLiteral n) {
    // f0 -> "null"
    final NodeToken n0 = n.f0;
    n0.accept(this);
  }

  /**
   * Visits a {@link Arguments} node, whose children are the following :
   * <p>
   * f0 -> "("<br>
   * f1 -> [ ArgumentList() ]<br>
   * f2 -> ")"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final Arguments n) {
    // f0 -> "("
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> [ ArgumentList() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this);
    }
    // f2 -> ")"
    final NodeToken n2 = n.f2;
    n2.accept(this);
  }

  /**
   * Visits a {@link ArgumentList} node, whose children are the following :
   * <p>
   * f0 -> Expression()<br>
   * f1 -> ( #0 "," #1 Expression() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ArgumentList n) {
    // f0 -> Expression()
    final Expression n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 "," #1 Expression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 ","
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 Expression()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link AllocationExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "new" #1 PrimitiveType() #2 ArrayDimsAndInits()<br>
   * .. .. | %1 #0 "new" #1 ClassOrInterfaceType()<br>
   * .. .. . .. #2 [ TypeArguments() ]<br>
   * .. .. . .. #3 ( &0 ArrayDimsAndInits()<br>
   * .. .. . .. .. | &1 $0 Arguments()<br>
   * .. .. . .. .. . .. $1 [ ClassOrInterfaceBody() ] )<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final AllocationExpression n) {
    // f0 -> . %0 #0 "new" #1 PrimitiveType() #2 ArrayDimsAndInits()
    // .. .. | %1 #0 "new" #1 ClassOrInterfaceType()
    // .. .. . .. #2 [ TypeArguments() ]
    // .. .. . .. #3 ( &0 ArrayDimsAndInits()
    // .. .. . .. .. | &1 $0 Arguments()
    // .. .. . .. .. . .. $1 [ ClassOrInterfaceBody() ] )
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 #0 "new" #1 PrimitiveType() #2 ArrayDimsAndInits()
        final NodeSequence seq = (NodeSequence) ich;
        // #0 "new"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 PrimitiveType()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
        // #2 ArrayDimsAndInits()
        final INode seq3 = seq.elementAt(2);
        seq3.accept(this);
        break;
      case 1:
        // %1 #0 "new" #1 ClassOrInterfaceType()
        // .. #2 [ TypeArguments() ]
        // .. #3 ( &0 ArrayDimsAndInits()
        // .. .. | &1 $0 Arguments()
        // .. .. .. $1 [ ClassOrInterfaceBody() ] )
        final NodeSequence seq4 = (NodeSequence) ich;
        // #0 "new"
        final INode seq5 = seq4.elementAt(0);
        seq5.accept(this);
        // #1 ClassOrInterfaceType()
        final INode seq6 = seq4.elementAt(1);
        seq6.accept(this);
        // #2 [ TypeArguments() ]
        final INode seq7 = seq4.elementAt(2);
        final NodeOptional opt = (NodeOptional) seq7;
        if (opt.present()) {
          opt.accept(this);
        }
        // #3 ( &0 ArrayDimsAndInits()
        // .. | &1 $0 Arguments()
        // .. .. $1 [ ClassOrInterfaceBody() ] )
        final INode seq8 = seq4.elementAt(3);
        final NodeChoice nch1 = (NodeChoice) seq8;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            // &0 ArrayDimsAndInits()
            ich1.accept(this);
            break;
          case 1:
            // &1 $0 Arguments()
            // .. $1 [ ClassOrInterfaceBody() ]
            final NodeSequence seq9 = (NodeSequence) ich1;
            // $0 Arguments()
            final INode seq10 = seq9.elementAt(0);
            seq10.accept(this);
            // $1 [ ClassOrInterfaceBody() ]
            final INode seq11 = seq9.elementAt(1);
            final NodeOptional opt1 = (NodeOptional) seq11;
            if (opt1.present()) {
              opt1.accept(this);
            }
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ArrayDimsAndInits} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 ( $0 "[" $1 Expression() $2 "]" )+<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )*<br>
   * .. .. | %1 #0 ( $0 "[" $1 "]" )+<br>
   * .. .. . .. #1 ArrayInitializer()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ArrayDimsAndInits n) {
    // f0 -> . %0 #0 ( $0 "[" $1 Expression() $2 "]" )+
    // .. .. . .. #1 ( $0 "[" $1 "]" )*
    // .. .. | %1 #0 ( $0 "[" $1 "]" )+
    // .. .. . .. #1 ArrayInitializer()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 #0 ( $0 "[" $1 Expression() $2 "]" )+
        // .. #1 ( $0 "[" $1 "]" )*
        final NodeSequence seq = (NodeSequence) ich;
        // #0 ( $0 "[" $1 Expression() $2 "]" )+
        final INode seq1 = seq.elementAt(0);
        final NodeList lst = (NodeList) seq1;
        for (int i = 0; i < lst.size(); i++) {
          final INode lsteai = lst.elementAt(i);
          final NodeSequence seq2 = (NodeSequence) lsteai;
          // $0 "["
          final INode seq3 = seq2.elementAt(0);
          seq3.accept(this);
          // $1 Expression()
          final INode seq4 = seq2.elementAt(1);
          seq4.accept(this);
          // $2 "]"
          final INode seq5 = seq2.elementAt(2);
          seq5.accept(this);
        }
        // #1 ( $0 "[" $1 "]" )*
        final INode seq6 = seq.elementAt(1);
        final NodeListOptional nlo = (NodeListOptional) seq6;
        if (nlo.present()) {
          for (int i = 0; i < nlo.size(); i++) {
            final INode nloeai = nlo.elementAt(i);
            final NodeSequence seq7 = (NodeSequence) nloeai;
            // $0 "["
            final INode seq8 = seq7.elementAt(0);
            seq8.accept(this);
            // $1 "]"
            final INode seq9 = seq7.elementAt(1);
            seq9.accept(this);
          }
        }
        break;
      case 1:
        // %1 #0 ( $0 "[" $1 "]" )+
        // .. #1 ArrayInitializer()
        final NodeSequence seq10 = (NodeSequence) ich;
        // #0 ( $0 "[" $1 "]" )+
        final INode seq11 = seq10.elementAt(0);
        final NodeList lst1 = (NodeList) seq11;
        for (int i = 0; i < lst1.size(); i++) {
          final INode lsteai = lst1.elementAt(i);
          final NodeSequence seq12 = (NodeSequence) lsteai;
          // $0 "["
          final INode seq13 = seq12.elementAt(0);
          seq13.accept(this);
          // $1 "]"
          final INode seq14 = seq12.elementAt(1);
          seq14.accept(this);
        }
        // #1 ArrayInitializer()
        final INode seq15 = seq10.elementAt(1);
        seq15.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link Statement} node, whose child is the following :
   * <p>
   * f0 -> . %00 LabeledStatement()<br>
   * .. .. | %01 AssertStatement()<br>
   * .. .. | %02 Block()<br>
   * .. .. | %03 EmptyStatement()<br>
   * .. .. | %04 #0 StatementExpression() #1 ";"<br>
   * .. .. | %05 SwitchStatement()<br>
   * .. .. | %06 IfStatement()<br>
   * .. .. | %07 WhileStatement()<br>
   * .. .. | %08 DoStatement()<br>
   * .. .. | %09 ForStatement()<br>
   * .. .. | %10 BreakStatement()<br>
   * .. .. | %11 ContinueStatement()<br>
   * .. .. | %12 ReturnStatement()<br>
   * .. .. | %13 ThrowStatement()<br>
   * .. .. | %14 SynchronizedStatement()<br>
   * .. .. | %15 TryStatement()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final Statement n) {
    // f0 -> . %00 LabeledStatement()
    // .. .. | %01 AssertStatement()
    // .. .. | %02 Block()
    // .. .. | %03 EmptyStatement()
    // .. .. | %04 #0 StatementExpression() #1 ";"
    // .. .. | %05 SwitchStatement()
    // .. .. | %06 IfStatement()
    // .. .. | %07 WhileStatement()
    // .. .. | %08 DoStatement()
    // .. .. | %09 ForStatement()
    // .. .. | %10 BreakStatement()
    // .. .. | %11 ContinueStatement()
    // .. .. | %12 ReturnStatement()
    // .. .. | %13 ThrowStatement()
    // .. .. | %14 SynchronizedStatement()
    // .. .. | %15 TryStatement()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %00 LabeledStatement()
        ich.accept(this);
        break;
      case 1:
        // %01 AssertStatement()
        ich.accept(this);
        break;
      case 2:
        // %02 Block()
        ich.accept(this);
        break;
      case 3:
        // %03 EmptyStatement()
        ich.accept(this);
        break;
      case 4:
        // %04 #0 StatementExpression() #1 ";"
        final NodeSequence seq = (NodeSequence) ich;
        // #0 StatementExpression()
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 ";"
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
        break;
      case 5:
        // %05 SwitchStatement()
        ich.accept(this);
        break;
      case 6:
        // %06 IfStatement()
        ich.accept(this);
        break;
      case 7:
        // %07 WhileStatement()
        ich.accept(this);
        break;
      case 8:
        // %08 DoStatement()
        ich.accept(this);
        break;
      case 9:
        // %09 ForStatement()
        ich.accept(this);
        break;
      case 10:
        // %10 BreakStatement()
        ich.accept(this);
        break;
      case 11:
        // %11 ContinueStatement()
        ich.accept(this);
        break;
      case 12:
        // %12 ReturnStatement()
        ich.accept(this);
        break;
      case 13:
        // %13 ThrowStatement()
        ich.accept(this);
        break;
      case 14:
        // %14 SynchronizedStatement()
        ich.accept(this);
        break;
      case 15:
        // %15 TryStatement()
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link AssertStatement} node, whose children are the following :
   * <p>
   * f0 -> "assert"<br>
   * f1 -> Expression()<br>
   * f2 -> [ #0 ":" #1 Expression() ]<br>
   * f3 -> ";"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final AssertStatement n) {
    // f0 -> "assert"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> Expression()
    final Expression n1 = n.f1;
    n1.accept(this);
    // f2 -> [ #0 ":" #1 Expression() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      final NodeSequence seq = (NodeSequence) n2.node;
      // #0 ":"
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 Expression()
      final INode seq2 = seq.elementAt(1);
      seq2.accept(this);
    }
    // f3 -> ";"
    final NodeToken n3 = n.f3;
    n3.accept(this);
  }

  /**
   * Visits a {@link LabeledStatement} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> ":"<br>
   * f2 -> Statement()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final LabeledStatement n) {
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> ":"
    final NodeToken n1 = n.f1;
    n1.accept(this);
    // f2 -> Statement()
    final Statement n2 = n.f2;
    n2.accept(this);
  }

  /**
   * Visits a {@link Block} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( BlockStatement() )*<br>
   * f2 -> "}"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final Block n) {
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> ( BlockStatement() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        nloeai.accept(this);
      }
    }
    // f2 -> "}"
    final NodeToken n2 = n.f2;
    n2.accept(this);
  }

  /**
   * Visits a {@link BlockStatement} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 LocalVariableDeclaration() #1 ";"<br>
   * .. .. | %1 Statement()<br>
   * .. .. | %2 ClassOrInterfaceDeclaration()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final BlockStatement n) {
    // f0 -> . %0 #0 LocalVariableDeclaration() #1 ";"
    // .. .. | %1 Statement()
    // .. .. | %2 ClassOrInterfaceDeclaration()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 #0 LocalVariableDeclaration() #1 ";"
        final NodeSequence seq = (NodeSequence) ich;
        // #0 LocalVariableDeclaration()
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 ";"
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
        break;
      case 1:
        // %1 Statement()
        ich.accept(this);
        break;
      case 2:
        // %2 ClassOrInterfaceDeclaration()
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link LocalVariableDeclaration} node, whose children are the following :
   * <p>
   * f0 -> VariableModifiers()<br>
   * f1 -> Type()<br>
   * f2 -> VariableDeclarator()<br>
   * f3 -> ( #0 "," #1 VariableDeclarator() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final LocalVariableDeclaration n) {
    // f0 -> VariableModifiers()
    final VariableModifiers n0 = n.f0;
    n0.accept(this);
    // f1 -> Type()
    final Type n1 = n.f1;
    n1.accept(this);
    // f2 -> VariableDeclarator()
    final VariableDeclarator n2 = n.f2;
    n2.accept(this);
    // f3 -> ( #0 "," #1 VariableDeclarator() )*
    final NodeListOptional n3 = n.f3;
    if (n3.present()) {
      for (int i = 0; i < n3.size(); i++) {
        final INode nloeai = n3.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 ","
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 VariableDeclarator()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link VariableModifiers} node, whose child is the following :
   * <p>
   * f0 -> ( ( %0 "final"<br>
   * .. .. . | %1 Annotation() ) )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final VariableModifiers n) {
    // f0 -> ( ( %0 "final"
    // .. .. . | %1 Annotation() ) )*
    final NodeListOptional n0 = n.f0;
    if (n0.present()) {
      for (int i = 0; i < n0.size(); i++) {
        final INode nloeai = n0.elementAt(i);
        final NodeChoice nch = (NodeChoice) nloeai;
        final INode ich = nch.choice;
        switch (nch.which) {
          case 0:
            // %0 "final"
            ich.accept(this);
            break;
          case 1:
            // %1 Annotation()
            ich.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
      }
    }
  }

  /**
   * Visits a {@link EmptyStatement} node, whose child is the following :
   * <p>
   * f0 -> ";"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final EmptyStatement n) {
    // f0 -> ";"
    final NodeToken n0 = n.f0;
    n0.accept(this);
  }

  /**
   * Visits a {@link StatementExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 PreIncrementExpression()<br>
   * .. .. | %1 PreDecrementExpression()<br>
   * .. .. | %2 #0 PrimaryExpression()<br>
   * .. .. . .. #1 [ &0 "++"<br>
   * .. .. . .. .. | &1 "--"<br>
   * .. .. . .. .. | &2 $0 AssignmentOperator() $1 Expression() ]<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final StatementExpression n) {
    // f0 -> . %0 PreIncrementExpression()
    // .. .. | %1 PreDecrementExpression()
    // .. .. | %2 #0 PrimaryExpression()
    // .. .. . .. #1 [ &0 "++"
    // .. .. . .. .. | &1 "--"
    // .. .. . .. .. | &2 $0 AssignmentOperator() $1 Expression() ]
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 PreIncrementExpression()
        ich.accept(this);
        break;
      case 1:
        // %1 PreDecrementExpression()
        ich.accept(this);
        break;
      case 2:
        // %2 #0 PrimaryExpression()
        // .. #1 [ &0 "++"
        // .. .. | &1 "--"
        // .. .. | &2 $0 AssignmentOperator() $1 Expression() ]
        final NodeSequence seq = (NodeSequence) ich;
        // #0 PrimaryExpression()
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 [ &0 "++"
        // .. | &1 "--"
        // .. | &2 $0 AssignmentOperator() $1 Expression() ]
        final INode seq2 = seq.elementAt(1);
        final NodeOptional opt = (NodeOptional) seq2;
        if (opt.present()) {
          final NodeChoice nch1 = (NodeChoice) opt.node;
          final INode ich1 = nch1.choice;
          switch (nch1.which) {
            case 0:
              // &0 "++"
              ich1.accept(this);
              break;
            case 1:
              // &1 "--"
              ich1.accept(this);
              break;
            case 2:
              // &2 $0 AssignmentOperator() $1 Expression()
              final NodeSequence seq3 = (NodeSequence) ich1;
              // $0 AssignmentOperator()
              final INode seq4 = seq3.elementAt(0);
              seq4.accept(this);
              // $1 Expression()
              final INode seq5 = seq3.elementAt(1);
              seq5.accept(this);
              break;
            default:
              // should not occur !!!
              break;
          }
        }
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link SwitchStatement} node, whose children are the following :
   * <p>
   * f0 -> "switch"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> "{"<br>
   * f5 -> ( #0 SwitchLabel()<br>
   * .. .. . #1 ( BlockStatement() )* )*<br>
   * f6 -> "}"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final SwitchStatement n) {
    // f0 -> "switch"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> "("
    final NodeToken n1 = n.f1;
    n1.accept(this);
    // f2 -> Expression()
    final Expression n2 = n.f2;
    n2.accept(this);
    // f3 -> ")"
    final NodeToken n3 = n.f3;
    n3.accept(this);
    // f4 -> "{"
    final NodeToken n4 = n.f4;
    n4.accept(this);
    // f5 -> ( #0 SwitchLabel()
    // .. .. . #1 ( BlockStatement() )* )*
    final NodeListOptional n5 = n.f5;
    if (n5.present()) {
      for (int i = 0; i < n5.size(); i++) {
        final INode nloeai = n5.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 SwitchLabel()
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 ( BlockStatement() )*
        final INode seq2 = seq.elementAt(1);
        final NodeListOptional nlo = (NodeListOptional) seq2;
        if (nlo.present()) {
          for (int i1 = 0; i1 < nlo.size(); i1++) {
            final INode nloeai1 = nlo.elementAt(i1);
            nloeai1.accept(this);
          }
        }
      }
    }
    // f6 -> "}"
    final NodeToken n6 = n.f6;
    n6.accept(this);
  }

  /**
   * Visits a {@link SwitchLabel} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "case" #1 Expression() #2 ":"<br>
   * .. .. | %1 #0 "default" #1 ":"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final SwitchLabel n) {
    // f0 -> . %0 #0 "case" #1 Expression() #2 ":"
    // .. .. | %1 #0 "default" #1 ":"
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 #0 "case" #1 Expression() #2 ":"
        final NodeSequence seq = (NodeSequence) ich;
        // #0 "case"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 Expression()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
        // #2 ":"
        final INode seq3 = seq.elementAt(2);
        seq3.accept(this);
        break;
      case 1:
        // %1 #0 "default" #1 ":"
        final NodeSequence seq4 = (NodeSequence) ich;
        // #0 "default"
        final INode seq5 = seq4.elementAt(0);
        seq5.accept(this);
        // #1 ":"
        final INode seq6 = seq4.elementAt(1);
        seq6.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link IfStatement} node, whose children are the following :
   * <p>
   * f0 -> "if"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   * f5 -> [ #0 "else" #1 Statement() ]<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final IfStatement n) {
    // f0 -> "if"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> "("
    final NodeToken n1 = n.f1;
    n1.accept(this);
    // f2 -> Expression()
    final Expression n2 = n.f2;
    n2.accept(this);
    // f3 -> ")"
    final NodeToken n3 = n.f3;
    n3.accept(this);
    // f4 -> Statement()
    final Statement n4 = n.f4;
    n4.accept(this);
    // f5 -> [ #0 "else" #1 Statement() ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      final NodeSequence seq = (NodeSequence) n5.node;
      // #0 "else"
      final INode seq1 = seq.elementAt(0);
      seq1.accept(this);
      // #1 Statement()
      final INode seq2 = seq.elementAt(1);
      seq2.accept(this);
    }
  }

  /**
   * Visits a {@link WhileStatement} node, whose children are the following :
   * <p>
   * f0 -> "while"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final WhileStatement n) {
    // f0 -> "while"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> "("
    final NodeToken n1 = n.f1;
    n1.accept(this);
    // f2 -> Expression()
    final Expression n2 = n.f2;
    n2.accept(this);
    // f3 -> ")"
    final NodeToken n3 = n.f3;
    n3.accept(this);
    // f4 -> Statement()
    final Statement n4 = n.f4;
    n4.accept(this);
  }

  /**
   * Visits a {@link DoStatement} node, whose children are the following :
   * <p>
   * f0 -> "do"<br>
   * f1 -> Statement()<br>
   * f2 -> "while"<br>
   * f3 -> "("<br>
   * f4 -> Expression()<br>
   * f5 -> ")"<br>
   * f6 -> ";"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final DoStatement n) {
    // f0 -> "do"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> Statement()
    final Statement n1 = n.f1;
    n1.accept(this);
    // f2 -> "while"
    final NodeToken n2 = n.f2;
    n2.accept(this);
    // f3 -> "("
    final NodeToken n3 = n.f3;
    n3.accept(this);
    // f4 -> Expression()
    final Expression n4 = n.f4;
    n4.accept(this);
    // f5 -> ")"
    final NodeToken n5 = n.f5;
    n5.accept(this);
    // f6 -> ";"
    final NodeToken n6 = n.f6;
    n6.accept(this);
  }

  /**
   * Visits a {@link ForStatement} node, whose children are the following :
   * <p>
   * f0 -> "for"<br>
   * f1 -> "("<br>
   * f2 -> ( %0 #0 VariableModifiers() #1 Type() #2 <IDENTIFIER> #3 ":" #4 Expression()<br>
   * .. .. | %1 #0 [ ForInit() ]<br>
   * .. .. . .. #1 ";"<br>
   * .. .. . .. #2 [ Expression() ]<br>
   * .. .. . .. #3 ";"<br>
   * .. .. . .. #4 [ ForUpdate() ] )<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ForStatement n) {
    // f0 -> "for"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> "("
    final NodeToken n1 = n.f1;
    n1.accept(this);
    // f2 -> ( %0 #0 VariableModifiers() #1 Type() #2 <IDENTIFIER> #3 ":" #4 Expression()
    // .. .. | %1 #0 [ ForInit() ]
    // .. .. . .. #1 ";"
    // .. .. . .. #2 [ Expression() ]
    // .. .. . .. #3 ";"
    // .. .. . .. #4 [ ForUpdate() ] )
    final NodeChoice n2 = n.f2;
    final NodeChoice nch = n2;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 #0 VariableModifiers() #1 Type() #2 <IDENTIFIER> #3 ":" #4 Expression()
        final NodeSequence seq = (NodeSequence) ich;
        // #0 VariableModifiers()
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 Type()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
        // #2 <IDENTIFIER>
        final INode seq3 = seq.elementAt(2);
        seq3.accept(this);
        // #3 ":"
        final INode seq4 = seq.elementAt(3);
        seq4.accept(this);
        // #4 Expression()
        final INode seq5 = seq.elementAt(4);
        seq5.accept(this);
        break;
      case 1:
        // %1 #0 [ ForInit() ]
        // .. #1 ";"
        // .. #2 [ Expression() ]
        // .. #3 ";"
        // .. #4 [ ForUpdate() ]
        final NodeSequence seq6 = (NodeSequence) ich;
        // #0 [ ForInit() ]
        final INode seq7 = seq6.elementAt(0);
        final NodeOptional opt = (NodeOptional) seq7;
        if (opt.present()) {
          opt.accept(this);
        }
        // #1 ";"
        final INode seq8 = seq6.elementAt(1);
        seq8.accept(this);
        // #2 [ Expression() ]
        final INode seq9 = seq6.elementAt(2);
        final NodeOptional opt1 = (NodeOptional) seq9;
        if (opt1.present()) {
          opt1.accept(this);
        }
        // #3 ";"
        final INode seq10 = seq6.elementAt(3);
        seq10.accept(this);
        // #4 [ ForUpdate() ]
        final INode seq11 = seq6.elementAt(4);
        final NodeOptional opt2 = (NodeOptional) seq11;
        if (opt2.present()) {
          opt2.accept(this);
        }
        break;
      default:
        // should not occur !!!
        break;
    }
    // f3 -> ")"
    final NodeToken n3 = n.f3;
    n3.accept(this);
    // f4 -> Statement()
    final Statement n4 = n.f4;
    n4.accept(this);
  }

  /**
   * Visits a {@link ForInit} node, whose child is the following :
   * <p>
   * f0 -> . %0 LocalVariableDeclaration()<br>
   * .. .. | %1 StatementExpressionList()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ForInit n) {
    // f0 -> . %0 LocalVariableDeclaration()
    // .. .. | %1 StatementExpressionList()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 LocalVariableDeclaration()
        ich.accept(this);
        break;
      case 1:
        // %1 StatementExpressionList()
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link StatementExpressionList} node, whose children are the following :
   * <p>
   * f0 -> StatementExpression()<br>
   * f1 -> ( #0 "," #1 StatementExpression() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final StatementExpressionList n) {
    // f0 -> StatementExpression()
    final StatementExpression n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 "," #1 StatementExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 ","
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 StatementExpression()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link ForUpdate} node, whose child is the following :
   * <p>
   * f0 -> StatementExpressionList()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ForUpdate n) {
    // f0 -> StatementExpressionList()
    final StatementExpressionList n0 = n.f0;
    n0.accept(this);
  }

  /**
   * Visits a {@link BreakStatement} node, whose children are the following :
   * <p>
   * f0 -> "break"<br>
   * f1 -> [ <IDENTIFIER> ]<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final BreakStatement n) {
    // f0 -> "break"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> [ <IDENTIFIER> ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this);
    }
    // f2 -> ";"
    final NodeToken n2 = n.f2;
    n2.accept(this);
  }

  /**
   * Visits a {@link ContinueStatement} node, whose children are the following :
   * <p>
   * f0 -> "continue"<br>
   * f1 -> [ <IDENTIFIER> ]<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ContinueStatement n) {
    // f0 -> "continue"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> [ <IDENTIFIER> ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this);
    }
    // f2 -> ";"
    final NodeToken n2 = n.f2;
    n2.accept(this);
  }

  /**
   * Visits a {@link ReturnStatement} node, whose children are the following :
   * <p>
   * f0 -> "return"<br>
   * f1 -> [ Expression() ]<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ReturnStatement n) {
    // f0 -> "return"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> [ Expression() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this);
    }
    // f2 -> ";"
    final NodeToken n2 = n.f2;
    n2.accept(this);
  }

  /**
   * Visits a {@link ThrowStatement} node, whose children are the following :
   * <p>
   * f0 -> "throw"<br>
   * f1 -> Expression()<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final ThrowStatement n) {
    // f0 -> "throw"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> Expression()
    final Expression n1 = n.f1;
    n1.accept(this);
    // f2 -> ";"
    final NodeToken n2 = n.f2;
    n2.accept(this);
  }

  /**
   * Visits a {@link SynchronizedStatement} node, whose children are the following :
   * <p>
   * f0 -> "synchronized"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Block()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final SynchronizedStatement n) {
    // f0 -> "synchronized"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> "("
    final NodeToken n1 = n.f1;
    n1.accept(this);
    // f2 -> Expression()
    final Expression n2 = n.f2;
    n2.accept(this);
    // f3 -> ")"
    final NodeToken n3 = n.f3;
    n3.accept(this);
    // f4 -> Block()
    final Block n4 = n.f4;
    n4.accept(this);
  }

  /**
   * Visits a {@link TryStatement} node, whose children are the following :
   * <p>
   * f0 -> "try"<br>
   * f1 -> Block()<br>
   * f2 -> ( #0 "catch" #1 "(" #2 FormalParameter() #3 ")" #4 Block() )*<br>
   * f3 -> [ #0 "finally" #1 Block() ]<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final TryStatement n) {
    // f0 -> "try"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> Block()
    final Block n1 = n.f1;
    n1.accept(this);
    // f2 -> ( #0 "catch" #1 "(" #2 FormalParameter() #3 ")" #4 Block() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 "catch"
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 "("
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
        // #2 FormalParameter()
        final INode seq3 = seq.elementAt(2);
        seq3.accept(this);
        // #3 ")"
        final INode seq4 = seq.elementAt(3);
        seq4.accept(this);
        // #4 Block()
        final INode seq5 = seq.elementAt(4);
        seq5.accept(this);
      }
    }
    // f3 -> [ #0 "finally" #1 Block() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence seq6 = (NodeSequence) n3.node;
      // #0 "finally"
      final INode seq7 = seq6.elementAt(0);
      seq7.accept(this);
      // #1 Block()
      final INode seq8 = seq6.elementAt(1);
      seq8.accept(this);
    }
  }

  /**
   * Visits a {@link Annotation} node, whose child is the following :
   * <p>
   * f0 -> . %0 NormalAnnotation()<br>
   * .. .. | %1 SingleMemberAnnotation()<br>
   * .. .. | %2 MarkerAnnotation()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final Annotation n) {
    // f0 -> . %0 NormalAnnotation()
    // .. .. | %1 SingleMemberAnnotation()
    // .. .. | %2 MarkerAnnotation()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 NormalAnnotation()
        ich.accept(this);
        break;
      case 1:
        // %1 SingleMemberAnnotation()
        ich.accept(this);
        break;
      case 2:
        // %2 MarkerAnnotation()
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link NormalAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   * f2 -> "("<br>
   * f3 -> [ MemberValuePairs() ]<br>
   * f4 -> ")"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final NormalAnnotation n) {
    // f0 -> "@"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> Name()
    final Name n1 = n.f1;
    n1.accept(this);
    // f2 -> "("
    final NodeToken n2 = n.f2;
    n2.accept(this);
    // f3 -> [ MemberValuePairs() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      n3.accept(this);
    }
    // f4 -> ")"
    final NodeToken n4 = n.f4;
    n4.accept(this);
  }

  /**
   * Visits a {@link MarkerAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final MarkerAnnotation n) {
    // f0 -> "@"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> Name()
    final Name n1 = n.f1;
    n1.accept(this);
  }

  /**
   * Visits a {@link SingleMemberAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   * f2 -> "("<br>
   * f3 -> MemberValue()<br>
   * f4 -> ")"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final SingleMemberAnnotation n) {
    // f0 -> "@"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> Name()
    final Name n1 = n.f1;
    n1.accept(this);
    // f2 -> "("
    final NodeToken n2 = n.f2;
    n2.accept(this);
    // f3 -> MemberValue()
    final MemberValue n3 = n.f3;
    n3.accept(this);
    // f4 -> ")"
    final NodeToken n4 = n.f4;
    n4.accept(this);
  }

  /**
   * Visits a {@link MemberValuePairs} node, whose children are the following :
   * <p>
   * f0 -> MemberValuePair()<br>
   * f1 -> ( #0 "," #1 MemberValuePair() )*<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final MemberValuePairs n) {
    // f0 -> MemberValuePair()
    final MemberValuePair n0 = n.f0;
    n0.accept(this);
    // f1 -> ( #0 "," #1 MemberValuePair() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 ","
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 MemberValuePair()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
  }

  /**
   * Visits a {@link MemberValuePair} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> "="<br>
   * f2 -> MemberValue()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final MemberValuePair n) {
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> "="
    final NodeToken n1 = n.f1;
    n1.accept(this);
    // f2 -> MemberValue()
    final MemberValue n2 = n.f2;
    n2.accept(this);
  }

  /**
   * Visits a {@link MemberValue} node, whose child is the following :
   * <p>
   * f0 -> . %0 Annotation()<br>
   * .. .. | %1 MemberValueArrayInitializer()<br>
   * .. .. | %2 ConditionalExpression()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final MemberValue n) {
    // f0 -> . %0 Annotation()
    // .. .. | %1 MemberValueArrayInitializer()
    // .. .. | %2 ConditionalExpression()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 Annotation()
        ich.accept(this);
        break;
      case 1:
        // %1 MemberValueArrayInitializer()
        ich.accept(this);
        break;
      case 2:
        // %2 ConditionalExpression()
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link MemberValueArrayInitializer} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> MemberValue()<br>
   * f2 -> ( #0 "," #1 MemberValue() )*<br>
   * f3 -> [ "," ]<br>
   * f4 -> "}"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final MemberValueArrayInitializer n) {
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> MemberValue()
    final MemberValue n1 = n.f1;
    n1.accept(this);
    // f2 -> ( #0 "," #1 MemberValue() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        // #0 ","
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 MemberValue()
        final INode seq2 = seq.elementAt(1);
        seq2.accept(this);
      }
    }
    // f3 -> [ "," ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      n3.accept(this);
    }
    // f4 -> "}"
    final NodeToken n4 = n.f4;
    n4.accept(this);
  }

  /**
   * Visits a {@link AnnotationTypeDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> "interface"<br>
   * f2 -> <IDENTIFIER><br>
   * f3 -> AnnotationTypeBody()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final AnnotationTypeDeclaration n) {
    // f0 -> "@"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> "interface"
    final NodeToken n1 = n.f1;
    n1.accept(this);
    // f2 -> <IDENTIFIER>
    final NodeToken n2 = n.f2;
    n2.accept(this);
    // f3 -> AnnotationTypeBody()
    final AnnotationTypeBody n3 = n.f3;
    n3.accept(this);
  }

  /**
   * Visits a {@link AnnotationTypeBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( AnnotationTypeMemberDeclaration() )*<br>
   * f2 -> "}"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final AnnotationTypeBody n) {
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> ( AnnotationTypeMemberDeclaration() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        nloeai.accept(this);
      }
    }
    // f2 -> "}"
    final NodeToken n2 = n.f2;
    n2.accept(this);
  }

  /**
   * Visits a {@link AnnotationTypeMemberDeclaration} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 $0 Type() $1 <IDENTIFIER> $2 "(" $3 ")"<br>
   * .. .. . .. .. . .. $4 [ DefaultValue() ]<br>
   * .. .. . .. .. . .. $5 ";"<br>
   * .. .. . .. .. | &1 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &2 EnumDeclaration()<br>
   * .. .. . .. .. | &3 AnnotationTypeDeclaration()<br>
   * .. .. . .. .. | &4 FieldDeclaration() )<br>
   * .. .. | %1 ";"<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final AnnotationTypeMemberDeclaration n) {
    // f0 -> . %0 #0 Modifiers()
    // .. .. . .. #1 ( &0 $0 Type() $1 <IDENTIFIER> $2 "(" $3 ")"
    // .. .. . .. .. . .. $4 [ DefaultValue() ]
    // .. .. . .. .. . .. $5 ";"
    // .. .. . .. .. | &1 ClassOrInterfaceDeclaration()
    // .. .. . .. .. | &2 EnumDeclaration()
    // .. .. . .. .. | &3 AnnotationTypeDeclaration()
    // .. .. . .. .. | &4 FieldDeclaration() )
    // .. .. | %1 ";"
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        // %0 #0 Modifiers()
        // .. #1 ( &0 $0 Type() $1 <IDENTIFIER> $2 "(" $3 ")"
        // .. .. .. $4 [ DefaultValue() ]
        // .. .. .. $5 ";"
        // .. .. | &1 ClassOrInterfaceDeclaration()
        // .. .. | &2 EnumDeclaration()
        // .. .. | &3 AnnotationTypeDeclaration()
        // .. .. | &4 FieldDeclaration() )
        final NodeSequence seq = (NodeSequence) ich;
        // #0 Modifiers()
        final INode seq1 = seq.elementAt(0);
        seq1.accept(this);
        // #1 ( &0 $0 Type() $1 <IDENTIFIER> $2 "(" $3 ")"
        // .. .. $4 [ DefaultValue() ]
        // .. .. $5 ";"
        // .. | &1 ClassOrInterfaceDeclaration()
        // .. | &2 EnumDeclaration()
        // .. | &3 AnnotationTypeDeclaration()
        // .. | &4 FieldDeclaration() )
        final INode seq2 = seq.elementAt(1);
        final NodeChoice nch1 = (NodeChoice) seq2;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            // &0 $0 Type() $1 <IDENTIFIER> $2 "(" $3 ")"
            // .. $4 [ DefaultValue() ]
            // .. $5 ";"
            final NodeSequence seq3 = (NodeSequence) ich1;
            // $0 Type()
            final INode seq4 = seq3.elementAt(0);
            seq4.accept(this);
            // $1 <IDENTIFIER>
            final INode seq5 = seq3.elementAt(1);
            seq5.accept(this);
            // $2 "("
            final INode seq6 = seq3.elementAt(2);
            seq6.accept(this);
            // $3 ")"
            final INode seq7 = seq3.elementAt(3);
            seq7.accept(this);
            // $4 [ DefaultValue() ]
            final INode seq8 = seq3.elementAt(4);
            final NodeOptional opt = (NodeOptional) seq8;
            if (opt.present()) {
              opt.accept(this);
            }
            // $5 ";"
            final INode seq9 = seq3.elementAt(5);
            seq9.accept(this);
            break;
          case 1:
            // &1 ClassOrInterfaceDeclaration()
            ich1.accept(this);
            break;
          case 2:
            // &2 EnumDeclaration()
            ich1.accept(this);
            break;
          case 3:
            // &3 AnnotationTypeDeclaration()
            ich1.accept(this);
            break;
          case 4:
            // &4 FieldDeclaration()
            ich1.accept(this);
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      case 1:
        // %1 ";"
        ich.accept(this);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link DefaultValue} node, whose children are the following :
   * <p>
   * f0 -> "default"<br>
   * f1 -> MemberValue()<br>
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final DefaultValue n) {
    // f0 -> "default"
    final NodeToken n0 = n.f0;
    n0.accept(this);
    // f1 -> MemberValue()
    final MemberValue n1 = n.f1;
    n1.accept(this);
  }

}
