/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.security.UserGroupInformation;

public class JobSubmissionFiles {
    public static final FsPermission JOB_DIR_PERMISSION = FsPermission.createImmutable((short)448);
    public static final FsPermission JOB_FILE_PERMISSION = FsPermission.createImmutable((short)420);

    public static Path getJobSplitFile(Path jobSubmissionDir) {
        return new Path(jobSubmissionDir, "job.split");
    }

    public static Path getJobSplitMetaFile(Path jobSubmissionDir) {
        return new Path(jobSubmissionDir, "job.splitmetainfo");
    }

    public static Path getJobConfPath(Path jobSubmitDir) {
        return new Path(jobSubmitDir, "job.xml");
    }

    public static Path getJobJar(Path jobSubmitDir) {
        return new Path(jobSubmitDir, "job.jar");
    }

    public static Path getJobDistCacheFiles(Path jobSubmitDir) {
        return new Path(jobSubmitDir, "files");
    }

    public static Path getJobDistCacheArchives(Path jobSubmitDir) {
        return new Path(jobSubmitDir, "archives");
    }

    public static Path getJobDistCacheLibjars(Path jobSubmitDir) {
        return new Path(jobSubmitDir, "libjars");
    }

    public static Path getStagingDir(JobClient client, Configuration conf) throws IOException, InterruptedException {
        Path stagingArea = client.getStagingAreaDir();
        FileSystem fs = stagingArea.getFileSystem(conf);
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        String realUser = ugi.getShortUserName();
        String currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
        if (fs.exists(stagingArea)) {
            FileStatus fsStatus = fs.getFileStatus(stagingArea);
            String owner = fsStatus.getOwner();
            if (!owner.equals(currentUser) && !owner.equals(realUser) || !fsStatus.getPermission().equals(JOB_DIR_PERMISSION)) {
                throw new IOException("The ownership/permissions on the staging directory " + stagingArea + " is not as expected. " + "It is owned by " + owner + " and permissions are " + fsStatus.getPermission() + ". The directory must " + "be owned by the submitter " + currentUser + " or " + "by " + realUser + " and permissions must be rwx------");
            }
        } else {
            fs.mkdirs(stagingArea, new FsPermission(JOB_DIR_PERMISSION));
        }
        return stagingArea;
    }
}

