#ifndef _KDC_H
#define _KDC_H

/* Class used to read tags and image data from .kdc files.
 * 
 * Written by:  Chris Studholme
 * Last Update: 7-July-1999
 * Copyright:   GPL (http://www.fsf.org/copyleft/gpl.html)
 */

#include <tiffio.h>

class KDCFile {

 public:

  /* main directory */
  /* standard tags */
  const char* DateTime;
  const char* ImageDescription;
  const char* Make;
  const char* Model;
  const char* Software;

  /* Kodak specific tags */
  const char* Copyright;   // 33432
  const char* T33423;
  const char* T36867;

  /*
    33424 (0x8290) LONG (4) 1<1002>
    33434 (0x829a) RATIONAL (5) 1<0.01069>
    33437 (0x829d) RATIONAL (5) 1<2.5>
    34850 (0x8822) SHORT (3) 1<2>
    34859 (0x882b) SHORT (3) 1<0>
    37382 (0x9206) RATIONAL (5) 1<0.7>
    37385 (0x9209) SHORT (3) 1<31>
    37386 (0x920a) RATIONAL (5) 1<100>
    37393 (0x9211) SHORT (3) 1<1>
    37398 (0x9216) BYTE (1) 4<00 00 00 0x1>
    37399 (0x9217) SHORT (3) 1<2>
  */

  /* sub directory */
  /*
    33421 (0x828d) SHORT (3) 2<2 2>
    33422 (0x828e) BYTE (1) 4<0x1 0x2 00 0x1>
    37122 (0x9102) RATIONAL (5) 1<0.75>
    37400 (0x9218) SRATIONAL (10) 12<0 -2.02926 1.04202 -0.824892 0 
                         -1.4279 5.95526 -0.572662 0 -0
  */

 protected:
  TIFF* kdcimage;

  static const unsigned int width = 848;
  static const unsigned int height = 976;
  
 public:
  KDCFile(const char* filename);
  ~KDCFile();

  bool isOK() {
    return (kdcimage!=0);
  }

  bool ReadKDCFile(unsigned char* dest);

  unsigned int getWidth() {
    return width;
  }

  unsigned int getHeight() {
    return height;
  }

  /* Current measurements are:
   *   1.56691
   *   1.56554
   * Camera specs say:
   *   1.56 (7.8um by 5.0um)
   */
  double getPixelAspect() {
    return 1.56;
  }

 protected:
  
  bool ReadUncompressedData(unsigned char* dest);
  void FixScanline(unsigned char* dest, const unsigned char* src, int row);

  bool ReadCompressedData(unsigned char* dest);
  bool UncompressJPEG(unsigned char* dest, const unsigned char* src,
		      int srcsize);

};

#endif
