/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.resolve;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/resolve/additionalLazyResolve")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class AdditionalResolveDescriptorRendererTestGenerated extends AbstractAdditionalResolveDescriptorRendererTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInAdditionalLazyResolve() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/resolve/additionalLazyResolve"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("anonymousObjectInBaseConstructor.kt")
    public void testAnonymousObjectInBaseConstructor() throws Exception {
        runTest("idea/testData/resolve/additionalLazyResolve/anonymousObjectInBaseConstructor.kt");
    }

    @TestMetadata("anonymousObjectInClassInitializer.kt")
    public void testAnonymousObjectInClassInitializer() throws Exception {
        runTest("idea/testData/resolve/additionalLazyResolve/anonymousObjectInClassInitializer.kt");
    }

    @TestMetadata("anonymousObjectInClassParameterInitializer.kt")
    public void testAnonymousObjectInClassParameterInitializer() throws Exception {
        runTest("idea/testData/resolve/additionalLazyResolve/anonymousObjectInClassParameterInitializer.kt");
    }

    @TestMetadata("functionLiteralInBaseConstructor.kt")
    public void testFunctionLiteralInBaseConstructor() throws Exception {
        runTest("idea/testData/resolve/additionalLazyResolve/functionLiteralInBaseConstructor.kt");
    }

    @TestMetadata("localClassInClassInitializer.kt")
    public void testLocalClassInClassInitializer() throws Exception {
        runTest("idea/testData/resolve/additionalLazyResolve/localClassInClassInitializer.kt");
    }

    @TestMetadata("localClassInClosureInClassParameterInitializer.kt")
    public void testLocalClassInClosureInClassParameterInitializer() throws Exception {
        runTest("idea/testData/resolve/additionalLazyResolve/localClassInClosureInClassParameterInitializer.kt");
    }

    @TestMetadata("localObjectInClassInitializer.kt")
    public void testLocalObjectInClassInitializer() throws Exception {
        runTest("idea/testData/resolve/additionalLazyResolve/localObjectInClassInitializer.kt");
    }

    @TestMetadata("localObjectInClosureInClassParameterInitializer.kt")
    public void testLocalObjectInClosureInClassParameterInitializer() throws Exception {
        runTest("idea/testData/resolve/additionalLazyResolve/localObjectInClosureInClassParameterInitializer.kt");
    }
}
