#!/bin/bash

KS_BUILD=`date +%Y%m%d`
KS_FILE_VERSION=`sed 1!d tools/VERSION`
KS_FULL_VERSION=`sed 2!d tools/VERSION`

cat > "kshutdown.nsh" <<EOF
# Generated by $0, do not modify!
!define APP_FILE_VERSION "$KS_FILE_VERSION"
!define APP_FULL_VERSION "$KS_FULL_VERSION"
EOF

cat > "src/version.h" <<EOF
// Generated by $0, do not modify!
#ifndef KSHUTDOWN_VERSION_H
#define KSHUTDOWN_VERSION_H

#define KS_BUILD "$KS_BUILD"
#define KS_FILE_VERSION "$KS_FILE_VERSION"
#define KS_FULL_VERSION "$KS_FULL_VERSION"

#endif // KSHUTDOWN_VERSION_H
EOF