/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "addnetworkroutedialog.h"
#include "widgetnotifyhelper.h"

AddNetworkRouteDialog::AddNetworkRouteDialog(QWidget *parent, const QString& caption) : KDialog(parent)
{
    Q_UNUSED(caption);

    QWidget *page = new QWidget(this);
    setMainWidget(page);
    setupUi(page);
//  setMainWidget(this);
    sizeHint();
    connect(UseGatewayCheckBox, SIGNAL(toggled(bool)), this, SLOT(useGatewayToggled(bool)));
    connect(UseInterfaceCheckBox, SIGNAL(toggled(bool)), this, SLOT(useInterfaceToggled(bool)));
    WidgetNotifyHelper h;
    h.setupChangedAction(this);
    dialogModified = false;
    Network = "";
    Netmask = "";
    Gateway = "";
    Interface = "";
    useGateway = false;
    useInterface = false;
}


AddNetworkRouteDialog::~AddNetworkRouteDialog()
{ }

void AddNetworkRouteDialog::accept()
{
    Network = RemoteNetAddrLineEdit->text();
    Netmask = RemoteNetMaskComboBox->currentText();
    Gateway = RemoteGatewayAddrLineEdit->text();
    Interface = InterfaceComboBox->currentText();
    useGateway = UseGatewayCheckBox->isChecked();
    useInterface = UseInterfaceCheckBox->isChecked();
    QDialog::accept();
}

QString AddNetworkRouteDialog::getNetwork()
{
    return Network;
}

QString AddNetworkRouteDialog::getNetmask()
{
    return Netmask;
}

QString AddNetworkRouteDialog::getGateway()
{
    return Gateway;
}

QString AddNetworkRouteDialog::getInterface()
{
    return Interface;
}


bool AddNetworkRouteDialog::getUseGateway()
{
    return useGateway;
}

bool AddNetworkRouteDialog::getUseInterface()
{
    return useInterface;
}


void AddNetworkRouteDialog::useGatewayToggled(bool)
{
    if (UseGatewayCheckBox->isChecked())
        RemoteGatewayAddrLineEdit->setEnabled(true);
    else
        RemoteGatewayAddrLineEdit->setEnabled(false);
}

void AddNetworkRouteDialog::useInterfaceToggled(bool)
{
    if (UseInterfaceCheckBox->isChecked())
        InterfaceComboBox->setEnabled(true);
    else
        InterfaceComboBox->setEnabled(false);
}

void AddNetworkRouteDialog::dialogChanged()
{
    dialogModified = true;
}

#include "addnetworkroutedialog.moc"
