/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.classpath;

import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.classpath.ClasspathEntry;
import com.sun.tdk.signaturetest.model.ExoticCharTools;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;

class DirectoryEntry
extends ClasspathEntry {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$tdk$signaturetest$classpath$DirectoryEntry == null ? (class$com$sun$tdk$signaturetest$classpath$DirectoryEntry = DirectoryEntry.class$("com.sun.tdk.signaturetest.classpath.DirectoryEntry")) : class$com$sun$tdk$signaturetest$classpath$DirectoryEntry);
    private String directoryName = "";
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$classpath$DirectoryEntry;

    public DirectoryEntry(ClasspathEntry previous, String name) throws IOException {
        super(previous);
        this.init(name);
    }

    public void init(String directoryName) throws IOException {
        File directory = new File(directoryName);
        if (!directory.isDirectory()) {
            throw new IOException(i18n.getString("DirectoryEntry.error.invdir", directoryName));
        }
        this.directoryName = directoryName;
        this.classes = new LinkedHashSet();
        this.scanDirectory(directory, "");
        this.currentPosition = this.classes.iterator();
    }

    public void close() {
    }

    private void scanDirectory(File directory, String packageName) {
        block10: {
            int pos;
            int startPos = 0;
            int depth = 0;
            do {
                if ((pos = packageName.indexOf(46, startPos)) != -1) {
                    ++depth;
                    startPos = pos + 1;
                }
                if (depth <= 512) continue;
                return;
            } while (pos != -1);
            try {
                String[] files = directory.list();
                if (files == null) {
                    return;
                }
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < files.length) {
                    String namePrefix;
                    File current = new File(directory, files[i]);
                    String string = namePrefix = packageName.equals("") ? "" : packageName + ".";
                    if (current.isDirectory()) {
                        this.scanDirectory(current, namePrefix + files[i]);
                    } else if (files[i].endsWith(".class")) {
                        buf.setLength(0);
                        buf.append(namePrefix);
                        buf.append(files[i].substring(0, files[i].length() - ClasspathEntry.JAVA_CLASSFILE_EXTENSION_LEN));
                        String className = buf.toString();
                        if (!this.contains(className)) {
                            this.classes.add(className.intern());
                        }
                    }
                    ++i;
                }
            }
            catch (SecurityException e) {
                if (!SigTest.debug) break block10;
                e.printStackTrace();
            }
        }
    }

    public InputStream findClass(String name) throws IOException, ClassNotFoundException {
        if (!this.classes.contains(name)) {
            throw new ClassNotFoundException(name);
        }
        name = ExoticCharTools.decodeExotic(name);
        return new FileInputStream(new File(this.constructFileName(name)));
    }

    private String constructFileName(String name) {
        StringBuffer buf = new StringBuffer(256);
        buf.append(this.directoryName);
        buf.append(File.separator);
        buf.append(name.replace('.', File.separatorChar));
        buf.append(".class");
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

