/* config.c generated by valac 0.10.4, the Vala compiler
 * generated from config.vala, do not modify */

/*
 * Interface for the configuration implementations.
 *
 * Copyright (C) 2008, 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libdesktop-agnostic/desktop-agnostic.h>


#define DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND (desktop_agnostic_config_backend_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND, DesktopAgnosticConfigBackend))
#define DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND, DesktopAgnosticConfigBackendClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND))
#define DESKTOP_AGNOSTIC_CONFIG_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND))
#define DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND, DesktopAgnosticConfigBackendClass))

typedef struct _DesktopAgnosticConfigBackend DesktopAgnosticConfigBackend;
typedef struct _DesktopAgnosticConfigBackendClass DesktopAgnosticConfigBackendClass;
typedef struct _DesktopAgnosticConfigBackendPrivate DesktopAgnosticConfigBackendPrivate;

#define DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA (desktop_agnostic_config_schema_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA, DesktopAgnosticConfigSchema))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA, DesktopAgnosticConfigSchemaClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA, DesktopAgnosticConfigSchemaClass))

typedef struct _DesktopAgnosticConfigSchema DesktopAgnosticConfigSchema;
typedef struct _DesktopAgnosticConfigSchemaClass DesktopAgnosticConfigSchemaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION (desktop_agnostic_config_schema_option_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION, DesktopAgnosticConfigSchemaOption))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION, DesktopAgnosticConfigSchemaOptionClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION, DesktopAgnosticConfigSchemaOptionClass))

typedef struct _DesktopAgnosticConfigSchemaOption DesktopAgnosticConfigSchemaOption;
typedef struct _DesktopAgnosticConfigSchemaOptionClass DesktopAgnosticConfigSchemaOptionClass;

#define DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE (desktop_agnostic_config_schema_type_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE, DesktopAgnosticConfigSchemaType))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE, DesktopAgnosticConfigSchemaTypeClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE, DesktopAgnosticConfigSchemaTypeClass))

typedef struct _DesktopAgnosticConfigSchemaType DesktopAgnosticConfigSchemaType;
typedef struct _DesktopAgnosticConfigSchemaTypeClass DesktopAgnosticConfigSchemaTypeClass;

/**
   * Errors which occur when setting/retrieving configuration options.
   */
typedef enum  {
	DESKTOP_AGNOSTIC_CONFIG_ERROR_NO_SCHEMA,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_INVALID_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_KEY_NOT_FOUND,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_METADATA_NOT_FOUND,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_NOTIFY,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_DUPLICATE_BINDING
} DesktopAgnosticConfigError;
#define DESKTOP_AGNOSTIC_CONFIG_ERROR desktop_agnostic_config_error_quark ()
typedef void (*DesktopAgnosticConfigNotifyFunc) (const char* group, const char* key, GValue* value, void* user_data);
struct _DesktopAgnosticConfigBackend {
	GObject parent_instance;
	DesktopAgnosticConfigBackendPrivate * priv;
};

struct _DesktopAgnosticConfigBackendClass {
	GObjectClass parent_class;
	void (*reset) (DesktopAgnosticConfigBackend* self, GError** error);
	void (*remove) (DesktopAgnosticConfigBackend* self, GError** error);
	void (*notify_add) (DesktopAgnosticConfigBackend* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error);
	void (*notify) (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
	void (*notify_remove) (DesktopAgnosticConfigBackend* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error);
	void (*get_value) (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValue* result, GError** error);
	void (*set_value) (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValue* value, GError** error);
	gboolean (*get_bool) (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
	void (*set_bool) (DesktopAgnosticConfigBackend* self, const char* group, const char* key, gboolean value, GError** error);
	float (*get_float) (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
	void (*set_float) (DesktopAgnosticConfigBackend* self, const char* group, const char* key, float value, GError** error);
	gint (*get_int) (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
	void (*set_int) (DesktopAgnosticConfigBackend* self, const char* group, const char* key, gint value, GError** error);
	char* (*get_string) (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
	void (*set_string) (DesktopAgnosticConfigBackend* self, const char* group, const char* key, const char* value, GError** error);
	GValueArray* (*get_list) (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
	void (*set_list) (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValueArray* value, GError** error);
	char* (*get_name) (DesktopAgnosticConfigBackend* self);
};

struct _DesktopAgnosticConfigBackendPrivate {
	DesktopAgnosticConfigSchema* _schema;
	char* _instance_id;
};

typedef enum  {
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_PARSE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_METADATA_OPTION,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_METADATA_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_LIST_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_TYPE_NAME_EXISTS,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_TYPE_GTYPE_EXISTS
} DesktopAgnosticConfigSchemaError;
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR desktop_agnostic_config_schema_error_quark ()

static GHashTable* desktop_agnostic_config_backend__backend_metadata_keys;
static GHashTable* desktop_agnostic_config_backend__backend_metadata_keys = NULL;
static gpointer desktop_agnostic_config_backend_parent_class = NULL;
extern GType* desktop_agnostic_config_module_type;
GType* desktop_agnostic_config_module_type = NULL;

GQuark desktop_agnostic_config_error_quark (void);
#define DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT "DEFAULT"
GType desktop_agnostic_config_backend_get_type (void) G_GNUC_CONST;
GType desktop_agnostic_config_schema_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND, DesktopAgnosticConfigBackendPrivate))
enum  {
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_NAME,
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_SCHEMA,
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_INSTANCE_ID
};
GHashTable* desktop_agnostic_config_backend_get_backend_metadata_keys (void);
static void _vala_GValue_free (GValue* self);
void desktop_agnostic_config_backend_reset (DesktopAgnosticConfigBackend* self, GError** error);
static void desktop_agnostic_config_backend_real_reset (DesktopAgnosticConfigBackend* self, GError** error);
void desktop_agnostic_config_backend_remove (DesktopAgnosticConfigBackend* self, GError** error);
static void desktop_agnostic_config_backend_real_remove (DesktopAgnosticConfigBackend* self, GError** error);
void desktop_agnostic_config_backend_notify_add (DesktopAgnosticConfigBackend* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error);
static void desktop_agnostic_config_backend_real_notify_add (DesktopAgnosticConfigBackend* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error);
void desktop_agnostic_config_backend_notify (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_backend_real_notify (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
void desktop_agnostic_config_backend_notify_remove (DesktopAgnosticConfigBackend* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error);
static void desktop_agnostic_config_backend_real_notify_remove (DesktopAgnosticConfigBackend* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error);
void desktop_agnostic_config_backend_get_value (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValue* result, GError** error);
static void desktop_agnostic_config_backend_real_get_value (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValue* result, GError** error);
void desktop_agnostic_config_backend_set_value (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValue* value, GError** error);
static void desktop_agnostic_config_backend_real_set_value (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValue* value, GError** error);
GType desktop_agnostic_config_schema_option_get_type (void) G_GNUC_CONST;
DesktopAgnosticConfigSchemaOption* desktop_agnostic_config_schema_get_option (DesktopAgnosticConfigSchema* self, const char* group, const char* key);
GType desktop_agnostic_config_schema_option_get_option_type (DesktopAgnosticConfigSchemaOption* self);
void desktop_agnostic_config_backend_set_bool (DesktopAgnosticConfigBackend* self, const char* group, const char* key, gboolean value, GError** error);
float desktop_agnostic_config_backend_get_float_from_value (GValue* value, GError** error);
void desktop_agnostic_config_backend_set_float (DesktopAgnosticConfigBackend* self, const char* group, const char* key, float value, GError** error);
gint desktop_agnostic_config_backend_get_int_from_value (GValue* value, GError** error);
void desktop_agnostic_config_backend_set_int (DesktopAgnosticConfigBackend* self, const char* group, const char* key, gint value, GError** error);
void desktop_agnostic_config_backend_set_string (DesktopAgnosticConfigBackend* self, const char* group, const char* key, const char* value, GError** error);
void desktop_agnostic_config_backend_set_list (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValueArray* value, GError** error);
DesktopAgnosticConfigSchema* desktop_agnostic_config_backend_get_schema (DesktopAgnosticConfigBackend* self);
GType desktop_agnostic_config_schema_type_get_type (void) G_GNUC_CONST;
DesktopAgnosticConfigSchemaType* desktop_agnostic_config_schema_find_type (GType type);
GQuark desktop_agnostic_config_schema_error_quark (void);
char* desktop_agnostic_config_schema_type_serialize (DesktopAgnosticConfigSchemaType* self, GValue* val, GError** error);
gboolean desktop_agnostic_config_backend_get_bool (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
static gboolean desktop_agnostic_config_backend_real_get_bool (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_backend_real_set_bool (DesktopAgnosticConfigBackend* self, const char* group, const char* key, gboolean value, GError** error);
float desktop_agnostic_config_backend_get_float (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
static float desktop_agnostic_config_backend_real_get_float (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_backend_real_set_float (DesktopAgnosticConfigBackend* self, const char* group, const char* key, float value, GError** error);
gint desktop_agnostic_config_backend_get_int (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
static gint desktop_agnostic_config_backend_real_get_int (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_backend_real_set_int (DesktopAgnosticConfigBackend* self, const char* group, const char* key, gint value, GError** error);
char* desktop_agnostic_config_backend_get_string (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
static char* desktop_agnostic_config_backend_real_get_string (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_backend_real_set_string (DesktopAgnosticConfigBackend* self, const char* group, const char* key, const char* value, GError** error);
GValueArray* desktop_agnostic_config_backend_get_list (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
static GValueArray* desktop_agnostic_config_backend_real_get_list (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_backend_real_set_list (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValueArray* value, GError** error);
DesktopAgnosticConfigBackend* desktop_agnostic_config_backend_construct (GType object_type);
char* desktop_agnostic_config_backend_get_name (DesktopAgnosticConfigBackend* self);
static void desktop_agnostic_config_backend_set_schema (DesktopAgnosticConfigBackend* self, DesktopAgnosticConfigSchema* value);
const char* desktop_agnostic_config_backend_get_instance_id (DesktopAgnosticConfigBackend* self);
static void desktop_agnostic_config_backend_set_instance_id (DesktopAgnosticConfigBackend* self, const char* value);
static void desktop_agnostic_config_backend_finalize (GObject* obj);
static void desktop_agnostic_config_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_config_backend_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType desktop_agnostic_config_get_type (GError** error);
static GType* _g_type_dup (GType* self);
DesktopAgnosticConfigBackend* desktop_agnostic_config_new (DesktopAgnosticConfigSchema* schema, GError** error);
DesktopAgnosticConfigBackend* desktop_agnostic_config_new_for_instance (const char* instance_id, DesktopAgnosticConfigSchema* schema, GError** error);



GQuark desktop_agnostic_config_error_quark (void) {
	return g_quark_from_static_string ("desktop_agnostic_config_error-quark");
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


GHashTable* desktop_agnostic_config_backend_get_backend_metadata_keys (void) {
	GHashTable* result = NULL;
	if (desktop_agnostic_config_backend__backend_metadata_keys == NULL) {
		GHashTable* _tmp0_;
		desktop_agnostic_config_backend__backend_metadata_keys = (_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, _vala_GValue_free), _g_hash_table_unref0 (desktop_agnostic_config_backend__backend_metadata_keys), _tmp0_);
	}
	result = desktop_agnostic_config_backend__backend_metadata_keys;
	return result;
}


/**
     * Resets the configuration to the default values.
     * @throws Error if something wrong happened during the reset
     */
static void desktop_agnostic_config_backend_real_reset (DesktopAgnosticConfigBackend* self, GError** error) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_config_backend_reset'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void desktop_agnostic_config_backend_reset (DesktopAgnosticConfigBackend* self, GError** error) {
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->reset (self, error);
}


/**
     * Removes all of the configuration.
     * @throws Error if the config removal could not be completed.
     */
static void desktop_agnostic_config_backend_real_remove (DesktopAgnosticConfigBackend* self, GError** error) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_config_backend_remove'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void desktop_agnostic_config_backend_remove (DesktopAgnosticConfigBackend* self, GError** error) {
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->remove (self, error);
}


/**
     * Adds a notification callback to the specified key.
     * @param group the group the key is associated with
     * @param key the config key to associate the callback with
     */
static void desktop_agnostic_config_backend_real_notify_add (DesktopAgnosticConfigBackend* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_config_backend_notify_add'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void desktop_agnostic_config_backend_notify_add (DesktopAgnosticConfigBackend* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error) {
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->notify_add (self, group, key, callback, callback_target, error);
}


/**
     * Manually executes all of the notification callbacks associated with the
     * specified key.
     * @param group the group the key is associated with
     * @param key the config key that is associated with the callback(s)
     */
static void desktop_agnostic_config_backend_real_notify (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_config_backend_notify'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void desktop_agnostic_config_backend_notify (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error) {
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->notify (self, group, key, error);
}


/**
     * Removes the specified notification callback for the specified key.
     * @param group the group the key is associated with
     * @param key the config key that is associated with the callback
     * @param callback the callback to remove
     * @throws Error if the callback is not associated with the key, among
     * other things
     */
static void desktop_agnostic_config_backend_real_notify_remove (DesktopAgnosticConfigBackend* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_config_backend_notify_remove'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void desktop_agnostic_config_backend_notify_remove (DesktopAgnosticConfigBackend* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error) {
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->notify_remove (self, group, key, callback, callback_target, error);
}


static void desktop_agnostic_config_backend_real_get_value (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValue* result, GError** error) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_config_backend_get_value'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void desktop_agnostic_config_backend_get_value (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValue* result, GError** error) {
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->get_value (self, group, key, result, error);
}


/**
     * Sets the configuration option to the specified value.
     * @param group the group the key is associated with
     * @param key the config key that is associated with the value
     * @param value the new value of the configuration option
     * @throws Error if the group/key does not exist, the value type is not
     * supported, or something bad happened while trying to set the value
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void desktop_agnostic_config_backend_real_set_value (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValue* value, GError** error) {
	DesktopAgnosticConfigSchemaOption* option;
	GType option_type = 0UL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	option = _g_object_ref0 (desktop_agnostic_config_schema_get_option (self->priv->_schema, group, key));
	if (option == NULL) {
		_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_KEY_NOT_FOUND, "Could not find group and/or key in schema.");
		{
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (option);
			return;
		}
	}
	option_type = desktop_agnostic_config_schema_option_get_option_type (option);
	if (option_type == G_TYPE_BOOLEAN) {
		desktop_agnostic_config_backend_set_bool (self, group, key, g_value_get_boolean (value), &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (option);
			return;
		}
	} else {
		if (option_type == G_TYPE_FLOAT) {
			float _tmp0_;
			_tmp0_ = desktop_agnostic_config_backend_get_float_from_value (value, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (option);
				return;
			}
			desktop_agnostic_config_backend_set_float (self, group, key, _tmp0_, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (option);
				return;
			}
		} else {
			if (option_type == G_TYPE_INT) {
				gint _tmp1_;
				_tmp1_ = desktop_agnostic_config_backend_get_int_from_value (value, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (option);
					return;
				}
				desktop_agnostic_config_backend_set_int (self, group, key, _tmp1_, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (option);
					return;
				}
			} else {
				if (option_type == G_TYPE_STRING) {
					desktop_agnostic_config_backend_set_string (self, group, key, g_value_get_string (value), &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (option);
						return;
					}
				} else {
					if (option_type == G_TYPE_VALUE_ARRAY) {
						desktop_agnostic_config_backend_set_list (self, group, key, g_value_get_boxed (value), &_inner_error_);
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (option);
							return;
						}
					} else {
						DesktopAgnosticConfigSchemaType* st;
						st = _g_object_ref0 (desktop_agnostic_config_schema_find_type (option_type));
						if (st == NULL) {
							_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_INVALID_TYPE, "Invalid config value type.");
							{
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (st);
								_g_object_unref0 (option);
								return;
							}
						} else {
							char* _tmp2_;
							char* _tmp3_;
							_tmp2_ = desktop_agnostic_config_schema_type_serialize (st, value, &_inner_error_);
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (st);
								_g_object_unref0 (option);
								return;
							}
							desktop_agnostic_config_backend_set_string (self, group, key, _tmp3_ = _tmp2_, &_inner_error_);
							_g_free0 (_tmp3_);
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (st);
								_g_object_unref0 (option);
								return;
							}
						}
						_g_object_unref0 (st);
					}
				}
			}
		}
	}
	_g_object_unref0 (option);
}


void desktop_agnostic_config_backend_set_value (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValue* value, GError** error) {
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->set_value (self, group, key, value, error);
}


static gboolean desktop_agnostic_config_backend_real_get_bool (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_config_backend_get_bool'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean desktop_agnostic_config_backend_get_bool (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error) {
	return DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->get_bool (self, group, key, error);
}


static void desktop_agnostic_config_backend_real_set_bool (DesktopAgnosticConfigBackend* self, const char* group, const char* key, gboolean value, GError** error) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_config_backend_set_bool'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void desktop_agnostic_config_backend_set_bool (DesktopAgnosticConfigBackend* self, const char* group, const char* key, gboolean value, GError** error) {
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->set_bool (self, group, key, value, error);
}


static float desktop_agnostic_config_backend_real_get_float (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error) {
	g_return_val_if_fail (self != NULL, 0.0F);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_config_backend_get_float'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0.0F;
}


float desktop_agnostic_config_backend_get_float (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error) {
	return DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->get_float (self, group, key, error);
}


static void desktop_agnostic_config_backend_real_set_float (DesktopAgnosticConfigBackend* self, const char* group, const char* key, float value, GError** error) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_config_backend_set_float'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void desktop_agnostic_config_backend_set_float (DesktopAgnosticConfigBackend* self, const char* group, const char* key, float value, GError** error) {
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->set_float (self, group, key, value, error);
}


static gint desktop_agnostic_config_backend_real_get_int (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error) {
	g_return_val_if_fail (self != NULL, 0);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_config_backend_get_int'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}


gint desktop_agnostic_config_backend_get_int (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error) {
	return DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->get_int (self, group, key, error);
}


static void desktop_agnostic_config_backend_real_set_int (DesktopAgnosticConfigBackend* self, const char* group, const char* key, gint value, GError** error) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_config_backend_set_int'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void desktop_agnostic_config_backend_set_int (DesktopAgnosticConfigBackend* self, const char* group, const char* key, gint value, GError** error) {
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->set_int (self, group, key, value, error);
}


static char* desktop_agnostic_config_backend_real_get_string (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_config_backend_get_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


char* desktop_agnostic_config_backend_get_string (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error) {
	return DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->get_string (self, group, key, error);
}


static void desktop_agnostic_config_backend_real_set_string (DesktopAgnosticConfigBackend* self, const char* group, const char* key, const char* value, GError** error) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_config_backend_set_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void desktop_agnostic_config_backend_set_string (DesktopAgnosticConfigBackend* self, const char* group, const char* key, const char* value, GError** error) {
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->set_string (self, group, key, value, error);
}


static GValueArray* desktop_agnostic_config_backend_real_get_list (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_config_backend_get_list'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GValueArray* desktop_agnostic_config_backend_get_list (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GError** error) {
	return DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->get_list (self, group, key, error);
}


static void desktop_agnostic_config_backend_real_set_list (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValueArray* value, GError** error) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `desktop_agnostic_config_backend_set_list'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void desktop_agnostic_config_backend_set_list (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValueArray* value, GError** error) {
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->set_list (self, group, key, value, error);
}


float desktop_agnostic_config_backend_get_float_from_value (GValue* value, GError** error) {
	float result = 0.0F;
	GError * _inner_error_ = NULL;
	if (G_VALUE_HOLDS (value, G_TYPE_FLOAT)) {
		result = g_value_get_float (value);
		return result;
	} else {
		if (g_value_type_transformable (G_VALUE_TYPE (value), G_TYPE_FLOAT)) {
			GValue converted = {0};
			g_value_init (&converted, G_TYPE_FLOAT);
			g_value_transform (value, &converted);
			result = g_value_get_float (&converted);
			G_IS_VALUE (&converted) ? (g_value_unset (&converted), NULL) : NULL;
			return result;
		} else {
			_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_INVALID_TYPE, "Value given cannot be converted to a float: %s.", g_type_name (G_VALUE_TYPE (value)));
			{
				if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0.0F;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0.0F;
				}
			}
		}
	}
}


gint desktop_agnostic_config_backend_get_int_from_value (GValue* value, GError** error) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	if (G_VALUE_HOLDS (value, G_TYPE_INT)) {
		result = g_value_get_int (value);
		return result;
	} else {
		if (g_value_type_transformable (G_VALUE_TYPE (value), G_TYPE_INT)) {
			GValue converted = {0};
			g_value_init (&converted, G_TYPE_INT);
			g_value_transform (value, &converted);
			result = g_value_get_int (&converted);
			G_IS_VALUE (&converted) ? (g_value_unset (&converted), NULL) : NULL;
			return result;
		} else {
			_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_INVALID_TYPE, "Value given cannot be converted to an integer: %s.", g_type_name (G_VALUE_TYPE (value)));
			{
				if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
		}
	}
}


DesktopAgnosticConfigBackend* desktop_agnostic_config_backend_construct (GType object_type) {
	DesktopAgnosticConfigBackend * self = NULL;
	self = (DesktopAgnosticConfigBackend*) g_object_new (object_type, NULL);
	return self;
}


char* desktop_agnostic_config_backend_get_name (DesktopAgnosticConfigBackend* self) {
	return DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS (self)->get_name (self);
}


DesktopAgnosticConfigSchema* desktop_agnostic_config_backend_get_schema (DesktopAgnosticConfigBackend* self) {
	DesktopAgnosticConfigSchema* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_schema;
	return result;
}


static void desktop_agnostic_config_backend_set_schema (DesktopAgnosticConfigBackend* self, DesktopAgnosticConfigSchema* value) {
	DesktopAgnosticConfigSchema* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_schema = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_schema), _tmp0_);
	g_object_notify ((GObject *) self, "schema");
}


const char* desktop_agnostic_config_backend_get_instance_id (DesktopAgnosticConfigBackend* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_instance_id;
	return result;
}


static void desktop_agnostic_config_backend_set_instance_id (DesktopAgnosticConfigBackend* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_instance_id = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_instance_id), _tmp0_);
	g_object_notify ((GObject *) self, "instance-id");
}


static void desktop_agnostic_config_backend_class_init (DesktopAgnosticConfigBackendClass * klass) {
	desktop_agnostic_config_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticConfigBackendPrivate));
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->reset = desktop_agnostic_config_backend_real_reset;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->remove = desktop_agnostic_config_backend_real_remove;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->notify_add = desktop_agnostic_config_backend_real_notify_add;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->notify = desktop_agnostic_config_backend_real_notify;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->notify_remove = desktop_agnostic_config_backend_real_notify_remove;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_value = desktop_agnostic_config_backend_real_get_value;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->set_value = desktop_agnostic_config_backend_real_set_value;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_bool = desktop_agnostic_config_backend_real_get_bool;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->set_bool = desktop_agnostic_config_backend_real_set_bool;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_float = desktop_agnostic_config_backend_real_get_float;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->set_float = desktop_agnostic_config_backend_real_set_float;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_int = desktop_agnostic_config_backend_real_get_int;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->set_int = desktop_agnostic_config_backend_real_set_int;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_string = desktop_agnostic_config_backend_real_get_string;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->set_string = desktop_agnostic_config_backend_real_set_string;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_list = desktop_agnostic_config_backend_real_get_list;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->set_list = desktop_agnostic_config_backend_real_set_list;
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_config_backend_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_config_backend_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_config_backend_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_BACKEND_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_BACKEND_SCHEMA, g_param_spec_object ("schema", "schema", "schema", DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_BACKEND_INSTANCE_ID, g_param_spec_string ("instance-id", "instance-id", "instance-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void desktop_agnostic_config_backend_instance_init (DesktopAgnosticConfigBackend * self) {
	self->priv = DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_PRIVATE (self);
	self->priv->_schema = NULL;
}


static void desktop_agnostic_config_backend_finalize (GObject* obj) {
	DesktopAgnosticConfigBackend * self;
	self = DESKTOP_AGNOSTIC_CONFIG_BACKEND (obj);
	_g_object_unref0 (self->priv->_schema);
	_g_free0 (self->priv->_instance_id);
	G_OBJECT_CLASS (desktop_agnostic_config_backend_parent_class)->finalize (obj);
}


/**
   * The abstract base class that defines what a configuration backend should
   * look like.
   */
GType desktop_agnostic_config_backend_get_type (void) {
	static volatile gsize desktop_agnostic_config_backend_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_config_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticConfigBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_config_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticConfigBackend), 0, (GInstanceInitFunc) desktop_agnostic_config_backend_instance_init, NULL };
		GType desktop_agnostic_config_backend_type_id;
		desktop_agnostic_config_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticConfigBackend", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&desktop_agnostic_config_backend_type_id__volatile, desktop_agnostic_config_backend_type_id);
	}
	return desktop_agnostic_config_backend_type_id__volatile;
}


static void desktop_agnostic_config_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticConfigBackend * self;
	self = DESKTOP_AGNOSTIC_CONFIG_BACKEND (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_CONFIG_BACKEND_SCHEMA:
		g_value_set_object (value, desktop_agnostic_config_backend_get_schema (self));
		break;
		case DESKTOP_AGNOSTIC_CONFIG_BACKEND_INSTANCE_ID:
		g_value_set_string (value, desktop_agnostic_config_backend_get_instance_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_config_backend_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticConfigBackend * self;
	self = DESKTOP_AGNOSTIC_CONFIG_BACKEND (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_CONFIG_BACKEND_SCHEMA:
		desktop_agnostic_config_backend_set_schema (self, g_value_get_object (value));
		break;
		case DESKTOP_AGNOSTIC_CONFIG_BACKEND_INSTANCE_ID:
		desktop_agnostic_config_backend_set_instance_id (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


/**
   * Retrieve the default config backend type.
   * @return Config.Backend-based type on succes, Type.INVALID on failure
   */
static GType* _g_type_dup (GType* self) {
	GType* dup;
	dup = g_new0 (GType, 1);
	memcpy (dup, self, sizeof (GType));
	return dup;
}


static gpointer __g_type_dup0 (gpointer self) {
	return self ? _g_type_dup (self) : NULL;
}


GType desktop_agnostic_config_get_type (GError** error) {
	GType result = 0UL;
	GError * _inner_error_ = NULL;
	if (desktop_agnostic_config_module_type == NULL) {
		GType _tmp0_;
		GType* _tmp1_;
		_tmp0_ = desktop_agnostic_get_module_type ("cfg", "config", &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return 0UL;
		}
		desktop_agnostic_config_module_type = (_tmp1_ = __g_type_dup0 (&_tmp0_), _g_free0 (desktop_agnostic_config_module_type), _tmp1_);
	}
	result = *desktop_agnostic_config_module_type;
	return result;
}


/**
   * Convenience method for instantiating a configuration backend.
   * @return a Config.Backend object on success, %NULL on failure
   */
DesktopAgnosticConfigBackend* desktop_agnostic_config_new (DesktopAgnosticConfigSchema* schema, GError** error) {
	DesktopAgnosticConfigBackend* result = NULL;
	GType type;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (schema != NULL, NULL);
	type = desktop_agnostic_config_get_type (&_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (type == G_TYPE_INVALID) {
		result = NULL;
		return result;
	} else {
		GObject* _tmp0_;
		result = DESKTOP_AGNOSTIC_CONFIG_BACKEND ((_tmp0_ = g_object_new (type, "schema", schema, NULL), G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_));
		return result;
	}
}


/**
   * Convenience method for instantiating a configuration backend with an
   * instance ID.
   * @return a Config.Backend object on success, %NULL on failure
   */
DesktopAgnosticConfigBackend* desktop_agnostic_config_new_for_instance (const char* instance_id, DesktopAgnosticConfigSchema* schema, GError** error) {
	DesktopAgnosticConfigBackend* result = NULL;
	GType type;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (instance_id != NULL, NULL);
	g_return_val_if_fail (schema != NULL, NULL);
	type = desktop_agnostic_config_get_type (&_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (type == G_TYPE_INVALID) {
		result = NULL;
		return result;
	} else {
		GObject* _tmp0_;
		result = DESKTOP_AGNOSTIC_CONFIG_BACKEND ((_tmp0_ = g_object_new (type, "schema", schema, "instance_id", instance_id, NULL), G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_));
		return result;
	}
}




