#!/usr/bin/env php
<?php
// Copyright 2008, Google Inc. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are met:
//
//  1. Redistributions of source code must retain the above copyright notice, 
//     this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//  3. Neither the name of Google Inc. nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
// EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
// OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
// OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
// ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// This script takes the SWIG-generated kmldom.php wrapper and applies
// a couple of bug fixes:
// - removes the bogus C++ namespace prefixes to enums
// - fixes the code for KmlFactory
//
// usage: ./tweak_generated_kmldom.php

  $infile = "../../build/php/kmldom.php";
  if (!file_exists($infile)) {
    echo "error: $infile does not yet exist. This file is\n";
    echo "automatically generated by SWIG when you build the project.\n";
    exit(1);
  }

  $outfile = "kmldom.php";
  $output_handle = fopen($outfile, "w");
  if (!file_exists($outfile)) {
    echo "error: $outfile could not be created. Please ensure that\n";
    echo "the current directory is writable.\n";
    exit(1);
  }

  $lines = file($infile);
  if (count($lines) == 0) {
    echo "error: could not read $infile. Make sure the file is readable\n";
    exit(1);
  }

  $in_factory_class = false;
  for ($i = 0; $i < count($lines); $i++) {
    // Fix the namespace problem:
    if (strstr($lines[$i], "const kmldom::")) {
      $lines[$i] = preg_replace('/const kmldom::/', 'const ', $lines[$i]);
    }
    // Set a flag so we know when we're inside the KmlFactory class.
    if (strstr($lines[$i], "class KmlFactory")) {
      $in_factory_class = true;
    }
    // Fix the factory class.
    if ($in_factory_class) {
      if (strstr($lines[$i], "public \$_cPtr=null")) {
        // We need to insert the missing constructor here:
        $lines[$i] .= "  function __construct(\$h) {\n";
        $lines[$i] .= "    \$this->_cPtr=\$h;\n";
        $lines[$i] .= "  }\n";
      }
      if (strstr($lines[$i], "function __construct")) {
        // We need to get the class name from the broken code and reconstruct
        // the correct calls. The broken code is of the form:
        //  function __construct() {
        //    $this->_cPtr=KmlFactory_CreateFoo($this->_cPtr);
        //  }
        // We'll correct it to:
        //  function CreateXXX() {
        //    $r=KmlFactory_CreateFoo($this->_cPtr);
        //    return is_resource($r) ? new Foo($r) : $r;
        //  } 
        if (strstr($lines[$i+1], "KmlFactory_Create")) {
          preg_match('/Create.*\(/', $lines[$i+1], $matches);
          if ($matches) {
            // Get the class name by stripping back the match from the search:
            $class_name = substr(substr($matches[0], 6), 0, -1);
            // Build up the correct function definition:
            $f = sprintf("\tfunction Create%s() {\n", $class_name);
            $f .= sprintf("\t\t\$r=KmlFactory_Create%s(\$this->_cPtr);\n",
                          $class_name);
            $f .= sprintf("\t\treturn is_resource(\$r) ? new ");
            $f .= sprintf("%s(\$r) : \$r;\n\t}\n", $class_name);
            $lines[$i] = $f;
            // Clear the next two lines:
            $lines[$i+1] = '';
            $lines[$i+2] = '';
          }
        }
      }
    }
    fwrite($output_handle, $lines[$i]);
  }

  fclose($output_handle);
  echo "tweak successful";
?>

