/* NBD client library in userspace
 * WARNING: THIS FILE IS GENERATED FROM
 * generator/generator
 * ANY CHANGES YOU MAKE TO THIS FILE WILL BE LOST.
 *
 * Copyright (C) 2013-2019 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#define PY_SSIZE_T_CLEAN 1
#include <Python.h>

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>

#include <libnbd.h>

#include <methods.h>

/* This is passed to *_wrapper as the user_data pointer
 * and freed in the free_user_data function below.
 */
struct user_data {
  PyObject *fn;    /* Optional pointer to Python function. */
  PyObject *buf;   /* Optional pointer to persistent buffer. */
};

static struct user_data *
alloc_user_data (void)
{
  struct user_data *data = calloc (1, sizeof *data);
  if (data == NULL) {
    PyErr_NoMemory ();
    return NULL;
  }
  return data;
}

static void
free_user_data (void *user_data)
{
  struct user_data *data = user_data;

  if (data->fn != NULL)
    Py_DECREF (data->fn);
  if (data->buf != NULL)
    Py_DECREF (data->buf);
  free (data);
}

/* Wrapper for chunk callback. */
static int
chunk_wrapper (void *user_data, const void *subbuf, size_t count,
               uint64_t offset, unsigned status, int *error)
{
  const struct user_data *data = user_data;
  int ret = 0;

  PyGILState_STATE py_save = PyGILState_UNLOCKED;
  PyObject *py_args, *py_ret;
  PyObject *py_error_modname = PyUnicode_FromString ("ctypes");
  if (!py_error_modname) { PyErr_PrintEx (0); return -1; }
  PyObject *py_error_mod = PyImport_Import (py_error_modname);
  Py_DECREF (py_error_modname);
  if (!py_error_mod) { PyErr_PrintEx (0); return -1; }
  PyObject *py_error = PyObject_CallMethod (py_error_mod, "c_int", "i", *error);
  if (!py_error) { PyErr_PrintEx (0); return -1; }

  py_args = Py_BuildValue ("(" "y#" "K" "I" "O" ")", subbuf, (int) count, offset, status, py_error);
  Py_INCREF (py_args);

  if (PyEval_ThreadsInitialized ())
    py_save = PyGILState_Ensure ();

  py_ret = PyObject_CallObject (data->fn, py_args);

  if (PyEval_ThreadsInitialized ())
    PyGILState_Release (py_save);

  Py_DECREF (py_args);

  if (py_ret != NULL) {
    if (PyLong_Check (py_ret))
      ret = PyLong_AsLong (py_ret);
    else
      /* If it's not a long, just assume it's 0. */
      ret = 0;
    Py_DECREF (py_ret);
  }
  else {
    /* Special case failed assertions to be fatal. */
    if (PyErr_ExceptionMatches (PyExc_AssertionError)) {
      PyErr_Print ();
      abort ();
    }
    ret = -1;
    PyErr_PrintEx (0); /* print exception */
  };

  PyObject *py_error_ret = PyObject_GetAttrString (py_error, "value");
  *error = PyLong_AsLong (py_error_ret);
  Py_DECREF (py_error_ret);
  Py_DECREF (py_error);
  return ret;
}

/* Wrapper for completion callback. */
static int
completion_wrapper (void *user_data, int *error)
{
  const struct user_data *data = user_data;
  int ret = 0;

  PyGILState_STATE py_save = PyGILState_UNLOCKED;
  PyObject *py_args, *py_ret;
  PyObject *py_error_modname = PyUnicode_FromString ("ctypes");
  if (!py_error_modname) { PyErr_PrintEx (0); return -1; }
  PyObject *py_error_mod = PyImport_Import (py_error_modname);
  Py_DECREF (py_error_modname);
  if (!py_error_mod) { PyErr_PrintEx (0); return -1; }
  PyObject *py_error = PyObject_CallMethod (py_error_mod, "c_int", "i", *error);
  if (!py_error) { PyErr_PrintEx (0); return -1; }

  py_args = Py_BuildValue ("(" "O" ")", py_error);
  Py_INCREF (py_args);

  if (PyEval_ThreadsInitialized ())
    py_save = PyGILState_Ensure ();

  py_ret = PyObject_CallObject (data->fn, py_args);

  if (PyEval_ThreadsInitialized ())
    PyGILState_Release (py_save);

  Py_DECREF (py_args);

  if (py_ret != NULL) {
    if (PyLong_Check (py_ret))
      ret = PyLong_AsLong (py_ret);
    else
      /* If it's not a long, just assume it's 0. */
      ret = 0;
    Py_DECREF (py_ret);
  }
  else {
    /* Special case failed assertions to be fatal. */
    if (PyErr_ExceptionMatches (PyExc_AssertionError)) {
      PyErr_Print ();
      abort ();
    }
    ret = -1;
    PyErr_PrintEx (0); /* print exception */
  };

  PyObject *py_error_ret = PyObject_GetAttrString (py_error, "value");
  *error = PyLong_AsLong (py_error_ret);
  Py_DECREF (py_error_ret);
  Py_DECREF (py_error);
  return ret;
}

/* Wrapper for debug callback. */
static int
debug_wrapper (void *user_data, const char *context, const char *msg)
{
  const struct user_data *data = user_data;
  int ret = 0;

  PyGILState_STATE py_save = PyGILState_UNLOCKED;
  PyObject *py_args, *py_ret;

  py_args = Py_BuildValue ("(" "s" "s" ")", context, msg);
  Py_INCREF (py_args);

  if (PyEval_ThreadsInitialized ())
    py_save = PyGILState_Ensure ();

  py_ret = PyObject_CallObject (data->fn, py_args);

  if (PyEval_ThreadsInitialized ())
    PyGILState_Release (py_save);

  Py_DECREF (py_args);

  if (py_ret != NULL) {
    if (PyLong_Check (py_ret))
      ret = PyLong_AsLong (py_ret);
    else
      /* If it's not a long, just assume it's 0. */
      ret = 0;
    Py_DECREF (py_ret);
  }
  else {
    /* Special case failed assertions to be fatal. */
    if (PyErr_ExceptionMatches (PyExc_AssertionError)) {
      PyErr_Print ();
      abort ();
    }
    ret = -1;
    PyErr_PrintEx (0); /* print exception */
  };

  return ret;
}

/* Wrapper for extent callback. */
static int
extent_wrapper (void *user_data, const char *metacontext, uint64_t offset,
                uint32_t *entries, size_t nr_entries, int *error)
{
  const struct user_data *data = user_data;
  int ret = 0;

  PyGILState_STATE py_save = PyGILState_UNLOCKED;
  PyObject *py_args, *py_ret;
  PyObject *py_entries = PyList_New (nr_entries);
  for (size_t i = 0; i < nr_entries; ++i)
    PyList_SET_ITEM (py_entries, i, PyLong_FromUnsignedLong (entries[i]));
  PyObject *py_error_modname = PyUnicode_FromString ("ctypes");
  if (!py_error_modname) { PyErr_PrintEx (0); return -1; }
  PyObject *py_error_mod = PyImport_Import (py_error_modname);
  Py_DECREF (py_error_modname);
  if (!py_error_mod) { PyErr_PrintEx (0); return -1; }
  PyObject *py_error = PyObject_CallMethod (py_error_mod, "c_int", "i", *error);
  if (!py_error) { PyErr_PrintEx (0); return -1; }

  py_args = Py_BuildValue ("(" "s" "K" "O" "O" ")", metacontext, offset, py_entries, py_error);
  Py_INCREF (py_args);

  if (PyEval_ThreadsInitialized ())
    py_save = PyGILState_Ensure ();

  py_ret = PyObject_CallObject (data->fn, py_args);

  if (PyEval_ThreadsInitialized ())
    PyGILState_Release (py_save);

  Py_DECREF (py_args);

  if (py_ret != NULL) {
    if (PyLong_Check (py_ret))
      ret = PyLong_AsLong (py_ret);
    else
      /* If it's not a long, just assume it's 0. */
      ret = 0;
    Py_DECREF (py_ret);
  }
  else {
    /* Special case failed assertions to be fatal. */
    if (PyErr_ExceptionMatches (PyExc_AssertionError)) {
      PyErr_Print ();
      abort ();
    }
    ret = -1;
    PyErr_PrintEx (0); /* print exception */
  };

  Py_DECREF (py_entries);
  PyObject *py_error_ret = PyObject_GetAttrString (py_error, "value");
  *error = PyLong_AsLong (py_error_ret);
  Py_DECREF (py_error_ret);
  Py_DECREF (py_error);
  return ret;
}

PyObject *
nbd_internal_py_set_debug (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  int debug;

  if (!PyArg_ParseTuple (args, (char *) "O" "b"
                         ":nbd_set_debug",
                         &py_h, &debug))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_set_debug (h, debug);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_get_debug (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_get_debug",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_get_debug (h);
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

  return py_ret;
}

PyObject *
nbd_internal_py_set_debug_callback (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  struct user_data *debug_user_data = alloc_user_data ();
  if (debug_user_data == NULL) return NULL;
  nbd_debug_callback debug = { .callback = debug_wrapper,
                         .user_data = debug_user_data,
                         .free = free_user_data };

  if (!PyArg_ParseTuple (args, (char *) "O" "O"
                         ":nbd_set_debug_callback",
                         &py_h, &debug_user_data->fn))
    return NULL;
  h = get_handle (py_h);
  /* Increment refcount since pointer may be saved by libnbd. */
  Py_INCREF (debug_user_data->fn);
  if (!PyCallable_Check (debug_user_data->fn)) {
    PyErr_SetString (PyExc_TypeError,
                     "callback parameter debug is not callable");
    return NULL;
  }
  ret = nbd_set_debug_callback (h, debug);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_clear_debug_callback (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_clear_debug_callback",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_clear_debug_callback (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_set_handle_name (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  const char *handle_name;

  if (!PyArg_ParseTuple (args, (char *) "O" "s"
                         ":nbd_set_handle_name",
                         &py_h, &handle_name))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_set_handle_name (h, handle_name);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_get_handle_name (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  char * ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_get_handle_name",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_get_handle_name (h);
  if (ret == NULL) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyUnicode_FromString (ret);
  free (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_set_export_name (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  const char *export_name;

  if (!PyArg_ParseTuple (args, (char *) "O" "s"
                         ":nbd_set_export_name",
                         &py_h, &export_name))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_set_export_name (h, export_name);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_get_export_name (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  char * ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_get_export_name",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_get_export_name (h);
  if (ret == NULL) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyUnicode_FromString (ret);
  free (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_set_tls (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  int tls;

  if (!PyArg_ParseTuple (args, (char *) "O" "i"
                         ":nbd_set_tls",
                         &py_h, &tls))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_set_tls (h, tls);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_get_tls (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_get_tls",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_get_tls (h);
  py_ret = PyLong_FromLong (ret);

  return py_ret;
}

PyObject *
nbd_internal_py_get_tls_negotiated (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_get_tls_negotiated",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_get_tls_negotiated (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_set_tls_certificates (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  PyObject *py_dir = NULL;
  char *dir = NULL;

  if (!PyArg_ParseTuple (args, (char *) "O" "O&"
                         ":nbd_set_tls_certificates",
                         &py_h, PyUnicode_FSConverter, &py_dir))
    return NULL;
  h = get_handle (py_h);
  dir = PyBytes_AS_STRING (py_dir);
  assert (dir != NULL);
  ret = nbd_set_tls_certificates (h, dir);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  Py_XDECREF (py_dir);
  return py_ret;
}

PyObject *
nbd_internal_py_set_tls_verify_peer (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  int verify;

  if (!PyArg_ParseTuple (args, (char *) "O" "b"
                         ":nbd_set_tls_verify_peer",
                         &py_h, &verify))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_set_tls_verify_peer (h, verify);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_get_tls_verify_peer (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_get_tls_verify_peer",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_get_tls_verify_peer (h);
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

  return py_ret;
}

PyObject *
nbd_internal_py_set_tls_username (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  const char *username;

  if (!PyArg_ParseTuple (args, (char *) "O" "s"
                         ":nbd_set_tls_username",
                         &py_h, &username))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_set_tls_username (h, username);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_get_tls_username (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  char * ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_get_tls_username",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_get_tls_username (h);
  if (ret == NULL) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyUnicode_FromString (ret);
  free (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_set_tls_psk_file (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  PyObject *py_filename = NULL;
  char *filename = NULL;

  if (!PyArg_ParseTuple (args, (char *) "O" "O&"
                         ":nbd_set_tls_psk_file",
                         &py_h, PyUnicode_FSConverter, &py_filename))
    return NULL;
  h = get_handle (py_h);
  filename = PyBytes_AS_STRING (py_filename);
  assert (filename != NULL);
  ret = nbd_set_tls_psk_file (h, filename);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  Py_XDECREF (py_filename);
  return py_ret;
}

PyObject *
nbd_internal_py_set_request_structured_replies (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  int request;

  if (!PyArg_ParseTuple (args, (char *) "O" "b"
                         ":nbd_set_request_structured_replies",
                         &py_h, &request))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_set_request_structured_replies (h, request);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_get_request_structured_replies (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_get_request_structured_replies",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_get_request_structured_replies (h);
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

  return py_ret;
}

PyObject *
nbd_internal_py_get_structured_replies_negotiated (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_get_structured_replies_negotiated",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_get_structured_replies_negotiated (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_set_handshake_flags (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "I"
                         ":nbd_set_handshake_flags",
                         &py_h, &flags))
    return NULL;
  h = get_handle (py_h);
  flags_u32 = flags;
  ret = nbd_set_handshake_flags (h, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_get_handshake_flags (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  unsigned ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_get_handshake_flags",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_get_handshake_flags (h);
  py_ret = PyLong_FromLong (ret);

  return py_ret;
}

PyObject *
nbd_internal_py_add_meta_context (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  const char *name;

  if (!PyArg_ParseTuple (args, (char *) "O" "s"
                         ":nbd_add_meta_context",
                         &py_h, &name))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_add_meta_context (h, name);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_set_uri_allow_transports (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  uint32_t mask_u32;
  unsigned int mask; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "I"
                         ":nbd_set_uri_allow_transports",
                         &py_h, &mask))
    return NULL;
  h = get_handle (py_h);
  mask_u32 = mask;
  ret = nbd_set_uri_allow_transports (h, mask_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_set_uri_allow_tls (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  int tls;

  if (!PyArg_ParseTuple (args, (char *) "O" "i"
                         ":nbd_set_uri_allow_tls",
                         &py_h, &tls))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_set_uri_allow_tls (h, tls);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_set_uri_allow_local_file (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  int allow;

  if (!PyArg_ParseTuple (args, (char *) "O" "b"
                         ":nbd_set_uri_allow_local_file",
                         &py_h, &allow))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_set_uri_allow_local_file (h, allow);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_connect_uri (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  const char *uri;

  if (!PyArg_ParseTuple (args, (char *) "O" "s"
                         ":nbd_connect_uri",
                         &py_h, &uri))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_connect_uri (h, uri);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_connect_unix (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  PyObject *py_unixsocket = NULL;
  char *unixsocket = NULL;

  if (!PyArg_ParseTuple (args, (char *) "O" "O&"
                         ":nbd_connect_unix",
                         &py_h, PyUnicode_FSConverter, &py_unixsocket))
    return NULL;
  h = get_handle (py_h);
  unixsocket = PyBytes_AS_STRING (py_unixsocket);
  assert (unixsocket != NULL);
  ret = nbd_connect_unix (h, unixsocket);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  Py_XDECREF (py_unixsocket);
  return py_ret;
}

PyObject *
nbd_internal_py_connect_vsock (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  uint32_t cid_u32;
  unsigned int cid; /* really uint32_t */
  uint32_t port_u32;
  unsigned int port; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "I" "I"
                         ":nbd_connect_vsock",
                         &py_h, &cid, &port))
    return NULL;
  h = get_handle (py_h);
  cid_u32 = cid;
  port_u32 = port;
  ret = nbd_connect_vsock (h, cid_u32, port_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_connect_tcp (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  const char *hostname;
  const char *port;

  if (!PyArg_ParseTuple (args, (char *) "O" "s" "s"
                         ":nbd_connect_tcp",
                         &py_h, &hostname, &port))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_connect_tcp (h, hostname, port);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_connect_socket (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  int sock;

  if (!PyArg_ParseTuple (args, (char *) "O" "i"
                         ":nbd_connect_socket",
                         &py_h, &sock))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_connect_socket (h, sock);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_connect_command (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  PyObject *py_argv;
  char **argv = NULL;

  if (!PyArg_ParseTuple (args, (char *) "O" "O"
                         ":nbd_connect_command",
                         &py_h, &py_argv))
    return NULL;
  h = get_handle (py_h);
  argv = nbd_internal_py_get_string_list (py_argv);
  if (!argv) { py_ret = NULL; goto out; }
  ret = nbd_connect_command (h, argv);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  nbd_internal_py_free_string_list (argv);
  return py_ret;
}

PyObject *
nbd_internal_py_connect_systemd_socket_activation (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  PyObject *py_argv;
  char **argv = NULL;

  if (!PyArg_ParseTuple (args, (char *) "O" "O"
                         ":nbd_connect_systemd_socket_activation",
                         &py_h, &py_argv))
    return NULL;
  h = get_handle (py_h);
  argv = nbd_internal_py_get_string_list (py_argv);
  if (!argv) { py_ret = NULL; goto out; }
  ret = nbd_connect_systemd_socket_activation (h, argv);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  nbd_internal_py_free_string_list (argv);
  return py_ret;
}

PyObject *
nbd_internal_py_is_read_only (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_is_read_only",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_is_read_only (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_can_flush (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_can_flush",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_can_flush (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_can_fua (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_can_fua",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_can_fua (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_is_rotational (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_is_rotational",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_is_rotational (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_can_trim (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_can_trim",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_can_trim (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_can_zero (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_can_zero",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_can_zero (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_can_fast_zero (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_can_fast_zero",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_can_fast_zero (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_can_df (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_can_df",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_can_df (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_can_multi_conn (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_can_multi_conn",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_can_multi_conn (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_can_cache (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_can_cache",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_can_cache (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_can_meta_context (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  const char *metacontext;

  if (!PyArg_ParseTuple (args, (char *) "O" "s"
                         ":nbd_can_meta_context",
                         &py_h, &metacontext))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_can_meta_context (h, metacontext);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_get_protocol (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  const char * ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_get_protocol",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_get_protocol (h);
  if (ret == NULL) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyUnicode_FromString (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_get_size (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int64_t ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_get_size",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_get_size (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyLong_FromLongLong (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_pread (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  char *buf;
  Py_ssize_t count;
  uint64_t offset_u64;
  unsigned long long offset; /* really uint64_t */
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "n" "K" "I"
                         ":nbd_pread",
                         &py_h, &count, &offset, &flags))
    return NULL;
  h = get_handle (py_h);
  buf = malloc (count);
  offset_u64 = offset;
  flags_u32 = flags;
  ret = nbd_pread (h, buf, count, offset_u64, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyBytes_FromStringAndSize (buf, count);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_pread_structured (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  char *buf;
  Py_ssize_t count;
  uint64_t offset_u64;
  unsigned long long offset; /* really uint64_t */
  struct user_data *chunk_user_data = alloc_user_data ();
  if (chunk_user_data == NULL) return NULL;
  nbd_chunk_callback chunk = { .callback = chunk_wrapper,
                         .user_data = chunk_user_data,
                         .free = free_user_data };
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "n" "K" "O" "I"
                         ":nbd_pread_structured",
                         &py_h, &count, &offset, &chunk_user_data->fn, &flags))
    return NULL;
  h = get_handle (py_h);
  buf = malloc (count);
  offset_u64 = offset;
  /* Increment refcount since pointer may be saved by libnbd. */
  Py_INCREF (chunk_user_data->fn);
  if (!PyCallable_Check (chunk_user_data->fn)) {
    PyErr_SetString (PyExc_TypeError,
                     "callback parameter chunk is not callable");
    return NULL;
  }
  flags_u32 = flags;
  ret = nbd_pread_structured (h, buf, count, offset_u64, chunk, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyBytes_FromStringAndSize (buf, count);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_pwrite (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  Py_buffer buf;
  uint64_t offset_u64;
  unsigned long long offset; /* really uint64_t */
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "y*" "K" "I"
                         ":nbd_pwrite",
                         &py_h, &buf, &offset, &flags))
    return NULL;
  h = get_handle (py_h);
  offset_u64 = offset;
  flags_u32 = flags;
  ret = nbd_pwrite (h, buf.buf, buf.len, offset_u64, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  PyBuffer_Release (&buf);
  return py_ret;
}

PyObject *
nbd_internal_py_shutdown (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "I"
                         ":nbd_shutdown",
                         &py_h, &flags))
    return NULL;
  h = get_handle (py_h);
  flags_u32 = flags;
  ret = nbd_shutdown (h, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_flush (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "I"
                         ":nbd_flush",
                         &py_h, &flags))
    return NULL;
  h = get_handle (py_h);
  flags_u32 = flags;
  ret = nbd_flush (h, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_trim (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  uint64_t count_u64;
  unsigned long long count; /* really uint64_t */
  uint64_t offset_u64;
  unsigned long long offset; /* really uint64_t */
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "K" "K" "I"
                         ":nbd_trim",
                         &py_h, &count, &offset, &flags))
    return NULL;
  h = get_handle (py_h);
  count_u64 = count;
  offset_u64 = offset;
  flags_u32 = flags;
  ret = nbd_trim (h, count_u64, offset_u64, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_cache (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  uint64_t count_u64;
  unsigned long long count; /* really uint64_t */
  uint64_t offset_u64;
  unsigned long long offset; /* really uint64_t */
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "K" "K" "I"
                         ":nbd_cache",
                         &py_h, &count, &offset, &flags))
    return NULL;
  h = get_handle (py_h);
  count_u64 = count;
  offset_u64 = offset;
  flags_u32 = flags;
  ret = nbd_cache (h, count_u64, offset_u64, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_zero (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  uint64_t count_u64;
  unsigned long long count; /* really uint64_t */
  uint64_t offset_u64;
  unsigned long long offset; /* really uint64_t */
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "K" "K" "I"
                         ":nbd_zero",
                         &py_h, &count, &offset, &flags))
    return NULL;
  h = get_handle (py_h);
  count_u64 = count;
  offset_u64 = offset;
  flags_u32 = flags;
  ret = nbd_zero (h, count_u64, offset_u64, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_block_status (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  uint64_t count_u64;
  unsigned long long count; /* really uint64_t */
  uint64_t offset_u64;
  unsigned long long offset; /* really uint64_t */
  struct user_data *extent_user_data = alloc_user_data ();
  if (extent_user_data == NULL) return NULL;
  nbd_extent_callback extent = { .callback = extent_wrapper,
                         .user_data = extent_user_data,
                         .free = free_user_data };
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "K" "K" "O" "I"
                         ":nbd_block_status",
                         &py_h, &count, &offset, &extent_user_data->fn, &flags))
    return NULL;
  h = get_handle (py_h);
  count_u64 = count;
  offset_u64 = offset;
  /* Increment refcount since pointer may be saved by libnbd. */
  Py_INCREF (extent_user_data->fn);
  if (!PyCallable_Check (extent_user_data->fn)) {
    PyErr_SetString (PyExc_TypeError,
                     "callback parameter extent is not callable");
    return NULL;
  }
  flags_u32 = flags;
  ret = nbd_block_status (h, count_u64, offset_u64, extent, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_poll (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  int timeout;

  if (!PyArg_ParseTuple (args, (char *) "O" "i"
                         ":nbd_poll",
                         &py_h, &timeout))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_poll (h, timeout);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyLong_FromLong (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_connect (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  /* XXX Complicated - Python uses a tuple of different
   * lengths for the different socket types.
   */
  PyObject *addr;

  if (!PyArg_ParseTuple (args, (char *) "O" "O"
                         ":nbd_aio_connect",
                         &py_h, &addr))
    return NULL;
  h = get_handle (py_h);
  abort (); /* XXX SockAddrAndLen not implemented */
  ret = nbd_aio_connect (h, /* XXX */ (void *) addr, 0);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_connect_uri (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  const char *uri;

  if (!PyArg_ParseTuple (args, (char *) "O" "s"
                         ":nbd_aio_connect_uri",
                         &py_h, &uri))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_aio_connect_uri (h, uri);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_connect_unix (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  PyObject *py_unixsocket = NULL;
  char *unixsocket = NULL;

  if (!PyArg_ParseTuple (args, (char *) "O" "O&"
                         ":nbd_aio_connect_unix",
                         &py_h, PyUnicode_FSConverter, &py_unixsocket))
    return NULL;
  h = get_handle (py_h);
  unixsocket = PyBytes_AS_STRING (py_unixsocket);
  assert (unixsocket != NULL);
  ret = nbd_aio_connect_unix (h, unixsocket);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  Py_XDECREF (py_unixsocket);
  return py_ret;
}

PyObject *
nbd_internal_py_aio_connect_vsock (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  uint32_t cid_u32;
  unsigned int cid; /* really uint32_t */
  uint32_t port_u32;
  unsigned int port; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "I" "I"
                         ":nbd_aio_connect_vsock",
                         &py_h, &cid, &port))
    return NULL;
  h = get_handle (py_h);
  cid_u32 = cid;
  port_u32 = port;
  ret = nbd_aio_connect_vsock (h, cid_u32, port_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_connect_tcp (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  const char *hostname;
  const char *port;

  if (!PyArg_ParseTuple (args, (char *) "O" "s" "s"
                         ":nbd_aio_connect_tcp",
                         &py_h, &hostname, &port))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_aio_connect_tcp (h, hostname, port);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_connect_socket (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  int sock;

  if (!PyArg_ParseTuple (args, (char *) "O" "i"
                         ":nbd_aio_connect_socket",
                         &py_h, &sock))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_aio_connect_socket (h, sock);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_connect_command (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  PyObject *py_argv;
  char **argv = NULL;

  if (!PyArg_ParseTuple (args, (char *) "O" "O"
                         ":nbd_aio_connect_command",
                         &py_h, &py_argv))
    return NULL;
  h = get_handle (py_h);
  argv = nbd_internal_py_get_string_list (py_argv);
  if (!argv) { py_ret = NULL; goto out; }
  ret = nbd_aio_connect_command (h, argv);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  nbd_internal_py_free_string_list (argv);
  return py_ret;
}

PyObject *
nbd_internal_py_aio_connect_systemd_socket_activation (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  PyObject *py_argv;
  char **argv = NULL;

  if (!PyArg_ParseTuple (args, (char *) "O" "O"
                         ":nbd_aio_connect_systemd_socket_activation",
                         &py_h, &py_argv))
    return NULL;
  h = get_handle (py_h);
  argv = nbd_internal_py_get_string_list (py_argv);
  if (!argv) { py_ret = NULL; goto out; }
  ret = nbd_aio_connect_systemd_socket_activation (h, argv);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  nbd_internal_py_free_string_list (argv);
  return py_ret;
}

PyObject *
nbd_internal_py_aio_pread (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int64_t ret;
  PyObject *py_ret;
  PyObject *buf; /* PyCapsule pointing to struct py_aio_buffer */
  struct py_aio_buffer *buf_buf;
  uint64_t offset_u64;
  unsigned long long offset; /* really uint64_t */
  struct user_data *completion_user_data = alloc_user_data ();
  if (completion_user_data == NULL) return NULL;
  nbd_completion_callback completion = { .callback = completion_wrapper,
                         .user_data = completion_user_data,
                         .free = free_user_data };
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "O" "K" "O" "I"
                         ":nbd_aio_pread",
                         &py_h, &buf, &offset, &completion_user_data->fn, &flags))
    return NULL;
  h = get_handle (py_h);
  buf_buf = nbd_internal_py_get_aio_buffer (buf);
  offset_u64 = offset;
  if (completion_user_data->fn != Py_None) {
    /* Increment refcount since pointer may be saved by libnbd. */
    Py_INCREF (completion_user_data->fn);
    if (!PyCallable_Check (completion_user_data->fn)) {
      PyErr_SetString (PyExc_TypeError,
                       "callback parameter completion is not callable");
      return NULL;
    }
  }
  else
    completion.callback = NULL; /* we're not going to call it */
  flags_u32 = flags;
  /* Increment refcount since buffer may be saved by libnbd. */
  Py_INCREF (buf);
  completion_user_data->buf = buf;
  ret = nbd_aio_pread (h, buf_buf->data, buf_buf->len, offset_u64, completion, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyLong_FromLongLong (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_pread_structured (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int64_t ret;
  PyObject *py_ret;
  PyObject *buf; /* PyCapsule pointing to struct py_aio_buffer */
  struct py_aio_buffer *buf_buf;
  uint64_t offset_u64;
  unsigned long long offset; /* really uint64_t */
  struct user_data *chunk_user_data = alloc_user_data ();
  if (chunk_user_data == NULL) return NULL;
  nbd_chunk_callback chunk = { .callback = chunk_wrapper,
                         .user_data = chunk_user_data,
                         .free = free_user_data };
  struct user_data *completion_user_data = alloc_user_data ();
  if (completion_user_data == NULL) return NULL;
  nbd_completion_callback completion = { .callback = completion_wrapper,
                         .user_data = completion_user_data,
                         .free = free_user_data };
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "O" "K" "O" "O" "I"
                         ":nbd_aio_pread_structured",
                         &py_h, &buf, &offset, &chunk_user_data->fn, &completion_user_data->fn, &flags))
    return NULL;
  h = get_handle (py_h);
  buf_buf = nbd_internal_py_get_aio_buffer (buf);
  offset_u64 = offset;
  /* Increment refcount since pointer may be saved by libnbd. */
  Py_INCREF (chunk_user_data->fn);
  if (!PyCallable_Check (chunk_user_data->fn)) {
    PyErr_SetString (PyExc_TypeError,
                     "callback parameter chunk is not callable");
    return NULL;
  }
  if (completion_user_data->fn != Py_None) {
    /* Increment refcount since pointer may be saved by libnbd. */
    Py_INCREF (completion_user_data->fn);
    if (!PyCallable_Check (completion_user_data->fn)) {
      PyErr_SetString (PyExc_TypeError,
                       "callback parameter completion is not callable");
      return NULL;
    }
  }
  else
    completion.callback = NULL; /* we're not going to call it */
  flags_u32 = flags;
  /* Increment refcount since buffer may be saved by libnbd. */
  Py_INCREF (buf);
  completion_user_data->buf = buf;
  ret = nbd_aio_pread_structured (h, buf_buf->data, buf_buf->len, offset_u64, chunk, completion, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyLong_FromLongLong (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_pwrite (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int64_t ret;
  PyObject *py_ret;
  PyObject *buf; /* PyCapsule pointing to struct py_aio_buffer */
  struct py_aio_buffer *buf_buf;
  uint64_t offset_u64;
  unsigned long long offset; /* really uint64_t */
  struct user_data *completion_user_data = alloc_user_data ();
  if (completion_user_data == NULL) return NULL;
  nbd_completion_callback completion = { .callback = completion_wrapper,
                         .user_data = completion_user_data,
                         .free = free_user_data };
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "O" "K" "O" "I"
                         ":nbd_aio_pwrite",
                         &py_h, &buf, &offset, &completion_user_data->fn, &flags))
    return NULL;
  h = get_handle (py_h);
  buf_buf = nbd_internal_py_get_aio_buffer (buf);
  offset_u64 = offset;
  if (completion_user_data->fn != Py_None) {
    /* Increment refcount since pointer may be saved by libnbd. */
    Py_INCREF (completion_user_data->fn);
    if (!PyCallable_Check (completion_user_data->fn)) {
      PyErr_SetString (PyExc_TypeError,
                       "callback parameter completion is not callable");
      return NULL;
    }
  }
  else
    completion.callback = NULL; /* we're not going to call it */
  flags_u32 = flags;
  /* Increment refcount since buffer may be saved by libnbd. */
  Py_INCREF (buf);
  completion_user_data->buf = buf;
  ret = nbd_aio_pwrite (h, buf_buf->data, buf_buf->len, offset_u64, completion, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyLong_FromLongLong (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_disconnect (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "I"
                         ":nbd_aio_disconnect",
                         &py_h, &flags))
    return NULL;
  h = get_handle (py_h);
  flags_u32 = flags;
  ret = nbd_aio_disconnect (h, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_flush (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int64_t ret;
  PyObject *py_ret;
  struct user_data *completion_user_data = alloc_user_data ();
  if (completion_user_data == NULL) return NULL;
  nbd_completion_callback completion = { .callback = completion_wrapper,
                         .user_data = completion_user_data,
                         .free = free_user_data };
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "O" "I"
                         ":nbd_aio_flush",
                         &py_h, &completion_user_data->fn, &flags))
    return NULL;
  h = get_handle (py_h);
  if (completion_user_data->fn != Py_None) {
    /* Increment refcount since pointer may be saved by libnbd. */
    Py_INCREF (completion_user_data->fn);
    if (!PyCallable_Check (completion_user_data->fn)) {
      PyErr_SetString (PyExc_TypeError,
                       "callback parameter completion is not callable");
      return NULL;
    }
  }
  else
    completion.callback = NULL; /* we're not going to call it */
  flags_u32 = flags;
  ret = nbd_aio_flush (h, completion, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyLong_FromLongLong (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_trim (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int64_t ret;
  PyObject *py_ret;
  uint64_t count_u64;
  unsigned long long count; /* really uint64_t */
  uint64_t offset_u64;
  unsigned long long offset; /* really uint64_t */
  struct user_data *completion_user_data = alloc_user_data ();
  if (completion_user_data == NULL) return NULL;
  nbd_completion_callback completion = { .callback = completion_wrapper,
                         .user_data = completion_user_data,
                         .free = free_user_data };
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "K" "K" "O" "I"
                         ":nbd_aio_trim",
                         &py_h, &count, &offset, &completion_user_data->fn, &flags))
    return NULL;
  h = get_handle (py_h);
  count_u64 = count;
  offset_u64 = offset;
  if (completion_user_data->fn != Py_None) {
    /* Increment refcount since pointer may be saved by libnbd. */
    Py_INCREF (completion_user_data->fn);
    if (!PyCallable_Check (completion_user_data->fn)) {
      PyErr_SetString (PyExc_TypeError,
                       "callback parameter completion is not callable");
      return NULL;
    }
  }
  else
    completion.callback = NULL; /* we're not going to call it */
  flags_u32 = flags;
  ret = nbd_aio_trim (h, count_u64, offset_u64, completion, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyLong_FromLongLong (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_cache (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int64_t ret;
  PyObject *py_ret;
  uint64_t count_u64;
  unsigned long long count; /* really uint64_t */
  uint64_t offset_u64;
  unsigned long long offset; /* really uint64_t */
  struct user_data *completion_user_data = alloc_user_data ();
  if (completion_user_data == NULL) return NULL;
  nbd_completion_callback completion = { .callback = completion_wrapper,
                         .user_data = completion_user_data,
                         .free = free_user_data };
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "K" "K" "O" "I"
                         ":nbd_aio_cache",
                         &py_h, &count, &offset, &completion_user_data->fn, &flags))
    return NULL;
  h = get_handle (py_h);
  count_u64 = count;
  offset_u64 = offset;
  if (completion_user_data->fn != Py_None) {
    /* Increment refcount since pointer may be saved by libnbd. */
    Py_INCREF (completion_user_data->fn);
    if (!PyCallable_Check (completion_user_data->fn)) {
      PyErr_SetString (PyExc_TypeError,
                       "callback parameter completion is not callable");
      return NULL;
    }
  }
  else
    completion.callback = NULL; /* we're not going to call it */
  flags_u32 = flags;
  ret = nbd_aio_cache (h, count_u64, offset_u64, completion, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyLong_FromLongLong (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_zero (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int64_t ret;
  PyObject *py_ret;
  uint64_t count_u64;
  unsigned long long count; /* really uint64_t */
  uint64_t offset_u64;
  unsigned long long offset; /* really uint64_t */
  struct user_data *completion_user_data = alloc_user_data ();
  if (completion_user_data == NULL) return NULL;
  nbd_completion_callback completion = { .callback = completion_wrapper,
                         .user_data = completion_user_data,
                         .free = free_user_data };
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "K" "K" "O" "I"
                         ":nbd_aio_zero",
                         &py_h, &count, &offset, &completion_user_data->fn, &flags))
    return NULL;
  h = get_handle (py_h);
  count_u64 = count;
  offset_u64 = offset;
  if (completion_user_data->fn != Py_None) {
    /* Increment refcount since pointer may be saved by libnbd. */
    Py_INCREF (completion_user_data->fn);
    if (!PyCallable_Check (completion_user_data->fn)) {
      PyErr_SetString (PyExc_TypeError,
                       "callback parameter completion is not callable");
      return NULL;
    }
  }
  else
    completion.callback = NULL; /* we're not going to call it */
  flags_u32 = flags;
  ret = nbd_aio_zero (h, count_u64, offset_u64, completion, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyLong_FromLongLong (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_block_status (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int64_t ret;
  PyObject *py_ret;
  uint64_t count_u64;
  unsigned long long count; /* really uint64_t */
  uint64_t offset_u64;
  unsigned long long offset; /* really uint64_t */
  struct user_data *extent_user_data = alloc_user_data ();
  if (extent_user_data == NULL) return NULL;
  nbd_extent_callback extent = { .callback = extent_wrapper,
                         .user_data = extent_user_data,
                         .free = free_user_data };
  struct user_data *completion_user_data = alloc_user_data ();
  if (completion_user_data == NULL) return NULL;
  nbd_completion_callback completion = { .callback = completion_wrapper,
                         .user_data = completion_user_data,
                         .free = free_user_data };
  uint32_t flags_u32;
  unsigned int flags; /* really uint32_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "K" "K" "O" "O" "I"
                         ":nbd_aio_block_status",
                         &py_h, &count, &offset, &extent_user_data->fn, &completion_user_data->fn, &flags))
    return NULL;
  h = get_handle (py_h);
  count_u64 = count;
  offset_u64 = offset;
  /* Increment refcount since pointer may be saved by libnbd. */
  Py_INCREF (extent_user_data->fn);
  if (!PyCallable_Check (extent_user_data->fn)) {
    PyErr_SetString (PyExc_TypeError,
                     "callback parameter extent is not callable");
    return NULL;
  }
  if (completion_user_data->fn != Py_None) {
    /* Increment refcount since pointer may be saved by libnbd. */
    Py_INCREF (completion_user_data->fn);
    if (!PyCallable_Check (completion_user_data->fn)) {
      PyErr_SetString (PyExc_TypeError,
                       "callback parameter completion is not callable");
      return NULL;
    }
  }
  else
    completion.callback = NULL; /* we're not going to call it */
  flags_u32 = flags;
  ret = nbd_aio_block_status (h, count_u64, offset_u64, extent, completion, flags_u32);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyLong_FromLongLong (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_get_fd (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_aio_get_fd",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_aio_get_fd (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyLong_FromLong (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_get_direction (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  unsigned ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_aio_get_direction",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_aio_get_direction (h);
  py_ret = PyLong_FromLong (ret);

  return py_ret;
}

PyObject *
nbd_internal_py_aio_notify_read (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_aio_notify_read",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_aio_notify_read (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_notify_write (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_aio_notify_write",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_aio_notify_write (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_is_created (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_aio_is_created",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_aio_is_created (h);
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

  return py_ret;
}

PyObject *
nbd_internal_py_aio_is_connecting (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_aio_is_connecting",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_aio_is_connecting (h);
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

  return py_ret;
}

PyObject *
nbd_internal_py_aio_is_ready (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_aio_is_ready",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_aio_is_ready (h);
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

  return py_ret;
}

PyObject *
nbd_internal_py_aio_is_processing (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_aio_is_processing",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_aio_is_processing (h);
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

  return py_ret;
}

PyObject *
nbd_internal_py_aio_is_dead (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_aio_is_dead",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_aio_is_dead (h);
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

  return py_ret;
}

PyObject *
nbd_internal_py_aio_is_closed (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_aio_is_closed",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_aio_is_closed (h);
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

  return py_ret;
}

PyObject *
nbd_internal_py_aio_command_completed (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  int64_t cookie_i64;
  long long cookie; /* really int64_t */

  if (!PyArg_ParseTuple (args, (char *) "O" "L"
                         ":nbd_aio_command_completed",
                         &py_h, &cookie))
    return NULL;
  h = get_handle (py_h);
  cookie_i64 = cookie;
  ret = nbd_aio_command_completed (h, cookie_i64);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_peek_command_completed (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int64_t ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_aio_peek_command_completed",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_aio_peek_command_completed (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyLong_FromLongLong (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_aio_in_flight (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_aio_in_flight",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_aio_in_flight (h);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyLong_FromLong (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_connection_state (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  const char * ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_connection_state",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_connection_state (h);
  if (ret == NULL) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = PyUnicode_FromString (ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_get_package_name (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  const char * ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_get_package_name",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_get_package_name (h);
  py_ret = PyUnicode_FromString (ret);

  return py_ret;
}

PyObject *
nbd_internal_py_get_version (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  const char * ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_get_version",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_get_version (h);
  py_ret = PyUnicode_FromString (ret);

  return py_ret;
}

PyObject *
nbd_internal_py_kill_subprocess (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;
  int signum;

  if (!PyArg_ParseTuple (args, (char *) "O" "i"
                         ":nbd_kill_subprocess",
                         &py_h, &signum))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_kill_subprocess (h, signum);
  if (ret == -1) {
    raise_exception ();
    py_ret = NULL;
    goto out;
  }
  py_ret = Py_None;
  Py_INCREF (py_ret);

 out:
  return py_ret;
}

PyObject *
nbd_internal_py_supports_tls (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_supports_tls",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_supports_tls (h);
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

  return py_ret;
}

PyObject *
nbd_internal_py_supports_uri (PyObject *self, PyObject *args)
{
  PyObject *py_h;
  struct nbd_handle *h;
  int ret;
  PyObject *py_ret;

  if (!PyArg_ParseTuple (args, (char *) "O"
                         ":nbd_supports_uri",
                         &py_h))
    return NULL;
  h = get_handle (py_h);
  ret = nbd_supports_uri (h);
  py_ret = ret ? Py_True : Py_False;
  Py_INCREF (py_ret);

  return py_ret;
}

