/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#include "vdk/vdkfont.h"
#include "vdk/forms.h"
#include <cstring>
/*
 */
VDKFont::VDKFont(char* name): VDKRawObject((VDKObject*) NULL)
{
  pangoDes = NULL;
  fontName = NULL;
  if(name)
    {
      fontName = new char[std::strlen(name)+1];
      std::strcpy(fontName,name);
      pangoDes = pango_font_description_from_string (fontName);
  } 
}

/*
 */
VDKFont::VDKFont(VDKObject* obj, char* name): VDKRawObject(obj)
{
  pangoDes = NULL;
  fontName = NULL;
  if(name)
    {
      fontName = new char[std::strlen(name)+1];
      std::strcpy(fontName,name);
      pangoDes = pango_font_description_from_string (fontName);
  } 
}
/*
 */
VDKFont::~VDKFont()
{
if(fontName)
  delete[] fontName;
if(pangoDes)
  pango_font_description_free (pangoDes);
  
}
/*
 */
bool VDKFont::operator==(VDKFont& f)
{
  if(pangoDes)
    return pango_font_description_equal(pangoDes,f.pangoDes);
  else
    return false;
}
/*
 */
int VDKFont::Height(const char* s)
{
  GdkFont* gdkfont = NULL;
  if(fontName && pangoDes)
    gdkfont = gdk_font_from_description (pangoDes);
  if(gdkfont)
    {
      int h = gdk_string_height (gdkfont,s);
      gdk_font_unref(gdkfont);
      return h;
    }
  else
    return 0;
}
/*
 */
VDKFont::operator char*()
{
return fontName;
}
/*
 */
int VDKFont::FontId()
{
  return -1;
}

int VDKFont::Width(const char* s)
{
  GdkFont* gdkfont = NULL;
  if(fontName && pangoDes)
    gdkfont = gdk_font_from_description (pangoDes);
  if(gdkfont)
    {
      int w = gdk_string_width(gdkfont,s);
      gdk_font_unref(gdkfont);
      return w;
    }
  else
    return 0;
}

VDKFont::operator GdkFont*()
{
  if(fontName && pangoDes)
    return gdk_font_from_description (pangoDes);
  else
    return NULL;
}

GdkFont*
VDKFont:: AsGdkFont()
{
  if(fontName && pangoDes)
    return gdk_font_from_description (pangoDes);
  else
    return NULL;
}

PangoFontDescription *
VDKFont::AsPangoFontDescription()
{
  return pangoDes;
}





