Compiling Vera++
================

Getting the sources
-------------------

### From the download section

Just download [this archive](https://bitbucket.org/verateam/vera/downloads/vera++-1.2.0.tar.gz)
and extract it.

### With git

To get a copy of Vera++'s repository, run:

    git clone https://bitbucket.org/verateam/vera.git
    cd vera
    git submodule update --init

To update that repository, run:

    git pull
    git submodule update

Note that the submodule is only needed to build the documentation. If it is not there, a warning is displayed and the documentation is not generated.

Dependencies
------------

Vera++ is implemented in C++ and depends on the [Boost](http://www.boost.org/) and [Tcl](http://www.tcl.tk/) libraries. It uses [CMake](http://cmake.org/ CMake) as build system.
The documentation is generated with [pandoc](http://johnmacfarlane.net/pandoc/).

Note that pandoc is only needed to build the documentation. If it is not found, a warning is displayed and the documentation is not generated.

Configuring and building
------------------------

To build vera++, as with any CMake project, run either, `cmake`, `ccmake` or `cmake-gui`, configure and generate the project, and build the project with your build environment. You can then install vera++ by building the `install` target, or generate a package by building the `package` target.

On unix compatible systems (Linux, *BSD, Mac OS X, ...), this is done this way:

    cd vera
    mkdir build
    cd build
    cmake ..
    make -j
    make install

See [Running CMake](http://www.cmake.org/cmake/help/runningcmake.html) for more information.

Testing
-------

Vera++ uses CTest, the testing tool that comes with CMake. To run the tests, simply type

    ctest

in your build directory.

The test results can be submitted to the [vera++'s dashboard](http://my.cdash.org/index.php?project=vera%2B%2B) with the command

    ctest -D Experimental

To submit nightly tests, it is easier to create a test directory, copy `vera.ctest` from [vera++'s sources](https://bitbucket.org/ThArGos/vera/src) to that directory and create a new file `vera.cmake` like this one:

    set(CTEST_SITE "host.site")
    set(CTEST_BUILD_NAME "compiler name")
    set(CTEST_BUILD_CONFIGURATION Debug)
    set(CTEST_CMAKE_GENERATOR "Unix Makefiles")
    include(${CTEST_SCRIPT_DIRECTORY}/vera.ctest)

adjust the values, and run every nights:

    ctest -S /path/to/vera.cmake

The test results will appear on [vera++'s dashboard](http://my.cdash.org/index.php?project=vera%2B%2B). See [CMake Scripting Of CTest](http://www.cmake.org/Wiki/CMake_Scripting_Of_CTest) for more details.

Packages
--------

Vera++ uses `CPack` to generate the binary and source packages.

### Source package ###

Just build the `package_source` target to generate the source archive as a `tar.gz` file.
Make sure your repository is clean with `git status` before generating the package.

### Documentation package ###

Build the `package_doc` target to generate the documentation archive as a `tar.gz` file.

### Mac OS X package ###

`CPack` depends on [PackageMaker](https://developer.apple.com/downloads/index.action) to generate this package.
Set the CMake option `Boost_USE_STATIC_LIBS` to `ON` and `CMAKE_BUILD_TYPE` to `Release` and build the target `package`.
A few options can be turned off to speed up the package build if only the package built with `PackageMaker` is needed:

* `CPACK_BINARY_STGZ`
* `CPACK_BINARY_TGZ`

### Microsoft Windows ###

`CPack` depends on [NSIS](http://nsis.sourceforge.net/Main_Page) to generate this package.
Set the CMake option `CMAKE_BUILD_TYPE` to `Release` and build the target `package`.

### Linux Debian ###

Set the CMake option `CMAKE_BUILD_TYPE` to `Release` and build the target `package`.

### Linux RPM ###

Set the CMake option `CMAKE_BUILD_TYPE` to `Release` and build the target `package`.

Note: this package generation has not yet been tested.