/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#ifndef _TFRAMEITEM_H_
#define _TFRAMEITEM_H_

#include <QGraphicsItem>
#include <QPen>
#include <QPainter>
#include <QMessageBox>
#include <QMenu>
#include <QAction>
#include <QGraphicsSceneContextMenuEvent>
#include <QLinearGradient>

class TFrameItem : public QObject, public QGraphicsItem
{
    Q_OBJECT 
public:
    TFrameItem(QImage &p, int h_s, QAction &, QAction &);
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget);
    QRectF boundingRect() const;
    void deSelect();
	void select();

protected:
    void hoverMoveEvent(QGraphicsSceneHoverEvent*);
    void hoverLeaveEvent(QGraphicsSceneHoverEvent*);
    void mousePressEvent(QGraphicsSceneMouseEvent*);

    void contextMenuEvent(QGraphicsSceneContextMenuEvent *event);

signals:
    void onSave(TFrameItem &);
    void onSelectItem(TFrameItem &);

private slots:
    void S_Save();

private:
    int index;
    bool isSelect;
	bool hovered;

    QImage *p;
    int w_s, h_s;
	int widthBorder;
	int shadowSize;

    QRectF boundRect;
    QRectF pixRect, bigRect;
    QRectF source;

    QColor colHover, colPress;

    QAction *menuAct;
    QMenu *menu;
};

#endif
